(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35590,       1291]
NotebookOptionsPosition[     27997,       1026]
NotebookOutlinePosition[     29474,       1066]
CellTagsIndexPosition[     29388,       1061]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "BitNot" :> 
          Documentation`HelpLookup["paclet:ref/BitNot"], "Nand" :> 
          Documentation`HelpLookup["paclet:ref/Nand"], "Nor" :> 
          Documentation`HelpLookup["paclet:ref/Nor"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 2->"\<\"BitNot\"\>", 
       3->"\<\"Nand\"\>", 4->"\<\"Nor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Not ",
 StyleBox["(!, \[Not])", "OperatorCharacter"]
}], "ObjectName",
 CellID->11363],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"!", 
       StyleBox["expr", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is the logical NOT function. It gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if it is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29802]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 ". The character ",
 Cell[BoxData[
  FormBox["\[Not]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]!\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]not\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", "Not", "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->425944919]
}], "Notes",
 CellID->28069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 " gives symbolic results when necessary, applying various simplification \
rules to them. "
}], "Notes",
 CellID->21999],

Cell[TextData[{
 "If you are using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a text\[Hyphen]based front end, then you cannot use the notation ",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " if it appears at the very beginning of a line. In this case, ",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " is interpreted as a shell escape. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->46739781]
}], "Notes",
 CellID->2380]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->665577244],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->349718878],

Cell["Negate assertions:", "ExampleText",
 CellID->862097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", ">", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->426102860],

Cell[BoxData[
 RowBox[{"x", "\[LessEqual]", "1"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40377103]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342674758],

Cell["Symbolic negation:", "ExampleText",
 CellID->597351030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125601131],

Cell[BoxData[
 RowBox[{"!", "x"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235451483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440589430],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]not\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->425944919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Not]", "p"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334579468],

Cell[BoxData[
 RowBox[{"!", "p"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486642164]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->69607141],

Cell["Double negation simplifies to the identity:", "ExampleText",
 CellID->780031108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"Not", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318127747],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223152787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->780885533],

Cell["Negate equations and inequalities:", "ExampleText",
 CellID->263439749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"a", "\[Equal]", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378450275],

Cell[BoxData[
 RowBox[{"a", "\[NotEqual]", "b"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435952252]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"a", "\[GreaterEqual]", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->796896445],

Cell[BoxData[
 RowBox[{"a", "<", "b"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30184614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203563979],

Cell["Negate quantifiers:", "ExampleText",
 CellID->577727941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{"f", "[", "x", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147777357],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", "x"], 
  RowBox[{"(", 
   RowBox[{"!", 
    RowBox[{"f", "[", "x", "]"}]}], ")"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171387686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"ForAll", "[", 
   RowBox[{"x", ",", 
    RowBox[{"f", "[", "x", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->332965220],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{"(", 
   RowBox[{"!", 
    RowBox[{"f", "[", "x", "]"}]}], ")"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183687835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214987407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->55835233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "x"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58089908],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Not]", "x"}], TraditionalForm]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->316244523]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->242987270],

Cell[TextData[{
 "Negate conditions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code:"
}], "ExampleText",
 CellID->843171773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "Pi", ",", "2.3", ",", 
     RowBox[{"3", "+", 
      RowBox[{"7", "I"}]}], ",", "x"}], "}"}], ",", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"NumberQ", "[", "#", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177415948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Pi]", ",", "x"}], "}"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128511106]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444580791],

Cell["\<\
Find the area of the complement of a set given by algebraic conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "2"}], "-", 
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", "0"}], "]"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData[
 FractionBox["4", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17762718]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Not", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"x", "^", "4"}]}]}], "\[LessEqual]", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339535853]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->905792121],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->122470850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{"Not", ",", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77014198],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylU0sOgjAQLf2osDHujLog4S668hANMYGF0SD3r9PPSFsqEmnSTud1+ujM
PK6yb2532be1LC+dfDZt/SrPjw4glhFCKpjHPYG9gp2ZlVJg/ZVwa+wQ4Ai9
YQPKYFJwuQvWNjPHGjXHygx7SXx8R8GjKJqMSnL9+YWVXvjg27xCNuJlE9/X
X2GuCCLIFtFFWY7QcTWRkeHbo9dx9w7szTfmIrq7tbjXXc2Ug0vB7lSsjunV
r4hwlkbqQeVsDMRS/ZzwaUIZxXymnypbyiUmM6Ooi5k6SDNRrOrwpzoET1AJ
uQ0IlB9nfDDwGoCT10mSvQFgWgpp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{35, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->306487683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259809846],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to simplify the negation of ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->133224304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"Implies", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20529620],

Cell[BoxData[
 RowBox[{"a", "&&", 
  RowBox[{"!", "b"}]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241731819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211109122],

Cell[TextData[{
 "De Morgan's laws relate ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->346309266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "&&", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238943236],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "||", 
  RowBox[{"!", "b"}]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352801189]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "||", "b", "||", "c"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->864089889],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "&&", 
  RowBox[{"!", "b"}], "&&", 
  RowBox[{"!", "c"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->663836708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181313949],

Cell[TextData[{
 "Negation of the condition for ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->257207371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"!", "a"}], "]"}], "\[Equal]", 
  RowBox[{"1", "-", 
   RowBox[{"Boole", "[", "a", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551050724],

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"!", "a"}], "]"}], "\[Equal]", 
  RowBox[{"1", "-", 
   RowBox[{"Boole", "[", "a", "]"}]}]}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41938379]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40654382],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85963991]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15937],

Cell[TextData[{
 "Use parentheses to ensure ",
 Cell[BoxData["!"], "InlineFormula"],
 " beginning a line is not taken as a shell escape when using a terminal \
interface: "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->46739781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{"!", "True"}], ")"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6927164],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264417903]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17366],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15962]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12789],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->6509]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->199826987],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->162222746]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Not (!, \[Not]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 28.9061524}", "context" -> "System`", 
    "keywords" -> {
     "bang", "conjugation", "exclamation point", "inversion", "negation", 
      "not", "logical prime", "denial", "complement", "logical bar", 
      "contradiction", "logical connective", "Boolean algebra", 
      "switching algebra", "propositional logic"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "! expr is the logical NOT function. It gives False if expr is True, and \
True if it is False. ", "synonyms" -> {"!"}, "title" -> "Not", "type" -> 
    "Symbol", "uri" -> "ref/Not"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6464, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->665577244]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29245, 1054}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2063, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2686, 77, 104, 4, 70, "ObjectName",
 CellID->11363],
Cell[2793, 83, 1028, 35, 70, "Usage",
 CellID->29802]
}, Open  ]],
Cell[CellGroupData[{
Cell[3858, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4336, 140, 1126, 41, 70, "Notes",
 CellID->28069],
Cell[5465, 183, 246, 8, 70, "Notes",
 CellID->21999],
Cell[5714, 193, 713, 24, 70, "Notes",
 CellID->2380]
}, Closed]],
Cell[CellGroupData[{
Cell[6464, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->665577244],
Cell[CellGroupData[{
Cell[6849, 236, 148, 5, 70, "ExampleSection",
 CellID->349718878],
Cell[7000, 243, 58, 1, 70, "ExampleText",
 CellID->862097],
Cell[CellGroupData[{
Cell[7083, 248, 110, 4, 28, "Input",
 CellID->426102860],
Cell[7196, 254, 190, 6, 36, "Output",
 CellID->40377103]
}, Open  ]],
Cell[7401, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->342674758],
Cell[7529, 268, 61, 1, 70, "ExampleText",
 CellID->597351030],
Cell[CellGroupData[{
Cell[7615, 273, 87, 3, 70, "Input",
 CellID->125601131],
Cell[7705, 278, 175, 6, 36, "Output",
 CellID->235451483]
}, Open  ]],
Cell[7895, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->440589430],
Cell[8023, 292, 240, 8, 70, "ExampleText",
 CellID->425944919],
Cell[CellGroupData[{
Cell[8288, 304, 92, 3, 70, "Input",
 CellID->334579468],
Cell[8383, 309, 175, 6, 36, "Output",
 CellID->486642164]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8607, 321, 219, 7, 70, "ExampleSection",
 CellID->69607141],
Cell[8829, 330, 86, 1, 70, "ExampleText",
 CellID->780031108],
Cell[CellGroupData[{
Cell[8940, 335, 129, 4, 70, "Input",
 CellID->318127747],
Cell[9072, 341, 158, 5, 36, "Output",
 CellID->223152787]
}, Open  ]],
Cell[9245, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->780885533],
Cell[9373, 354, 77, 1, 70, "ExampleText",
 CellID->263439749],
Cell[CellGroupData[{
Cell[9475, 359, 129, 4, 70, "Input",
 CellID->378450275],
Cell[9607, 365, 190, 6, 36, "Output",
 CellID->435952252]
}, Open  ]],
Cell[CellGroupData[{
Cell[9834, 376, 136, 4, 70, "Input",
 CellID->796896445],
Cell[9973, 382, 179, 6, 36, "Output",
 CellID->30184614]
}, Open  ]],
Cell[10167, 391, 125, 3, 70, "ExampleDelimiter",
 CellID->203563979],
Cell[10295, 396, 62, 1, 70, "ExampleText",
 CellID->577727941],
Cell[CellGroupData[{
Cell[10382, 401, 174, 6, 70, "Input",
 CellID->147777357],
Cell[10559, 409, 277, 10, 36, "Output",
 CellID->171387686]
}, Open  ]],
Cell[CellGroupData[{
Cell[10873, 424, 174, 6, 70, "Input",
 CellID->332965220],
Cell[11050, 432, 277, 10, 36, "Output",
 CellID->183687835]
}, Open  ]],
Cell[11342, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->214987407],
Cell[11470, 450, 202, 7, 70, "ExampleText",
 CellID->55835233],
Cell[CellGroupData[{
Cell[11697, 461, 124, 4, 70, "Input",
 CellID->58089908],
Cell[11824, 467, 226, 7, 50, "Output",
 CellID->316244523]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12099, 480, 227, 7, 70, "ExampleSection",
 CellID->242987270],
Cell[12329, 489, 139, 6, 70, "ExampleText",
 CellID->843171773],
Cell[CellGroupData[{
Cell[12493, 499, 331, 11, 70, "Input",
 CellID->177415948],
Cell[12827, 512, 207, 7, 36, "Output",
 CellID->128511106]
}, Open  ]],
Cell[13049, 522, 125, 3, 70, "ExampleDelimiter",
 CellID->444580791],
Cell[13177, 527, 122, 3, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[13324, 534, 573, 20, 70, "Input",
 CellID->310451651],
Cell[13900, 556, 177, 6, 51, "Output",
 CellID->17762718]
}, Open  ]],
Cell[14092, 565, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[14177, 570, 529, 18, 70, "Input",
 CellID->167686269],
Cell[14709, 590, 5170, 89, 70, "Output",
 Evaluatable->False,
 CellID->339535853]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19928, 685, 237, 7, 70, "ExampleSection",
 CellID->905792121],
Cell[20168, 694, 189, 8, 70, "ExampleText",
 CellID->122470850],
Cell[CellGroupData[{
Cell[20382, 706, 217, 8, 70, "Input",
 CellID->77014198],
Cell[20602, 716, 555, 13, 70, "Output",
 Evaluatable->False,
 CellID->306487683]
}, Open  ]],
Cell[21172, 732, 125, 3, 70, "ExampleDelimiter",
 CellID->259809846],
Cell[21300, 737, 348, 13, 70, "ExampleText",
 CellID->133224304],
Cell[CellGroupData[{
Cell[21673, 754, 186, 6, 70, "Input",
 CellID->20529620],
Cell[21862, 762, 199, 7, 36, "Output",
 CellID->241731819]
}, Open  ]],
Cell[22076, 772, 125, 3, 70, "ExampleDelimiter",
 CellID->211109122],
Cell[22204, 777, 430, 18, 70, "ExampleText",
 CellID->346309266],
Cell[CellGroupData[{
Cell[22659, 799, 177, 6, 70, "Input",
 CellID->238943236],
Cell[22839, 807, 217, 8, 36, "Output",
 CellID->352801189]
}, Open  ]],
Cell[CellGroupData[{
Cell[23093, 820, 188, 6, 70, "Input",
 CellID->864089889],
Cell[23284, 828, 246, 9, 36, "Output",
 CellID->663836708]
}, Open  ]],
Cell[23545, 840, 125, 3, 70, "ExampleDelimiter",
 CellID->181313949],
Cell[23673, 845, 216, 8, 70, "ExampleText",
 CellID->257207371],
Cell[CellGroupData[{
Cell[23914, 857, 206, 7, 70, "Input",
 CellID->551050724],
Cell[24123, 866, 294, 10, 36, "Output",
 CellID->41938379]
}, Open  ]],
Cell[CellGroupData[{
Cell[24454, 881, 103, 3, 70, "Input",
 CellID->40654382],
Cell[24560, 886, 160, 5, 36, "Output",
 CellID->85963991]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24769, 897, 226, 7, 70, "ExampleSection",
 CellID->15937],
Cell[24998, 906, 258, 7, 70, "ExampleText",
 CellID->46739781],
Cell[CellGroupData[{
Cell[25281, 917, 111, 4, 70, "Input",
 CellID->6927164],
Cell[25395, 923, 162, 5, 36, "Output",
 CellID->264417903]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25618, 935, 311, 9, 70, "SeeAlsoSection",
 CellID->17366],
Cell[25932, 946, 929, 35, 70, "SeeAlso",
 CellID->15962]
}, Open  ]],
Cell[CellGroupData[{
Cell[26898, 986, 314, 9, 70, "TutorialsSection",
 CellID->12789],
Cell[27215, 997, 171, 3, 70, "Tutorials",
 CellID->6509]
}, Open  ]],
Cell[CellGroupData[{
Cell[27423, 1005, 319, 9, 70, "MoreAboutSection",
 CellID->199826987],
Cell[27745, 1016, 157, 3, 70, "MoreAbout",
 CellID->162222746]
}, Open  ]],
Cell[27917, 1022, 50, 0, 70, "History"],
Cell[27970, 1024, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

