(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50355,       1256]
NotebookOptionsPosition[     45296,       1090]
NotebookOutlinePosition[     46862,       1130]
CellTagsIndexPosition[     46776,       1125]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"], 
          "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], 
          "SelectionMove" :> 
          Documentation`HelpLookup["paclet:ref/SelectionMove"], "PasteButton" :> 
          Documentation`HelpLookup["paclet:ref/PasteButton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookWrite\"\>", 
       2->"\<\"NotebookRead\"\>", 3->"\<\"SelectionMove\"\>", 
       4->"\<\"PasteButton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Low-Level Notebook Programming\"\>",
        2->"\<\"Palettes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookApply", "ObjectName",
 CellID->28965],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookApply",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookApply"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes data into a notebook at the current selection, \
replacing the first selection placeholder in ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " by the current selection, and then setting the current selection to be \
just after the data written. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookApply",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookApply"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"], ",", 
        StyleBox["sel", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes data into a notebook and then sets the current \
selection to be as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->37]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 " has the same effect as ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ", except that it replaces the first selection placeholder in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " by the current selection. "
}], "Notes",
 CellID->9818],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 " can be used in setting up actions for buttons in palettes. "
}], "Notes",
 CellID->25049],

Cell[TextData[{
 "Selection placeholders are represented by the character ",
 Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
 " or ",
 Cell[TextData[ButtonBox["\\[SelectionPlaceholder]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SelectionPlaceholder"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->712],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " are as in ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28646]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54007834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->526211943],

Cell[TextData[{
 "Create a notebook and select the first \"",
 Cell[BoxData["x"], "InlineFormula"],
 "\":"
}], "ExampleText",
 CellID->914649034],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142365028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->904349655],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtPlEccxnGa3jf+C/1XerjV2PTGmlQxFbWNMTa9MGnSC1O11drUE4gC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   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellID->370926748]
}, Open  ]],

Cell[TextData[{
 "Apply a template to make the \"",
 Cell[BoxData["x"], "InlineFormula"],
 "\" the base of a superscript structure:"
}], "ExampleText",
 CellID->41003072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{
    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<\[Placeholder]\>\""}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->363983101],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1PVEccxnGa3jf+C73vn9CrvtxqNN5YkyqmorYxxqYXJk16Yaq2Wpv6
BqKISgHf8AWoqFgQeVmXBRdkQRZk1xZWUxTfxUiBTufs7M6ePWfFhT2jtn4/
eUrmNzPntFdPNquh769Yt2jFu3l5eUvlP4F38vKsdUHBd4QQQkxkcmqaEEKI
h9HtevTYRUIIIZ7E0a6v/SM0IYT8D5KxXQUAIAcFye9aaVcA8BDtCgAm0K4A
YALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4A
YALtCgAm0K4AYALtCgAm0K4AkI1vvq39dH6xysIlB2fYVGhXAJgt2aUv3aRd
AWC2aNe8OPcaAHJBu4p4qToWAJAj2lXhUysAb9GuCu0KwFu0q+CbAQAG0K78
qRYAD6X+duuCt71dAcBzQ9ExPrsCgLdktapPsO4j2hUA5kZV65OnE7QrAHhF
V6vgT7UAwCP2ahW0KwB4pKjEt35Djf51WKvXVbnv0K4AYALtCgAm0K4AYALt
CgAm0K4AYMKipYftI+0KAJ7gsysAmEC7AoAJtCsAmEC7AoAJtCsAzEHqV2fP
L1645KD7Au0KADnit7gAgAm0KwCYQLvmfdCi4lgDQC5oV5EsVfsCAHJEuyp8
agXgLdpVoV0BeIt2FXwzAMAA2tX9p1oi9GFeJq/7vxTAfwnt6paxS2lXANkb
io7Rrm66Xe2fWmlXAFlS/+tt2tWNdgUwZ6panzydoF3daFcAc6OrVfC9ayZ8
7wpgDuzVKmjXTDL+hQHaFcDMikp86zfU6N9AuHpdldq3/1pCvam8be0KAK8G
7QoAJtCuAGAC7QoAJtCuAGAC7QoAJtCuAGCCvV2/WrstMvRHda1/67ZyQggh
OWby70mfv3/91zsK1m6X7SozMBAlhBCSY+ztOhAeEWJ6enqKEEJILvlnesre
rtf7hicnp8afPZd5Fk9iPS5/TuhxfDxxQW7qy3ptzzNGRkbGN3ScdaftLTl2
YPFHlQs+rljwiTtyX57KO+rB588nxscndLv2XLv56PH42L1HY/cexn8+Sq4f
Otf37Rf0fb35OP2UkZGR8Y0a59JpNYvnT+3aLQ6VidLSDDlUJk/lHfXgvfvW
I7pdu7qGbv91bzh2d3hk9L158+wZjo0Ox+4k1iP29R0Z27W7ycUdvVZjat92
P+Pl1Jvjl9WpWjifSj9lZGRkzGq0Smw0vql2RpP7ySSORq2nkm+4sSpf1J0V
p4+/MHVn5R317MituyOxMd2uHZ2DQzdvD9wYUfUlFyrJMZbaH0zdSS6G45cT
dwbTXjJsHx0vd5zKMf2CdWq/PPMpIyMj40vH5CKW2hxMH631sO2O9YbBgnxR
Uy1OHEn8pSu5UNFjTbW8E38kNjgUuxG5rdvV3x4O9d28FoqoBpOL7lDEPupF
ps1oxv3u9Jd0p7/cfdqdvlan9ssznzIyMjJmOV5LX7sStT8lF852laps62S7
qqd6eiO91//U7SoXHcFw4Gq/arD2zrC/I9zemRqTi377OrG4Gm7v6E+NHfqp
/oC8bxsd3wC4L6u1P/2m3/qXpp3qN8sFIyMjY/ZjoDMs05782W7th639eOOp
y7rT9BsGC5aLmtPieIUVh8qDoqJUnDom27VdvfNqONg9pNu1zdfX6gu1+EKq
weSipS3U7OtJjG1p+47N5vhmS5u+3JPa94Xso36w+QWXE+u2Hv2supzNKSMj
I2MWY2JHrlM7if1EdKfpNwx8sczq1bL9omyfOGz7PxGUFooDu8X+nbJgB1Yu
Sz7S4w+EL12+ptq11dfX2NQloxqs4bK1brwcVKPe17FfTu4EHQvH2NDU1ZD+
SIP1kmCmlwfVZXWqx5lPGRkZGbMYEzsNif202O6nvcFq1/IDoniH2LvD+dl1
13ax8ydxoFi2q35Pq6/3tzq/ateWtt7z9e0XLgZUg8mFihrPX+y4YCVwoT4g
19ZY32G7HD+y9gPxm/qpzKPjsn3UL3Sf6u590bOMjIyMLx3Pp/YzdJo6dXfa
wMrlorR46pdtulMnfk6tn/24RRTtGVy5PP5s4Hx9oKm5++jxxkS7tvbW1vnO
nvOrBpMLFcfoSPrpFT3a9q+4R1uco+OFszplZGRknOU4c67on9b3rkV7Hm/Z
rOr06Q+bH8ejxgebNok9u+Ud/WzDpWBJaW2yXftOV1+prvWbiGpFb28SQsgr
S2R1vigsHNu48cGm792R+6KoMLJqubp8psZf/3vXjl3HE+3acr3qROupkz5C
CCGOBNd8JvYViSKZwgwpLBT7Sjq//FxdPlnlO1cX3LqtXLVrU1Oo7HBDZfkl
QgghjuwtOda1cml0zYqhVfnuRFfnB1flyzvqcsWvjWdO+2lXQgjxNrQrIYSY
CO1KCCEm4mjX5pZQeVnDkcpLhBBCckllRWNNdapdR2L3I9E7kegoIYSQHHPr
1kPdroQQQryNbNd/ATshN10=
   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellID->19744779]
}, Open  ]],

Cell["Apply a template and select all of the data written:", "ExampleText",
 CellID->327415060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "CellContents"}], "]"}], ";", 
  RowBox[{"NotebookApply", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{
     "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<\[Placeholder]\>\""}], 
     "]"}], ",", "All"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15564343],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx3Ga7hv/he77E7rqx21OjTflTIKTqDWOY9NFM8100aT9sJpM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   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellID->711422343]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17569],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoScroll",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25425039],

Cell[TextData[{
 "Select an \"",
 Cell[BoxData["x"], "InlineFormula"],
 "\" in a cell that is not visible in the notebook window:"
}], "ExampleText",
 CellID->553566239],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
         "]"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cell", "[", 
          RowBox[{
           RowBox[{"BoxData", "[", "\"\<x\>\"", "]"}], ",", "\"\<Input\>\""}],
           "]"}], ",", 
         RowBox[{"{", "50", "}"}]}], "]"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellContents", ",", "30", ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->682512284],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1zVNd9B3B1+r6Tf6H/Sh9eOh6YvKHMNMZTY6WdDJNO39XTF5k6aWOn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   "], {{0, 0}, {458, 210}}, {0, 255}],
  ImageSize->{458 0.75, 210 0.75},
  PlotRange->{{0, 458}, {0, 210}}]], "NotebookImage",
 CellID->417263585]
}, Open  ]],

Cell["\<\
Usually, writing data to a location makes the document scroll to that \
location:\
\>", "ExampleText",
 CellID->332025699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{
    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<\[Placeholder]\>\""}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->169089497],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etzFeUdB3A6fd/xX+i/0stbHZi+ocxUcArEdhyGTl8w05m+cKq2UjvF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   "], {{0, 0}, {458, 208}}, {0, 255}],
  ImageSize->{458 0.75, 208 0.75},
  PlotRange->{{0, 458}, {0, 208}}]], "NotebookImage",
 CellID->166077899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->581410254],

Cell[TextData[{
 "Again, select an \"",
 Cell[BoxData["x"], "InlineFormula"],
 "\" that is not visible in the notebook window:"
}], "ExampleText",
 CellID->41115676],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
         "]"}], "}"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cell", "[", 
          RowBox[{
           RowBox[{"BoxData", "[", "\"\<x\>\"", "]"}], ",", "\"\<Input\>\""}],
           "]"}], ",", 
         RowBox[{"{", "50", "}"}]}], "]"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellContents", ",", "30", ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->36069886],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1zVNd9B3B1+r6Tf6H/Sh9eOh6YvKHMNMZTY6WdDEOmL5ippy8yddLG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   "], {{0, 0}, {458, 207}}, {0, 255}],
  ImageSize->{458 0.75, 207 0.75},
  PlotRange->{{0, 458}, {0, 207}}]], "NotebookImage",
 CellID->73904079]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["AutoScroll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoScroll"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the location where data is written stays off screen:"
}], "ExampleText",
 CellID->22258763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{
    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<\[Placeholder]\>\""}], "]"}],
    ",", 
   RowBox[{"AutoScroll", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11733032],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1zVNd9B3B1+r6Tf6H/Sh9eOh6YvKHMNMZTY6WdDEOmL5ippy8yddLG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   "], {{0, 0}, {458, 207}}, {0, 255}],
  ImageSize->{458 0.75, 207 0.75},
  PlotRange->{{0, 458}, {0, 207}}]], "NotebookImage",
 CellID->52808109]
}, Open  ]],

Cell[TextData[{
 "Moving the selection slightly, without ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutoScroll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoScroll"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", scrolls to where the new data is:"
}], "ExampleText",
 CellID->417963044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "After", ",", "Character"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->868244389],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etzFeUdB3A6fd/xX+i/0stbHRjfUGYqOAViOw5Dpy+Y6UxfOFVbqZ3i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   "], {{0, 0}, {458, 207}}, {0, 255}],
  ImageSize->{458 0.75, 207 0.75},
  PlotRange->{{0, 458}, {0, 207}}]], "NotebookImage",
 CellID->337783508]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9033],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionMove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionMove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PasteButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PasteButton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6718],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->25038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->44964809],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->573719460]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookApply - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 39.9830250}", "context" -> "System`", 
    "keywords" -> {"applying functions to notebook content"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookApply[notebook, data] writes data into a notebook at the current \
selection, replacing the first selection placeholder in data by the current \
selection, and then setting the current selection to be just after the data \
written. NotebookApply[notebook, data, sel] writes data into a notebook and \
then sets the current selection to be as specified by sel. ", 
    "synonyms" -> {"notebook apply"}, "title" -> "NotebookApply", "type" -> 
    "Symbol", "uri" -> "ref/NotebookApply"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6573, 215, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->54007834]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46634, 1118}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2310, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2933, 83, 51, 1, 70, "ObjectName",
 CellID->28965],
Cell[2987, 86, 1329, 38, 70, "Usage",
 CellID->37]
}, Open  ]],
Cell[CellGroupData[{
Cell[4353, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4831, 146, 348, 13, 70, "Notes",
 CellID->22219],
Cell[5182, 161, 487, 15, 70, "Notes",
 CellID->9818],
Cell[5672, 178, 237, 7, 70, "Notes",
 CellID->25049],
Cell[5912, 187, 340, 10, 70, "Notes",
 CellID->712],
Cell[6255, 199, 281, 11, 70, "Notes",
 CellID->28646]
}, Closed]],
Cell[CellGroupData[{
Cell[6573, 215, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54007834],
Cell[CellGroupData[{
Cell[6957, 229, 148, 5, 70, "ExampleSection",
 CellID->526211943],
Cell[7108, 236, 145, 5, 70, "ExampleText",
 CellID->914649034],
Cell[7256, 243, 204, 7, 70, "Input",
 CellID->142365028],
Cell[CellGroupData[{
Cell[7485, 254, 157, 4, 70, "Input",
 CellID->904349655],
Cell[7645, 260, 2698, 46, 70, "NotebookImage",
 CellID->370926748]
}, Open  ]],
Cell[10358, 309, 170, 5, 70, "ExampleText",
 CellID->41003072],
Cell[CellGroupData[{
Cell[10553, 318, 261, 8, 70, "Input",
 CellID->363983101],
Cell[10817, 328, 2726, 47, 70, "NotebookImage",
 CellID->19744779]
}, Open  ]],
Cell[13558, 378, 95, 1, 70, "ExampleText",
 CellID->327415060],
Cell[CellGroupData[{
Cell[13678, 383, 389, 11, 70, "Input",
 CellID->15564343],
Cell[14070, 396, 2743, 47, 70, "NotebookImage",
 CellID->711422343]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16862, 449, 218, 7, 70, "ExampleSection",
 CellID->17569],
Cell[CellGroupData[{
Cell[17105, 460, 230, 7, 70, "ExampleSubsection",
 CellID->25425039],
Cell[17338, 469, 169, 5, 70, "ExampleText",
 CellID->553566239],
Cell[CellGroupData[{
Cell[17532, 478, 802, 23, 70, "Input",
 CellID->682512284],
Cell[18337, 503, 4491, 76, 70, "NotebookImage",
 CellID->417263585]
}, Open  ]],
Cell[22843, 582, 132, 4, 70, "ExampleText",
 CellID->332025699],
Cell[CellGroupData[{
Cell[23000, 590, 261, 8, 70, "Input",
 CellID->169089497],
Cell[23264, 600, 3836, 65, 70, "NotebookImage",
 CellID->166077899]
}, Open  ]],
Cell[27115, 668, 125, 3, 70, "ExampleDelimiter",
 CellID->581410254],
Cell[27243, 673, 165, 5, 70, "ExampleText",
 CellID->41115676],
Cell[CellGroupData[{
Cell[27433, 682, 801, 23, 70, "Input",
 CellID->36069886],
Cell[28237, 707, 4681, 79, 70, "NotebookImage",
 CellID->73904079]
}, Open  ]],
Cell[32933, 789, 370, 13, 70, "ExampleText",
 CellID->22258763],
Cell[CellGroupData[{
Cell[33328, 806, 307, 9, 70, "Input",
 CellID->11733032],
Cell[33638, 817, 4681, 79, 70, "NotebookImage",
 CellID->52808109]
}, Open  ]],
Cell[38334, 899, 365, 12, 70, "ExampleText",
 CellID->417963044],
Cell[CellGroupData[{
Cell[38724, 915, 155, 4, 70, "Input",
 CellID->868244389],
Cell[38882, 921, 3804, 65, 70, "NotebookImage",
 CellID->337783508]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42759, 994, 310, 9, 70, "SeeAlsoSection",
 CellID->9033],
Cell[43072, 1005, 975, 35, 70, "SeeAlso",
 CellID->14672]
}, Open  ]],
Cell[CellGroupData[{
Cell[44084, 1045, 313, 9, 70, "TutorialsSection",
 CellID->6718],
Cell[44400, 1056, 186, 4, 70, "Tutorials",
 CellID->25038]
}, Open  ]],
Cell[CellGroupData[{
Cell[44623, 1065, 299, 8, 70, "MoreAboutSection"],
Cell[44925, 1075, 168, 3, 70, "MoreAbout",
 CellID->44964809],
Cell[45096, 1080, 128, 3, 70, "MoreAbout",
 CellID->573719460]
}, Open  ]],
Cell[45239, 1086, 27, 0, 70, "History"],
Cell[45269, 1088, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

