(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43898,       1057]
NotebookOptionsPosition[     39109,        900]
NotebookOutlinePosition[     40980,        952]
CellTagsIndexPosition[     40862,        946]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookRead\"\>", 
       2->"\<\"NotebookWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookDelete", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookDelete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookDelete"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes the current selection in the notebook \
corresponding to the specified notebook object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookDelete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookDelete"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]deletes the current selection in the current \
evaluation notebook."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11457]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["NotebookDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookDelete"]], "InlineFormula"],
 " in the kernel is equivalent to using the ",
 StyleBox["Clear", "MenuName"],
 " command in the front end. "
}], "Notes",
 CellID->24385],

Cell[TextData[{
 "After ",
 Cell[BoxData[
  ButtonBox["NotebookDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookDelete"]], "InlineFormula"],
 ", the current selection becomes an insertion point at the position of the \
deleted material. "
}], "Notes",
 CellID->19293],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["notebook", "TI"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ", as returned by ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 ", etc. "
}], "Notes",
 CellID->31716]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7286721],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->136869342],

Cell["Select a cell:", "ExampleText",
 CellID->172447795],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98183004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->523832854],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/HtdKZP2ulkpn9Bpn9Fn/bHs1QnbZ6knWnAVCTtZBw7eZCZ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   "], {{0, 0}, {458, 116}}, {0, 255}],
  ImageSize->{458 0.75, 116 0.75},
  PlotRange->{{0, 458}, {0, 116}}]], "NotebookImage",
 CellID->86736058]
}, Open  ]],

Cell["Delete the current selection:", "ExampleText",
 CellID->7352444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDelete", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->411331320],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx3Ga7pv+hf6Vftzq1HRTzZQ4iVbjODZdNNNMF032y2oyFcQQ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   "], {{0, 0}, {458, 116}}, {0, 255}],
  ImageSize->{458 0.75, 116 0.75},
  PlotRange->{{0, 458}, {0, 116}}]], "NotebookImage",
 CellID->235652519]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->35287782],

Cell["Create a notebook:", "ExampleText",
 CellID->1037626643],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Text\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<some text\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}],
         "]"}], ",", 
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{"TextCell", "[", 
          RowBox[{"\"\<Next section\>\"", ",", "\"\<Section\>\""}], "]"}], 
         "}"}], "]"}]}], "}"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356012824],

Cell["Move the selection to the first \"T\":", "ExampleText",
 CellID->7030179],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "CellContents"}], "]"}], ";"}], "\n", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Character"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->342746478],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9zVNUdx/Ht9HnHf6H/CdPWh4HR8Yl1poJTIG3HYdrhGUwfOFVbiZ3i
j2AiP5QCEUSRpCJiF5Af2fzAEAhINpLY/NBpEDQyDSMFevvdnN3vnr337mZD
7jfZ7L5f823mfM89e3aTBx/P3izpT5/Z9PgzP06lUr3yv74fpVK58YYNf6Qo
iqIs6t79BxRFUVSCpen6zsFPKIqiqEQqlK7LfoSmKIqqg4pN1wAAsAgbCvda
SVcASBDpCgAWSFcAsEC6AoAF0hUALJCuAGCBdAUAC6QrAFggXQHAAukKABZI
VwCwQLoCwEPbvKXr0dVtrh57co9/iXQFgERIwPot6QoAiSBdAcAC6QoAFpYx
XVMFofl0Oh17qbOzs7m52c23t7dPT0+7eRm4yZaWFl28detWN+mWyVe5Gl0W
JStl86amJn2i8fHx0Jpyr0QNDg7qCwjtEPtKYr9ffxMZSDvvT6/cjxTA0qvB
dNVk00szMzOaZkqWaaxJ3LlJF0GZTMa1EtRugUScPlDG5V6SxGAqTjabrfKV
iI6Ojgo7xL6S6I8idhOZrPzTK/cjBbD0ai1d/YOrXtLwdHEkSeVa/xTqMlmi
TwJQx5WfK0qT04Whhq1uNe8rkXh3M3LalFcSFHJSd6gmFXVbt4nQQ6weg0lX
oMbVWrr6B1e9FHqbH0tjTXfw348/XOzoPYfqX4m+6/ePuzK5oFTU861uonlb
4bj70N8mAAs1la7uZOi/KS63MpYmW6r0TXT1OygJT3kxGtSVb5Au6ImqSUV9
3ugauVT9PgCWUe2kq5zxXKuDaLpG+Rv6d03du/Jyz1VBOp0O3VmV82p0n3Kv
ZN4nqiYVk1oDYBnVTrq6I6s7c5ZLknKZ5uhNUSHjCs9Vjn/6TVX8TX25VzLv
E1WTipxdgTpQI+nqH1yDSEro3c7QY/1TZfTX/Q9x31WX6YcNQuZ9JZrP+uzW
910Xf3sZgIUaSVf/4BpEUkIPpS5t9HMF/gHVvZ2Xo130F/3RDcvRQ6P7pZVm
WvQzA+VeSbnPDGj8VpOu+i1U85mB0BOFvnEAy6UW0tX9al7f8wZxERT6LIFb
rzdXNeUymYzfuiNoKqLcS9IPyoboGXLeVxKU+aiqS8VyryT6wmI38f9ropMa
vKrcwRvAUqqFdHXvpv1MiI1BCRyXbPJVxhpo+rkp/0aB/9GpcpkWS4LUv/sa
+2+1yr0SJSdY3cTfofp0da/E/7dafsIHkZO/fsSXaAVqRC2ka6r04BoY3D9M
fMM6eCUATNVIuoZOXKQrgJWuFtI1dHANDCJI3la7985JbZjsKyFygfpTC+ka
vVVolDYV/n7LEgu9EtIVqD/8fVcAsEC6AoAF0hUALJCuAGCBdAUAC6QrAFgg
XQEgQZu3dEmu5moN6QoAyVuus+uqVatSALCSSY6Fkq14cF3d1rzp8LKkKwA0
FNIVACyQrgBggXQFAAukKwBYIF0BwALpCgAWSFcAsEC6AoAF0hUALJCuAGCB
dAUAC6QrAFggXQHAAukKABZIVwCwQLoCgAXSFQAskK4AYIF0BQALpCsAWCBd
AcAC6QoAFkhXALBAugKABdIVACyQrgBggXQFAAukKwBYIF0BwALpCgAWSFcA
sEC6AoAF0hUALJCuAGCBdAUAC6QrAFggXQHAAukKABZIVwCwQLoCgAXSFQCq
sXlL16Or21w99uSeCpMO6QoACyVZOu8k6QoAC9Vo6ZoqKDfjtxUGsdtWGM+7
A4A604Dp6g9CMVt5EJ1P5LEA6lKjpavjnyT9ycqDCsFYOTxjnwVAfWu0dI3e
FoiOK6Rr9MZCdGXszYfYMYA61oDp6g/KpWv0Zmn0sRW2rfBEpCvQIBotXYOK
v8YKIokaRBI4NlpjdwgiQV3u6Aug/jRgulqoPjCJVqBBkK6JIF0BhJCuAGCB
dAWABBX/qsAa0hUAksfZFQCS4v85rOZNh6MLSFcAsEC6AoAF0hUALJCuAGCB
dAUAC6QrAFggXQHAwuNPve23pCsAJIKzKwBYIF0BwALpCgAWSFcAsEC6AoAF
0hUALJCuAGBhudI1VZ3EnxcAEuH/fdfHntwTXUC6AsAi1dT/NwHpCqBukK4A
YIF0BQALtZyu8853dnY2Nze7yfb29unpaTcvAzfZ0tKii7du3eom3TL5Klej
ywAgESs0XWdmZjRXVVNTkwasBK+bHBwclDaTybg2nU67BZLG+kAZJ/69AGhw
KzRdNTxdMGaz2egpVMJWZiSEJYp1HN0z8e8CAIIVm66ht/mx5NSqZ1o3GB8f
j+6Z+HcBAMGKTdcqs1HvrIqOjo7Y50r8uwCAYOWna5S/oRxWdX5mZib2uRL/
LgAgqPd01duzQsaxz5X4dwEAwYpNV73vGloj8zrjH1wd7rsCWDIrNF31UJrN
ZqVNp9PRA6r7yFZTU5PGLJ8ZALBkVmi6BoUPXPlkRm+uat5mMhm/dZ93TUUk
/r0AaHArN11FR0eHy1j5KmONVv23Wv6NAv9DXKQrAGsrOl0Tea5EdgOAkFpL
10TWVPlcpCsAOw2brtls1t1VSGQ3AAhp2HR1+PstAIzUWrpWI/HnBYDEka4A
YIF0BQALpCsAWKipdAWAukG6AoAF0hUAErR5S5dEaK7WkK4AkLyaOruuWrWq
yl9sAcCyk8gKhVjx4Lq6rXnT4QqTS5yuANBQSFcAsEC6AoAF0hUALJCuAGCB
dAUAC6QrAFggXQHAAukKABZIVwCwQLoCgAXSFQAskK4AYIF0BQALpCsAWCBd
AcAC6QoAFkhXALBAugKABdIVACyQrgBggXQFAAukKwBYIF0BwALpCgAWSFcA
sEC6AoAF0hUALJCuAGCBdAUAC6QrAFggXQHAAukKABZIVwCw4Kfr757dNnr9
X0e7el7ato+iKIpaZN37773unmu//8P2Dc++LOkqlc2OURRFUYssP12zw5NB
8ODBg/sURVHUYup/D+776fr51Yl79+7P3vlB6s5c5cez8vWutrOz+QUyqYt1
7NcdWlpa2hptF5xpb+w8uOuJnx1Y8/P9a34RLZmXq7LGPfCHH+7Ozt7VdL18
6cvvb8/evPX9zVszc1+/L4xnwuNv/QW6Xidvl16lpaWlran2YTKt84nV9199
LXhrb7B7d0y9tVeuyhr3wFvf5h6i6Xrx4vWv/31rYuqbicnpnzzyiF8TU9MT
Uzfy40l/fEPKW/ZNYXBDx64tznvrYxcXd55b7K66QfhRpVdpaWlpq2pzITY9
N+lmpgvzhcpfms49qrDDFxvXBcc+DI4cKlvHPpQ17rGTX30zOXVT07X/wsj1
L7/OfjHp4ksGrgrtVHF+pLimMJiYW5xfM1KyyYTfhjYPXZW2dEHuqr+48lVa
WlraedvCYKo4OVLa5sYT3prcDiMb1gWdR4N3O/IfupKBK207j8qauYdMjVyf
+mL0a03Xnt7hoatfXhoadQkmg8GhUb/VQdzkWOz8YOkmg6WbR68Olo7dVX9x
5au0tLS0VbaXSseRGvMfJYNwuorD3riQru5Rl6+MXvl8XNNVBv0Dw32fXXMJ
1nthuKd/uPdCsS0Mrvnj/OCz4d7+a8W2Xx91rU/We23oDkB0sRv3lK7syT1p
yVXdWQa0tLS01bd9F4alegtfe3Pzw7n5ucRzizXTdIeRDWuDziPBof25Cjmw
J9i/O3j/oKRrr9vzs+GBweuarue7r57rHjrbPeQSTAZnzw+d6b6cb8+XzIcm
z8xNnj2viy8X57uH/FYfeKbM4vz4/GV9rFtczVVaWlraKtr8jIyLM/n5fGmm
6Q7ZXz+dy9W9bwZ724O324rRurs12PVa8OYrErDZ9U8XHnK5p2/41KeXXLqe
67568vRFKZdg6U9z45OfDrhW57X8xYWZgdAg1KZPX0yXPiSd22QgbvMBt9hd
1bbyVVpaWtoq2vxMOj9fUt76kh1y6bpvV9C2PXhje/js+urLwSstwa42SVfd
51z3lX8c63Hpevb8leMnej/+pM8lmAxcufb4J/0f56rv4xN9Ms61J/q9xXOX
cvN9cyv1UfFtaLHf6obRq5q95R5LS0tLO297vDgfk2nuajTTsuvXBrvb7v9t
m2bq3b8Wx3f+8mKw4/WR9WvnHtt3/ETf6TOD7xw6mU/Xc1e6jnV/+FGPSzAZ
uAq1oSq9mtHWm89EW6/CbWjDBV2lpaWlXWBbuTL6NXffdcfrt198wcXpf/78
wu25cu13zz8fvP6arNHHpk8N7NzdVUjXq0eOZo529ViUS8VkV1IURS1ZjTav
C1pbbz733HfP/ylaMh/saB3duNYt/qCz58Q/L25/9VA+Xc9+fvjdc++/101R
FEWFauA3vwzadwQ7pFpjqrU1aN954be/covfO9z90bGBl7btc+l6+vTQ3rfT
B/adoiiKokL1xs6DF9c/NfabZ65vXBetseZ1AxvXyRq3eP/fT35wpId0pSiK
SrZIV4qiKIsiXSmKoiwqlK5nzg7t25vuOHCKoiiKWkwd2H+y82gxXSenvh0d
uzE6Nk1RFEUtsr76akbTlaIoikq2JF3/D5X/ioo=
   "], {{0, 0}, {458, 201}}, {0, 255}],
  ImageSize->{458 0.75, 201 0.75},
  PlotRange->{{0, 458}, {0, 201}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->73159192]
}, Open  ]],

Cell["Delete the current selection:", "ExampleText",
 CellID->71975722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDelete", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->399637059],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9zVNUdx/Ht9HnHf6H/CdPWh4HR8Yl1poJTINpxmHZ4BtMHTtVWYqf4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   "], {{0, 0}, {458, 201}}, {0, 255}],
  ImageSize->{458 0.75, 201 0.75},
  PlotRange->{{0, 458}, {0, 201}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->86341417]
}, Open  ]],

Cell["Select multiple cells:", "ExampleText",
 CellID->288773701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellGroup"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14612606],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zVNUdx/Ht9PeO/0L/E6atvxkYW3+xnVFwSojtOEw7/AbTHxwfWokd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   "], {{0, 0}, {458, 201}}, {0, 255}],
  ImageSize->{458 0.75, 201 0.75},
  PlotRange->{{0, 458}, {0, 201}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->184263003]
}, Open  ]],

Cell["Delete the current selection:", "ExampleText",
 CellID->49058476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDelete", "[", "nb", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->491503552],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1zXdV5B2B1ep/Jv9D/hGnaS2DayU3bmQYzxTjpZDLt5C5MLzIlaQPp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   "], {{0, 0}, {458, 201}}, {0, 255}],
  ImageSize->{458 0.75, 201 0.75},
  PlotRange->{{0, 458}, {0, 201}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->10666788]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5107],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19628],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->12394]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->377153886]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookDelete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 45.1862832}", "context" -> "System`", 
    "keywords" -> {"delete selection", "remove selection"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookDelete[notebook] deletes the current selection in the notebook \
corresponding to the specified notebook object. NotebookDelete[] deletes the \
current selection in the current evaluation notebook.", 
    "synonyms" -> {"notebook delete"}, "title" -> "NotebookDelete", "type" -> 
    "Symbol", "uri" -> "ref/NotebookDelete"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9224, 254, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7286721]},
 "Notebook Image"->{
  Cell[17752, 464, 4848, 82, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->73159192],
  Cell[22825, 559, 4803, 81, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->86341417],
  Cell[27888, 654, 4853, 82, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->184263003],
  Cell[32966, 749, 4157, 71, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->10666788]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40286, 926},
 {"Notebook Image", 40425, 930}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1974, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2597, 78, 4198, 83, 70, "ObjectNameGrid"],
Cell[6798, 163, 873, 26, 70, "Usage",
 CellID->11457]
}, Open  ]],
Cell[CellGroupData[{
Cell[7708, 194, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8186, 211, 296, 10, 70, "Notes",
 CellID->24385],
Cell[8485, 223, 284, 9, 70, "Notes",
 CellID->19293],
Cell[8772, 234, 415, 15, 70, "Notes",
 CellID->31716]
}, Closed]],
Cell[CellGroupData[{
Cell[9224, 254, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7286721],
Cell[CellGroupData[{
Cell[9607, 268, 148, 5, 70, "ExampleSection",
 CellID->136869342],
Cell[9758, 275, 57, 1, 70, "ExampleText",
 CellID->172447795],
Cell[9818, 278, 213, 7, 70, "Input",
 CellID->98183004],
Cell[CellGroupData[{
Cell[10056, 289, 149, 4, 70, "Input",
 CellID->523832854],
Cell[10208, 295, 3014, 52, 70, "NotebookImage",
 CellID->86736058]
}, Open  ]],
Cell[13237, 350, 70, 1, 70, "ExampleText",
 CellID->7352444],
Cell[CellGroupData[{
Cell[13332, 355, 111, 3, 70, "Input",
 CellID->411331320],
Cell[13446, 360, 2840, 49, 70, "NotebookImage",
 CellID->235652519]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16335, 415, 219, 7, 70, "ExampleSection",
 CellID->35287782],
Cell[16557, 424, 62, 1, 70, "ExampleText",
 CellID->1037626643],
Cell[16622, 427, 746, 21, 70, "Input",
 CellID->356012824],
Cell[17371, 450, 79, 1, 70, "ExampleText",
 CellID->7030179],
Cell[CellGroupData[{
Cell[17475, 455, 274, 7, 70, "Input",
 CellID->342746478],
Cell[17752, 464, 4848, 82, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->73159192]
}, Open  ]],
Cell[22615, 549, 71, 1, 70, "ExampleText",
 CellID->71975722],
Cell[CellGroupData[{
Cell[22711, 554, 111, 3, 70, "Input",
 CellID->399637059],
Cell[22825, 559, 4803, 81, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->86341417]
}, Open  ]],
Cell[27643, 643, 65, 1, 70, "ExampleText",
 CellID->288773701],
Cell[CellGroupData[{
Cell[27733, 648, 152, 4, 70, "Input",
 CellID->14612606],
Cell[27888, 654, 4853, 82, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->184263003]
}, Open  ]],
Cell[32756, 739, 71, 1, 70, "ExampleText",
 CellID->49058476],
Cell[CellGroupData[{
Cell[32852, 744, 111, 3, 70, "Input",
 CellID->491503552],
Cell[32966, 749, 4157, 71, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->10666788]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37184, 827, 310, 9, 70, "SeeAlsoSection",
 CellID->5107],
Cell[37497, 838, 469, 17, 70, "SeeAlso",
 CellID->12912]
}, Open  ]],
Cell[CellGroupData[{
Cell[38003, 860, 314, 9, 70, "TutorialsSection",
 CellID->19628],
Cell[38320, 871, 186, 4, 70, "Tutorials",
 CellID->12394]
}, Open  ]],
Cell[CellGroupData[{
Cell[38543, 880, 299, 8, 70, "MoreAboutSection"],
Cell[38845, 890, 169, 3, 70, "MoreAbout",
 CellID->377153886]
}, Open  ]],
Cell[39029, 896, 50, 0, 70, "History"],
Cell[39082, 898, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

