(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17524,        576]
NotebookOptionsPosition[     14071,        462]
NotebookOutlinePosition[     15516,        502]
CellTagsIndexPosition[     15431,        497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating the Front End from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating the Front End from the Kernel\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookInformation" :> 
          Documentation`HelpLookup["paclet:ref/NotebookInformation"], 
          "Directory" :> Documentation`HelpLookup["paclet:ref/Directory"], 
          "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NotebookInformation\"\>", 2->"\<\"Directory\"\>",
        3->"\<\"SetDirectory\"\>", 4->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookDirectory", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookDirectory"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the directory of the current evaluation notebook. \
"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookDirectory"], "[", 
       StyleBox["nb", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the directory for the notebook specified by ",
     Cell[BoxData[
      StyleBox["nb", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookDirectory"]], "InlineFormula"],
 " returns the full name of the directory as a string. "
}], "Notes",
 CellID->2398],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookDirectory"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if the specified notebook has never been saved as a file. "
}], "Notes",
 CellID->32505],

Cell[TextData[{
 "The directory given by ",
 Cell[BoxData[
  ButtonBox["NotebookDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookDirectory"]], "InlineFormula"],
 " is on the filesystem of the computer on which the notebook front end is \
being run. "
}], "Notes",
 CellID->20339]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76324929],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->514128589],

Cell["\<\
Find the name of the directory containing the notebook file for this \
reference page:\
\>", "ExampleText",
 CellID->39982144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDirectory", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191195820],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\\\\\"\>"], "Output",
 ImageSize->{557, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312516446]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->511790402],

Cell["\<\
There is no directory for a notebook that has been created but not yet saved:\
\
\>", "ExampleText",
 CellID->46714229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394419106],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["wzf_shm", 1, 1]], 28]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"Untitled-3\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["wzf_shm", 1, 1]], 28],
  Editable->False]], "Output",
 ImageSize->{202, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181759352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDirectory", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134306273],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookDirectory", "::", "\<\"nosv\"\>"}], ":", 
  " ", "\<\"The notebook \
\\!\\(\\*InterpretationBox[\\(NotebookObject[\\(\\(\\*PanelBox[GridBox[{{\
TooltipBox[ButtonBox[StyleBox[DynamicBox[FEPrivate`FrontEndResource[\\\"\
FEBitmaps\\\", \\\"ManipulatePasteIcon\\\"]], Rule[DynamicUpdating, True]], \
Rule[ButtonFrame, None], RuleDelayed[ButtonFunction, \
FrontEndExecute[List[FrontEnd`SetSelectedNotebook[NotebookObject[\
FrontEndObject[LinkObject[\\\"wzf_shm\\\", 1, 1]], 28]]]]], \
Rule[ButtonEvaluator, None], Rule[BaseStyle, List[]], Rule[Method, \\\"Queued\
\\\"]], DynamicBox[FEPrivate`FrontEndResource[\\\"FEStrings\\\", \
\\\"NotebookObjectToTheFront\\\"]]], \
StyleBox[\\\"\\\\\\\"Untitled-3\\\\\\\"\\\", Rule[FontColor, \
GrayLevel[0.5`]], Rule[StripOnInput, False]]}}, ColumnAlignments -> Left], \
Rule[FrameMargins, List[List[4, 5], List[4, 4]]]]\\)\\)]\\), \
NotebookObject[FrontEndObject[LinkObject[\\\"wzf_shm\\\", 1, 1]], 28], \
Rule[Editable, False]]\\) is not saved.\"\>"}]], "Message", "MSG",
 CellID->265464206],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->273759279]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21479],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31251],

Cell[TextData[ButtonBox["Manipulating the Front End from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]], "Tutorials",
 CellID->22073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->470905458],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->468965343],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->517732400]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 46.4206898}", "context" -> "System`", 
    "keywords" -> {
     "current notebook directory", "directory of the current notebook", 
      "notebook location", "notebook path"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookDirectory[] gives the directory of the current evaluation \
notebook. NotebookDirectory[nb] gives the directory for the notebook \
specified by nb. ", "synonyms" -> {"notebook directory"}, "title" -> 
    "NotebookDirectory", "type" -> "Symbol", "uri" -> 
    "ref/NotebookDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6982, 210, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->76324929]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15289, 490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2407, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3030, 84, 1582, 37, 70, "ObjectNameGrid"],
Cell[4615, 123, 900, 28, 70, "Usage",
 CellID->18538]
}, Open  ]],
Cell[CellGroupData[{
Cell[5552, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6030, 173, 237, 7, 70, "Notes",
 CellID->2398],
Cell[6270, 182, 373, 12, 70, "Notes",
 CellID->32505],
Cell[6646, 196, 299, 9, 70, "Notes",
 CellID->20339]
}, Closed]],
Cell[CellGroupData[{
Cell[6982, 210, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76324929],
Cell[CellGroupData[{
Cell[7366, 224, 148, 5, 70, "ExampleSection",
 CellID->514128589],
Cell[7517, 231, 136, 4, 70, "ExampleText",
 CellID->39982144],
Cell[CellGroupData[{
Cell[7678, 239, 108, 3, 28, "Input",
 CellID->191195820],
Cell[7789, 244, 302, 7, 54, "Output",
 CellID->312516446]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8140, 257, 230, 7, 70, "ExampleSection",
 CellID->511790402],
Cell[8373, 266, 129, 4, 70, "ExampleText",
 CellID->46714229],
Cell[CellGroupData[{
Cell[8527, 274, 193, 6, 70, "Input",
 CellID->394419106],
Cell[8723, 282, 1281, 41, 70, "Output",
 CellID->181759352]
}, Open  ]],
Cell[CellGroupData[{
Cell[10041, 328, 114, 3, 70, "Input",
 CellID->134306273],
Cell[10158, 333, 1070, 18, 70, "Message",
 CellID->265464206],
Cell[11231, 353, 164, 5, 36, "Output",
 CellID->273759279]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11456, 365, 311, 9, 70, "SeeAlsoSection",
 CellID->21479],
Cell[11770, 376, 969, 35, 70, "SeeAlso",
 CellID->27217]
}, Open  ]],
Cell[CellGroupData[{
Cell[12776, 416, 314, 9, 70, "TutorialsSection",
 CellID->31251],
Cell[13093, 427, 192, 4, 70, "Tutorials",
 CellID->22073]
}, Open  ]],
Cell[CellGroupData[{
Cell[13322, 436, 319, 9, 70, "MoreAboutSection",
 CellID->470905458],
Cell[13644, 447, 179, 3, 70, "MoreAbout",
 CellID->468965343],
Cell[13826, 452, 173, 3, 70, "MoreAbout",
 CellID->517732400]
}, Open  ]],
Cell[14014, 458, 27, 0, 70, "History"],
Cell[14044, 460, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

