(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56813,       1510]
NotebookOptionsPosition[     49972,       1286]
NotebookOutlinePosition[     51419,       1326]
CellTagsIndexPosition[     51333,       1321]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"], 
          "CellEventActions" :> 
          Documentation`HelpLookup["paclet:ref/CellEventActions"], 
          "FrontEndEventActions" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndEventActions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"EventHandler\"\>", 
       2->"\<\"CellEventActions\"\>", 
       3->"\<\"FrontEndEventActions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookAndInterfaceCustomization"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Low-Level Interface Control\"\>", 
       2->"\<\"Notebook & Interface Customization\"\>", 
       3->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       4->"\<\"Stylesheets\"\>", 
       5->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookEventActions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NotebookEventActions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
     " \[LineSeparator]is a notebook option that gives a list of actions to \
perform when specified events occur in connection with the notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NotebookEventActions", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ":>", 
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ":>", 
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["2", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["action", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be evaluated whenever ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " occurs in connection with the notebook."
}], "Notes",
 CellID->20826],

Cell[TextData[{
 "The possible event specifications are the same as for ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 ", with the following addition:"
}], "Notes",
 CellID->15670],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<WindowClose\>\"", Cell[
    "window being closed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16712],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 " are often defined at the level of stylesheets, rather than for individual \
notebooks."
}], "Notes",
 CellID->20880],

Cell[TextData[{
 "By default, any action specified for an event by ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 " will override any default action that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would take for that event."
}], "Notes",
 CellID->563375303],

Cell[TextData[{
 "The default behavior can be changed by including rules for ",
 Cell[BoxData[
  ButtonBox["PassEventsDown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PassEventsDown"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PassEventsUp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PassEventsUp"]], "InlineFormula"],
 " in the list given as the setting for ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->141044261]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->201343996],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115610305],

Cell["\<\
Set up a certain action to take place when a notebook is closed:\
\>", "ExampleText",
 CellID->448315431],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "0"}], ";", 
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118995096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<WindowClose\>\"", "\[RuleDelayed]", 
       RowBox[{"k", "++"}]}], "}"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106816466],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+kua9HCraeNN26SCqWjbGGPTiyZNemGqtlqbegIP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   "], {{0, 0}, {458, 63}}, {0, 255}],
  ImageSize->{458 0.75, 63 0.75},
  PlotRange->{{0, 458}, {0, 63}}]], "NotebookImage",
 CellID->37512001]
}, Open  ]],

Cell[TextData[{
 "With the notebook open, ",
 Cell[BoxData["k"], "InlineFormula"],
 " is unchanged:"
}], "ExampleText",
 CellID->67770792],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[3]:=",
 CellID->214408060],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43526074]
}, Open  ]],

Cell[TextData[{
 "When you close the notebook window, ",
 Cell[BoxData["k"], "InlineFormula"],
 " is incremented:"
}], "ExampleText",
 CellID->79592513],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[4]:=",
 CellID->26785636],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->190015053]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->59703114],

Cell["Create a notebook window :", "ExampleText",
 CellID->18352363],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160409786],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 " so that the notebook will change color when clicked:"
}], "ExampleText",
 CellID->304750147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"nb", ",", 
         RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]}], "}"}]}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->165747673],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+kN608Otpo03bZMKpqJtY4xNL5o06YWp2mpt6gk8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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->57895206]
}, Open  ]],

Cell["Clicking the notebook changes its background:", "ExampleText",
 CellID->204021091],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtPVFcYxnGa3jd+hX6Q3vRwq7ExaaJJBSNg25jGpkmv2hhTtJVqiiCI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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->256050757],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219431775],

Cell[TextData[{
 "Make an action occur when the ",
 StyleBox["Enter", "KeyEvent"],
 " key is pressed:"
}], "ExampleText",
 CellID->112206551],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->657431519],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"nb", ",", 
         RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]}], "}"}]}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->520577085],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396599906],

Cell[TextData[{
 "Define actions for ",
 Cell[BoxData["\"\<MouseDown\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<MouseUp\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->730802096],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4924837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"nb", ",", 
          RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]}], ",", 
       RowBox[{"\"\<MouseUp\>\"", "\[RuleDelayed]", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"nb", ",", 
          RowBox[{"Background", "\[Rule]", "Inherited"}]}], "]"}]}]}], 
      "}"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->399852593],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+kN608Otpo03bZMKpqJtY4xNL5o06YWp2mpt6gk8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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->201155197]
}, Open  ]],

Cell["\<\
The background will be pink only while the mouse button is held down:\
\>", "ExampleText",
 CellID->260664617],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtPVFcYxnGa3jd+hX6Q3vRwq7ExaaJJBSNg25jGpkmv2hhTtJVqiiCI
AlUKKHhAoCJiOchhGAYcDgMyIIMtjKYgeKCFSIGurj1rZs3ee0ZEmS0G/uQn
eZ+13r3l6skEm76758uP97ydlJT0nvzjeSspyZjT0r4DADhhcWkZAJBAul0v
lN8EACSErV3X/SM0AGwAcdtVHDwIAHhlaZHftdKuAJBAtCsAOIF2BQAn0K4A
4ATaFQCcQLsCgBNoVwBwAu0KAE6gXQHACbQrADiBdgUAJ9CuAOAE2hUAnEC7
AoATaFcAeGVf78r+aGu+sn17nvmKdgWAhJAFa460KwAkxCZs1yTr17r/PAA2
pM3WruY6pVoBOId2BQAnbLZ2FdbfDKz7DwNgo9ps7cpnVwCvx2ZrV2H67Lru
PwmAjSf6n7xu23TtCgBOG/0mYxN+dgUAR8lqVZ9gzYe0KwCsharWv789RLsC
QKLoahWb8l+1AMAJ5moVtCsAJEje3uMHdubo/0fWvk9yzLe0KwA4gXYFACfQ
rgDgBNoVAJxAuwKAE8zt+sX+zMDoH1U17qOZJQCANVr8d9HlHjrwVVba/mOy
XaXh4TEAwBqZ23XYPyHE8vLyEgBgLf5bXjK3653B8cXFpbn5Z9J8SHiek98X
dJybCy/IQ72sZ7N5IpFIfEPjS3faqYLywh3vl237oHTbh7HkubyVO+rBZ88W
5uYWdLv29917Ojs3PfN0euZJ6PvTyPzEPj8yL+h9fThrvSUSicQ3Kr5Kp1Xv
2LqUnSPOFouiojjOFstbuaMenHlkPKLbtadn9MFfM+PBh+MTk+9s2WI2Hpwc
D06F5wnzPCWZ1h5Ghik9qxg9N+3HXY6+ObSsbtVgf8p6SyQSiauKRolNhg7V
yWTkPCJ8NWk8FXnD3fQUUXtNVFY8V+01uaOenbj/cCI4rdu1q3tk9N6D4bsT
qr7koERiMHo+Et2JDOOh5fDOiOUl4+Zoe7ntVkbrgnFrXl75lkgkEl8YI0Mw
ejhijcY8btox3jCSliKqq8TF80J9yUHRsbpK7oQeCY6MBu8GHuh2dXf6fYP3
+nwB1WBy6PUFzFEP8Q7H4p73Wl/Sa3157G2vdVa35uWVb4lEInGVsc86xxgz
PyUHe7vKr0umOdKu6qn+gcDAnT91u8qhy+v33B5SDdbZ7Xd3+Tu7ozEyDJnn
8HDb39k1FI1d+qkhj9w3RdtvAGKX1ey2brqNv9Ryq98sByKRSFx99HT7pc7I
907j3G+chxpPLetO028YSUsW1ZWiotRg+yr7RZQWiSvlsl071Ttv+729o7pd
212DbS5fq8unGkwOre2+Fld/OLZbzm2HLaHD1na93B89d/nMUT/Y8pzl8Nze
r59Vy6u5JRKJxFXE8Imcoyfh8zDdafoNw3t3G71afEYUnxbn8qPVWpQrCnPE
mROyYIdTd0ce6Xd7/E23+lS7trkGG5t7JNVgDbeMufGWV0V9rpmXIyde22CL
Dc09DdZHGoyXeOO93KuW1a2OK98SiUTiKmL4pCF8bmHat7zBaNeSQpGfJU5l
2T+7Zh8TJ34ShfmyXfV72lwDv9W6Vbu2tg/U1XfeuOlRDSYHRcW6m103DJ4b
9R45G7G+y7QcujLOPaFN/VT8aFs2R/3C2Fvdvc97lkgkEl8Y66LncTpN3cZ2
2nBqsijKX/o5U3fqwvHoPP/jEZF3ciQ1OfSsp67e09zSe6GiMdyubQM1ta5r
192qweSg2KKN9bZDR9N5R2w0sUfbC1/qlkgkEl8yrqxDfzd+75p3cvbIYVWn
//xweDZExccZGeJkjtzRzzY0eQuKaiLtOlhZ1VFV43aCasXEbgLAaxPYlyJy
c6cPHXqc8X0seS7ycgPpyWr5arW7/veerOyKcLu23rl0se3KZRcAwMb72U5x
Ok/kSblx5OaK0wXdn3+qli9fcl2v9R7NLFHt2tzsKz7XUFbSBACwOVVQ3pO6
a+yzPaPpKbHG9qV401Pkjlou/bXxaqWbdgWAxKJdAcAJtCsAOMHWri2tvpLi
hvNlTQCAtSgrbayuirbrRPBRYGwqMDYJAFij+/ef6HYFACSWbNf/Ad7ZBDI=

   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->184321496],

Cell["\<\
After the mouse is released, the notebook is back to its normal background:\
\>", "ExampleText",
 CellID->78536433],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+kN608Otpo03bZMKpqJtY4xNL5o06YWp2mpt6gk8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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->633981100]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8130],

Cell[TextData[{
 "This ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 " setting blocks the normal ",
 StyleBox["Enter", "KeyEvent"],
 " key behavior:"
}], "ExampleText",
 CellID->245145802],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198328167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
       RowBox[{"SetOptions", "[", 
        RowBox[{"nb", ",", 
         RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]}], "}"}]}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->273900920],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+kN608Otpo03bZMKpqJtY4xNL5o06YWp2mpt6gk8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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->25849888]
}, Open  ]],

Cell[TextData[{
 "Pressing ",
 StyleBox["Enter", "KeyEvent"],
 " changes the background but does not start a new line:"
}], "ExampleText",
 CellID->10842450],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtPVFcYxnGa3jd+hX6Q3vRwq7ExaaJJBSNg25jGpkmv2hhTtJVqiiCI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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->4619722],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70305312],

Cell[TextData[{
 "This inserts a newline as part of the action specified for ",
 Cell[BoxData["\"\<ReturnKeyDown\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->121617900],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->596644575],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SetOptions", "[", 
          RowBox[{"nb", ",", 
           RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], ";", 
         RowBox[{"NotebookWrite", "[", 
          RowBox[{"nb", ",", "\"\<\\n\>\""}], "]"}]}], ")"}]}], "}"}]}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->606636239],

Cell[TextData[{
 "Pressing ",
 StyleBox["Enter", "KeyEvent"],
 " in this notebook inserts a newline as well as setting the background:"
}], "ExampleText",
 CellID->171437743],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2N9Pk1ccx3GW3S/+C7vfX7EftxoXkyWaTDACusUsLia72jRm6KbTTEEQ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   "], {{0, 0}, {458, 81}}, {0, 255}],
  ImageSize->{458 0.75, 81 0.75},
  PlotRange->{{0, 458}, {0, 81}}]], "NotebookImage",
 CellID->34967464],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->546117591],

Cell[TextData[{
 "Specify a ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 " setting that goes away after being activated once:"
}], "ExampleText",
 CellID->3101969],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "a", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176928803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"NotebookEventActions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<ReturnKeyDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"SetOptions", "[", 
         RowBox[{"nb", ",", 
          RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
          RowBox[{"NotebookEventActions", "\[Rule]", "None"}]}], "]"}], 
        ")"}]}], "}"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14111910],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+kN608Otpo03bZMKpqJtY4xNL5o06YWp2mpt6gk8
ICoFFEQRqKhYDnIYZwYckAEZRgbbYTRF8USFSIGurj1rZs3ae0ZEmS3GeZ48
ku9d69tbrt5MkPj22k0frX0zLy/vHfnH/0ZenjUXFn6PiIhuODs3j4iIWVS3
68mqS4iImBUd7brsH6EREV8DM7arAACAJVCY/Fkr7QoAkEVoVwAAN6BdAQDc
gHYFAHAD2hUAwA1oVwAAN6BdAQDcgHYFAHAD2hUAwA1oVwAAN6BdAQDcgHYF
AHAD2hUAwA1oVwAAN6BdAQBemG++a/hg5UHlhx8fNa9oVwCArCAL1oy0KwBA
VsjBds2zs9zfDgC8nuRau5p1SrUCgHvQrgAAbpBr7SrsPxlY7u8FAF5bcq1d
+ewKAC+HXGtXYXx2Xe5vBABeQ1K/8roq59oVAMBtRkYncvCzKwCAq8hqVZ9g
zUPaFQBgKahq/efxDO0KAJAtdLWKnPxXLQAANzCrVdCuAABZorjEs/nbev1/
ZG3YVGPe0q4AAG5AuwIAuAHtCgDgBrQrAIAb0K4AAG5gtutXG3dGRv6sa/Du
2FmOiIhLdPbfWY93aPPXuws37pLtKh0eHkVExCVqtutwaEyI+fn5OUREXIr/
zc+Z7Xp9MDo7Ozc1/UQ6HTcxT8mvMzpOTSUW5KFe1rPpNJFIJL6i8bk77UBJ
1ZHV71aueq9i1fvpynN5K3fUg0+ezExNzeh27b9289Hk1MS9RxP3Hsa/PkrO
D53zfXNB7+vDSfstkUgkvlLxRTqtfvXKub37xLEyUVqawWNl8lbuqAfv3bce
0e3a2zty++970djd6Nj4WytWmEZj49HYncQ8Zs53pMba3eRwR88qps6N/YzL
qTfHl9WtGpxP2W+JRCJxUdEqsfH4oToZT54nTVyNW08l33BjfYFoPCdqq59q
4zm5o54du3V3LDah27W7Jzxy8/bwjTFVX3JQJmMsdR5O7SSHaHw5sRO2vSRq
RsfLHbcy2hesW3N54VsikUh8ZkwOsdRh2B6tOWrsWG8IFxaI+jpx6kTil67k
oNSxvk7uxB+JhUdiNyK3dbt6faHg4M1rwYhqMDn0BSNm1EOmw9GM5332l/TZ
X55+22ef1a25vPAtkUgkLjJes89pjppPycHZrpIaY062q3qqfyAycP0v3a5y
6A6E/FeHVIP5ekLe7pCvJxWTw5A5J4arIV/3UCp266eG/HLfiI6fAKQvq9lr
3/Raf6ntVr9ZDkQikbj46O8JSX3Jrz7rPGSdxxtPLetO028IF+aL+lpRXWHp
oPKoqCgVZ6pku/rUO6+GAn0jul27PIOdnmCHJ6gaTA4dXcF2T38idtnOHYft
8cOOLr3cnzr3BM2oH2x/ynJi7urXz6rlxdwSiUTiImLiRM6pk8R5Qt1p+g3D
n6+xerXssCg7JI4b/5traZE4sk8c3iMLdnjdmuQj/V5/qPXyNdWunZ7BlrZe
qWqw5svW3HI5oKI+15rLyZOAY3DE5rbeZvsjzdZLApleHlDL6lbHhW+JRCJx
ETFx0pw4t2ns295gtWv5EXFwtziw2/nZde8usednceSgbFf9nk7PwO+NXtWu
HV0DF5p8Fy/5VYPJQanihUvdFy39F5v8crZiU7exHL+yzv3xTf1U5uhYNqN+
Yfqt7t6nPUskEonPjBdS5xk6Td2md9rwunxRenDu1526U2d+Sc3TP20XxfvD
6/Ljz/ovNPnb2vtOVrck2rVzoKHRc+68VzWYHJSO6NB+e0VH4/xKejR0RscL
n+uWSCQSnzMu7BX91fq5a/H+ye3bVJ0+/nHbZFwVH2zdKvbvkzv62ebWQElp
Q7JdB2vrrtQ1eN1QtWJ2NxERX5qRDQWiqGhiy5YHW39IV56L4qLI+ny1fLbe
2/RH7+691Yl27bhec6rzzGkPIiI6DHzxiThULIqlRRksKhKHSnq+/Ewtn67x
nG8M7NhZrtq1rS1Ydry5srwVEREdHiip6l336egXa0fWF6Q7uqEgsL5A7qjl
it9aztZ6aVdExOxKuyIiuiHtiojoho52be8Ilpc1n6hsRUTEpVhZ0VJfl2rX
sdj9yOidyOg4IiIu0Vu3Hup2RUTE7Crb9X+Y0uNY
   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->34626145]
}, Open  ]],

Cell[TextData[{
 "A single ",
 StyleBox["Enter", "KeyEvent"],
 " changes the background without entering a newline:"
}], "ExampleText",
 CellID->270385041],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtPVFcYxnGa3jd+hX6Q3vRwq7ExaaJJBSNg25jGpkmv2hhTtJVqiiCI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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->680609997],

Cell[TextData[{
 "Also, ",
 Cell[BoxData[
  ButtonBox["NotebookEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookEventActions"]], "InlineFormula"],
 " has been reset to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->46593577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"nb", ",", "NotebookEventActions"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->220039702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NotebookEventActions", "\[Rule]", "None"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47938540]
}, Open  ]],

Cell[TextData[{
 "Now, more ",
 StyleBox["Enter", "KeyEvent"],
 " keystrokes add new lines as usual:"
}], "ExampleText",
 CellID->7954716],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2OtPk1ccwHGWvV/8F/Z+f8UubzUuJks0mWIUdYtZXEz2atOYqZtOMwVB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   "], {{0, 0}, {458, 127}}, {0, 255}],
  ImageSize->{458 0.75, 127 0.75},
  PlotRange->{{0, 458}, {0, 127}}]], "NotebookImage",
 CellID->911699332]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4200],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->246080028],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->373595107],

Cell[TextData[ButtonBox["Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookAndInterfaceCustomization"]], "MoreAbout",
 CellID->288885367],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->706762312],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->507445909],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->528175169]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookEventActions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 46.9519534}", "context" -> "System`", 
    "keywords" -> {
     "event handler", "notebook event handler", "event interception", 
      "document level event handling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookEventActions is a notebook option that gives a list of actions \
to perform when specified events occur in connection with the notebook. ", 
    "synonyms" -> {"notebook event actions"}, "title" -> 
    "NotebookEventActions", "type" -> "Symbol", "uri" -> 
    "ref/NotebookEventActions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8335, 252, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->201343996]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51190, 1314}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2253, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2876, 78, 1585, 37, 70, "ObjectNameGrid"],
Cell[4464, 117, 532, 14, 70, "Usage",
 CellID->15565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5033, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5511, 153, 920, 29, 70, "Notes",
 CellID->20826],
Cell[6434, 184, 264, 8, 70, "Notes",
 CellID->15670],
Cell[6701, 194, 353, 9, 70, "2ColumnTableMod",
 CellID->16712],
Cell[7057, 205, 296, 9, 70, "Notes",
 CellID->20880],
Cell[7356, 216, 369, 11, 70, "Notes",
 CellID->563375303],
Cell[7728, 229, 570, 18, 70, "Notes",
 CellID->141044261]
}, Closed]],
Cell[CellGroupData[{
Cell[8335, 252, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->201343996],
Cell[CellGroupData[{
Cell[8720, 266, 148, 5, 70, "ExampleSection",
 CellID->115610305],
Cell[8871, 273, 115, 3, 70, "ExampleText",
 CellID->448315431],
Cell[8989, 278, 211, 7, 70, "Input",
 CellID->118995096],
Cell[CellGroupData[{
Cell[9225, 289, 307, 9, 70, "Input",
 CellID->106816466],
Cell[9535, 300, 2392, 41, 70, "NotebookImage",
 CellID->37512001]
}, Open  ]],
Cell[11942, 344, 138, 5, 70, "ExampleText",
 CellID->67770792],
Cell[CellGroupData[{
Cell[12105, 353, 70, 2, 70, "Input",
 CellID->214408060],
Cell[12178, 357, 157, 5, 36, "Output",
 CellID->43526074]
}, Open  ]],
Cell[12350, 365, 152, 5, 70, "ExampleText",
 CellID->79592513],
Cell[CellGroupData[{
Cell[12527, 374, 69, 2, 70, "Input",
 CellID->26785636],
Cell[12599, 378, 158, 5, 36, "Output",
 CellID->190015053]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12806, 389, 219, 7, 70, "ExampleSection",
 CellID->59703114],
Cell[13028, 398, 68, 1, 70, "ExampleText",
 CellID->18352363],
Cell[13099, 401, 178, 6, 70, "Input",
 CellID->160409786],
Cell[13280, 409, 263, 8, 70, "ExampleText",
 CellID->304750147],
Cell[CellGroupData[{
Cell[13568, 421, 408, 12, 70, "Input",
 CellID->165747673],
Cell[13979, 435, 2376, 41, 70, "NotebookImage",
 CellID->57895206]
}, Open  ]],
Cell[16370, 479, 88, 1, 70, "ExampleText",
 CellID->204021091],
Cell[16461, 482, 2337, 41, 70, "NotebookImage",
 CellID->256050757],
Cell[18801, 525, 125, 3, 70, "ExampleDelimiter",
 CellID->219431775],
Cell[18929, 530, 141, 5, 70, "ExampleText",
 CellID->112206551],
Cell[19073, 537, 178, 6, 70, "Input",
 CellID->657431519],
Cell[19254, 545, 409, 12, 70, "Input",
 CellID->520577085],
Cell[19666, 559, 125, 3, 70, "ExampleDelimiter",
 CellID->396599906],
Cell[19794, 564, 199, 7, 70, "ExampleText",
 CellID->730802096],
Cell[19996, 573, 176, 6, 70, "Input",
 CellID->4924837],
Cell[CellGroupData[{
Cell[20197, 583, 622, 17, 70, "Input",
 CellID->399852593],
Cell[20822, 602, 2377, 41, 70, "NotebookImage",
 CellID->201155197]
}, Open  ]],
Cell[23214, 646, 120, 3, 70, "ExampleText",
 CellID->260664617],
Cell[23337, 651, 2337, 41, 70, "NotebookImage",
 CellID->184321496],
Cell[25677, 694, 125, 3, 70, "ExampleText",
 CellID->78536433],
Cell[25805, 699, 2377, 41, 70, "NotebookImage",
 CellID->633981100]
}, Closed]],
Cell[CellGroupData[{
Cell[28219, 745, 225, 7, 70, "ExampleSection",
 CellID->8130],
Cell[28447, 754, 289, 10, 70, "ExampleText",
 CellID->245145802],
Cell[28739, 766, 178, 6, 70, "Input",
 CellID->198328167],
Cell[CellGroupData[{
Cell[28942, 776, 409, 12, 70, "Input",
 CellID->273900920],
Cell[29354, 790, 2376, 41, 70, "NotebookImage",
 CellID->25849888]
}, Open  ]],
Cell[31745, 834, 157, 5, 70, "ExampleText",
 CellID->10842450],
Cell[31905, 841, 2335, 41, 70, "NotebookImage",
 CellID->4619722],
Cell[34243, 884, 124, 3, 70, "ExampleDelimiter",
 CellID->70305312],
Cell[34370, 889, 181, 5, 70, "ExampleText",
 CellID->121617900],
Cell[34554, 896, 178, 6, 70, "Input",
 CellID->596644575],
Cell[34735, 904, 561, 16, 70, "Input",
 CellID->606636239],
Cell[35299, 922, 174, 5, 70, "ExampleText",
 CellID->171437743],
Cell[35476, 929, 2449, 42, 70, "NotebookImage",
 CellID->34967464],
Cell[37928, 973, 125, 3, 70, "ExampleDelimiter",
 CellID->546117591],
Cell[38056, 978, 265, 8, 70, "ExampleText",
 CellID->3101969],
Cell[38324, 988, 178, 6, 70, "Input",
 CellID->176928803],
Cell[CellGroupData[{
Cell[38527, 998, 513, 14, 70, "Input",
 CellID->14111910],
Cell[39043, 1014, 2376, 41, 70, "NotebookImage",
 CellID->34626145]
}, Open  ]],
Cell[41434, 1058, 155, 5, 70, "ExampleText",
 CellID->270385041],
Cell[41592, 1065, 2337, 41, 70, "NotebookImage",
 CellID->680609997],
Cell[43932, 1108, 347, 13, 70, "ExampleText",
 CellID->46593577],
Cell[CellGroupData[{
Cell[44304, 1125, 146, 4, 70, "Input",
 CellID->220039702],
Cell[44453, 1131, 231, 7, 36, "Output",
 CellID->47938540]
}, Open  ]],
Cell[44699, 1141, 138, 5, 70, "ExampleText",
 CellID->7954716],
Cell[44840, 1148, 2726, 47, 70, "NotebookImage",
 CellID->911699332]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47615, 1201, 310, 9, 70, "SeeAlsoSection",
 CellID->4200],
Cell[47928, 1212, 744, 26, 70, "SeeAlso",
 CellID->31274]
}, Open  ]],
Cell[CellGroupData[{
Cell[48709, 1243, 319, 9, 70, "MoreAboutSection",
 CellID->246080028],
Cell[49031, 1254, 163, 3, 70, "MoreAbout",
 CellID->373595107],
Cell[49197, 1259, 179, 3, 70, "MoreAbout",
 CellID->288885367],
Cell[49379, 1264, 209, 5, 70, "MoreAbout",
 CellID->706762312],
Cell[49591, 1271, 134, 3, 70, "MoreAbout",
 CellID->507445909],
Cell[49728, 1276, 172, 3, 70, "MoreAbout",
 CellID->528175169]
}, Open  ]],
Cell[49915, 1282, 27, 0, 70, "History"],
Cell[49945, 1284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

