(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60974,       1551]
NotebookOptionsPosition[     54365,       1331]
NotebookOutlinePosition[     56219,       1379]
CellTagsIndexPosition[     56099,       1373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookLocate" :> 
          Documentation`HelpLookup["paclet:ref/NotebookLocate"], 
          "SelectionMove" :> 
          Documentation`HelpLookup["paclet:ref/SelectionMove"], 
          "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], "Find" :> 
          Documentation`HelpLookup["paclet:ref/Find"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NotebookLocate\"\>", 2->"\<\"SelectionMove\"\>", 
       3->"\<\"NotebookOpen\"\>", 4->"\<\"Find\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Low-Level Notebook Programming\"\>",
        2->"\<\"Palettes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookFind", "ObjectName",
 CellID->3925],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookFind",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookFind"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current selection in the specified notebook \
object to be the next occurrence of ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookFind",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookFind"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"], ",", "Previous"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current selection to be the previous \
occurrence. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookFind",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookFind"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current selection to be all occurrences. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookFind",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookFind"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"], ",", 
        StyleBox["dir", "TI"], ",", 
        StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]searches the elements of cells specified by ",
     Cell[BoxData[
      StyleBox["elems", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->558]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookFind",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookFind"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if the search it performs finds no occurrence of ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6914],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["notebook", "TI"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ", as returned by ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 ", etc. "
}], "Notes",
 CellID->23130],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " can be a string, box expression, or a complete cell. "
}], "Notes",
 CellID->9479],

Cell["The possible elements are: ", "Notes",
 CellID->30803],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "CellContents", Cell[
    "contents of each cell, represented as a string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellLabel"], Cell[TextData[{
     "setting for the ",
     Cell[BoxData[
      ButtonBox["CellLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellLabel"]], "InlineFormula"],
     " option of each cell "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "CellStyle", Cell[
    "name of style for each cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellTags"], Cell[TextData[{
     "parts of the setting for the ",
     Cell[BoxData[
      ButtonBox["CellTags",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CellTags"]], "InlineFormula"],
     " option for each cell "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "list of different types of elements ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->15399],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["elems", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["CellContents"], "InlineFormula"],
 ". Only the contents of boxes, not their styles or options, are included in \
the search. "
}], "Notes",
 CellID->28785],

Cell[TextData[{
 "Unless the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutoScroll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoScroll"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is given, the front end will scroll a notebook so that the result of ",
 Cell[BoxData[
  ButtonBox["NotebookFind",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookFind"]], "InlineFormula"],
 " is visible. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25570]
}], "Notes",
 CellID->27000],

Cell["\<\
The front end will also usually highlight the region corresponding to the \
result. \
\>", "Notes",
 CellID->15651]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13177128],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->264601228],

Cell["Create a notebook:", "ExampleText",
 CellID->263165768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<fat cat\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<L1\>\"", "}"}]}]}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<on my hat\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<L2\>\"", "}"}]}]}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43501151],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVFUcx/Ftet70L/Sv9ONpTk1PqpkSJ9FqHKemZ830oMl+WU2mgppi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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->103603568]
}, Open  ]],

Cell["Find an occurrence of the letters \"at\":", "ExampleText",
 CellID->338989096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<at\>\""}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->305356519],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1T1FUch2m6b/oX+ld6uc2p6aaaKXESrcZxarprposme7OaTAU1xSKg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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->204082661]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29881],

Cell["Create a notebook:", "ExampleText",
 CellID->458510165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<fat cat\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<L1\>\"", "}"}]}]}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<on my hat\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<L2\>\"", "}"}]}]}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482154408],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVFUcx/Ftet70L/Sv9ONpTk1PqpkSJ9FqHKemZ830oMl+WU2mgppi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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->229605214]
}, Open  ]],

Cell["Find an occurrence of the letters \"at\":", "ExampleText",
 CellID->55173013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<at\>\""}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66547318],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1T1FUch2m6b/oX+ld6uc2p6aaaKXESrcZxarprposme7OaTAU1xSKg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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->330123407]
}, Open  ]],

Cell["Find the next occurrence:", "ExampleText",
 CellID->262457873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<at\>\""}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->561322],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1vk1Ucx2u8N/4L/iu+3Eo03qiJMCIDNIRovDPxgohvqBGBjdeBc5sC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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->180960305]
}, Open  ]],

Cell["Select all cells that contain \"at\":", "ExampleText",
 CellID->148862066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<at\>\"", ",", "All"}], "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22786450],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVFUcx/Ftet70L/SvVA+bmqke1VTgJPZjmqb+gB402S+q0VRQUyoC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   "], {{0, 0}, {458, 93}}, {0, 255}],
  ImageSize->{458 0.75, 93 0.75},
  PlotRange->{{0, 458}, {0, 93}}]], "NotebookImage",
 CellID->492439621]
}, Open  ]],

Cell["Find the last \"at\" in the document:", "ExampleText",
 CellID->206269686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "After", ",", "Notebook"}], "]"}], ";", 
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<at\>\"", ",", "Previous"}], "]"}], ";"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->38004916],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtPlEccxnGa3jf+C/1XerjV2PTGNq1iKmobY9r0rkkvTNVWa1NP4BGV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   "], {{0, 0}, {458, 93}}, {0, 255}],
  ImageSize->{458 0.75, 93 0.75},
  PlotRange->{{0, 458}, {0, 93}}]], "NotebookImage",
 CellID->3235378]
}, Open  ]],

Cell["Go back to find a cell with \"L1\" in its cell tags:", "ExampleText",
 CellID->512157011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<L1\>\"", ",", "Previous", ",", "CellTags"}], "]"}],
   ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->474812934],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etT1FUcx/Ftet70L/SvdHnW5FQ+qaYCJ9FqmqamZ830oMluVJOpIF4o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   "], {{0, 0}, {458, 93}}, {0, 255}],
  ImageSize->{458 0.75, 93 0.75},
  PlotRange->{{0, 458}, {0, 93}}]], "NotebookImage",
 CellID->216466218]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19380],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoScroll",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25570],

Cell["\<\
Normally, the document scrolls so that the found data is visible in the \
notebook window:\
\>", "ExampleText",
 CellID->553566239],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "i", "]"}], ",", "\"\<Text\>\""}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "50"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "30"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->682512284],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3euPVOUdB/Bt+r7xX+i/0stbNzS+oU0qmHKxjSFt+q5JX5iqrdSmeFlE
uSgFFFxFoCJiF5DLsrvgclmQZWWxXVZTELyQQqRAT8/smTnzzGVxhXlmzJnP
J183z+85z4zz6pvJOJ75/kPLfvLQd3t6evam/4x8p6entF68+PciIhIjN2/d
FhGRFiZv11c3vysiIi1JXbt2/C20iEgB0rRdEwDuweLKZ63aFaCFtCtADNoV
IAbtChCDdgWIQbsC3LXf/m7Hj+9flWXe/HXhJe0K0BJpwYajdgVoiQK3a0+g
cbODLwzoBgVu11BdwXbwlQBdQrsCxKBdAWIofLs2fsqqXYE2KHy7Jg11ql2B
NuiGdk18MgC0XYHbtWmj+joW0B4Fbtdklm+3alegDYrdrgBtVr3VQK92BWg9
710BWiW8R9bSZf3hJe0KEIN2BYhBuwLEoF0BYtCuADFoV4AYtCtADNoVIAbt
ChCDdgWIQbsCxKBdAWLQrgAxaFeAGIrUrj1z0OnXCBRKeAfCefPXhZe0K0BL
FPju2doV6KACt2uosU61KxBVgdu17j1q/rduByAG7QoQg3YFiKHw7Vq31q5A
exS+XcNSbdzs8EsEiqsb2tUnA0D7Fbhdk2Zdql2B9ihwu/Y0fLu1cacTrwvo
CsVu16/V6dcIFE31VgO92hWg9bx3BWiV8B5ZS5f1h5eK1K4A3x7aFSAG7QoQ
g3YFiEG7AsSgXQFi0K4AMWhXgBi0K0AM2hUgBu0KEIN2BYhBuwLEoF0BYtCu
AHctvAPhvPnrwkvaFaAlCnz3bIAOKnC7Nv4Mgd8jANqmwO2aBD8LW/drsB16
OUAXKXa7JrN0qYIFYit8uyYNb1z9ZCHQBt3QrkmlYH0+ALSNdgWIQbsCxFDg
dm3sUu0KtE2B2zUJ/hvWHXYAYih2uwK0WfVWA73aFaD1vHcFaJXwHllLl/WH
l7QrQAzaFSAG7QoQg3YFiEG7AsSgXQFi0K4AMWhXgBi0K0AM2hUgBu0KEIN2
BYhBuwLEoF0BYtCuAHctvAPhvPnrwkvaFaAl3D0bIIYCt2tPrbrNzr42oPAK
3K5J8LPafnEbaLNit2sye6NqVyCqwrdr0qxUVSsQWze0a+JdK9B23dau3rsC
7dFV7eodLNA2BW7XO3/cql2BqArcrkmzb7f6vivQHsVuV4A2q95qoFe7ArSe
964ArRLeI2vpsv7wknYFiEG7AsSgXQFi0K4AMWhXgBi0K0AM2hUgBu0KEIN2
BYhBuwLEoF0BYtCuADFoV4AYtCtADNoV4K6FdyCcN39deEm7ArSEu2cDxFDg
du2pFe538FUBXaLA7ZoERapdgTYrdrsms3SpggViK3y7Js26VLsCsXVDuyYN
dapdgdi0K0AM3dmuTXcAWqjA7dr4PQHfHADapsDtmgRfeW3c0a5AVMVuV4A2
q95qoFe7ArSe964ArRLeI2vpsv7wknYFiEG7AsSgXQFi0K4AMWhXgBi0K0AM
2hUgBu0KEIN2BYhBuwLEoF0BYtCuADFoV4AYtCtADNoV4K6FdyCcN39deEm7
ArSEu2cDxFDgdu2pVbfZ2dcGFF6B2zUJflbbL24DbVbsdk1mb1TtCkRV+HZN
Gt7BNq4BWq4b2jUJPhlo2rQALddt7ZrUdixAJF3Vrom3rEC7FLhd/fcsoIMK
3K7J7N9u9eEAEFux2xWgzaq3GujVrgCtd4f3rr96ZPnkuX9u2zH05PINIiJy
j7n535uDQ2d+/ZsVix95Km3XNGfPnhcRkXtM2K5nxy8kye3bt2+JiMi95H+3
b4Xt+sHpqZs3b127/lWa6zMpr6+lf2/k47Vr5QPpZn44X4e5bjQajd/S8Rt3
2vOrN6954Aeben+4sfdHjUn306vpmeyBX31149q1G3m7njzx0ZdXr12+8uXl
K1/M/P2ysv6ifv1ZeCA/n29erb1qNBqN36rxbjpt+wP333rm2eSl9cnatU3y
0vr0anome+CVz0oPydv12LFzn/z7ytT0p1MXLn7vvvvCTE1fnJq+VF5fCNeX
0gTHPq0sLuXrbKzuB+ebHq4+88zh7Gq2qH9U7VWj0Wic01gqsYszm9nOxcp+
JeVLF0uPqjzDh0sWJjvfSrZumTU730rPZI+98PGnF6Yv5+165OjEuY8+Ofvh
hay+0kWWyjhd3Z+onqkspmYOl89M1DzJVDjWPXnd1XSsPVC6Gh6+81Wj0Wj8
2rGymK5uTtSOpfVUcKb0DBOLFybbtyWvvVL+0lW6yJKP27elZ2YeMj1xbvrD
yU/ydh0aHh87/dGJscmswdLF8bHJcMwXzTbPN90/Xvskx2ufvPHq8dp1djU8
fOerRqPROMfxRO26IefDR6WL+nZN9QfrSrtmjzp5avLUB//K2zVdHBkdH3n/
TNZgw0fHh46MDx+tjpXFmXBdXrw/PnzkTHU8kj/qzEh6PhjrPgFoPJyth2pP
DpX+pTVX82dOF0aj0Tj3ceToeJrhyt/h0v54aX+m8bLDeaflzzCxeEGyfWuy
ZWMpdTatSzauTd7YnLbrcPac74+PHj+Xt+uhwdMHB8cODI5lDZYuDhwa2z94
sjweqtmv29w/s3ngUH74ZHV/cCwc8wfun+VweX3oZP7Y7PBcrhqNRuMcxvJO
uq7ulPfLyTstf4azv3iw1KvrX0zWv5C8HPyfWWv7kjXPJi8+nRbs2UUPVh5y
cmhkfO97J7J2PTh4es++Y2myBht4r7Te895oNub7ecLDlZ3RukXdOLDv2EDt
QwZKTzLa7MlHs8PZ1Xy881Wj0Wicw1jeGSjv1yQ4X/MMpXbdsCZZtSJ5fkX9
e9dnnkqe/nOyZlXarvnzHBw89fedQ1m7Hjh0atfu4XfeHckaLF1kycZd7x55
p5SRd3aPpOvSuPtIcHjmUml/ZOZk/qjmY93hcMyfsPFq3r2zPdZoNBq/dtxV
3W/SadnVxk47u2hBsnbVrb8uzzv1xl+q6+t/eiJZ+dzEogUzjx3ZtXtk3/7j
r27ZU27Xg6d27Bx86+2hrMHSRZa6sS61Vw/nY7B/uHEMUj/WPeE3umo0Go3f
cLxzDud/S5+7rnzu6hOPZ3X6nz8+fnUm2fj5Y48lzz2bnskfO7B3dPXaHZV2
Pb112+FtO4ZiJGvF1p4UEWlbJpcuTPr6Lj/66OeP/aEx6X6ysm9yyYLs8Jvb
h3b/49iKZ7aU2/XAB/2vHXzj9UEREanL6MM/TV5YmaxM09ckfX3JC6uP/vLn
2eHX+wff3jn65PINWbvu2ze2/uWBTRv2iohIXZ5fvfnYop+df/ihc0sWNub8
0oWjSxamZ7LDG/+2582tQ9pVRKS10a4iIjGiXUVEYqSuXfcfGNuwfuCVTXtF
ROResmnjnu3bqu16YfqzyfOXJs9fFBGRe8zHH3+Rt6uIiLQ2abv+H+Qx1/U=

   "], {{0, 0}, {458, 191}}, {0, 255}],
  ImageSize->{458 0.75, 191 0.75},
  PlotRange->{{0, 458}, {0, 191}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->283252652]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["AutoScroll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoScroll"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the document does not scroll to the found data:"
}], "ExampleText",
 CellID->22258763],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "Notebook"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "30", ",", 
    RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->959879958],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtvFNcdB3BXfa/yL/Rf6eU1FlVeaKUGogJOq8hq1bdKfYiapA1NVXIx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   "], {{0, 0}, {458, 191}}, {0, 255}],
  ImageSize->{458 0.75, 191 0.75},
  PlotRange->{{0, 458}, {0, 191}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->76217999]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->75578790],

Cell["By default, searches are case sensitive:", "ExampleText",
 CellID->558334924],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "\"\<Better and better!\>\"", "}"}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->98122032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<better\>\""}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126412483],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+k+aHm41bbxpm1QxFbWNMW1616QXpmqrtaknUKuo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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellID->70072967]
}, Open  ]],

Cell["A case-insensitive search:", "ExampleText",
 CellID->97287284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "Notebook"}], "]"}], ";", 
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<better\>\"", ",", 
    RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12386350],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+k+aHm41bbxpm1QxFbSNMW1616QXpmqrtSkeQCyg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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellID->242645249]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17852],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookLocate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookLocate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionMove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionMove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Find",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Find"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21660]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17554],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->10980]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->68947394],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->279929613]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookFind - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 47.7800996}", "context" -> "System`", 
    "keywords" -> {"notebook search", "notebook seek"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookFind[notebook, data] sets the current selection in the specified \
notebook object to be the next occurrence of data. NotebookFind[notebook, \
data, Previous] sets the current selection to be the previous occurrence. \
NotebookFind[notebook, data, All] sets the current selection to be all \
occurrences. NotebookFind[notebook, data, dir, elems] searches the elements \
of cells specified by elems. ", "synonyms" -> {"notebook find"}, "title" -> 
    "NotebookFind", "type" -> "Symbol", "uri" -> "ref/NotebookFind"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9436, 305, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13177128]},
 "Notebook Image"->{
  Cell[37384, 927, 3711, 64, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->283252652],
  Cell[41846, 1023, 3518, 60, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->76217999]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55727, 1359},
 {"Notebook Image", 55867, 1363}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2284, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2907, 82, 49, 1, 70, "ObjectName",
 CellID->3925],
Cell[2959, 85, 2098, 63, 70, "Usage",
 CellID->558]
}, Open  ]],
Cell[CellGroupData[{
Cell[5094, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5572, 170, 422, 15, 70, "Notes",
 CellID->6914],
Cell[5997, 187, 415, 15, 70, "Notes",
 CellID->23130],
Cell[6415, 204, 161, 5, 70, "Notes",
 CellID->9479],
Cell[6579, 211, 60, 1, 70, "Notes",
 CellID->30803],
Cell[6642, 214, 1741, 47, 70, "2ColumnTableMod",
 CellID->15399],
Cell[8386, 263, 277, 9, 70, "Notes",
 CellID->28785],
Cell[8666, 274, 605, 20, 70, "Notes",
 CellID->27000],
Cell[9274, 296, 125, 4, 70, "Notes",
 CellID->15651]
}, Closed]],
Cell[CellGroupData[{
Cell[9436, 305, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13177128],
Cell[CellGroupData[{
Cell[9820, 319, 148, 5, 70, "ExampleSection",
 CellID->264601228],
Cell[9971, 326, 61, 1, 70, "ExampleText",
 CellID->263165768],
Cell[CellGroupData[{
Cell[10057, 331, 629, 17, 70, "Input",
 CellID->43501151],
Cell[10689, 350, 2796, 48, 70, "NotebookImage",
 CellID->103603568]
}, Open  ]],
Cell[13500, 401, 84, 1, 70, "ExampleText",
 CellID->338989096],
Cell[CellGroupData[{
Cell[13609, 406, 160, 5, 70, "Input",
 CellID->305356519],
Cell[13772, 413, 2829, 49, 70, "NotebookImage",
 CellID->204082661]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16650, 468, 216, 7, 70, "ExampleSection",
 CellID->29881],
Cell[16869, 477, 61, 1, 70, "ExampleText",
 CellID->458510165],
Cell[CellGroupData[{
Cell[16955, 482, 630, 17, 70, "Input",
 CellID->482154408],
Cell[17588, 501, 2796, 48, 70, "NotebookImage",
 CellID->229605214]
}, Open  ]],
Cell[20399, 552, 83, 1, 70, "ExampleText",
 CellID->55173013],
Cell[CellGroupData[{
Cell[20507, 557, 159, 5, 70, "Input",
 CellID->66547318],
Cell[20669, 564, 2829, 49, 70, "NotebookImage",
 CellID->330123407]
}, Open  ]],
Cell[23513, 616, 68, 1, 70, "ExampleText",
 CellID->262457873],
Cell[CellGroupData[{
Cell[23606, 621, 157, 5, 70, "Input",
 CellID->561322],
Cell[23766, 628, 2841, 49, 70, "NotebookImage",
 CellID->180960305]
}, Open  ]],
Cell[26622, 680, 80, 1, 70, "ExampleText",
 CellID->148862066],
Cell[CellGroupData[{
Cell[26727, 685, 171, 5, 70, "Input",
 CellID->22786450],
Cell[26901, 692, 2845, 49, 70, "NotebookImage",
 CellID->492439621]
}, Open  ]],
Cell[29761, 744, 80, 1, 70, "ExampleText",
 CellID->206269686],
Cell[CellGroupData[{
Cell[29866, 749, 274, 8, 70, "Input",
 CellID->38004916],
Cell[30143, 759, 2774, 48, 70, "NotebookImage",
 CellID->3235378]
}, Open  ]],
Cell[32932, 810, 95, 1, 70, "ExampleText",
 CellID->512157011],
Cell[CellGroupData[{
Cell[33052, 815, 197, 6, 70, "Input",
 CellID->474812934],
Cell[33252, 823, 2845, 49, 70, "NotebookImage",
 CellID->216466218]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36146, 878, 218, 7, 70, "ExampleSection",
 CellID->19380],
Cell[CellGroupData[{
Cell[36389, 889, 275, 8, 70, "ExampleSubsection",
 CellID->25570],
Cell[36667, 899, 141, 4, 70, "ExampleText",
 CellID->553566239],
Cell[CellGroupData[{
Cell[36833, 907, 548, 18, 70, "Input",
 CellID->682512284],
Cell[37384, 927, 3711, 64, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->283252652]
}, Open  ]],
Cell[41110, 994, 365, 13, 70, "ExampleText",
 CellID->22258763],
Cell[CellGroupData[{
Cell[41500, 1011, 343, 10, 70, "Input",
 CellID->959879958],
Cell[41846, 1023, 3518, 60, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->76217999]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45413, 1089, 230, 7, 70, "ExampleSubsection",
 CellID->75578790],
Cell[45646, 1098, 83, 1, 70, "ExampleText",
 CellID->558334924],
Cell[45732, 1101, 204, 7, 70, "Input",
 CellID->98122032],
Cell[CellGroupData[{
Cell[45961, 1112, 164, 5, 70, "Input",
 CellID->126412483],
Cell[46128, 1119, 2620, 45, 70, "NotebookImage",
 CellID->70072967]
}, Open  ]],
Cell[48763, 1167, 68, 1, 70, "ExampleText",
 CellID->97287284],
Cell[CellGroupData[{
Cell[48856, 1172, 313, 8, 70, "Input",
 CellID->12386350],
Cell[49172, 1182, 2593, 45, 70, "NotebookImage",
 CellID->242645249]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51838, 1235, 311, 9, 70, "SeeAlsoSection",
 CellID->17852],
Cell[52152, 1246, 963, 35, 70, "SeeAlso",
 CellID->21660]
}, Open  ]],
Cell[CellGroupData[{
Cell[53152, 1286, 314, 9, 70, "TutorialsSection",
 CellID->17554],
Cell[53469, 1297, 186, 4, 70, "Tutorials",
 CellID->10980]
}, Open  ]],
Cell[CellGroupData[{
Cell[53692, 1306, 299, 8, 70, "MoreAboutSection"],
Cell[53994, 1316, 168, 3, 70, "MoreAbout",
 CellID->68947394],
Cell[54165, 1321, 128, 3, 70, "MoreAbout",
 CellID->279929613]
}, Open  ]],
Cell[54308, 1327, 27, 0, 70, "History"],
Cell[54338, 1329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

