(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36116,       1004]
NotebookOptionsPosition[     31173,        838]
NotebookOutlinePosition[     32945,        887]
CellTagsIndexPosition[     32827,        881]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], "NotebookPut" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPut"], "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookOpen\"\>", 
       2->"\<\"NotebookPut\"\>", 
       3->"\<\"NotebookRead\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookGet", "ObjectName",
 CellID->15815],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookGet",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookGet"], "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gets the raw expression corresponding to the notebook \
represented by the notebook object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookGet",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookGet"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gets the raw expression corresponding to the currently \
selected notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12937]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookGet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookGet"]], "InlineFormula"],
 " allows you to take a notebook that is open in the front end, and get the \
raw expression corresponding to it in the kernel. "
}], "Notes",
 CellID->10531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookGet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookGet"]], "InlineFormula"],
 " returns an expression with head ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 ", containing ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expressions and boxes data."
}], "Notes",
 CellID->23461],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookGet"], "[", 
   RowBox[{
    ButtonBox["NotebookOpen",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NotebookOpen"], "[", 
    StyleBox["file", "TI"], "]"}], "]"}]], "InlineFormula"],
 " returns the same expression as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", 
   StyleBox["file", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->195171359]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85201170],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->328709115],

Cell["First create a small sample notebook to operate on:", "ExampleText",
 CellID->1329819078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->884610844],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1TlNcZh+n0syX/Qv+KTGOmSWqa8VOcZGIco6NgBTVO4jTDt2TSNtX4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   "], {{0, 0}, {458, 107}}, {0, 255}],
  ImageSize->{458 0.75, 107 0.75},
  PlotRange->{{0, 458}, {0, 107}}]], "NotebookImage",
 CellID->510184350]
}, Open  ]],

Cell["Get the notebook expression of the small sample notebook:", \
"ExampleText",
 CellID->323635802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookGet", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141135718],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Cell", "[", 
     RowBox[{"CellGroupData", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cell", "[", 
          RowBox[{"\<\"Subsection heading\"\>", ",", "\<\"Subsection\"\>"}], 
          "]"}], ",", 
         RowBox[{"Cell", "[", 
          RowBox[{"\<\"Some text.\"\>", ",", "\<\"Text\"\>"}], "]"}]}], "}"}],
        ",", "Open"}], "]"}], "]"}], "}"}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"615", ",", "750"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"488", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "166"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
   "FrontEndVersion", 
    "\[Rule]", "\<\"6.0 for Microsoft Windows (32-bit) (June 28, 2006)\"\>"}],
    ",", 
   RowBox[{"StyleDefinitions", "\[Rule]", "\<\"Default.nb\"\>"}]}], 
  "]"}]], "Output",
 ImageSize->{533, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192069420]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{
        "\"\<Mathematical Constants\>\"", ",", " ", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<pi\>\"", ",", " ", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248893354],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etvFNcZx/Gt+r7Kv9B/pZeXBCXKmzRSg1ExTqsIteq7or6IStIGUpUA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   "], {{0, 0}, {458, 158}}, {0, 255}],
  ImageSize->{458 0.75, 158 0.75},
  PlotRange->{{0, 458}, {0, 158}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->115882265]
}, Open  ]],

Cell["Find subsection titles:", "ExampleText",
 CellID->15779977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"NotebookGet", "[", "nb", "]"}], ",", 
   RowBox[{
    RowBox[{"Cell", "[", 
     RowBox[{"t_", ",", "\"\<Subsection\>\"", ",", "___"}], "]"}], 
    "\[RuleDelayed]", "t"}], ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151520381],

Cell[BoxData[
 RowBox[{"{", "\<\"Mathematical Constants\"\>", "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628491642]
}, Open  ]],

Cell["Change \"Subsection\"-style cells to \"Section\" style:", "ExampleText",
 CellID->28301103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"NotebookGet", "[", "nb", "]"}], "/.", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{"c_", ",", " ", "\"\<Subsection\>\"", ",", "o___"}], "]"}], 
      "\[RuleDelayed]", 
      RowBox[{"Cell", "[", 
       RowBox[{"c", ",", "\"\<Section\>\"", ",", "o"}], "]"}]}]}], ",", 
    "nb"}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->225574399],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zVNUdx/F0+nvHf6H/idOHH5HR8RfrTAWnQGzHcdrxN5n+4BRtBTvF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   "], {{0, 0}, {458, 158}}, {0, 255}],
  ImageSize->{458 0.75, 158 0.75},
  PlotRange->{{0, 458}, {0, 158}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1036992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1943],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookRead"]], "InlineFormula"],
 " reads only the selected part of a notebook:"
}], "ExampleText",
 CellID->753850921],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<first\>\"", ",", " ", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<second\>\"", ",", " ", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352748964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->515860686],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtvlEUcxvE13hv+Bf8VD3dG4uFGTbQlUlBjjMY7Ey8M4KFqRKClHKrW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   "], {{0, 0}, {458, 100}}, {0, 255}],
  ImageSize->{458 0.75, 100 0.75},
  PlotRange->{{0, 458}, {0, 100}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->382135512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32473970],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"\<\"first\"\>", ",", "\<\"Text\"\>"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->719585288]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookGet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookGet"]], "InlineFormula"],
 " always gets the whole notebook:"
}], "ExampleText",
 CellID->216055221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookGet", "[", "nb", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->159976208],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cell", "[", 
      RowBox[{"\<\"first\"\>", ",", "\<\"Text\"\>"}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"\<\"second\"\>", ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"615", ",", "623"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"264", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "62"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
   "FrontEndVersion", 
    "\[Rule]", "\<\"6.0 for Microsoft Windows (32-bit) (December 17, \
2006)\"\>"}], ",", 
   RowBox[{"StyleDefinitions", "\[Rule]", "\<\"Default.nb\"\>"}]}], 
  "]"}]], "Output",
 ImageSize->{526, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->65693113]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13674],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPut",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPut"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16838]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->610],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->4047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->16196981]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookGet - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 48.9363792}", "context" -> "System`", 
    "keywords" -> {"import notebook", "notebook contents", "notebook data"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NotebookGet[obj] gets the raw expression corresponding to the notebook \
represented by the notebook object obj. NotebookGet[] gets the raw expression \
corresponding to the currently selected notebook. ", 
    "synonyms" -> {"notebook get"}, "title" -> "NotebookGet", "type" -> 
    "Symbol", "uri" -> "ref/NotebookGet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5575, 186, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->85201170]},
 "Notebook Image"->{
  Cell[13089, 382, 4064, 69, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->115882265],
  Cell[18378, 500, 4644, 79, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->1036992],
  Cell[24148, 626, 2865, 50, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->382135512]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32353, 864},
 {"Notebook Image", 32493, 868}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2069, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2692, 79, 49, 1, 70, "ObjectName",
 CellID->15815],
Cell[2744, 82, 930, 28, 70, "Usage",
 CellID->12937]
}, Open  ]],
Cell[CellGroupData[{
Cell[3711, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4189, 132, 299, 8, 70, "Notes",
 CellID->10531],
Cell[4491, 142, 487, 17, 70, "Notes",
 CellID->23461],
Cell[4981, 161, 557, 20, 70, "Notes",
 CellID->195171359]
}, Closed]],
Cell[CellGroupData[{
Cell[5575, 186, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85201170],
Cell[CellGroupData[{
Cell[5959, 200, 148, 5, 70, "ExampleSection",
 CellID->328709115],
Cell[6110, 207, 95, 1, 70, "ExampleText",
 CellID->1329819078],
Cell[CellGroupData[{
Cell[6230, 212, 455, 14, 70, "Input",
 CellID->884610844],
Cell[6688, 228, 4222, 71, 70, "NotebookImage",
 CellID->510184350]
}, Open  ]],
Cell[10925, 302, 102, 2, 70, "ExampleText",
 CellID->323635802],
Cell[CellGroupData[{
Cell[11052, 308, 108, 3, 70, "Input",
 CellID->141135718],
Cell[11163, 313, 1156, 35, 105, "Output",
 CellID->192069420]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12368, 354, 223, 7, 70, "ExampleSection",
 CellID->25331],
Cell[CellGroupData[{
Cell[12616, 365, 470, 15, 70, "Input",
 CellID->248893354],
Cell[13089, 382, 4064, 69, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->115882265]
}, Open  ]],
Cell[17168, 454, 65, 1, 70, "ExampleText",
 CellID->15779977],
Cell[CellGroupData[{
Cell[17258, 459, 312, 9, 70, "Input",
 CellID->151520381],
Cell[17573, 470, 210, 6, 36, "Output",
 CellID->628491642]
}, Open  ]],
Cell[17798, 479, 97, 1, 70, "ExampleText",
 CellID->28301103],
Cell[CellGroupData[{
Cell[17920, 484, 455, 14, 70, "Input",
 CellID->225574399],
Cell[18378, 500, 4644, 79, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1036992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23071, 585, 232, 7, 70, "ExampleSection",
 CellID->1943],
Cell[23306, 594, 229, 7, 70, "ExampleText",
 CellID->753850921],
Cell[23538, 603, 433, 13, 70, "Input",
 CellID->352748964],
Cell[CellGroupData[{
Cell[23996, 620, 149, 4, 70, "Input",
 CellID->515860686],
Cell[24148, 626, 2865, 50, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->382135512]
}, Open  ]],
Cell[CellGroupData[{
Cell[27050, 681, 108, 3, 70, "Input",
 CellID->32473970],
Cell[27161, 686, 235, 7, 36, "Output",
 CellID->719585288]
}, Open  ]],
Cell[27411, 696, 215, 7, 70, "ExampleText",
 CellID->216055221],
Cell[CellGroupData[{
Cell[27651, 707, 108, 3, 70, "Input",
 CellID->159976208],
Cell[27762, 712, 960, 29, 88, "Output",
 CellID->65693113]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28783, 748, 311, 9, 70, "SeeAlsoSection",
 CellID->13674],
Cell[29097, 759, 718, 26, 70, "SeeAlso",
 CellID->16838]
}, Open  ]],
Cell[CellGroupData[{
Cell[29852, 790, 312, 9, 70, "TutorialsSection",
 CellID->610],
Cell[30167, 801, 427, 12, 70, "Tutorials",
 CellID->4047]
}, Open  ]],
Cell[CellGroupData[{
Cell[30631, 818, 299, 8, 70, "MoreAboutSection"],
Cell[30933, 828, 168, 3, 70, "MoreAbout",
 CellID->16196981]
}, Open  ]],
Cell[31116, 834, 27, 0, 70, "History"],
Cell[31146, 836, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

