(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42225,       1102]
NotebookOptionsPosition[     37278,        935]
NotebookOutlinePosition[     38880,        979]
CellTagsIndexPosition[     38775,        973]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookFind" :> 
          Documentation`HelpLookup["paclet:ref/NotebookFind"], "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], 
          "SetSelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SetSelectedNotebook"], 
          "Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "Hyperlink" :> Documentation`HelpLookup["paclet:ref/Hyperlink"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"NotebookFind\"\>", 
       2->"\<\"NotebookOpen\"\>", 3->"\<\"SetSelectedNotebook\"\>", 
       4->"\<\"Button\"\>", 5->"\<\"Hyperlink\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookLocate", "ObjectName",
 CellID->14972],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookLocate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookLocate"], "[", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]locates all cells with the specified tag in your \
current input notebook, selecting the cells and scrolling to the position of \
the first one. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookLocate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookLocate"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]if necessary opens the notebook stored in ",
     Cell[BoxData[
      StyleBox["file", "TI"]], "InlineFormula"],
     ", then locates cells with the specified tag. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " sets the current selection to contain all cells with the specified tag. "
}], "Notes",
 CellID->18328],

Cell[TextData[{
 "If the cells are in closed groups, ",
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " will open all these groups. "
}], "Notes",
 CellID->23288],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " is used for following hyperlinks within one notebook or between notebooks. \
"
}], "Notes",
 CellID->2739],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " searches for tags in the list given as the setting for the ",
 Cell[BoxData[
  ButtonBox["CellTags",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellTags"]], "InlineFormula"],
 " option of each cell. "
}], "Notes",
 CellID->8415]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->263434124],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->109961675],

Cell[TextData[{
 "Find the cell with the tag ",
 Cell[BoxData["\"\<t\>\""], "InlineFormula"],
 ", the notebook autoscrolls:"
}], "ExampleText",
 CellID->505834473],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<first\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<second\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<t\>\"", "}"}]}]}], "]"}]}], "}"}], "]"}], "]"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179803119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";", 
  RowBox[{"NotebookLocate", "[", "\"\<t\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68867946],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3OtPVEccxvFt+r7xX+i/0su7RtPWN7ZJBVPAtjFNm75r0hfGSyu1ES8g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   "], {{0, 0}, {458, 89}}, {0, 255}],
  ImageSize->{458 0.75, 89 0.75},
  PlotRange->{{0, 458}, {0, 89}}]], "NotebookImage",
 CellID->356090141]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13669799],

Cell[TextData[{
 "Create a notebook, then go to the cell tagged ",
 Cell[BoxData["\"\<t0\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->419098016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<a\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<b\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<c\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<d\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<t1\>\"", "}"}]}]}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<e\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<f\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<t0\>\"", ",", "\"\<t1\>\""}], "}"}]}]}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<g\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<h\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9507904],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etzVOUdB/B0+r7jv9B/pZe3Zuj0De1MBadAbMfJtNN3nekLp2ortVO8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   "], {{0, 0}, {458, 189}}, {0, 255}],
  ImageSize->{458 0.75, 189 0.75},
  PlotRange->{{0, 458}, {0, 189}}]], "NotebookImage",
 CellID->315545040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";", 
  RowBox[{"NotebookLocate", "[", "\"\<t0\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19675691],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VtzVeUdBvB0et/xK/SrtPWuI2Prje1MBacE2o7jtOOdM71wPLRSO+Ih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   "], {{0, 0}, {458, 189}}, {0, 255}],
  ImageSize->{458 0.75, 189 0.75},
  PlotRange->{{0, 458}, {0, 189}}]], "NotebookImage",
 CellID->89827066]
}, Open  ]],

Cell["Locate more than one cell with the same tag:", "ExampleText",
 CellID->17732277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";", 
  RowBox[{"NotebookLocate", "[", "\"\<t1\>\"", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->262472800],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etzVOUdB/Dt9H3Hf6H/SlvfOTBU39DOVHBKQDsO047vnOkLx0srtSNe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   "], {{0, 0}, {458, 189}}, {0, 255}],
  ImageSize->{458 0.75, 189 0.75},
  PlotRange->{{0, 458}, {0, 189}}]], "NotebookImage",
 CellID->135087361]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->40294108],

Cell["\<\
Cell tags identify a cell as a target for navigation controls:\
\>", "ExampleText",
 CellID->208247602],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{"\"\<target\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellTags", "\[Rule]", 
     RowBox[{"{", "\"\<t\>\"", "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26428730],

Cell["target", "Text",
 CellAutoOverwrite->True,
 CellTags->"t",
 CellID->481234417],

Cell[TextData[{
 "A button to find the cell in this document with label ",
 Cell[BoxData["\"\<t\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->94329519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<Go to target\>\"", ",", 
   RowBox[{"NotebookLocate", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<NotebookLocate.nb\>\"", ",", "\"\<t\>\""}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->291431153],

Cell[BoxData[
 ButtonBox["\<\"Go to target\"\>",
  Appearance->Automatic,
  ButtonData->"paclet:ref/Go to target",
  ButtonFrame->"DialogBox",
  ButtonFunction:>NotebookLocate[{"NotebookLocate.nb", "t"}],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{73, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->478501656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18143527],

Cell["\<\
When more than one cell has the target tag, you might only see the first one:\
\
\>", "ExampleText",
 CellID->40922801],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<a\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<t1\>\"", "}"}]}]}], "]"}], ",", 
       RowBox[{"ExpressionCell", "[", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"Pi", ",", "2000"}], "]"}], ",", "\"\<Output\>\""}], "]"}], 
       ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<b\>\"", ",", "\"\<Text\>\"", ",", 
         RowBox[{"CellTags", "\[Rule]", 
          RowBox[{"{", "\"\<t1\>\"", "}"}]}]}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8640492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";", 
  RowBox[{"NotebookLocate", "[", "\"\<t1\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504903916],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne2PXdV1h2/V71X+hf4rfflWgdTmUys1NiqGtIqiVP1QqVI/RCFp46YK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   "], {{0, 0}, {458, 216}}, {0, 255}],
  ImageSize->{458 0.75, 216 0.75},
  PlotRange->{{0, 458}, {0, 216}}]], "NotebookImage",
 CellID->93635676]
}, Open  ]],

Cell["\<\
But an operation on the selected cells also acts on those you do not see:\
\>", "ExampleText",
 CellID->16253017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->492506327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"Text\"\>", ",", 
     RowBox[{"CellTags", "\[Rule]", "\<\"t1\"\>"}]}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"b\"\>", ",", "\<\"Text\"\>", ",", 
     RowBox[{"CellTags", "\[Rule]", "\<\"t1\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{400, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->171312199]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8484],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookFind",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookFind"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetSelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1399],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->23755]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->769063403]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookLocate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 54.8115296}", "context" -> "System`", 
    "keywords" -> {"location", "searching for tags"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookLocate[\"tag\"] locates all cells with the specified tag in your \
current input notebook, selecting the cells and scrolling to the position of \
the first one. NotebookLocate[{\" file\", \" tag\"}] if necessary opens the \
notebook stored in file, then locates cells with the specified tag. ", 
    "synonyms" -> {"notebook locate"}, "title" -> "NotebookLocate", "type" -> 
    "Symbol", "uri" -> "ref/NotebookLocate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5846, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->263434124]},
 "t"->{
  Cell[23138, 571, 84, 3, 70, "Text",
   CellTags->"t",
   CellID->481234417]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38544, 962},
 {"t", 38672, 966}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2301, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2924, 82, 52, 1, 70, "ObjectName",
 CellID->14972],
Cell[2979, 85, 1166, 32, 70, "Usage",
 CellID->20896]
}, Open  ]],
Cell[CellGroupData[{
Cell[4182, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4660, 139, 252, 7, 70, "Notes",
 CellID->18328],
Cell[4915, 148, 248, 8, 70, "Notes",
 CellID->23288],
Cell[5166, 158, 256, 8, 70, "Notes",
 CellID->2739],
Cell[5425, 168, 384, 12, 70, "Notes",
 CellID->8415]
}, Closed]],
Cell[CellGroupData[{
Cell[5846, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->263434124],
Cell[CellGroupData[{
Cell[6231, 199, 148, 5, 70, "ExampleSection",
 CellID->109961675],
Cell[6382, 206, 163, 5, 70, "ExampleText",
 CellID->505834473],
Cell[6548, 213, 512, 15, 70, "Input",
 CellID->179803119],
Cell[CellGroupData[{
Cell[7085, 232, 187, 5, 70, "Input",
 CellID->68867946],
Cell[7275, 239, 2621, 45, 70, "NotebookImage",
 CellID->356090141]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9945, 290, 219, 7, 70, "ExampleSection",
 CellID->13669799],
Cell[10167, 299, 157, 5, 70, "ExampleText",
 CellID->419098016],
Cell[CellGroupData[{
Cell[10349, 308, 1243, 30, 70, "Input",
 CellID->9507904],
Cell[11595, 340, 3429, 58, 70, "NotebookImage",
 CellID->315545040]
}, Open  ]],
Cell[CellGroupData[{
Cell[15061, 403, 188, 5, 70, "Input",
 CellID->19675691],
Cell[15252, 410, 3355, 57, 70, "NotebookImage",
 CellID->89827066]
}, Open  ]],
Cell[18622, 470, 86, 1, 70, "ExampleText",
 CellID->17732277],
Cell[CellGroupData[{
Cell[18733, 475, 189, 5, 70, "Input",
 CellID->262472800],
Cell[18925, 482, 3547, 60, 70, "NotebookImage",
 CellID->135087361]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22521, 548, 226, 7, 70, "ExampleSection",
 CellID->40294108],
Cell[22750, 557, 113, 3, 70, "ExampleText",
 CellID->208247602],
Cell[22866, 562, 269, 7, 70, "Input",
 CellID->26428730],
Cell[23138, 571, 84, 3, 70, "Text",
 CellTags->"t",
 CellID->481234417],
Cell[23225, 576, 163, 5, 70, "ExampleText",
 CellID->94329519],
Cell[CellGroupData[{
Cell[23413, 585, 272, 8, 70, "Input",
 CellID->291431153],
Cell[23688, 595, 394, 12, 70, "Output",
 CellID->478501656]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24131, 613, 229, 7, 70, "ExampleSection",
 CellID->18143527],
Cell[24363, 622, 129, 4, 70, "ExampleText",
 CellID->40922801],
Cell[24495, 628, 790, 22, 70, "Input",
 CellID->8640492],
Cell[CellGroupData[{
Cell[25310, 654, 189, 5, 70, "Input",
 CellID->504903916],
Cell[25502, 661, 8312, 138, 70, "NotebookImage",
 CellID->93635676]
}, Open  ]],
Cell[33829, 802, 123, 3, 70, "ExampleText",
 CellID->16253017],
Cell[CellGroupData[{
Cell[33977, 809, 109, 3, 70, "Input",
 CellID->492506327],
Cell[34089, 814, 475, 14, 36, "Output",
 CellID->171312199]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34625, 835, 310, 9, 70, "SeeAlsoSection",
 CellID->8484],
Cell[34938, 846, 1221, 44, 70, "SeeAlso",
 CellID->8525]
}, Open  ]],
Cell[CellGroupData[{
Cell[36196, 895, 313, 9, 70, "TutorialsSection",
 CellID->1399],
Cell[36512, 906, 186, 4, 70, "Tutorials",
 CellID->23755]
}, Open  ]],
Cell[CellGroupData[{
Cell[36735, 915, 299, 8, 70, "MoreAboutSection"],
Cell[37037, 925, 169, 3, 70, "MoreAbout",
 CellID->769063403]
}, Open  ]],
Cell[37221, 931, 27, 0, 70, "History"],
Cell[37251, 933, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

