(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     99481,       2428]
NotebookOptionsPosition[     91181,       2144]
NotebookOutlinePosition[     93336,       2205]
CellTagsIndexPosition[     93216,       2199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookSelection" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSelection"], 
          "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], "Notebooks" :> 
          Documentation`HelpLookup["paclet:ref/Notebooks"], 
          "SelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SelectedNotebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookSelection\"\>", 
       2->"\<\"NotebookOpen\"\>", 3->"\<\"Notebooks\"\>", 
       4->"\<\"SelectedNotebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookObject", "ObjectName",
 CellID->19274],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookObject",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookObject"], "[", 
       RowBox[{
        StyleBox["fe", "TI"], ",", 
        StyleBox["id", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that represents an open notebook in the \
front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29116]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["fe", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData["FrontEndObject"], "InlineFormula"],
 " which specifies the front end in which the notebook is open. "
}], "Notes",
 CellID->26681],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["id", "TI"]], "InlineFormula"],
 " is an integer that gives a unique serial number for this open notebook. "
}], "Notes",
 CellID->3257],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " notebook objects are printed so as to indicate the current title of the \
window that would be used to display the notebook. "
}], "Notes",
 CellID->30465],

Cell[TextData[{
 "Functions such as ",
 Cell[BoxData[
  ButtonBox["NotebookPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPrint"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NotebookClose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookClose"]], "InlineFormula"],
 " take ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " as their argument. "
}], "Notes",
 CellID->8643],

Cell[TextData[{
 "Within any open notebook, there is always a current selection. The current \
selection can be modified by applying functions such as ",
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20959]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->720700688],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->330040175],

Cell[TextData[{
 "Functions that create notebooks return ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->774675420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98890695],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["gr5_shm", 1, 1]], 30]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Untitled-1\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["gr5_shm", 1, 1]], 30],
  Editable->False]], "Output",
 ImageSize->{209, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->699630487]
}, Open  ]],

Cell["\<\
Functions that act on notebooks take a notebook object as an argument:\
\>", "ExampleText",
 CellID->538903196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"WindowTitle", "\[Rule]", "\"\<Powers\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24611761],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/Ht9Hkm/0L/lf54KmMnT2xnGnEqknYyjp0+cKaTPsjUpI1N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   "], {{0, 0}, {458, 125}}, {0, 255}],
  ImageSize->{458 0.75, 125 0.75},
  PlotRange->{{0, 458}, {0, 125}}]], "NotebookImage",
 CellID->322453202]
}, Open  ]],

Cell[TextData[{
 "Retitling a notebook changes the way the ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " expression is displayed:"
}], "ExampleText",
 CellID->173030573],

Cell[CellGroupData[{

Cell[BoxData["nb"], "Input",
 CellLabel->"In[3]:=",
 CellID->398189884],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["gr5_shm", 1, 1]], 30]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Powers\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["gr5_shm", 1, 1]], 30],
  Editable->False]], "Output",
 ImageSize->{194, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->340816742]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " expression itself has not changed:"
}], "ExampleText",
 CellID->43284209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "===", "%1"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->92975212],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->632460404]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13463],

Cell[TextData[{
 "There are several ways to obtain a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31392814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CreateDialog", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
    RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185067965],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["t4y_shm", 1, 1]], 55]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["None",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["t4y_shm", 1, 1]], 55],
  Editable->False]], "Output",
 ImageSize->{184, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211690726],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPG0cUgJH6H/rehyh/ok9tX2mkKspDKzUQFQiNoqhVH1pVyUMUkiY0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   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->412509200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookOpen", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{
    RowBox[{"Directory", "[", "]"}], ",", "\"\<work.nb\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22715425],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["njg_shm", 1, 1]], 20]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       TagBox[
        TooltipBox["\<\"work.nb\"\>",
         "\"C:\\\\Documents and Settings\\\\walsh\\\\My \
Documents\\\\work.nb\""],
        Annotation[#, 
         "C:\\Documents and Settings\\walsh\\My Documents\\work.nb", 
         "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["njg_shm", 1, 1]], 20],
  Editable->False]], "Output",
 ImageSize->{198, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49932248]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputNotebook", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->111461133],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["t4y_shm", 1, 1]], 63]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       TagBox[
        TooltipBox["\<\"NotebookObject - Wolfram Mathematica\"\>",
         "\"C:\\\\Documents and Settings\\\\walsh\\\\Application \
Data\\\\Mathematica\\\\Paclets\\\\Repository\\\\SystemDocumentation\\\\6.0\\\\\
English\\\\System\\\\ReferencePages\\\\Symbols\\\\NotebookObject.nb\""],
        Annotation[#, 
         "C:\\Documents and Settings\\walsh\\Application \
Data\\Mathematica\\Paclets\\Repository\\SystemDocumentation\\6.0\\English\\\
System\\ReferencePages\\Symbols\\NotebookObject.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["t4y_shm", 1, 1]], 63],
  Editable->False]], "Output",
 ImageSize->{354, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->326696706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Notebooks", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->463418817],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["t4y_shm", 1, 1]], 63]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       TagBox[
        TooltipBox["\<\"NotebookObject - Wolfram Mathematica\"\>",
         "\"C:\\\\Documents and Settings\\\\walsh\\\\Application \
Data\\\\Mathematica\\\\Paclets\\\\Repository\\\\SystemDocumentation\\\\6.0\\\\\
English\\\\System\\\\ReferencePages\\\\Symbols\\\\NotebookObject.nb\""],
        Annotation[#, 
         "C:\\Documents and Settings\\walsh\\Application \
Data\\Mathematica\\Paclets\\Repository\\SystemDocumentation\\6.0\\English\\\
System\\ReferencePages\\Symbols\\NotebookObject.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["t4y_shm", 1, 1]], 63],
  Editable->False]], "Output",
 ImageSize->{354, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->793408680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280591296],

Cell["Open a notebook from a file:", "ExampleText",
 CellID->491615658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{
  "NotebookOpen", "[", 
   "\"\<C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ExampleData\\\\document.nb\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273902952],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["t4y_shm", 1, 1]], 71]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       TagBox[
        TooltipBox["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ExampleData\\\\sample.nb\"\>",
         "\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ExampleData\\\\document.nb\""],
        Annotation[#, 
         "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ExampleData\\\
document.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["t4y_shm", 1, 1]], 71],
  Editable->False]], "Output",
 ImageSize->{687, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243604756],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnW2TFcd1x28q713+CvkqeXiJVFb5jaOqWKgitI7LpYpL70TlhSuyEwun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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->75167048]
}, Open  ]],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " to refer to the notebook in notebook operations:"
}], "ExampleText",
 CellID->126945862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117713448],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnfuTHcV1x28qv7v8L+RfyeM3CyrEvyRUxRIVxDopF5UUv6HKDy6wE0tO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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->331500282]
}, Open  ]],

Cell["Read selected data from the notebook:", "ExampleText",
 CellID->100494566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->862632694],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"\<\"Sample Document\"\>", ",", "\<\"Title\"\>", ",", 
   RowBox[{"CellChangeTimes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"3.381191583666008`*^9", ",", "3.3811915879941607`*^9"}], "}"}],
      "}"}]}]}], "]"}]], "Output",
 ImageSize->{529, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->477396184]
}, Open  ]],

Cell["Set options for the notebook:", "ExampleText",
 CellID->55043221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Magnification", "\[Rule]", "1.25"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->281504057],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuTXcV1xyeVd5e/Qr5KLm8WVDl+iqtiRAUxjsvlSipvUeXBBXZijVPG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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->287827120]
}, Open  ]],

Cell["Set options for the selected cell:", "ExampleText",
 CellID->23158311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"CellMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->125561525],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnW2THcV1xzeV9y5/hXyVPLyLoOLym8RVMVBBrJ1yUUnxDiovXMZOzDoV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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->966528076]
}, Open  ]],

Cell["Insert new material into the notebook:", "ExampleText",
 CellID->42032408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "After", ",", "Cell"}], "]"}], ";", 
  RowBox[{"NotebookWrite", "[", 
   RowBox[{"nb", ",", "\"\<2+2\>\""}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->524167101],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnfuTHcV1xzeV313+F/Kv5PGjoKD8C6EqRlQQ67hclFP+IVVW5QdXsBOz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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->22352129]
}, Open  ]],

Cell["Save the notebook:", "ExampleText",
 CellID->371478998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookSave", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<nbobjexml.nb\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->264974974],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnW2THcV1xzeV9yl/hXyVPLwUFJTfEKpiRAWxjstFOeUXqbIqL1zBTsw6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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->361779604]
}, Open  ]],

Cell["Close the notebook:", "ExampleText",
 CellID->109567794],

Cell[BoxData[
 RowBox[{"NotebookClose", "[", "nb", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->389707214]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18968],

Cell[TextData[{
 "Turn a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression into a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->237493347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"NotebookPut", "[", 
   RowBox[{"Notebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<first\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<second\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], ",", 
     
     RowBox[{"StyleDefinitions", "\[Rule]", "\"\<Default.nb\>\""}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->505732619],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["t4y_shm", 1, 1]], 70]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"Untitled-4\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["t4y_shm", 1, 1]], 70],
  Editable->False]], "Output",
 ImageSize->{209, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154776884]
}, Open  ]],

Cell[TextData[{
 "Turn a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " into a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->777882066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookGet", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343787152],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cell", "[", 
      RowBox[{"\<\"first\"\>", ",", "\<\"Text\"\>"}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{"\<\"second\"\>", ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"615", ",", "623"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "261"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "539"}], ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
   "FrontEndVersion", 
    "\[Rule]", "\<\"6.0 for Microsoft Windows (32-bit) (February 18, \
2007)\"\>"}], ",", 
   RowBox[{"StyleDefinitions", "\[Rule]", "\<\"Default.nb\"\>"}]}], 
  "]"}]], "Output",
 ImageSize->{541, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56644976]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->96822648],

Cell[TextData[{
 "After a notebook has been closed, the ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " can no longer be manipulated:"
}], "ExampleText",
 CellID->152774527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501697423],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["gr5_shm", 1, 1]], 32]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Untitled-1\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["gr5_shm", 1, 1]], 32],
  Editable->False]], "Output",
 ImageSize->{209, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363121301]
}, Open  ]],

Cell[BoxData[
 RowBox[{"NotebookClose", "@", "nb"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->186980459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookInformation", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->224077371],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->142790576]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1134],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSelection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10450],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->17621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->770682851]
}, Open  ]],

Cell["New in 3  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 58.1084890}", "context" -> "System`", 
    "keywords" -> {
     "notebook handle", "notebook object manipulation", 
      "document object handle", "interface object handle"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookObject[fe, id] is an object that represents an open notebook in \
the front end. ", "synonyms" -> {"notebook object"}, "title" -> 
    "NotebookObject", "type" -> "Symbol", "uri" -> "ref/NotebookObject"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5851, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->720700688]},
 "Notebook Image"->{
  Cell[15269, 497, 2666, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->412509200],
  Cell[25274, 782, 8211, 137, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->75167048],
  Cell[33928, 940, 8330, 139, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->331500282],
  Cell[43204, 1119, 9355, 156, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->287827120],
  Cell[52893, 1291, 10750, 179, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->966528076],
  Cell[64015, 1487, 9476, 158, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->22352129],
  Cell[73789, 1661, 8501, 142, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->361779604]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 92314, 2170},
 {"Notebook Image", 92455, 2174}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2226, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2849, 82, 52, 1, 70, "ObjectName",
 CellID->19274],
Cell[2904, 85, 576, 18, 70, "Usage",
 CellID->29116]
}, Open  ]],
Cell[CellGroupData[{
Cell[3517, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3995, 125, 230, 7, 70, "Notes",
 CellID->26681],
Cell[4228, 134, 178, 5, 70, "Notes",
 CellID->3257],
Cell[4409, 141, 442, 14, 70, "Notes",
 CellID->30465],
Cell[4854, 157, 500, 18, 70, "Notes",
 CellID->8643],
Cell[5357, 177, 457, 14, 70, "Notes",
 CellID->20959]
}, Closed]],
Cell[CellGroupData[{
Cell[5851, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->720700688],
Cell[CellGroupData[{
Cell[6236, 210, 148, 5, 70, "ExampleSection",
 CellID->330040175],
Cell[6387, 217, 246, 8, 70, "ExampleText",
 CellID->774675420],
Cell[CellGroupData[{
Cell[6658, 229, 218, 7, 28, "Input",
 CellID->98890695],
Cell[6879, 238, 1113, 35, 60, "Output",
 CellID->699630487]
}, Open  ]],
Cell[8007, 276, 121, 3, 70, "ExampleText",
 CellID->538903196],
Cell[CellGroupData[{
Cell[8153, 283, 182, 5, 70, "Input",
 CellID->24611761],
Cell[8338, 290, 2905, 50, 70, "NotebookImage",
 CellID->322453202]
}, Open  ]],
Cell[11258, 343, 260, 8, 70, "ExampleText",
 CellID->173030573],
Cell[CellGroupData[{
Cell[11543, 355, 71, 2, 70, "Input",
 CellID->398189884],
Cell[11617, 359, 1109, 35, 70, "Output",
 CellID->340816742]
}, Open  ]],
Cell[12741, 397, 232, 8, 70, "ExampleText",
 CellID->43284209],
Cell[CellGroupData[{
Cell[12998, 409, 95, 3, 70, "Input",
 CellID->92975212],
Cell[13096, 414, 161, 5, 36, "Output",
 CellID->632460404]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13306, 425, 216, 7, 70, "ExampleSection",
 CellID->13463],
Cell[13525, 434, 229, 8, 70, "ExampleText",
 CellID->31392814],
Cell[CellGroupData[{
Cell[13779, 446, 253, 7, 70, "Input",
 CellID->185067965],
Cell[14035, 455, 1231, 40, 70, "Output",
 CellID->211690726],
Cell[15269, 497, 2666, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->412509200]
}, Open  ]],
Cell[CellGroupData[{
Cell[17972, 548, 218, 7, 70, "Input",
 CellID->22715425],
Cell[18193, 557, 1263, 39, 70, "Output",
 CellID->49932248]
}, Open  ]],
Cell[CellGroupData[{
Cell[19493, 601, 104, 3, 70, "Input",
 CellID->111461133],
Cell[19600, 606, 1671, 46, 70, "Output",
 CellID->326696706]
}, Open  ]],
Cell[CellGroupData[{
Cell[21308, 657, 132, 4, 70, "Input",
 CellID->463418817],
Cell[21443, 663, 1671, 46, 70, "Output",
 CellID->793408680]
}, Open  ]],
Cell[23129, 712, 125, 3, 70, "ExampleDelimiter",
 CellID->280591296],
Cell[23257, 717, 71, 1, 70, "ExampleText",
 CellID->491615658],
Cell[CellGroupData[{
Cell[23353, 722, 279, 8, 70, "Input",
 CellID->273902952],
Cell[23635, 732, 1636, 48, 70, "Output",
 CellID->243604756],
Cell[25274, 782, 8211, 137, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->75167048]
}, Open  ]],
Cell[33500, 922, 251, 8, 70, "ExampleText",
 CellID->126945862],
Cell[CellGroupData[{
Cell[33776, 934, 149, 4, 70, "Input",
 CellID->117713448],
Cell[33928, 940, 8330, 139, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->331500282]
}, Open  ]],
Cell[42273, 1082, 80, 1, 70, "ExampleText",
 CellID->100494566],
Cell[CellGroupData[{
Cell[42378, 1087, 109, 3, 70, "Input",
 CellID->862632694],
Cell[42490, 1092, 425, 12, 39, "Output",
 CellID->477396184]
}, Open  ]],
Cell[42930, 1107, 71, 1, 70, "ExampleText",
 CellID->55043221],
Cell[CellGroupData[{
Cell[43026, 1112, 175, 5, 70, "Input",
 CellID->281504057],
Cell[43204, 1119, 9355, 156, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->287827120]
}, Open  ]],
Cell[52574, 1278, 76, 1, 70, "ExampleText",
 CellID->23158311],
Cell[CellGroupData[{
Cell[52675, 1283, 215, 6, 70, "Input",
 CellID->125561525],
Cell[52893, 1291, 10750, 179, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->966528076]
}, Open  ]],
Cell[63658, 1473, 80, 1, 70, "ExampleText",
 CellID->42032408],
Cell[CellGroupData[{
Cell[63763, 1478, 249, 7, 70, "Input",
 CellID->524167101],
Cell[64015, 1487, 9476, 158, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->22352129]
}, Open  ]],
Cell[73506, 1648, 61, 1, 70, "ExampleText",
 CellID->371478998],
Cell[CellGroupData[{
Cell[73592, 1653, 194, 6, 70, "Input",
 CellID->264974974],
Cell[73789, 1661, 8501, 142, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->361779604]
}, Open  ]],
Cell[82305, 1806, 62, 1, 70, "ExampleText",
 CellID->109567794],
Cell[82370, 1809, 110, 3, 70, "Input",
 CellID->389707214]
}, Closed]],
Cell[CellGroupData[{
Cell[82517, 1817, 233, 7, 70, "ExampleSection",
 CellID->18968],
Cell[82753, 1826, 345, 13, 70, "ExampleText",
 CellID->237493347],
Cell[CellGroupData[{
Cell[83123, 1843, 496, 15, 70, "Input",
 CellID->505732619],
Cell[83622, 1860, 1245, 40, 70, "Output",
 CellID->154776884]
}, Open  ]],
Cell[84882, 1903, 345, 13, 70, "ExampleText",
 CellID->777882066],
Cell[CellGroupData[{
Cell[85252, 1920, 108, 3, 70, "Input",
 CellID->343787152],
Cell[85363, 1925, 985, 30, 88, "Output",
 CellID->56644976]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86397, 1961, 229, 7, 70, "ExampleSection",
 CellID->96822648],
Cell[86629, 1970, 262, 8, 70, "ExampleText",
 CellID->152774527],
Cell[CellGroupData[{
Cell[86916, 1982, 219, 7, 70, "Input",
 CellID->501697423],
Cell[87138, 1991, 1113, 35, 70, "Output",
 CellID->363121301]
}, Open  ]],
Cell[88266, 2029, 105, 3, 70, "Input",
 CellID->186980459],
Cell[CellGroupData[{
Cell[88396, 2036, 116, 3, 70, "Input",
 CellID->224077371],
Cell[88515, 2041, 164, 5, 36, "Output",
 CellID->142790576]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88740, 2053, 310, 9, 70, "SeeAlsoSection",
 CellID->1134],
Cell[89053, 2064, 985, 35, 70, "SeeAlso",
 CellID->17274]
}, Open  ]],
Cell[CellGroupData[{
Cell[90075, 2104, 314, 9, 70, "TutorialsSection",
 CellID->10450],
Cell[90392, 2115, 186, 4, 70, "Tutorials",
 CellID->17621]
}, Open  ]],
Cell[CellGroupData[{
Cell[90615, 2124, 299, 8, 70, "MoreAboutSection"],
Cell[90917, 2134, 169, 3, 70, "MoreAbout",
 CellID->770682851]
}, Open  ]],
Cell[91101, 2140, 50, 0, 70, "History"],
Cell[91154, 2142, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

