(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81598,       1790]
NotebookOptionsPosition[     76492,       1624]
NotebookOutlinePosition[     78369,       1675]
CellTagsIndexPosition[     78249,       1669]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
          "Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>", 
       2->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookLocate" :> 
          Documentation`HelpLookup["paclet:ref/NotebookLocate"], 
          "NotebookSelection" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSelection"], 
          "NotebookClose" :> 
          Documentation`HelpLookup["paclet:ref/NotebookClose"], 
          "NotebookSave" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSave"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "SetSelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SetSelectedNotebook"], 
          "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookLocate\"\>", 
       2->"\<\"NotebookSelection\"\>", 3->"\<\"NotebookClose\"\>", 
       4->"\<\"NotebookSave\"\>", 5->"\<\"OpenRead\"\>", 6->"\<\"Get\"\>", 
       7->"\<\"SetSelectedNotebook\"\>", 
       8->"\<\"CreateDocument\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookOpen", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookOpen",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookOpen"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens an existing notebook with the specified name, \
returning the corresponding notebook object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookOpen",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookOpen"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a notebook using the options given. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookOpen",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookOpen"], "[", 
       RowBox[{"\"\<http://\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a notebook from any accessible URL. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " will usually cause a new notebook window to be opened on your screen. "
}], "Notes",
 CellID->10558],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it cannot open a notebook with the specified name. "
}], "Notes",
 CellID->17392],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " searches the directories specified by the ",
 Cell[BoxData[
  ButtonBox["NotebookPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPath"]], "InlineFormula"],
 " global option for the front end. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->652488337],
 " "
}], "Notes",
 CellID->9963],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Visible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Visible"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " set, ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " will return a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ", but will not cause a window to appear on your screen. "
}], "Notes",
 CellID->17462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " initially sets the current selection to be before the first cell in the \
notebook. "
}], "Notes",
 CellID->15183]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375694916],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->46889343],

Cell["Open a notebook from a file in a specified directory:", "ExampleText",
 CellID->502256142],

Cell[BoxData[
 RowBox[{
  RowBox[{"docpath", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "$InstallationDirectory", ",", "\"\<Documentation\>\"", ",", 
       "\"\<English\>\"", ",", "\"\<System\>\""}], "}"}], ",", 
     "\"\<ExampleData\>\""}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7765040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"docpath", ",", "\"\<document.nb\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22715425],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnetzHUV6h08q31P7L+Q/oXL5aFxQ+4VQlcVUMNqktqik+IYrH7bCbrJo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   "], {{0, 0}, {458, 252}}, {0, 255}],
  ImageSize->{458 0.75, 252 0.75},
  PlotRange->{{0, 458}, {0, 252}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->50415448]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20873],

Cell["Open a notebook from the web:", "ExampleText",
 CellID->154382981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookOpen", "[", 
  "\"\<http://demonstrations.wolfram.com/data/001281/0004/PoissonDistribution/\
PoissonDistribution.nb\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292624918],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["y9g_shm", 1, 1]], 51]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       TagBox[
        TooltipBox["\<\"Poisson Distribution - Wolfram Demonstration\"\>",
         "\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temporary Internet \
Files\\\\Content.IE5\\\\I67LXONN\\\\PoissonDistribution[1].nb\""],
        Annotation[#, 
         "C:\\Documents and Settings\\roger\\Local Settings\\Temporary \
Internet Files\\Content.IE5\\I67LXONN\\PoissonDistribution[1].nb", 
         "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["y9g_shm", 1, 1]], 51],
  Editable->False]], "Output",
 ImageSize->{371, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->781387869],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztvQlwHMl578ndF7Hh2I2wtc/7LOtpZMleP58bfhvPfrsySRzdAAHe9wyv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   "], {{0, 0}, {458, 520}}, {0, 255}],
  ImageSize->{458 0.75, 520 0.75},
  PlotRange->{{0, 458}, {0, 520}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->59675748]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->466901526],

Cell[TextData[{
 "A relative file name locates files relative to the front end's ",
 Cell[BoxData[
  ButtonBox["NotebookPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPath"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->652488337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookOpen", "[", "\"\<BasicMathInput.nb\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->847913797],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["njg_shm", 1, 1]], 24]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       TagBox[
        TooltipBox["\<\"Basic Math Input\"\>",
         "\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\FrontEnd\\\\Palettes\\\\\
BasicMathInput.nb\""],
        Annotation[#, 
         "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\FrontEnd\\Palettes\\BasicMathInput.\
nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["njg_shm", 1, 1]], 24],
  Editable->False]], "Output",
 ImageSize->{239, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619488547],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztm9uPFMcVxifKu+UX3vwSOU/OP+A8OUoi58m2FJGXoMSADNiJLEwekrzE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   "], {{0, 0}, {102, 415}}, {0, 255}],
  ImageSize->{102 0.75, 415 0.75},
  PlotRange->{{0, 102}, {0, 415}}]], "NotebookImage",
 CellID->298848098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301503440],

Cell["Set the current working directory:", "ExampleText",
 CellID->195216411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "$InstallationDirectory", ",", "\"\<Documentation\>\"", ",", 
      "\"\<English\>\"", ",", "\"\<System\>\""}], "}"}], ",", 
    "\"\<ExampleData\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28653481],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0 \
Prerelease\\\\Documentation\\\\English\\\\System\\\\ExampleData\"\>"], \
"Output",
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271525758]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " does not look in this directory for the specified file name:"
}], "ExampleText",
 CellID->634191098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookOpen", "[", "\"\<document.nb\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216565949],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->912029847]
}, Open  ]],

Cell[TextData[{
 "To open a file in the current directory, give a path based on ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->654538973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{
      RowBox[{"Directory", "[", "]"}], ",", "\"\<document.nb\>\""}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->708573798],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnetvHsd1h9+i34v8C/1XevkoGzHyJTHQWEYtMy0CI4W/WeiHoE7aWCnq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   "], {{0, 0}, {458, 162}}, {0, 255}],
  ImageSize->{458 0.75, 162 0.75},
  PlotRange->{{0, 458}, {0, 162}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->750412410]
}, Open  ]],

Cell["Return to the previous working directory:", "ExampleText",
 CellID->98182770],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->213004493]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13707],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookLocate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookLocate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSelection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSave"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetSelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17415],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->3848],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->12535]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookOpen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 59.1866416}", "context" -> "System`", 
    "keywords" -> {
     "open notebook", "notebook files", "document files", "notebook URL"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NotebookOpen[\"name\"] opens an existing notebook with the specified \
name, returning the corresponding notebook object. NotebookOpen[\"name\", \
options] opens a notebook using the options given. NotebookOpen[\"http:// url\
\", ...] opens a notebook from any accessible URL. ", 
    "synonyms" -> {"notebook open"}, "title" -> "NotebookOpen", "type" -> 
    "Symbol", "uri" -> "ref/NotebookOpen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11005, 301, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->375694916]},
 "Notebook Image"->{
  Cell[12266, 350, 9053, 151, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->50415448],
  Cell[23520, 577, 32880, 542, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->59675748],
  Cell[65745, 1366, 7102, 119, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->750412410]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 77768, 1652},
 {"Notebook Image", 77910, 1656}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2294, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2917, 78, 4196, 83, 70, "ObjectNameGrid"],
Cell[7116, 163, 1346, 38, 70, "Usage",
 CellID->6091]
}, Open  ]],
Cell[CellGroupData[{
Cell[8499, 206, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8977, 223, 246, 7, 70, "Notes",
 CellID->10558],
Cell[9226, 232, 361, 12, 70, "Notes",
 CellID->17392],
Cell[9590, 246, 476, 16, 70, "Notes",
 CellID->9963],
Cell[10069, 264, 636, 22, 70, "Notes",
 CellID->17462],
Cell[10708, 288, 260, 8, 70, "Notes",
 CellID->15183]
}, Closed]],
Cell[CellGroupData[{
Cell[11005, 301, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375694916],
Cell[CellGroupData[{
Cell[11390, 315, 147, 5, 70, "ExampleSection",
 CellID->46889343],
Cell[11540, 322, 96, 1, 70, "ExampleText",
 CellID->502256142],
Cell[11639, 325, 357, 11, 70, "Input",
 CellID->7765040],
Cell[CellGroupData[{
Cell[12021, 340, 242, 8, 70, "Input",
 CellID->22715425],
Cell[12266, 350, 9053, 151, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->50415448]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21368, 507, 216, 7, 70, "ExampleSection",
 CellID->20873],
Cell[21587, 516, 72, 1, 70, "ExampleText",
 CellID->154382981],
Cell[CellGroupData[{
Cell[21684, 521, 213, 5, 70, "Input",
 CellID->292624918],
Cell[21900, 528, 1617, 47, 70, "Output",
 CellID->781387869],
Cell[23520, 577, 32880, 542, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->59675748]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56449, 1125, 230, 7, 70, "ExampleSection",
 CellID->466901526],
Cell[56682, 1134, 310, 9, 70, "ExampleText",
 CellID->652488337],
Cell[CellGroupData[{
Cell[57017, 1147, 132, 3, 70, "Input",
 CellID->847913797],
Cell[57152, 1152, 1375, 41, 70, "Output",
 CellID->619488547],
Cell[58530, 1195, 5158, 87, 70, "NotebookImage",
 CellID->298848098]
}, Open  ]],
Cell[63703, 1285, 125, 3, 70, "ExampleDelimiter",
 CellID->301503440],
Cell[63831, 1290, 77, 1, 70, "ExampleText",
 CellID->195216411],
Cell[CellGroupData[{
Cell[63933, 1295, 343, 10, 70, "Input",
 CellID->28653481],
Cell[64279, 1307, 297, 8, 54, "Output",
 CellID->271525758]
}, Open  ]],
Cell[64591, 1318, 246, 7, 70, "ExampleText",
 CellID->634191098],
Cell[CellGroupData[{
Cell[64862, 1329, 126, 3, 70, "Input",
 CellID->216565949],
Cell[64991, 1334, 164, 5, 36, "Output",
 CellID->912029847]
}, Open  ]],
Cell[65170, 1342, 273, 9, 70, "ExampleText",
 CellID->654538973],
Cell[CellGroupData[{
Cell[65468, 1355, 274, 9, 70, "Input",
 CellID->708573798],
Cell[65745, 1366, 7102, 119, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->750412410]
}, Open  ]],
Cell[72862, 1488, 83, 1, 70, "ExampleText",
 CellID->98182770],
Cell[72948, 1491, 123, 4, 70, "Input",
 CellID->213004493]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73120, 1501, 311, 9, 70, "SeeAlsoSection",
 CellID->13707],
Cell[73434, 1512, 1993, 71, 70, "SeeAlso",
 CellID->17184]
}, Open  ]],
Cell[CellGroupData[{
Cell[75464, 1588, 314, 9, 70, "TutorialsSection",
 CellID->17415],
Cell[75781, 1599, 427, 12, 70, "Tutorials",
 CellID->3848],
Cell[76211, 1613, 186, 4, 70, "Tutorials",
 CellID->12535]
}, Open  ]],
Cell[76412, 1620, 50, 0, 70, "History"],
Cell[76465, 1622, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

