(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22649,        656]
NotebookOptionsPosition[     19104,        546]
NotebookOutlinePosition[     20851,        592]
CellTagsIndexPosition[     20733,        586]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookSave" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSave"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"], 
          "PrintingStyleEnvironment" :> 
          Documentation`HelpLookup["paclet:ref/PrintingStyleEnvironment"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"NotebookSave\"\>", 
       2->"\<\"NotebookWrite\"\>", 3->"\<\"PrintingStyleEnvironment\"\>", 
       4->"\<\"Export\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookPrint", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookPrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookPrint"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]sends the specified notebook to your default printer. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookPrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookPrint"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]saves a print\[Hyphen]ready form of the notebook to a \
file in the format indicated by the file extension ",
     Cell[BoxData[
      StyleBox["ext", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookPrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookPrint"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]sends the current evaluation notebook to your default \
printer."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["notebook", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["NotebookPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPrint"]], "InlineFormula"],
 " will print the complete notebook. If it is a ",
 Cell[BoxData[
  ButtonBox["NotebookSelection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookSelection"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["NotebookPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPrint"]], "InlineFormula"],
 " will print just the selection. "
}], "Notes",
 CellID->8337],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPrint"]], "InlineFormula"],
 " uses the printing options set for the specified notebook, taking defaults \
from the global options set for the whole front end. "
}], "Notes",
 CellID->22012],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ps\>\""}], "]"}]], "InlineFormula"],
 " saves the PostScript form of the notebook in a file. "
}], "Notes",
 CellID->17034],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pdf\>\""}], "]"}]], "InlineFormula"],
 " saves the PDF form. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3744],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", 
    StyleBox["stream", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " sends the print\[Hyphen]ready form of the notebook to a stream in the \
specified format. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3217],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives the print\[Hyphen]ready form of the notebook as input to a command. \
"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26068]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->352859034],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->94025597],

Cell["Save the print form of a notebook to a file in PDF format:", \
"ExampleText",
 CellID->199818600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"x", "^", "2"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106604703],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPVFcYhml63/gX+lfaeqtp05u2SQVTUNsYY9OLJk16Yaq2UpviATwA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   "], {{0, 0}, {458, 69}}, {0, 255}],
  ImageSize->{458 0.75, 69 0.75},
  PlotRange->{{0, 458}, {0, 69}}]], "NotebookImage",
 CellID->274683542]
}, Open  ]],

Cell[BoxData[
 RowBox[{"NotebookPrint", "[", 
  RowBox[{"nb", ",", "\"\<temp.pdf\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->364785861],

Cell[TextData[{
 "The file is saved with the same appearance it has when printed from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->59613540],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\
eJztVr1OAkEQ3rsFYqxttKIWXoDWP0yMFbUmJzE5CiMgFa9AbUFBjFrwAjwA
b8EzGDEm8gDnfnMzlz0Q76IWavbCze7O7HzzzezeLqdBL7y8CnqtZlCud4N2
2GrelI+uu0alPaW8N6XUWVmhH5kui8j8ogWEGRXUxcW5Go3u6aU5xvAMoTH0
yK40mUlDjvRCPlkzYwSH6BAd4hrEPZJFNZlMEj0ejGnGQ3a0Q/LS5NNoNNR0
Oo19H/Mw2GdveNVqNTWbzVa910Q+IN/Sh+wNnq+GwyFh3eVhcgzpg8CKz5r4
J1bmqTUa5YlXZ29kDITxeKzyRv5fu9AhOkSHCEMFU+gQu02Gv5ftzyNWafaO
GgwGdB7ySU5a3C3SQheGIdnRmoOezlE8sOHBGDeKYACz3+8TLtt9PoJFNZ/P
Y6odNkCBBxjVPInucgK2Tq4HIQwiaEFaDn7olpOU68wuAAihRWKm71NGOuVC
QbucgM2jkrf+2wQvbggvd5TUHlGhQys00dp6u5XU7XUqMEWZk3DvZHDPKH4h
KRTrfarwVrKpQEZIoMV0IQcyslkAAZ0UA74Ys59mmuKam/+ntS8SFv0XYFf0
i9TbSOltirz+JY4s5Y5HsUy2h9Bsf6/MpaQ2sniIamq3ufTtxFnROpjqCh35
Olfo2IZqdtX+wqnmEB2iQ/wqIgOIzcami+cFQrOfTuFEkK8Q7EWKBc/13gFf
J2m5\
\>"], "Graphics",
  ImageSize->{498, 93},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->287757846]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17691],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSave"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintingStyleEnvironment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrintingStyleEnvironment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13235],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->1104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->450622533]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookPrint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 0.5616768}", "context" -> "System`", 
    "keywords" -> {
     "hard copy", "laser printer", "paper copy", "print to file", 
      "print to PostScript", "print to PDF", "print to stream"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NotebookPrint[notebook] sends the specified notebook to your default \
printer. NotebookPrint[notebook, \" file. ext\"] saves a print-ready form of \
the notebook to a file in the format indicated by the file extension ext. \
NotebookPrint[] sends the current evaluation notebook to your default \
printer.", "synonyms" -> {"notebook print"}, "title" -> "NotebookPrint", 
    "type" -> "Symbol", "uri" -> "ref/NotebookPrint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12021, 336, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->352859034]},
 "Notebook Image"->{
  Cell[15690, 431, 922, 18, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->287757846]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20464, 575},
 {"Notebook Image", 20606, 579}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2229, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2852, 82, 4197, 83, 70, "ObjectNameGrid"],
Cell[7052, 167, 1390, 41, 70, "Usage",
 CellID->18040]
}, Open  ]],
Cell[CellGroupData[{
Cell[8479, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8957, 230, 763, 26, 70, "Notes",
 CellID->8337],
Cell[9723, 258, 307, 8, 70, "Notes",
 CellID->22012],
Cell[10033, 268, 359, 11, 70, "Notes",
 CellID->17034],
Cell[10395, 281, 456, 14, 70, "Notes",
 CellID->3744],
Cell[10854, 297, 560, 16, 70, "Notes",
 CellID->3217],
Cell[11417, 315, 567, 16, 70, "Notes",
 CellID->26068]
}, Closed]],
Cell[CellGroupData[{
Cell[12021, 336, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->352859034],
Cell[CellGroupData[{
Cell[12406, 350, 147, 5, 70, "ExampleSection",
 CellID->94025597],
Cell[12556, 357, 103, 2, 70, "ExampleText",
 CellID->199818600],
Cell[CellGroupData[{
Cell[12684, 363, 204, 7, 70, "Input",
 CellID->106604703],
Cell[12891, 372, 2450, 42, 70, "NotebookImage",
 CellID->274683542]
}, Open  ]],
Cell[15356, 417, 148, 4, 70, "Input",
 CellID->364785861],
Cell[15507, 423, 180, 6, 70, "ExampleText",
 CellID->59613540],
Cell[15690, 431, 922, 18, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->287757846]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16661, 455, 311, 9, 70, "SeeAlsoSection",
 CellID->17691],
Cell[16975, 466, 987, 35, 70, "SeeAlso",
 CellID->13197]
}, Open  ]],
Cell[CellGroupData[{
Cell[17999, 506, 314, 9, 70, "TutorialsSection",
 CellID->13235],
Cell[18316, 517, 185, 4, 70, "Tutorials",
 CellID->1104]
}, Open  ]],
Cell[CellGroupData[{
Cell[18538, 526, 299, 8, 70, "MoreAboutSection"],
Cell[18840, 536, 169, 3, 70, "MoreAbout",
 CellID->450622533]
}, Open  ]],
Cell[19024, 542, 50, 0, 70, "History"],
Cell[19077, 544, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

