(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49554,       1102]
NotebookOptionsPosition[     45752,        981]
NotebookOutlinePosition[     47375,       1025]
CellTagsIndexPosition[     47255,       1019]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookAutoSave" :> 
          Documentation`HelpLookup["paclet:ref/NotebookAutoSave"], 
          "NotebookPrint" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPrint"], "Save" :> 
          Documentation`HelpLookup["paclet:ref/Save"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NotebookAutoSave\"\>", 
       2->"\<\"NotebookPrint\"\>", 3->"\<\"Save\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Mathematica Session History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NotebookSave", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookSave"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]saves the current version of the specified notebook. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookSave"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]saves the notebook in the specified file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookSave",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookSave"], "[", "]"}]], "InlineFormula"],
     
     " \[LineSeparator]saves the current version of the current evaluation \
notebook in a file."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6266]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["notebook", "TI"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17605],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSave"], "[", 
   StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
 " saves the notebook in a file whose name is given by the notebook object ",
 Cell[BoxData[
  StyleBox["notebook", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookSave"]], "InlineFormula"],
 " writes out the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression corresponding to the notebook, together with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comments which make it easier for the front end to read the notebook in \
again. "
}], "Notes",
 CellID->21903]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->182799463],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->139011948],

Cell["Save a new document to a specified file:", "ExampleText",
 CellID->11044010],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265238082],

Cell[BoxData[
 RowBox[{"NotebookSave", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"DirectoryName", "[", "$TemporaryPrefix", "]"}], ",", 
     "\"\<savetest.nb\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->221753227],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376648205],

Cell["\<\
Modify a previously saved document and save it to the same place:\
\>", "ExampleText",
 CellID->240476663],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{
      RowBox[{"DirectoryName", "[", "$TemporaryPrefix", "]"}], ",", 
      "\"\<savetest.nb\>\""}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279028276],

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\<0\>\"", ",", "\"\<Output\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->612683636],

Cell[BoxData[
 RowBox[{"NotebookSave", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24481505]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113501598],

Cell["\<\
If you do not provide a file name for a new notebook, you will be prompted to \
choose one:\
\>", "ExampleText",
 CellID->691618111],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "\"\<new\>\"", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368041612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookSave", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->308612490],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{308.9375, 251.3125},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->520534874]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20282],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookAutoSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookAutoSave"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12832],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->27584]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->386282187],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->154712220],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->108430206]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookSave - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 3.9211378}", "context" -> "System`", 
    "keywords" -> {
     "save notebook", "save to file", "save work", "store notebook"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NotebookSave[notebook] saves the current version of the specified \
notebook. NotebookSave[notebook, \" file\"] saves the notebook in the \
specified file. NotebookSave[] saves the current version of the current \
evaluation notebook in a file.", "synonyms" -> {"notebook save"}, "title" -> 
    "NotebookSave", "type" -> "Symbol", "uri" -> "ref/NotebookSave"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9916, 270, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->182799463]},
 "Notebook Image"->{
  Cell[12636, 380, 30697, 506, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->520534874]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46984, 1008},
 {"Notebook Image", 47125, 1012}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2248, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2871, 82, 4196, 83, 70, "ObjectNameGrid"],
Cell[7070, 167, 1212, 36, 70, "Usage",
 CellID->6266]
}, Open  ]],
Cell[CellGroupData[{
Cell[8319, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8797, 225, 261, 10, 70, "Notes",
 CellID->17605],
Cell[9061, 237, 377, 12, 70, "Notes",
 CellID->18065],
Cell[9441, 251, 438, 14, 70, "Notes",
 CellID->21903]
}, Closed]],
Cell[CellGroupData[{
Cell[9916, 270, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->182799463],
Cell[CellGroupData[{
Cell[10301, 284, 148, 5, 70, "ExampleSection",
 CellID->139011948],
Cell[10452, 291, 82, 1, 70, "ExampleText",
 CellID->11044010],
Cell[10537, 294, 214, 7, 70, "Input",
 CellID->265238082],
Cell[10754, 303, 277, 8, 70, "Input",
 CellID->221753227],
Cell[11034, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->376648205],
Cell[11162, 318, 116, 3, 70, "ExampleText",
 CellID->240476663],
Cell[11281, 323, 300, 9, 70, "Input",
 CellID->279028276],
Cell[11584, 334, 211, 6, 70, "Input",
 CellID->612683636],
Cell[11798, 342, 108, 3, 70, "Input",
 CellID->24481505]
}, Open  ]],
Cell[CellGroupData[{
Cell[11943, 350, 220, 7, 70, "ExampleSection",
 CellID->113501598],
Cell[12166, 359, 142, 4, 70, "ExampleText",
 CellID->691618111],
Cell[12311, 365, 188, 6, 70, "Input",
 CellID->368041612],
Cell[CellGroupData[{
Cell[12524, 375, 109, 3, 70, "Input",
 CellID->308612490],
Cell[12636, 380, 30697, 506, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->520534874]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43394, 893, 311, 9, 70, "SeeAlsoSection",
 CellID->20282],
Cell[43708, 904, 714, 26, 70, "SeeAlso",
 CellID->29534]
}, Open  ]],
Cell[CellGroupData[{
Cell[44459, 935, 314, 9, 70, "TutorialsSection",
 CellID->12832],
Cell[44776, 946, 186, 4, 70, "Tutorials",
 CellID->27584]
}, Open  ]],
Cell[CellGroupData[{
Cell[44999, 955, 319, 9, 70, "MoreAboutSection",
 CellID->386282187],
Cell[45321, 966, 169, 3, 70, "MoreAbout",
 CellID->154712220],
Cell[45493, 971, 164, 3, 70, "MoreAbout",
 CellID->108430206]
}, Open  ]],
Cell[45672, 977, 50, 0, 70, "History"],
Cell[45725, 979, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

