(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41763,       1087]
NotebookOptionsPosition[     36653,        915]
NotebookOutlinePosition[     38152,        955]
CellTagsIndexPosition[     38067,        950]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectionMove" :> 
          Documentation`HelpLookup["paclet:ref/SelectionMove"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SelectionMove\"\>", 
       2->"\<\"CurrentValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Programmatic Notebook & Interface Customization\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookSelection", "ObjectName",
 CellID->17644],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookSelection",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookSelection"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]represents the current selection in the current \
evaluation notebook in the front end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookSelection",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookSelection"], "[", 
       StyleBox["nb", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the current selection associated with the \
open notebook ",
     Cell[BoxData[
      StyleBox["nb", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24383]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookSelection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookSelection"]], "InlineFormula"],
 " takes a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " as an argument. "
}], "Notes",
 CellID->19806],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " to read and write options associated with your current selection. "
}], "Notes",
 CellID->23911]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->540127994],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->554077409],

Cell["Select some text and then set a font option for it:", "ExampleText",
 CellID->196028353],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", "\"\<bold type\>\"", "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197505024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "CellContents"}], "]"}], ";", 
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Word"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143352300],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+j961cOtpo03bZMqpqK2MaZN75r0wlRttTb1BB4Q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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellID->126165646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22392881],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+j961cOtpo03bZMqpoC2MaZN75r0wlRtpTb1BB4A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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellID->181301728]
}, Open  ]],

Cell["Find out the option settings for the selected text:", "ExampleText",
 CellID->357919445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"NotebookSelection", "[", "nb", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->745101360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"FontWeight", "\[Rule]", "\<\"Bold\"\>"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->82142000]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->249552558],

Cell["Apply a named style to a selection:", "ExampleText",
 CellID->127391306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<text\>\"", ",", "\"\<text\>\"", ",", "\"\<text\>\""}], 
     "}"}], "]"}]}], ";", 
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184945382],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/Ht9Hkm/0L/laZ91omTNk/SzjTgVDTJZJxm8qwzfZCJSRua
TowKYhQTAiQaogKVKBZEfqzLgguyIAuy2MLqFH9FneJogZyeu2f37Nl7L5v9
cU/M7L5f8wlzvuece/PsMzvorD/buffXO38aCoXekP9FfxIKOeuGhj8TQgix
kY3NLUIIIQFGt+uXJy4QQggJJK52feYfoQkhpAri264CAFCBhuzvWmlXACjV
23/q/eWLLSovvXLcPKJdASAQsmDNkXYFgEBUd7uG0gqsvQsACETVt2vhhXcf
AAJRa+3qe7rdBQAoW+20q+Y9FbQrgKDVTrv6LvjNAABLqrhdXR9WC/yplvdj
LQBUqIrbVZTyiZRqBRAs2rXUmwBQjOpuVwB4VmhXAAhQ7qsGdtCuABA8PrsC
QFDM78jas7fLPKJdAcAG2hUAbKBdAcAG2hUAbKBdAcAG2hUAbKBdAcAG2hUA
bKBdAcAG2hUAbKBdAcAG2hUAbKBdAcAG2hUAbKBdAaBs5jcQvvTKcfOIdgWA
QPDt2QBgQ3W3ayitwNq7AIBAVH27Fl549wEgELXWrr6n210AgLLVTrtq3lNB
uwIIWu20q++C3wwAsKSK29X1YbXAn2p5P9YCQIWquF1FKZ9IqVYAwaJdS70J
AMWo7nYFgGeFdgWAAOW+amAH7QoAweOzKwAExfyOrD17u8wj2hUAbKBdAcAG
2hUAbKBdAcAG2hUAbKBdAcAG2hUAbKBdAcAG2hUAbKBdAcAG2hUAbKBdAcAG
2hUAylbgH5OiXQGgPCE/+pR2BYDyyC5tfPdX/d0NKqc662hXAKic61OrLFja
FQAqV1Ptav7ew3ftXQBAeWqtXQsvvPsAUJ4ab1ff0+0uAEDxarZdvX9BgnYF
EKCabVffBb8ZABCU2mlX14fVAn+q5f1YCwClqp12FaV8IqVaAVSIdq3wJgD4
qql2BYAfDO0KADaoUs191cAZ2hUAAsBnVwCwIZT/HVnNH/2GdgWAyoX86FPa
FQDKVuDvz9OuAGAD7QoANtCuAGAD7QoANtCuAGCD2a5vvNmYXPpXd2/kg8Z2
QgghFWbjfxvhyPwf39rf8OaHsl1lFhaWCSGEVBizXRcSq0JsbW1tEkIIqSTf
bW2a7XptbmVjY3P98ROZx+lk1uvy51M9rq9nLshNfVmvzTxmZGRk/JGOJXfa
4aMnjr38884dL3Ts+IU3cl+eyjvqwSdPnq6vP9XtOnP1xsNH63fvPbx770H6
58Ps+oF7fd+8oO/rzUf5p4yMjIw/qrGcTut5+cXNAwfFp22itdUnn7bJU3lH
PXjvvvOIbtepqaVb/7m3krqzsrr23PPPm1lJra2kbmfWq+b6toxx7U52cVuv
1ZjbN+77Xs69OX1ZnaqF+6n8U0ZGRsaiRqfE1tKbamctu59N5mjNeSr7huu7
60XfWXH65LbpOyvvqGdXb95ZTd3V7Toxubh049bC9VVVX3Khkh1Tuf3F3J3s
YiV9OXNnMe8lK+boernrVI75F5xT83LhU0ZGRsbvHbOLVG5zMX901ivGHecN
iw31oqdbfPVF5i9dyYWKHnu65Z30I6nFpdT15C3drpHxRHzuxtV4UjWYXEzH
k+aoF36by7770/kvmc5/ufd0On+tTs3LhU8ZGRkZixyv5q89WTafkgt3u0pd
xjrbruqpmdnk7LV/63aVi4lYInplXjXY+GQiMpEYn8yN2cW8uc4sriTGJ+Zz
44R+aj4q7xuj6zcA3stqHcm/GXH+p3mn+s1ywcjIyFj8GJ1MyIxnf447+wln
P9146rLuNP2GxYY60XNanOxw4tJ5XHS0ilMnZLuOq3deScSml3S7joXnRsPx
kXBcNZhcjIzFh8MzmXEsb9+1OZzeHBnTl2dy++G4OeoHh7e5nFmPzehn1eVi
ThkZGRmLGDM7cp3byexnojtNv2HhD686vdr2iWg7Ij5ryVVra5M4dlB88rEs
2IVdr2YfmYlEExcvXVXtOhqeGxyaklENNnDJWQ9eiqlR7+uYl7M7MdfCNQ4M
TQ3kPzLgvCTm9/KYuqxO9Vj4lJGRkbGIMbMzkNnPi3E/7w1Ou7YfEy37xeH9
7s+uBz4UH/9NHGuR7arfMxqe/UdfRLXryNjsuf7x8xeiqsHkQkWN5y5MnHcS
Pd8flWtn7J8wLqePnP1o+qZ+yn90XTZH/ULvqe7e7Z5lZGRk/N7xXG7fp9PU
qbfTFnbVidaWzY8adac+/Xtu/fiv74vmQ4u76tLPRs/1R4eGp788OZhp19HZ
3r7w2W8iqsHkQsU1upJ/elmPxv5l72jEPbpeWNIpIyMjY4lj4VzWP53fuzYf
evT+e6pO//uX9x6lo8Zv9+0Thw7KO/rZgYuxo6292XadO919ubs3YiOqFYO9
SQghP1iSe+pFU9Pdd975dt+73sh90dyU3F2nLp/pifT/c2r/gZOZdh251vXV
6Kmvw4QQQlyJvfZbcaRZNMs0+aSpSRw5Ovn679Xlr7vC3/TFPmhsV+06NBRv
+2ygs/0iIYQQVw4fPTG163fLr+1c2l3vzfKe+tjuenlHXe74fPDM6QjtSggh
wYZ2JYQQG6FdCSHERlztOjwSb28b+KLzIiGEkErS2THY051r19XU/eTy7eTy
GiGEkApz8+YD3a6EEEKCjWzX/wPEWn6E
   "], {{0, 0}, {458, 107}}, {0, 255}],
  ImageSize->{458 0.75, 107 0.75},
  PlotRange->{{0, 458}, {0, 107}}]], "NotebookImage",
 CellID->26290247]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", "\"\<Section\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->790134791],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/Ht9Hkn/0L/E6c/ngWdmDxpnWnAqUjayTjt5FmcPsho0gbT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   "], {{0, 0}, {458, 139}}, {0, 255}],
  ImageSize->{458 0.75, 139 0.75},
  PlotRange->{{0, 458}, {0, 139}}]], "NotebookImage",
 CellID->544643683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5951544],

Cell["Set an option for selected graphics:", "ExampleText",
 CellID->256739825],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1583196],

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283765201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5142512],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnWlzFMcZgJXK95T/Qn5IKuUQlYr79gF2jDjEbQymVCpCUWtuIcAIdBgb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   "], {{0, 0}, {458, 172}}, {0, 255}],
  ImageSize->{458 0.75, 172 0.75},
  PlotRange->{{0, 458}, {0, 172}}]], "NotebookImage",
 CellID->552783720]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->381057107],

Cell[TextData[{
 "You do not need to use ",
 Cell[BoxData[
  ButtonBox["NotebookSelection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookSelection"]], "InlineFormula"],
 " with most notebook-manipulating functions:"
}], "ExampleText",
 CellID->193858769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], ";", 
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263704306],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/HtdKZP2ulkJn9Bpn9Fn7bNs0YnTZ60nTZgK5J2Mo6dPMhM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   "], {{0, 0}, {458, 93}}, {0, 255}],
  ImageSize->{458 0.75, 93 0.75},
  PlotRange->{{0, 458}, {0, 93}}]], "NotebookImage",
 CellID->5136100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45638300],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{
   RowBox[{"BoxData", "[", "\<\"a\"\>", "]"}], ",", "\<\"Output\"\>"}], 
  "]"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369104019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->317963956],

Cell["\<\
Some options are not applicable to individual cells or cell contents:\
\>", "ExampleText",
 CellID->47912622],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], ";", 
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327316596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"WindowTitle", "\[Rule]", "\"\<Changed\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243485107],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9PlFcex/FpNtmbbjZN9i9o+lfs7f6429V0tzftJltwV8RtGuNmL5o0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   "], {{0, 0}, {458, 105}}, {0, 255}],
  ImageSize->{458 0.75, 105 0.75},
  PlotRange->{{0, 458}, {0, 105}}]], "NotebookImage",
 CellID->397555708]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3808],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionMove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionMove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31894]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10507],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->29206]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->317067250],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->148689539]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookSelection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 4.4211506}", "context" -> "System`", 
    "keywords" -> {
     "options for a selection", "selected cell", "selected text", 
      "setting options for a selection", "text options"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookSelection[] represents the current selection in the current \
evaluation notebook in the front end. NotebookSelection[nb] represents the \
current selection associated with the open notebook nb. ", 
    "synonyms" -> {"notebook selection"}, "title" -> "NotebookSelection", 
    "type" -> "Symbol", "uri" -> "ref/NotebookSelection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5136, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->540127994]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37924, 943}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2222, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2845, 83, 55, 1, 70, "ObjectName",
 CellID->17644],
Cell[2903, 86, 949, 29, 70, "Usage",
 CellID->24383]
}, Open  ]],
Cell[CellGroupData[{
Cell[3889, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4367, 137, 347, 12, 70, "Notes",
 CellID->19806],
Cell[4717, 151, 382, 13, 70, "Notes",
 CellID->23911]
}, Closed]],
Cell[CellGroupData[{
Cell[5136, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->540127994],
Cell[CellGroupData[{
Cell[5521, 183, 148, 5, 70, "ExampleSection",
 CellID->554077409],
Cell[5672, 190, 94, 1, 70, "ExampleText",
 CellID->196028353],
Cell[5769, 193, 194, 6, 70, "Input",
 CellID->197505024],
Cell[CellGroupData[{
Cell[5988, 203, 263, 7, 70, "Input",
 CellID->143352300],
Cell[6254, 212, 2491, 43, 70, "NotebookImage",
 CellID->126165646]
}, Open  ]],
Cell[CellGroupData[{
Cell[8782, 260, 224, 6, 70, "Input",
 CellID->22392881],
Cell[9009, 268, 2495, 43, 70, "NotebookImage",
 CellID->181301728]
}, Open  ]],
Cell[11519, 314, 94, 1, 70, "ExampleText",
 CellID->357919445],
Cell[CellGroupData[{
Cell[11638, 319, 148, 4, 70, "Input",
 CellID->745101360],
Cell[11789, 325, 229, 7, 36, "Output",
 CellID->82142000]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12067, 338, 220, 7, 70, "ExampleSection",
 CellID->249552558],
Cell[12290, 347, 78, 1, 70, "ExampleText",
 CellID->127391306],
Cell[CellGroupData[{
Cell[12393, 352, 339, 10, 70, "Input",
 CellID->184945382],
Cell[12735, 364, 2920, 50, 70, "NotebookImage",
 CellID->26290247]
}, Open  ]],
Cell[CellGroupData[{
Cell[15692, 419, 192, 6, 70, "Input",
 CellID->790134791],
Cell[15887, 427, 3413, 58, 70, "NotebookImage",
 CellID->544643683]
}, Open  ]],
Cell[19315, 488, 123, 3, 70, "ExampleDelimiter",
 CellID->5951544],
Cell[19441, 493, 79, 1, 70, "ExampleText",
 CellID->256739825],
Cell[19523, 496, 421, 15, 70, "Input",
 CellID->1583196],
Cell[19947, 513, 156, 4, 70, "Input",
 CellID->283765201],
Cell[CellGroupData[{
Cell[20128, 521, 215, 6, 70, "Input",
 CellID->5142512],
Cell[20346, 529, 6077, 102, 70, "NotebookImage",
 CellID->552783720]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26472, 637, 237, 7, 70, "ExampleSection",
 CellID->381057107],
Cell[26712, 646, 266, 8, 70, "ExampleText",
 CellID->193858769],
Cell[CellGroupData[{
Cell[27003, 658, 300, 9, 70, "Input",
 CellID->263704306],
Cell[27306, 669, 2851, 49, 70, "NotebookImage",
 CellID->5136100]
}, Open  ]],
Cell[CellGroupData[{
Cell[30194, 723, 108, 3, 70, "Input",
 CellID->45638300],
Cell[30305, 728, 271, 9, 36, "Output",
 CellID->369104019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30625, 743, 230, 7, 70, "ExampleSection",
 CellID->317963956],
Cell[30858, 752, 119, 3, 70, "ExampleText",
 CellID->47912622],
Cell[30980, 757, 300, 9, 70, "Input",
 CellID->327316596],
Cell[CellGroupData[{
Cell[31305, 770, 229, 6, 70, "Input",
 CellID->243485107],
Cell[31537, 778, 2941, 50, 70, "NotebookImage",
 CellID->397555708]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34539, 835, 310, 9, 70, "SeeAlsoSection",
 CellID->3808],
Cell[34852, 846, 469, 17, 70, "SeeAlso",
 CellID->31894]
}, Open  ]],
Cell[CellGroupData[{
Cell[35358, 868, 314, 9, 70, "TutorialsSection",
 CellID->10507],
Cell[35675, 879, 186, 4, 70, "Tutorials",
 CellID->29206]
}, Open  ]],
Cell[CellGroupData[{
Cell[35898, 888, 299, 8, 70, "MoreAboutSection"],
Cell[36200, 898, 169, 3, 70, "MoreAbout",
 CellID->317067250],
Cell[36372, 903, 209, 5, 70, "MoreAbout",
 CellID->148689539]
}, Open  ]],
Cell[36596, 911, 27, 0, 70, "History"],
Cell[36626, 913, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

