(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43241,       1140]
NotebookOptionsPosition[     37984,        965]
NotebookOutlinePosition[     39769,       1014]
CellTagsIndexPosition[     39651,       1008]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookApply" :> 
          Documentation`HelpLookup["paclet:ref/NotebookApply"], 
          "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], 
          "NotebookDelete" :> 
          Documentation`HelpLookup["paclet:ref/NotebookDelete"], 
          "SelectionMove" :> 
          Documentation`HelpLookup["paclet:ref/SelectionMove"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookApply\"\>", 
       2->"\<\"NotebookRead\"\>", 3->"\<\"NotebookDelete\"\>", 
       4->"\<\"SelectionMove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Low-Level Interface Control\"\>", 
       3->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NotebookWrite", "ObjectName",
 CellID->6152],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookWrite"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes data into a notebook at the current selection, \
setting the current selection to be just after the data written. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NotebookWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NotebookWrite"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["data", "TI"], ",", 
        StyleBox["sel", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes data into a notebook setting the current \
selection to be as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12561],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " does essentially the same as a ",
 StyleBox["Paste", "SR"],
 " operation in the front end: it replaces whatever the current selection in \
the notebook is by ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21568],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " is the basic way to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel to modify the contents of notebooks that are being manipulated by \
the front end. "
}], "Notes",
 CellID->13213],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " automatically wraps ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " around the ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " you specify if this is necessary. "
}], "Notes",
 CellID->17970],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->6689],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "After", Cell["\<\
place the current selection immediately after the data written \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "make the current selection be the data written ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Before", Cell["\<\
place the current selection immediately before the data written \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "leave the current selection unchanged ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Placeholder", Cell["\<\
make the current selection be the first placeholder in the data written \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->25149],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["After"], "InlineFormula"],
 ", so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " can be called repeatedly to insert several pieces of data in sequence. "
}], "Notes",
 CellID->18781]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216769979],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->673167434],

Cell["Create an empty notebook and write a cell:", "ExampleText",
 CellID->479496592],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1540578200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\<New content\>\"", ",", "\"\<Subsection\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->644507021],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtzU9cZht3pfSd/oX+lh0vCtJObtjMNZopx2slk2uldmV5kStIG0ikB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   "], {{0, 0}, {458, 97}}, {0, 255}],
  ImageSize->{458 0.75, 97 0.75},
  PlotRange->{{0, 458}, {0, 97}}]], "NotebookImage",
 CellID->119068258]
}, Open  ]],

Cell["Write another cell and select it:", "ExampleText",
 CellID->1195084199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\<Next cell\>\"", ",", "\"\<Subsection\>\""}], "]"}], ",", 
   "All"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->315237797],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtzU9cZhtXpfSd/oX+lh7s6TNvctJ1pMFOM004m007v6ulFJiRtIJ0Q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   "], {{0, 0}, {458, 101}}, {0, 255}],
  ImageSize->{458 0.75, 101 0.75},
  PlotRange->{{0, 458}, {0, 101}}]], "NotebookImage",
 CellID->98911563]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7997],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoScroll",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9387],

Cell["First create an empty sample notebook to operate on:", "ExampleText",
 CellID->365582202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389354947],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmtlPnNcZh6l67ZJ/oX9F1GA1SbEi9aaRKi9KbAFDWWyjpKpvY6VtiuMF
TEowDGCWmDUGJyyOMYayhGWYGTA7ZgYDbmfGVsBLbCtYdoF+PefbZmFcmsBR
o+p59PjTed/znjPf1U8D5ufpv/9t+k8TEhJ+Lf55f5KQINdZWR8iIqIK1zc2
ERFxF7XT9fPL3YiIuCvGpOv//Cs0IuL/gXHTVQMAgB2QZf2ulXQFANhFSFcA
ABWQrgAAKiBdAQBUQLoCAKiAdAUAUAHpCgCgAtIVAEAFpCsAgApIVwAAFZCu
AAAqIF0BAFRAugIAqIB0BQBQAekKAKAC0hUAQAWkKwCACkhXAAAVkK4AACog
XQEAVEC6AgCogHQFAFAB6QoAoALSFQBABaQrAIAKSFcAABWQrgAAKiBdAQBU
QLoCAKiAdAUAUAHpCgCgAtIVAEAFpCsAgApIVwAAFZCuAAAqIF0BAFRAugIA
qIB0BQBQAekKAKAC0hUAQAWkKwCACkhXAAAVvCxdEwAAYAfw3RUAQAWkKwCA
CkhXAAAVRKZrznt5S4t/b7vqPpdXh4iIO3T9n+su9/wfThRmvXdepKvQ719G
RMQdGpmufl9Q0zY3NzcQEXEn/mtzIzJdb80F1tc31p49Fz7TNddr4vnCLtfW
zAHRtIftdaTPKCkpKX+k5ffOtNKKy5X7f9XwdnL92/u2KvpiV8wYB58/f7G2
9sJO1+mpO0+erj14+OTBw8f684m1fhy7fhQ5YM/bzafRu5SUlJQ/qvKHZFr7
/t9sFF3QPqvRqqri+FmN2BUzxsGHj+QRO10nJhbvffMwELofCK4Egq3HEhN/
9sorwj2Jb+W7VwKh1cCV92WZ0yrWTTly91jzaiC4OlLwljX5flN45v7I+Xj9
4GrAXZhsXS5MLhgPhCby94U75s0hebl8ylcSz/ArRc2YuzHDlJSUlC8pRcSF
9EwzDK5YfUtza0Wesm64ne3QOq5pLU0vteOamDHOBu/eD4Ye2Ok6OraweOee
/3bQf7s5MzFxT2JOnb7OMtchf32OTMjsZv9CsC5bBl1mvT18XB+OmAlfElgQ
W3a//riet8blQrnbd2afaL5xxi3KiJvNXX/YwIJxT/L5vri7lJSUlNuV1iIU
bi5El3IdiJiRNyxkObT2Nq250fyjK7EwtMv2NjGjHwktLIZuL92z09Xt8c3M
3ZmaWZqqPioTLKNxUqxnliozZNylVy9NWn3RrLKaUzON6TJFj1bpwxEzZr9S
79t3duYmi8XruYPicsPI2yaj18bulDU5ad/zxtnOuLuUlJSU/105Fb3e4nLk
KbGITVfBlYi1la7GqenZpdlb/7DTVSxGx33em/Oei5kywRy17lGfZ2ze6ZBx
l1ru85ZnGX3PmK/UbM57RmtTZYpmOUfnxbCnXD+bJmZqU2Q/s1Q0R62+o7b9
j29G/nRvDFsfMe8VH5cm1ynl5hH9i+6bJ7+Sl4tdT5l+zy9PtRml/qHuMWuX
kpKScrvSO+YTeqynR/Z9sq8nnjHsuekzF9YNC1lpWnuL1lQvjaGhWquv0r68
LNLVY9x50zc+uWin67Brbsg1Mygs+Z1MsJTqweGZAdd0UYqMuyPFop8h+3tz
m4dnws3h6iMyRTOKhsV6esCYSakK912yP1icYd7ZkpuUmJj0QdeANZz0QWd4
12XfPD1gvIw4K15j2CqL9Xfb+5fmuLuUlJSU25dmR6zDHbNvOmCN2Tf4M1Jl
rtZc1GrKtUtl4WitKtEqL2gXPxUB689MtY5Mu72+vq+njHQdcs319k9IC9Nl
gh2pkOuvxz85LOPu3cKJnkKH7Ce9/pr+v0t7kv7c2D9h7FpfMh2fGGcPV7ys
3yPvd4S35CXjvdH36B83LiblsL4rnmZpvsOfGuPuUlJSUm5fmp0esx9lxHzU
DTJd6yq1skKttDD2u2vRee3TfK2yTKSrfc+Qa/arDreRroPDs51dnhvd3hsF
aTLB3imV625v/jsy9w4WjN7oHpWdLm9n96jwRpcsO7vLDsrvqGn5clj05a5+
sPSQ3s8zSutOazdmOFwaH3eoYOtu6UH7zxhe+7Am3llKSkrKbcvOcD9upsld
cyviBn9mmlZVtvHXPDtTXxSE18/OntacxQuZafpZb2eXt39g8vOmXjNdh2av
driuXXdfO5cqE+yQU66vu88ekpl24JzbKLfoPCBTNPWsXI9Un9grhl890RrR
H4m+cyT6eGwZ/XFbhi+dfFVc+4uT1XF3KSkpKb9f+Z8dsZ/y967O4qenPzbi
9LszHz/VNcpvT53Sii+IGftsT994RdVVK13nWtpG2q66lXhaT9cDzm0nTx2Q
6br/tJrXQET8QS4ddWglJQ8++ujbU7lbFX3NWbKUnWYMt7a7u/42UVjUZKbr
4K0rzUNffuFCRMQYx4+9q5U7NaewJI4lJVp5xdjxFGP4iyuu6x3j5/LqjHTt
75+pudTTUNeHiIgxllZcnsg8vHwsfTHbsdXlo47xbIeYMYbra3tbW9ykKyLi
7kq6IiKqkHRFRFRhTLoODM7U1fQ0NvQhIuJObKjvbW8Lp2sw9GhpeXVpeQUR
EXfo3buP7XRFRMTdVaTrvwGPgOfB
   "], {{0, 0}, {458, 73}}, {0, 255}],
  ImageSize->{458 0.75, 73 0.75},
  PlotRange->{{0, 458}, {0, 73}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->691456268]
}, Open  ]],

Cell["\<\
Write a tall cell expression to the sample notebook and the scroll position \
remains at the top:\
\>", "ExampleText",
 CellID->1140270267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"BoxData", "[", 
     RowBox[{"ToBoxes", "[", 
      RowBox[{"Column", "[", 
       RowBox[{"Table", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "1", ",", "200"}], "}"}]}], "]"}], "]"}], "]"}], 
     "]"}], "]"}], ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->247373797],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etTVdcZx3E6fW3Jv5C/ItPoNEm1GV7pTMfLJDrAoVy8TJKJc150Ridt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   "], {{0, 0}, {458, 142}}, {0, 255}],
  ImageSize->{458 0.75, 142 0.75},
  PlotRange->{{0, 458}, {0, 142}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->602059745]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17289669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<First.\>\"", ",", " ", "\"\<Text\>\""}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<Second.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555122886],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1TVFUcx3Gafm/6F/pXevg1p8ZfqhkVJ9FqHKem35rpByd7sppMBR8x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   "], {{0, 0}, {458, 94}}, {0, 255}],
  ImageSize->{458 0.75, 94 0.75},
  PlotRange->{{0, 458}, {0, 94}}]], "NotebookImage",
 CellID->613760411]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " to write over a selected part of the document:"
}], "ExampleText",
 CellID->9455241],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\<New first.\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->222787983],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9vlFUex/FuvDf+C/uvqHsrceONmiglS8HdGKLxzsQLI7orqxGBFhCK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   "], {{0, 0}, {458, 94}}, {0, 255}],
  ImageSize->{458 0.75, 94 0.75},
  PlotRange->{{0, 458}, {0, 94}}]], "NotebookImage",
 CellID->712948261]
}, Open  ]],

Cell[TextData[{
 "Or use ",
 Cell[BoxData[
  ButtonBox["NotebookPut",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookPut"]], "InlineFormula"],
 " to replace the full contents:"
}], "ExampleText",
 CellID->33146886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookPut", "[", 
   RowBox[{
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{"Cell", "[", 
       RowBox[{"\"\<Completely new\>\"", ",", "\"\<Text\>\""}], "]"}], "}"}], 
     "]"}], ",", "nb"}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18990937],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etT1FUcx3Ganjf9C/0rXZ7m1PSkmilxErXGcWp61kwPnMzKavIGaopG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   "], {{0, 0}, {458, 94}}, {0, 255}],
  ImageSize->{458 0.75, 94 0.75},
  PlotRange->{{0, 458}, {0, 94}}]], "NotebookImage",
 CellID->125902400]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27934],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookApply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookApply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionMove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionMove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21417]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29711],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->14455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->486602191],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->571065142],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->11549085]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NotebookWrite - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 9.3900278}", "context" -> "System`", 
    "keywords" -> {
     "incremental writing of notebooks", "paste", "pasting", 
      "writing to notebook"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NotebookWrite[notebook, data] writes data into a notebook at the current \
selection, setting the current selection to be just after the data written. \
NotebookWrite[notebook, data, sel] writes data into a notebook setting the \
current selection to be as specified by sel. ", 
    "synonyms" -> {"notebook write"}, "title" -> "NotebookWrite", "type" -> 
    "Symbol", "uri" -> "ref/NotebookWrite"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8362, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->216769979]},
 "Notebook Image"->{
  Cell[17367, 481, 2882, 50, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->691456268],
  Cell[20914, 558, 3894, 67, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->602059745]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39278, 994},
 {"Notebook Image", 39419, 998}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2545, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3168, 88, 50, 1, 70, "ObjectName",
 CellID->6152],
Cell[3221, 91, 1166, 34, 70, "Usage",
 CellID->26848]
}, Open  ]],
Cell[CellGroupData[{
Cell[4424, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4902, 147, 348, 13, 70, "Notes",
 CellID->12561],
Cell[5253, 162, 403, 13, 70, "Notes",
 CellID->21568],
Cell[5659, 177, 351, 11, 70, "Notes",
 CellID->13213],
Cell[6013, 190, 426, 15, 70, "Notes",
 CellID->17970],
Cell[6442, 207, 139, 6, 70, "Notes",
 CellID->6689],
Cell[6584, 215, 1241, 29, 70, "2ColumnTableMod",
 CellID->25149],
Cell[7828, 246, 497, 17, 70, "Notes",
 CellID->18781]
}, Closed]],
Cell[CellGroupData[{
Cell[8362, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216769979],
Cell[CellGroupData[{
Cell[8747, 282, 148, 5, 70, "ExampleSection",
 CellID->673167434],
Cell[8898, 289, 85, 1, 70, "ExampleText",
 CellID->479496592],
Cell[8986, 292, 149, 5, 70, "Input",
 CellID->1540578200],
Cell[CellGroupData[{
Cell[9160, 301, 228, 7, 70, "Input",
 CellID->644507021],
Cell[9391, 310, 3154, 54, 70, "NotebookImage",
 CellID->119068258]
}, Open  ]],
Cell[12560, 367, 77, 1, 70, "ExampleText",
 CellID->1195084199],
Cell[CellGroupData[{
Cell[12662, 372, 239, 7, 70, "Input",
 CellID->315237797],
Cell[12904, 381, 3672, 62, 70, "NotebookImage",
 CellID->98911563]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16625, 449, 217, 7, 70, "ExampleSection",
 CellID->7997],
Cell[CellGroupData[{
Cell[16867, 460, 226, 7, 70, "ExampleSubsection",
 CellID->9387],
Cell[17096, 469, 95, 1, 70, "ExampleText",
 CellID->365582202],
Cell[CellGroupData[{
Cell[17216, 474, 148, 5, 70, "Input",
 CellID->389354947],
Cell[17367, 481, 2882, 50, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->691456268]
}, Open  ]],
Cell[20264, 534, 149, 4, 70, "ExampleText",
 CellID->1140270267],
Cell[CellGroupData[{
Cell[20438, 542, 473, 14, 70, "Input",
 CellID->247373797],
Cell[20914, 558, 3894, 67, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->602059745]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24869, 632, 236, 7, 70, "ExampleSection",
 CellID->17289669],
Cell[CellGroupData[{
Cell[25130, 643, 397, 12, 70, "Input",
 CellID->555122886],
Cell[25530, 657, 2784, 48, 70, "NotebookImage",
 CellID->613760411]
}, Open  ]],
Cell[28329, 708, 241, 8, 70, "ExampleText",
 CellID->9455241],
Cell[CellGroupData[{
Cell[28595, 720, 352, 11, 70, "Input",
 CellID->222787983],
Cell[28950, 733, 2869, 49, 70, "NotebookImage",
 CellID->712948261]
}, Open  ]],
Cell[31834, 785, 224, 8, 70, "ExampleText",
 CellID->33146886],
Cell[CellGroupData[{
Cell[32083, 797, 313, 10, 70, "Input",
 CellID->18990937],
Cell[32399, 809, 2792, 48, 70, "NotebookImage",
 CellID->125902400]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35252, 864, 311, 9, 70, "SeeAlsoSection",
 CellID->27934],
Cell[35566, 875, 981, 35, 70, "SeeAlso",
 CellID->21417]
}, Open  ]],
Cell[CellGroupData[{
Cell[36584, 915, 314, 9, 70, "TutorialsSection",
 CellID->29711],
Cell[36901, 926, 186, 4, 70, "Tutorials",
 CellID->14455]
}, Open  ]],
Cell[CellGroupData[{
Cell[37124, 935, 299, 8, 70, "MoreAboutSection"],
Cell[37426, 945, 149, 3, 70, "MoreAbout",
 CellID->486602191],
Cell[37578, 950, 163, 3, 70, "MoreAbout",
 CellID->571065142],
Cell[37744, 955, 168, 3, 70, "MoreAbout",
 CellID->11549085]
}, Open  ]],
Cell[37927, 961, 27, 0, 70, "History"],
Cell[37957, 963, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

