(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16842,        555]
NotebookOptionsPosition[     14114,        464]
NotebookOutlinePosition[     15347,        500]
CellTagsIndexPosition[     15262,        495]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SelectedNotebook"], 
          "EvaluationNotebook" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationNotebook"], 
          "NotebookDirectory" :> 
          Documentation`HelpLookup["paclet:ref/NotebookDirectory"], 
          "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], "Streams" :> 
          Documentation`HelpLookup["paclet:ref/Streams"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SelectedNotebook\"\>", 
       2->"\<\"EvaluationNotebook\"\>", 3->"\<\"NotebookDirectory\"\>", 
       4->"\<\"NotebookOpen\"\>", 5->"\<\"Streams\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Mathematica Session Information\"\>", 
       3->"\<\"Mathematica Sessions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Notebooks", "ObjectName",
 CellID->21727],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Notebooks",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Notebooks"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of notebooks currently open in the front \
end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24126]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"], "[", "]"}]], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " constructs. "
}], "Notes",
 CellID->13824],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"], "[", 
   StyleBox["fe", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives a list of notebooks open in a specific front end, specified by a ",
 Cell[BoxData["FrontEndObject"], "InlineFormula"],
 ". The default is ",
 Cell[BoxData[
  ButtonBox["$FrontEnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$FrontEnd"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7240]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15410814],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->103692267],

Cell["\<\
Get a list of objects corresponding to all currently open notebooks:\
\>", "ExampleText",
 CellID->37110780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Notebooks", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57056849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["gr5_shm", 1, 1]], 20]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         TagBox[
          TooltipBox["\<\"Basic Math Input\"\>",
           
           "\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0\\\
\\SystemFiles\\\\FrontEnd\\\\Palettes\\\\BasicMathInput.nb\""],
          
          Annotation[#, 
           "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\FrontEnd\\Palettes\\BasicMathInput.\
nb", "Tooltip"]& ]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["gr5_shm", 1, 1]], 20],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["gr5_shm", 1, 1]], 18]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         TagBox[
          TooltipBox["\<\"Notebooks - Wolfram Mathematica\"\>",
           
           "\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0\\\
\\Documentation\\\\English\\\\System\\\\ReferencePages\\\\Symbols\\\\\
Notebooks.nb\""],
          
          Annotation[#, 
           "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ReferencePages\\\
Symbols\\Notebooks.nb", "Tooltip"]& ]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["gr5_shm", 1, 1]], 18],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["gr5_shm", 1, 1]], 21]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         StyleBox["\<\"Untitled-1\"\>",
          StripOnInput->False,
          FontColor->GrayLevel[0.5]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["gr5_shm", 1, 1]], 21],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["gr5_shm", 1, 1]], 9]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         StyleBox["\<\"Messages\"\>",
          StripOnInput->False,
          FontColor->GrayLevel[0.5]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["gr5_shm", 1, 1]], 9],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{437, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495666090]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32479],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1332],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->2515]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->68924375],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->127963942],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->63805543],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->471803659]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 5.2180460}", "context" -> "System`", 
    "keywords" -> {"list notebooks", "open notebooks"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Notebooks[] gives a list of notebooks currently open in the front end. ",
     "synonyms" -> {}, "title" -> "Notebooks", "type" -> "Symbol", "uri" -> 
    "ref/Notebooks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5290, 167, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15410814]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15120, 488}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2709, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3332, 91, 47, 1, 70, "ObjectName",
 CellID->21727],
Cell[3382, 94, 476, 15, 70, "Usage",
 CellID->24126]
}, Open  ]],
Cell[CellGroupData[{
Cell[3895, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4373, 131, 363, 13, 70, "Notes",
 CellID->13824],
Cell[4739, 146, 514, 16, 70, "Notes",
 CellID->7240]
}, Closed]],
Cell[CellGroupData[{
Cell[5290, 167, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15410814],
Cell[CellGroupData[{
Cell[5674, 181, 148, 5, 70, "ExampleSection",
 CellID->103692267],
Cell[5825, 188, 118, 3, 70, "ExampleText",
 CellID->37110780],
Cell[CellGroupData[{
Cell[5968, 195, 99, 3, 28, "Input",
 CellID->57056849],
Cell[6070, 200, 4958, 146, 140, "Output",
 CellID->495666090]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11089, 353, 311, 9, 70, "SeeAlsoSection",
 CellID->32479],
Cell[11403, 364, 1246, 44, 70, "SeeAlso",
 CellID->19707]
}, Open  ]],
Cell[CellGroupData[{
Cell[12686, 413, 313, 9, 70, "TutorialsSection",
 CellID->1332],
Cell[13002, 424, 185, 4, 70, "Tutorials",
 CellID->2515]
}, Open  ]],
Cell[CellGroupData[{
Cell[13224, 433, 318, 9, 70, "MoreAboutSection",
 CellID->68924375],
Cell[13545, 444, 169, 3, 70, "MoreAbout",
 CellID->127963942],
Cell[13717, 449, 171, 3, 70, "MoreAbout",
 CellID->63805543],
Cell[13891, 454, 151, 3, 70, "MoreAbout",
 CellID->471803659]
}, Open  ]],
Cell[14057, 460, 27, 0, 70, "History"],
Cell[14087, 462, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

