(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44119,       1686]
NotebookOptionsPosition[     34873,       1357]
NotebookOutlinePosition[     36213,       1395]
CellTagsIndexPosition[     36127,       1390]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Linear Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLinearSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Solving Linear Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatrixRank" :> 
          Documentation`HelpLookup["paclet:ref/MatrixRank"], "LinearSolve" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolve"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], 
          "SingularValueList" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueList"], 
          "Eigenvalues" :> Documentation`HelpLookup["paclet:ref/Eigenvalues"],
           "Det" :> Documentation`HelpLookup["paclet:ref/Det"], "Inverse" :> 
          Documentation`HelpLookup["paclet:ref/Inverse"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MatrixRank\"\>", 2->"\<\"LinearSolve\"\>", 
       3->"\<\"RowReduce\"\>", 4->"\<\"SingularValueList\"\>", 
       5->"\<\"Eigenvalues\"\>", 6->"\<\"Det\"\>", 
       7->"\<\"Inverse\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:guide/MatricesAndLinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NullSpace", "ObjectName",
 CellID->31497],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NullSpace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NullSpace"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of vectors that forms a basis for the null \
space of the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6735]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NullSpace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NullSpace"]], "InlineFormula"],
 " works on both numerical and symbolic matrices. "
}], "Notes",
 CellID->25227],

Cell["The following options can be given:", "Notes",
 CellID->28444],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[
    "integer modulus to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "numerical tolerance to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ZeroTest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ZeroTest"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
function to test whether matrix elements should be considered to be zero\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->21329],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " finds null spaces for integer matrices modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["ZeroTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZeroTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}], "]"}], "]"}], "]"}]], "InlineFormula"],
 " to determine whether matrix elements are zero. "
}], "Notes",
 CellID->27046],

Cell[TextData[{
 "The possible settings for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option are as for ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13385]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11113789],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->21453604],

Cell["Find the null space of a 3x3 matrix:", "ExampleText",
 CellID->330905980],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91136537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->760011218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8252584]
}, Open  ]],

Cell[TextData[{
 "The action of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " on the vector is the zero vector:"
}], "ExampleText",
 CellID->171097781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->721656437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->525777651]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12429],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3x4 matrix:"
}], "ExampleText",
 CellID->158239293],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", " ", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", " ", "7", ",", " ", "8"}], "}"}], ",", " ", 
     
     RowBox[{"{", 
      RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220698599],

Cell["Use exact arithmetic to find the null space:", "ExampleText",
 CellID->342832297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167559441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83670912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"Transpose", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->375025419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->525600474]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->6113933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->223199983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.45954308268659694`", ",", 
     RowBox[{"-", "0.8348603986881475`"}], ",", "0.2910915493165042`", ",", 
     "0.08422576668504636`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2980271047319345`", ",", 
     RowBox[{"-", "0.05484628248356682`"}], ",", 
     RowBox[{"-", "0.78438874922867`"}], ",", "0.5412079269803022`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{312, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->82546047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"Transpose", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31165213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1102230246251565`*^-16"}], ",", 
     RowBox[{"-", "4.440892098500626`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.220446049250313`*^-16"}], ",", 
     RowBox[{"-", "8.881784197001252`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.440892098500626`*^-16", ",", 
     RowBox[{"-", "8.881784197001252`*^-16"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{462, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->534536612]
}, Open  ]],

Cell["Use 20 digit precision arithmetic:", "ExampleText",
 CellID->541155668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", " ", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->34826461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.11572573064191291809108540006264173741`20.", ",", 
     RowBox[{"-", "0.5533328270443463898967084709218700043`20."}], ",", 
     "0.75948846216295402552016074165613224454`20.", ",", 
     RowBox[{"-", "0.32188136576052055371453767079610131306`20."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.53535740890305741383090470290242384194`20."}], ",", 
     "0.62755301171702733245775577180120778848`20.", ",", 
     "0.35096620327511757657720256511256346169`20.", ",", 
     RowBox[{"-", "0.44316180608908749520405363401105020227`20."}]}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{539, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->230272153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"Transpose", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->146032120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0``19.319811189175233", ",", "0``19.33573332801655"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0``18.92848266690461", ",", "0``18.90503430938792"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0``18.726031403002786", ",", "0``18.693096617596563"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{445, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->549929620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45762239],

Cell["Compute the null space for a complex matrix:", "ExampleText",
 CellID->29216845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", " ", "+", " ", "I"}], ",", " ", 
      RowBox[{"1", " ", "-", " ", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], " ", "+", " ", "I"}], ",", " ", 
      RowBox[{"1", " ", "+", " ", "I"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43891247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[ImaginaryI]", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->894996516]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26094],

Cell["Find the null space symbolically:", "ExampleText",
 CellID->181456730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "b", ",", "a"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237125218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", "+", "c"}], "b"]}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{107, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->618177984]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14677],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15209],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3x3 random matrix of integers between 0 and 4:"
}], "ExampleText",
 CellID->104071873],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266557437],

Cell["Use arithmetic modulo 5 to compute the null space:", "ExampleText",
 CellID->735194580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", 
  RowBox[{"m", ",", " ", 
   RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132358340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->476413726]
}, Open  ]],

Cell["The vector is in the null space modulo 5:", "ExampleText",
 CellID->30872859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"Transpose", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143343947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8048365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"%", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->87302679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "0", "}"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->58398505]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28319],

Cell["m is a 3x3 singular matrix with a nonempty null space:", "ExampleText",
 CellID->229257540],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489283912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ns", " ", "=", " ", 
  RowBox[{"NullSpace", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->332554766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->420700647]
}, Open  ]],

Cell[TextData[{
 "Find a solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x1", "TI"], " "}], TraditionalForm]], "InlineMath"],
 "for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], "=", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->661527754],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"x1", "=", " ", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"m", ",", "b"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->800801555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->349376753]
}, Open  ]],

Cell[TextData[{
 "All solutions are given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x1", "TI"], " ", "+", " ", 
   StyleBox["x0", "TI"]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["x0", "TI"]], "InlineFormula"],
 " is any vector in the null space:"
}], "ExampleText",
 CellID->558930712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "=", " ", 
  RowBox[{"x1", " ", "+", " ", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "[", "i", "]"}], " ", 
      RowBox[{"ns", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", 
       RowBox[{"Length", "[", "ns", "]"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->554346924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"c", "[", "1", "]"}]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", 
     RowBox[{"c", "[", "1", "]"}]}]}], ",", 
   RowBox[{"c", "[", "1", "]"}]}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->51088308]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"m", ".", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->150088414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->49409135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83432088],

Cell["Find a basis for the eigenspace for a particular eigenvalue:", \
"ExampleText",
 CellID->149561348],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"-", "1"}]}], ";"}], "\n", 
 RowBox[{"NullSpace", "[", 
  RowBox[{"m", " ", "-", " ", 
   RowBox[{"v", " ", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->220294907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->669386887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->628128531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84129622]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26589],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 5x5 matrix:"
}], "ExampleText",
 CellID->290026267],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "0"}], "}"}], ",", " ", 
     
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314247429],

Cell[TextData[{
 "The null space of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->75904322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ns", " ", "=", " ", 
  RowBox[{"NullSpace", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25496497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115250364]
}, Open  ]],

Cell[TextData[{
 "Arbitrary linear combinations of the null space of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " give zero:"
}], "ExampleText",
 CellID->172938953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "[", "i", "]"}], " ", 
    RowBox[{"ns", "[", 
     RowBox[{"[", "i", "]"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", 
     RowBox[{"Length", "[", "ns", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86796999],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"c", "[", "1", "]"}]}], "-", 
    RowBox[{"c", "[", "2", "]"}]}], ",", 
   RowBox[{"c", "[", "2", "]"}], ",", 
   RowBox[{"c", "[", "1", "]"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->173289303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "%"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32065007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->199263626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167514363],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3x4 matrix or random zeros and ones:"
}], "ExampleText",
 CellID->14951984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", " ", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42473910],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188455746]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MatrixRank",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixRank"]], "InlineFormula"],
 " equals the column dimension of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " minus the dimension of the null space:"
}], "ExampleText",
 CellID->643281104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ns", " ", "=", " ", 
  RowBox[{"NullSpace", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280701501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27581399]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "-", " ", 
   RowBox[{"Length", "[", "ns", "]"}]}], " ", "\[Equal]", " ", 
  RowBox[{"MatrixRank", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110194190],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->390103307]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13017],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixRank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixRank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23863]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31110],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "Tutorials",
 CellID->14411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5817],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#30506"], None}]], "RelatedLinks",
 CellID->449460589],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#22549"], None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
NullSpace"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->282735770],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->468224074],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->23027044]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NullSpace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 6.0633536}", "context" -> "System`", 
    "keywords" -> {
     "kernel of matrices", "null spaces of matrices", "rank of matrices", 
      "redundant linear equations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NullSpace[m] gives a list of vectors that forms a basis for the null \
space of the matrix m. ", "synonyms" -> {"null space"}, "title" -> 
    "NullSpace", "type" -> "Symbol", "uri" -> "ref/NullSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7531, 246, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->11113789]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35985, 1383}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2554, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3177, 86, 47, 1, 70, "ObjectName",
 CellID->31497],
Cell[3227, 89, 597, 19, 70, "Usage",
 CellID->6735]
}, Open  ]],
Cell[CellGroupData[{
Cell[3861, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4339, 130, 217, 7, 70, "Notes",
 CellID->25227],
Cell[4559, 139, 68, 1, 70, "Notes",
 CellID->28444],
Cell[4630, 142, 1329, 37, 70, "3ColumnTableMod",
 CellID->21329],
Cell[5962, 181, 491, 18, 70, "Notes",
 CellID->7146],
Cell[6456, 201, 686, 25, 70, "Notes",
 CellID->27046],
Cell[7145, 228, 349, 13, 70, "Notes",
 CellID->13385]
}, Closed]],
Cell[CellGroupData[{
Cell[7531, 246, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->11113789],
Cell[CellGroupData[{
Cell[7915, 260, 147, 5, 70, "ExampleSection",
 CellID->21453604],
Cell[8065, 267, 79, 1, 70, "ExampleText",
 CellID->330905980],
Cell[8147, 270, 367, 12, 70, "Input",
 CellID->91136537],
Cell[CellGroupData[{
Cell[8539, 286, 105, 3, 28, "Input",
 CellID->760011218],
Cell[8647, 291, 255, 9, 36, "Output",
 CellID->8252584]
}, Open  ]],
Cell[8917, 303, 168, 6, 70, "ExampleText",
 CellID->171097781],
Cell[CellGroupData[{
Cell[9110, 313, 169, 6, 70, "Input",
 CellID->721656437],
Cell[9282, 321, 213, 7, 36, "Output",
 CellID->525777651]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9544, 334, 216, 7, 70, "ExampleSection",
 CellID->12429],
Cell[9763, 343, 132, 5, 70, "ExampleText",
 CellID->158239293],
Cell[9898, 350, 430, 14, 70, "Input",
 CellID->220698599],
Cell[10331, 366, 87, 1, 70, "ExampleText",
 CellID->342832297],
Cell[CellGroupData[{
Cell[10443, 371, 105, 3, 70, "Input",
 CellID->167559441],
Cell[10551, 376, 383, 13, 36, "Output",
 CellID->83670912]
}, Open  ]],
Cell[CellGroupData[{
Cell[10971, 394, 128, 4, 70, "Input",
 CellID->375025419],
Cell[11102, 400, 361, 13, 36, "Output",
 CellID->525600474]
}, Open  ]],
Cell[11478, 416, 64, 1, 70, "ExampleText",
 CellID->6113933],
Cell[CellGroupData[{
Cell[11567, 421, 133, 4, 70, "Input",
 CellID->223199983],
Cell[11703, 427, 560, 16, 54, "Output",
 CellID->82546047]
}, Open  ]],
Cell[CellGroupData[{
Cell[12300, 448, 127, 4, 70, "Input",
 CellID->31165213],
Cell[12430, 454, 599, 18, 58, "Output",
 CellID->534536612]
}, Open  ]],
Cell[13044, 475, 77, 1, 70, "ExampleText",
 CellID->541155668],
Cell[CellGroupData[{
Cell[13146, 480, 162, 5, 70, "Input",
 CellID->34826461],
Cell[13311, 487, 794, 20, 71, "Output",
 CellID->230272153]
}, Open  ]],
Cell[CellGroupData[{
Cell[14142, 512, 128, 4, 70, "Input",
 CellID->146032120],
Cell[14273, 518, 489, 16, 39, "Output",
 CellID->549929620]
}, Open  ]],
Cell[14777, 537, 124, 3, 70, "ExampleDelimiter",
 CellID->45762239],
Cell[14904, 542, 86, 1, 70, "ExampleText",
 CellID->29216845],
Cell[CellGroupData[{
Cell[15015, 547, 434, 14, 70, "Input",
 CellID->43891247],
Cell[15452, 563, 239, 8, 36, "Output",
 CellID->894996516]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15740, 577, 239, 7, 70, "ExampleSection",
 CellID->26094],
Cell[15982, 586, 76, 1, 70, "ExampleText",
 CellID->181456730],
Cell[CellGroupData[{
Cell[16083, 591, 274, 9, 70, "Input",
 CellID->237125218],
Cell[16360, 602, 309, 11, 49, "Output",
 CellID->618177984]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16718, 619, 218, 7, 70, "ExampleSection",
 CellID->14677],
Cell[CellGroupData[{
Cell[16961, 630, 224, 7, 70, "ExampleSubsection",
 CellID->15209],
Cell[17188, 639, 167, 5, 70, "ExampleText",
 CellID->104071873],
Cell[17358, 646, 368, 12, 70, "Input",
 CellID->266557437],
Cell[17729, 660, 93, 1, 70, "ExampleText",
 CellID->735194580],
Cell[CellGroupData[{
Cell[17847, 665, 169, 5, 70, "Input",
 CellID->132358340],
Cell[18019, 672, 237, 8, 36, "Output",
 CellID->476413726]
}, Open  ]],
Cell[18271, 683, 83, 1, 70, "ExampleText",
 CellID->30872859],
Cell[CellGroupData[{
Cell[18379, 688, 128, 4, 70, "Input",
 CellID->143343947],
Cell[18510, 694, 284, 10, 36, "Output",
 CellID->8048365]
}, Open  ]],
Cell[CellGroupData[{
Cell[18831, 709, 121, 4, 70, "Input",
 CellID->87302679],
Cell[18955, 715, 285, 10, 36, "Output",
 CellID->58398505]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19301, 732, 223, 7, 70, "ExampleSection",
 CellID->28319],
Cell[19527, 741, 97, 1, 70, "ExampleText",
 CellID->229257540],
Cell[19627, 744, 368, 12, 70, "Input",
 CellID->489283912],
Cell[CellGroupData[{
Cell[20020, 760, 139, 4, 70, "Input",
 CellID->332554766],
Cell[20162, 766, 257, 9, 36, "Output",
 CellID->420700647]
}, Open  ]],
Cell[20434, 778, 341, 15, 70, "ExampleText",
 CellID->661527754],
Cell[CellGroupData[{
Cell[20800, 797, 282, 9, 70, "Input",
 CellID->800801555],
Cell[21085, 808, 232, 8, 36, "Output",
 CellID->349376753]
}, Open  ]],
Cell[21332, 819, 306, 11, 70, "ExampleText",
 CellID->558930712],
Cell[CellGroupData[{
Cell[21663, 834, 413, 13, 70, "Input",
 CellID->554346924],
Cell[22079, 849, 396, 14, 36, "Output",
 CellID->51088308]
}, Open  ]],
Cell[CellGroupData[{
Cell[22512, 868, 127, 4, 70, "Input",
 CellID->150088414],
Cell[22642, 874, 212, 7, 36, "Output",
 CellID->49409135]
}, Open  ]],
Cell[22869, 884, 124, 3, 70, "ExampleDelimiter",
 CellID->83432088],
Cell[22996, 889, 105, 2, 70, "ExampleText",
 CellID->149561348],
Cell[CellGroupData[{
Cell[23126, 895, 596, 19, 70, "Input",
 CellID->220294907],
Cell[23725, 916, 257, 9, 36, "Output",
 CellID->669386887]
}, Open  ]],
Cell[CellGroupData[{
Cell[24019, 930, 347, 11, 70, "Input",
 CellID->628128531],
Cell[24369, 943, 575, 20, 36, "Output",
 CellID->84129622]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24993, 969, 233, 7, 70, "ExampleSection",
 CellID->26589],
Cell[25229, 978, 132, 5, 70, "ExampleText",
 CellID->290026267],
Cell[25364, 985, 628, 18, 70, "Input",
 CellID->314247429],
Cell[25995, 1005, 138, 6, 70, "ExampleText",
 CellID->75904322],
Cell[CellGroupData[{
Cell[26158, 1015, 138, 4, 70, "Input",
 CellID->25496497],
Cell[26299, 1021, 407, 14, 36, "Output",
 CellID->115250364]
}, Open  ]],
Cell[26721, 1038, 182, 6, 70, "ExampleText",
 CellID->172938953],
Cell[CellGroupData[{
Cell[26928, 1048, 328, 11, 70, "Input",
 CellID->86796999],
Cell[27259, 1061, 397, 13, 36, "Output",
 CellID->173289303]
}, Open  ]],
Cell[CellGroupData[{
Cell[27693, 1079, 91, 3, 70, "Input",
 CellID->32065007],
Cell[27787, 1084, 233, 7, 36, "Output",
 CellID->199263626]
}, Open  ]],
Cell[28035, 1094, 125, 3, 70, "ExampleDelimiter",
 CellID->167514363],
Cell[28163, 1099, 156, 5, 70, "ExampleText",
 CellID->14951984],
Cell[CellGroupData[{
Cell[28344, 1108, 221, 7, 70, "Input",
 CellID->42473910],
Cell[28568, 1117, 421, 13, 36, "Output",
 CellID->188455746]
}, Open  ]],
Cell[29004, 1133, 323, 11, 70, "ExampleText",
 CellID->643281104],
Cell[CellGroupData[{
Cell[29352, 1148, 139, 4, 70, "Input",
 CellID->280701501],
Cell[29494, 1154, 362, 12, 36, "Output",
 CellID->27581399]
}, Open  ]],
Cell[CellGroupData[{
Cell[29893, 1171, 214, 6, 70, "Input",
 CellID->110194190],
Cell[30110, 1179, 161, 5, 36, "Output",
 CellID->390103307]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30332, 1191, 311, 9, 70, "SeeAlsoSection",
 CellID->13017],
Cell[30646, 1202, 1700, 62, 70, "SeeAlso",
 CellID->23863]
}, Open  ]],
Cell[CellGroupData[{
Cell[32383, 1269, 314, 9, 70, "TutorialsSection",
 CellID->31110],
Cell[32700, 1280, 153, 3, 70, "Tutorials",
 CellID->14411]
}, Open  ]],
Cell[CellGroupData[{
Cell[32890, 1288, 320, 9, 70, "RelatedLinksSection",
 CellID->5817],
Cell[33213, 1299, 271, 6, 70, "RelatedLinks",
 CellID->449460589],
Cell[33487, 1307, 238, 4, 70, "RelatedLinks"],
Cell[33728, 1313, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34152, 1331, 319, 9, 70, "MoreAboutSection",
 CellID->282735770],
Cell[34474, 1342, 139, 3, 70, "MoreAbout",
 CellID->468224074],
Cell[34616, 1347, 162, 3, 70, "MoreAbout",
 CellID->23027044]
}, Open  ]],
Cell[34793, 1353, 50, 0, 70, "History"],
Cell[34846, 1355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

