(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39153,       1338]
NotebookOptionsPosition[     32789,       1120]
NotebookOutlinePosition[     34222,       1159]
CellTagsIndexPosition[     34136,       1154]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlgebraicUnitQ" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicUnitQ"], 
          "NumberFieldRootsOfUnity" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRootsOfUnity"], 
          "NumberFieldIntegralBasis" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldIntegralBasis"], 
          "NumberFieldNormRepresentatives" :> 
          Documentation`HelpLookup[
           "paclet:ref/NumberFieldNormRepresentatives"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AlgebraicUnitQ\"\>", 
       2->"\<\"NumberFieldRootsOfUnity\"\>", 
       3->"\<\"NumberFieldIntegralBasis\"\>", 
       4->"\<\"NumberFieldNormRepresentatives\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldFundamentalUnits", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldFundamentalUnits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldFundamentalUnits"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of fundamental units for the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"],
     " generated by the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldFundamentalUnits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldFundamentalUnits"]], "InlineFormula"],
 " gives a list of algebraic integers that serve as multiplicative generators \
of the units in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The list of fundamental units produced by ",
 Cell[BoxData[
  ButtonBox["NumberFieldFundamentalUnits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldFundamentalUnits"]], "InlineFormula"],
 " may not be unique."
}], "Notes",
 CellID->22646481]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104456234],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->128505943],

Cell[TextData[{
 "Find generators of the group of units for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1041480569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86851463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["9", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["9", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{415, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->720732506]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->193536283],

Cell["Radical objects:", "ExampleText",
 CellID->1942146018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2044173773],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    SqrtBox["2"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{212, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1543459262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1485324216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1494185584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", 
       RowBox[{"#1", "^", "3"}]}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1419282844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{335, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1464844321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1461772365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->795216875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103342270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "20"}], "+", 
        RowBox[{"21", " ", "#1"}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      FractionBox["7", "4"], ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{440, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->885973839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1055270411],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldFundamentalUnits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldFundamentalUnits"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->1734332986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"I", " ", 
       RowBox[{"Pi", "/", "4"}]}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316732129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      SqrtBox["2"], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}]}], "]"}], "}"}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{566, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2058187422]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->148592117],

Cell[TextData[{
 "Table of fundamental units of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    SqrtBox["d"], "]"}], TraditionalForm]], "InlineMath"],
 "for positive square-free ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1311353095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"RootReduce", "[", 
      RowBox[{"NumberFieldFundamentalUnits", "[", 
       RowBox[{"Sqrt", "[", "d", "]"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"2", ",", "13"}], "]"}], ",", "SquareFreeQ"}], "]"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->539061929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", "+", 
       SqrtBox["2"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"2", "+", 
       SqrtBox["3"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["5"]}], ")"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{"5", "+", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"{", 
      RowBox[{"8", "+", 
       RowBox[{"3", " ", 
        SqrtBox["7"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{"3", "+", 
       SqrtBox["10"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", 
     RowBox[{"{", 
      RowBox[{"10", "+", 
       RowBox[{"3", " ", 
        SqrtBox["11"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         SqrtBox["13"]}], ")"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289415678]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->865652129],

Cell["Fundamental units are algebraic units:", "ExampleText",
 CellID->1650918245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", 
       RowBox[{"#1", "^", "5"}]}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1494224475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "8"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "8"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{398, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158839691]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", " ", "/@", " ", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1855596320],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->296513416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538353034],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " to find the fundamental units for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["3"], ",", 
     SqrtBox["7"]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1817100637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"primitive", "=", 
  RowBox[{
   RowBox[{"ToNumberField", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "3", "]"}], ",", 
       RowBox[{"Sqrt", "[", "7", "]"}]}], "}"}], ",", " ", "All"}], "]"}], 
   "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40168031],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "-", 
     RowBox[{"20", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{170, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1338921672]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", "primitive", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1307670376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"20", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["5", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "8"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"20", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "8"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"20", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "8"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{414, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1922888038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1033151638],

Cell[TextData[{
 "The number of fundamental units can be obtained from ",
 Cell[BoxData[
  ButtonBox["NumberFieldSignature",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldSignature"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1491900675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"primitive", "=", 
  RowBox[{
   RowBox[{"ToNumberField", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sqrt", "[", "3", "]"}], ",", 
       RowBox[{"Sqrt", "[", "7", "]"}]}], "}"}], ",", " ", "All"}], "]"}], 
   "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268425937],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "-", 
     RowBox[{"20", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{170, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497850963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s", ",", "t"}], "}"}], "=", 
  RowBox[{"NumberFieldSignature", "[", "primitive", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224838080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->784846429]
}, Open  ]],

Cell["The number of fundamental units:", "ExampleText",
 CellID->63696586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "+", "t", "-", "1"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->584289946],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1069372329]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"NumberFieldFundamentalUnits", "[", "primitive", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->608803658],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->650091760]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", 
       RowBox[{"First", "@", 
        RowBox[{"NumberFieldFundamentalUnits", "[", 
         RowBox[{"Sqrt", "[", "d", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"2", ",", "200"}], "]"}], ",", "SquareFreeQ"}], "]"}]}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111311366],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXGuQFFcVbmZ2dofsJhBDgGDU/LFKrcovf/ioSvGK+kNRITzU0rIotMIC
C1ZCEkkQU4Q8NEGMBuPurElINoCSAAsEBAwkJCFsJCxLoPKwsIpQZNcCqkQK
IyKO3+2v+9w7t3t6uufBLtamyOztO7fPPef77jn3nNu9O2nmwtk/bJm5sHnW
zBu+ctvMH81unnX7DV9ecBu60kMcx9mC/1tGO2jn0XL/35LP46f5+Tl8pvFV
Gj9T+Hm9d53yrv3+67x+p869zfvP/3Y0ftaF3JV2B39RfaqbvVtTxrVqjlEf
dfq6cETYHaOs63SJ8SPVR0a+DxnlXyvghqifA0TzUbFmGGhaj474Plznz3sr
JhXQ7frytNV3FJU8piwt/XUkYqqFb0BuOiDHHVdv9sRdE18wUPD93PZU389T
npub468rMp4eHowr5gpQzVbdqyy6ePG/Z8+ex2fq3Ll/u5NduHARTelBAz0f
fnjB7/koxuBSRqJ9/vx/gg2IxSeGoYcNSECDoigTX6HhpNB058a1NTdHKBvR
SqHDyVJfGSoiTX05m9tzhagZ1FfJVXMPDVWTPdSuiVZTHTRECd5D6a5+Gaol
+vH+jHQROMcdm+YQd5TStUFGia6KKFdCvQkuxqGRdbm8Fp+toLJeM/sxXJ46
ee6tnt5ptzw79qbWmyfklHjH6enpPX36n4cO9bLR2/uPd985iX6M7DnYi1uP
v/93jEQ/Ot977yQaBw58wMbevcecFL53JnbtO46fGI172MBojDh69DSFHjny
t4MHPlDz+QPQeKunr6/3LOZGP5XASNj55v4TmF40PnUKn31o9PWdRSdlmhpz
OmrMW9AIamyqJw3Yhga+pcJOSjUVt6bGmB5yeQ/0gwbK/86c+ZeTgR5QQjQm
HhlRmSBz7AiMxU/86z5wAsKCOtMQC2VanS3kMtf6BlhcePvW5tkb21u7yFAo
l6Zw4VKEB7kcEZNLAcTkMqXIvDHIJWYNcikyLS5FY5NLS+NoLru7T4RwSY2D
XGJokEsoGsKlK1WNbbK4DOqsIomav97iEjItLumRX5rYznuFy1yb4vjuRdur
ySU0HuSydlw+9OBL4Kxl3iaLS4m6g1xeNlzOmLba9MunntxPd9z72jFE3bbW
LuGS0RhfkUuOXPTj7YNcDhQuu/a9v2D+5m1b3+G906d67gjtfvv4PrQfuH83
uSTr+IpcyshkXJpCB7msLpesW57t6AbC9yzavuflv85v2bTqqf3QbuqUDnRO
GJfD55LFO8H67Fs3wFM5GOkSFgG8MxmXFHrzhPZEXD7z9AHqJ1xyP0fPIJcu
lyOFS/E5VkPQC9r9cdu7c5o7v/61VaY7QriEZX+WDIQ//PM96MS/O+/YFsUl
hGIJrH/+cCIuTf2sKuqy4fIaWX7kEiOf+N2f0fPgAy9FU+mU5lKdNzgj0IDH
fWvGGkj92UMvC5OcjSH4ySf2C5Pomd+igrLJ5ORvPEMmJ47PldgtpWEx6YeG
HUEmMeWcZq9ioo0IH+y5fJg0S3hiKyVExUw6TeZZl/gaIYWXcT6e2GG3FC7d
06Yshy35yU4MW7umZ+b3133vu79H/C2PR3G7II9CCiBg9oUFx54IHiVPi8Mj
bVl674s141EtPaN8p49gw0J4qjKPkv4Q0onuBgnHL8LjJEGe1QvPz2jZb1a+
LrDE5BGzz5u7qb31jdbHu5Rj3r09lEcr3xYerToYt0hSFodH35b2WDwuf1ht
JD+Y9TyNjMNjVmIJE3/gCon+PUNj8Sj717L7dhXyaJzUug94MuSS+yLAcopx
iHGoQ59e9WaQw1smdwgk0RzSY8QJsMSnTtGVbJBDLuDOjUcsDq36l0uSuVkc
Dt0V1Lm6ozsWh9xCxt3URiOTcci1xfQiGYeyc2HOohy6Z7Jpd+fbBH8kexmy
R9da/sgrPLv/LBT/9a9e49onfVydC1o2Y8siGtH0TfPIahf6du74y9w5nbm2
rlD68v5ZhEUfSl6SRfqo9SiuNgGDNQ+Df3BPJG2x+Fu7ugezrXxsL6IGrEzG
H4IqQ11i/mTDwvIV/hry4U9dM97PJoM/upXySZe/Bijue1qO/GGJOCl0OJ+5
f9nuOHsh6ZKFzy0GAwhCBIF0XEQTEsgsTPbCUP78OidXKX/WPayE7lu6K4K/
OuEPDRe9Ju6IshEG9+68UWVIgOOU5M79TPS0z75uNNh9YfPbWI/KZ8U7sVC+
7Wa7CN9MF8aPzUkAiLNBmqha5C5/ZA+jQZBccWsh1zxv0N7JcIGUH3qwnOJ2
UE12ZXutiF3fotwlZ1fvnBBe5zMLVCUd8Swcn0OxwtAgkRjssIhCIz6z3Cgg
WTJXUQD+jtDO+pTMmqcPmlmKAF7cNyGUIbIks4/+8lU6o2Z2xS9eQRcCknUP
E421aw5WxCwtQtlXa2bVZRFGP01GJQuWhonPlG96rEgGYDHK7A5MswHAhNEN
6w+zkpVCTBRwUrjVycr5Lk82ENRJsjCKTQ86IdInZZR6Y4GQ0aGuKd6ase4h
bllhyKK0CKMZi1FalHl0xasSXAr20UvrrWlym/dzq9ECz/rnDlt001cX37OD
hIqHT5/qxTDBBBLd+evlgQ7jO3yV1pt8ysnYJxnj834iLo1EhCLGwGPuumMr
syn0o6d59sZFd22zCtKq8umvo9zA4rNO0MFQlXU5w+igE8a10QtNtwZw6/5w
yKSR89Zb0RyN0jyScnmsU4xH2QokQFBlHkFIVpV3j8P6es9aSXk4j3Jal5hH
LnsGktI8qvw27O2hTLXYUvUqkyQvSrnvLylN64LeFozQESx9iixZD2zIBjIh
iyXZdCW8mywhJKMgQ3YkLGHfmjF9tUVsXtcUaj+UqrZgP5RdPYols14vzZJd
RV7hSub6bL51A6dzSjPCHiI2bmwbXCWcjazfG4m8daIrCFvIm3GYu6SJfK/7
2IsaE3nMy4AskbmwGlfI7951lKe2BcjTszA6OfJMoJHHx0LeQ9A9YVD1Xlzk
iRhghyYaeW5LXLIlkB8uOwzF0hLmDi9sedtC3vfBMSUBD02NegufEsgTScEb
PoJ9CYOT482wSGJL402tVj62l7rFwNvHUaPsHxq2l4sy9ZdqNoByY0mU3Wjr
x3nrtR8f1zTjvKtyYlSZWZqJbTiq15SBHzgA2c+tO1QZflIvVoofQgAXXzR+
dj2CLxigEc5FKYm+GEatK0fPScs83FV9lSSJ0CjSx3665E9xUZTarFIU5WAi
MYoSbGuMouzXJVGUTMBEMVsMRWYc3EP5rs4lR5ELZMrkDqziGqMocV2jmCGK
zDTVKm2Qbzga6ZCJZGMQSTmxpmPzbDPNokW9R3wJsTQzhZpheZWFncRwwY5V
jhUPm4LIyVkxnVnVIy52wJIDaGW52HFloTiKhZ256VeEHTdHtZZKY4f47T0D
aTC/MZ80E72hQfT0WSyfnxBBAlpi3VH+sqW7imIn9ZmNXdqIGMiHGLRRHjIb
0U9vykFOytIo5NJ5Pylzj3kEM7m5RNTzq7Y6ITw63sleXRQrnu51bjwSjpUo
JpUSsdJPSqKxUliYT18aQ7HTsa0M7OTm0ti5CKTZ4zaLI8dSh4k+kctYyDGP
83SlfNVD3EQpJjkosYibse4jcXNnLHo64xJpXfN3uaTQLUBOVrwgx1VkWsTf
iMJtck4WilZDKFrkF3KTIMUnqRylfJ4I8ft8Pl8jhGSbKUBIe28MhGTw/wNC
acf/PUAzpmhktG8WIJMxa0s3ZvroyCHBZYlO4DcF6y3MPmFZ1eRp7v800ZG1
5iGv78qWi014nqBOta34baPD1SvOnS+VH1QbH0Z+zo+0pqA21mssIU5MfZFr
BHBqtHBiEcL3ppbe+6L/XCccpcAbqpH7m3nqqnSoCzl9jUZFRx+uYZnNu46N
h6SzJfEg5JO+ypdz26PxMNPLaDyGGXYnXx16HZSNA5O4OxdulfO0QhxCIjrf
5Vnd0V0krjSUtHq4x75t7ceNNa9i5JWeJh8p1zqz6IiInDoqcxc77r8SVAPr
9Nqt2DokR7LMIqzTUbUa1l1tWVUXaqVemRVZmZbM1tsvpRwMsdPyhgrttKuW
G421qeJxDe0xpNaXtMS9zpjvIauUPmXN1hBhk16R/WsTvXDJ4p2eTeY7uUlt
0muhf23yH7TnPJsYO/lSUnybJvSrDfLUy8tx5PXEM9578aH6qwg4sSp6yxlL
bL1tuZkEelcf94LsqKb6lzo9sO2hvnq/HRrLnoLspqb2JK9Zwy3UES5rWVxn
zVs/QGwK8x7aoiNb1rJtoNoSxc9Vlk0D0QY/l1Ndtv7XDjB9w95DSlvX/W9D
WBVYaJNdD/a/zsMGgo787Qj/95hCdUyHVB7j8zrqqVPNkdXXTCqtcM2GWxrZ
2FFDHctqoGHnxiPeG1ahGl6dD38PjJrpCFW+Zg0GC/LEyHj6Zu+24TnJd9xr
ObdOPL/13KXM+XVNmXR+/ZtAlcxf+AQk3vxcg/qJXbz5ZiWUr5GpjXw5Lq66
fHtlx8spK5WfPIcYnLEaM5pZzSz3O/32Tr01K2OinIW7J5/lzBsnO6Eu+j2D
cF10FCuuS/Isg3Pve/2Y52Hhcxun70XnLnYGOM+S6L/LEy6ldM7Rv/KqY6Ud
sQbvLufuuXntoyrHMytddV4ZLqXwb+j6Md7O1ijbrqKLZ2uUHfQ32/ev9Oaj
5XZlWzznSiLfvF7Rz3LMfdSPvYlkhf+910iPDpfv/bFU9z8/PtaV1j+W7KYy
5eictjI5+v3JyuToTJVyGvOF+4kd9fh3Zfk3Z50h/wOL/QPD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->558092324]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicUnitQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicUnitQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRootsOfUnity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRootsOfUnity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldIntegralBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldIntegralBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldNormRepresentatives",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldNormRepresentatives"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->143861464],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->45216832]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldFundamentalUnits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 8.7821732}", "context" -> "System`", 
    "keywords" -> {
     "algebraic number units", "fundamental units", "number field"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldFundamentalUnits[a] gives a list of fundamental units for the \
field \\[DoubleStruckCapitalQ][a] generated by the algebraic number a.", 
    "synonyms" -> {"number field fundamental units"}, "title" -> 
    "NumberFieldFundamentalUnits", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldFundamentalUnits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6570, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->104456234]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33993, 1147}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2292, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2915, 83, 1592, 37, 70, "ObjectNameGrid"],
Cell[4510, 122, 793, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5340, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5818, 167, 438, 13, 70, "Notes",
 CellID->1067943069],
Cell[6259, 182, 274, 8, 70, "Notes",
 CellID->22646481]
}, Closed]],
Cell[CellGroupData[{
Cell[6570, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104456234],
Cell[CellGroupData[{
Cell[6955, 209, 148, 5, 70, "ExampleSection",
 CellID->128505943],
Cell[7106, 216, 277, 10, 70, "ExampleText",
 CellID->1041480569],
Cell[CellGroupData[{
Cell[7408, 230, 209, 6, 28, "Input",
 CellID->86851463],
Cell[7620, 238, 1548, 51, 103, "Output",
 CellID->720732506]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9217, 295, 220, 7, 70, "ExampleSection",
 CellID->193536283],
Cell[9440, 304, 60, 1, 70, "ExampleText",
 CellID->1942146018],
Cell[CellGroupData[{
Cell[9525, 309, 155, 4, 70, "Input",
 CellID->2044173773],
Cell[9683, 315, 313, 11, 43, "Output",
 CellID->1543459262]
}, Open  ]],
Cell[10011, 329, 126, 3, 70, "ExampleDelimiter",
 CellID->1485324216],
Cell[10140, 334, 179, 7, 70, "ExampleText",
 CellID->1494185584],
Cell[CellGroupData[{
Cell[10344, 345, 300, 11, 70, "Input",
 CellID->1419282844],
Cell[10647, 358, 521, 18, 51, "Output",
 CellID->1464844321]
}, Open  ]],
Cell[11183, 379, 126, 3, 70, "ExampleDelimiter",
 CellID->1461772365],
Cell[11312, 384, 200, 7, 70, "ExampleText",
 CellID->795216875],
Cell[CellGroupData[{
Cell[11537, 395, 436, 14, 70, "Input",
 CellID->103342270],
Cell[11976, 411, 680, 23, 51, "Output",
 CellID->885973839]
}, Open  ]],
Cell[12671, 437, 126, 3, 70, "ExampleDelimiter",
 CellID->1055270411],
Cell[12800, 442, 250, 7, 70, "ExampleText",
 CellID->1734332986],
Cell[CellGroupData[{
Cell[13075, 453, 310, 10, 70, "Input",
 CellID->316732129],
Cell[13388, 465, 740, 26, 43, "Output",
 CellID->2058187422]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14177, 497, 227, 7, 70, "ExampleSection",
 CellID->148592117],
Cell[14407, 506, 318, 11, 70, "ExampleText",
 CellID->1311353095],
Cell[CellGroupData[{
Cell[14750, 521, 501, 16, 70, "Input",
 CellID->539061929],
Cell[15254, 539, 1480, 56, 81, "Output",
 CellID->289415678]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16783, 601, 237, 7, 70, "ExampleSection",
 CellID->865652129],
Cell[17023, 610, 82, 1, 70, "ExampleText",
 CellID->1650918245],
Cell[CellGroupData[{
Cell[17130, 615, 300, 11, 70, "Input",
 CellID->1494224475],
Cell[17433, 628, 1021, 34, 81, "Output",
 CellID->158839691]
}, Open  ]],
Cell[CellGroupData[{
Cell[18491, 667, 117, 3, 70, "Input",
 CellID->1855596320],
Cell[18611, 672, 209, 7, 36, "Output",
 CellID->296513416]
}, Open  ]],
Cell[18835, 682, 125, 3, 70, "ExampleDelimiter",
 CellID->538353034],
Cell[18963, 687, 408, 15, 70, "ExampleText",
 CellID->1817100637],
Cell[CellGroupData[{
Cell[19396, 706, 378, 13, 70, "Input",
 CellID->40168031],
Cell[19777, 721, 352, 12, 39, "Output",
 CellID->1338921672]
}, Open  ]],
Cell[CellGroupData[{
Cell[20166, 738, 132, 3, 70, "Input",
 CellID->1307670376],
Cell[20301, 743, 1595, 52, 111, "Output",
 CellID->1922888038]
}, Open  ]],
Cell[21911, 798, 126, 3, 70, "ExampleDelimiter",
 CellID->1033151638],
Cell[22040, 803, 261, 8, 70, "ExampleText",
 CellID->1491900675],
Cell[CellGroupData[{
Cell[22326, 815, 379, 13, 70, "Input",
 CellID->268425937],
Cell[22708, 830, 351, 12, 39, "Output",
 CellID->497850963]
}, Open  ]],
Cell[CellGroupData[{
Cell[23096, 847, 194, 6, 70, "Input",
 CellID->224838080],
Cell[23293, 855, 203, 7, 36, "Output",
 CellID->784846429]
}, Open  ]],
Cell[23511, 865, 74, 1, 70, "ExampleText",
 CellID->63696586],
Cell[CellGroupData[{
Cell[23610, 870, 102, 3, 70, "Input",
 CellID->584289946],
Cell[23715, 875, 159, 5, 36, "Output",
 CellID->1069372329]
}, Open  ]],
Cell[CellGroupData[{
Cell[23911, 885, 167, 5, 70, "Input",
 CellID->608803658],
Cell[24081, 892, 158, 5, 36, "Output",
 CellID->650091760]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24288, 903, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[CellGroupData[{
Cell[24541, 914, 619, 19, 70, "Input",
 CellID->111311366],
Cell[25163, 935, 5080, 87, 70, "Output",
 Evaluatable->False,
 CellID->558092324]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30304, 1029, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[30623, 1040, 1063, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[31723, 1080, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[32044, 1091, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[32240, 1099, 319, 9, 70, "MoreAboutSection",
 CellID->143861464],
Cell[32562, 1110, 155, 3, 70, "MoreAbout",
 CellID->45216832]
}, Open  ]],
Cell[32732, 1116, 27, 0, 70, "History"],
Cell[32762, 1118, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

