(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41028,       1441]
NotebookOptionsPosition[     35233,       1243]
NotebookOutlinePosition[     36603,       1281]
CellTagsIndexPosition[     36517,       1276]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberFieldFundamentalUnits" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldFundamentalUnits"], 
          "RootOfUnityQ" :> 
          Documentation`HelpLookup["paclet:ref/RootOfUnityQ"], "RootReduce" :> 
          Documentation`HelpLookup["paclet:ref/RootReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberFieldFundamentalUnits\"\>", 
       2->"\<\"RootOfUnityQ\"\>", 
       3->"\<\"RootReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldRootsOfUnity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldRootsOfUnity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldRootsOfUnity"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the roots of unity for the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"],
     " generated by the algebraic number ",
     Cell[BoxData[
      FormBox[
       StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldRootsOfUnity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRootsOfUnity"]], "InlineFormula"],
 " gives a list of all algebraic numbers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "i"], TraditionalForm]], "InlineMath"],
 " in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["u", "i", "n"], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 " for some ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldRootsOfUnity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRootsOfUnity"]], "InlineFormula"],
 " returns any ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "i"], TraditionalForm]], "InlineMath"],
 " other than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", "1"}], TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->1124769981]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73442456],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->276639323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27183571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{"\[ImaginaryI]", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{"\[ImaginaryI]", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{436, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387270227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39775083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"-", "\[ImaginaryI]"}], ",", "\[ImaginaryI]"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1975254779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506433488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"I", "+", 
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85240978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"12", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["91", "22"]}], ",", 
       RowBox[{"-", 
        FractionBox["39", "11"]}], ",", 
       FractionBox["39", "11"], ",", 
       RowBox[{"-", 
        FractionBox["20", "11"]}], ",", 
       FractionBox["9", "22"], ",", 
       RowBox[{"-", 
        FractionBox["6", "11"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"12", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["91", "22"], ",", 
       FractionBox["39", "11"], ",", 
       RowBox[{"-", 
        FractionBox["39", "11"]}], ",", 
       FractionBox["20", "11"], ",", 
       RowBox[{"-", 
        FractionBox["9", "22"]}], ",", 
       FractionBox["6", "11"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{518, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157371680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85519248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "\[ImaginaryI]", ",", 
   RowBox[{"-", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1393456303]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Radical expressions:", "ExampleText",
 CellID->742321040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"-", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1457213857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{522, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1510913986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1291393904],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1987607946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"9", "-", 
      RowBox[{"2", " ", 
       RowBox[{"#1", "^", "2"}]}], "+", 
      RowBox[{"#1", "^", "4"}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1618619337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["5", "12"], ",", 
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "6"], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       FractionBox["5", "12"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{466, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2084720574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1087724053],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1997355507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "4"}], "-", 
        RowBox[{"#", "^", "2"}], "+", "1"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89636245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["272", "143"]}], ",", 
       FractionBox["280", "143"], ",", 
       RowBox[{"-", 
        FractionBox["53", "143"]}], ",", 
       FractionBox["6", "143"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["130", "77"]}], ",", 
       FractionBox["183", "77"], ",", 
       RowBox[{"-", 
        FractionBox["39", "77"]}], ",", 
       FractionBox["4", "77"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1681", "1001"]}], ",", 
       FractionBox["1129", "1001"], ",", 
       RowBox[{"-", 
        FractionBox["204", "1001"]}], ",", 
       FractionBox["15", "1001"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["129", "143"]}], ",", 
       FractionBox["280", "143"], ",", 
       RowBox[{"-", 
        FractionBox["53", "143"]}], ",", 
       FractionBox["6", "143"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["9", "1001"]}], ",", 
       FractionBox["1250", "1001"], ",", 
       RowBox[{"-", 
        FractionBox["303", "1001"]}], ",", 
       FractionBox["37", "1001"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["9", "1001"], ",", 
       RowBox[{"-", 
        FractionBox["1250", "1001"]}], ",", 
       FractionBox["303", "1001"], ",", 
       RowBox[{"-", 
        FractionBox["37", "1001"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["129", "143"], ",", 
       RowBox[{"-", 
        FractionBox["280", "143"]}], ",", 
       FractionBox["53", "143"], ",", 
       RowBox[{"-", 
        FractionBox["6", "143"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1681", "1001"], ",", 
       RowBox[{"-", 
        FractionBox["1129", "1001"]}], ",", 
       FractionBox["204", "1001"], ",", 
       RowBox[{"-", 
        FractionBox["15", "1001"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["130", "77"], ",", 
       RowBox[{"-", 
        FractionBox["183", "77"]}], ",", 
       FractionBox["39", "77"], ",", 
       RowBox[{"-", 
        FractionBox["4", "77"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"37", "-", 
         RowBox[{"68", " ", "#1"}], "+", 
         RowBox[{"53", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["272", "143"], ",", 
       RowBox[{"-", 
        FractionBox["280", "143"]}], ",", 
       FractionBox["53", "143"], ",", 
       RowBox[{"-", 
        FractionBox["6", "143"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{571, 388},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1702986413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1780204284],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldRootsOfUnity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRootsOfUnity"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->793770281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
    RowBox[{"I", " ", 
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}]}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->546369985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"4", "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
     
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"4", "+", 
           SuperscriptBox["#1", "6"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         FractionBox["1", "2"], ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{491, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430596075]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "A list of roots of unity in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", 
      SqrtBox["3"]}]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->2011480773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"roots", "=", 
  RowBox[{"NumberFieldRootsOfUnity", "[", 
   RowBox[{"1", "+", " ", 
    RowBox[{"I", " ", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1269780737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{545, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8342135]
}, Open  ]],

Cell["Roots of unity are also algebraic integers and units:", "ExampleText",
 CellID->519108586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", "roots", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2997921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->619825890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", "roots", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->236851772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2118045280]
}, Open  ]],

Cell[TextData[{
 "And they all have norm ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->671009316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", "roots", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->328011022],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1298088288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->844238877],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to get canonical complex expressions:"
}], "ExampleText",
 CellID->698350010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"I", "+", 
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1170487215],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"12", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["91", "22"]}], ",", 
       RowBox[{"-", 
        FractionBox["39", "11"]}], ",", 
       FractionBox["39", "11"], ",", 
       RowBox[{"-", 
        FractionBox["20", "11"]}], ",", 
       FractionBox["9", "22"], ",", 
       RowBox[{"-", 
        FractionBox["6", "11"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"5", "+", 
         RowBox[{"12", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["91", "22"], ",", 
       FractionBox["39", "11"], ",", 
       RowBox[{"-", 
        FractionBox["39", "11"]}], ",", 
       FractionBox["20", "11"], ",", 
       RowBox[{"-", 
        FractionBox["9", "22"]}], ",", 
       FractionBox["6", "11"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{518, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683486543]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->667770082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "\[ImaginaryI]", ",", 
   RowBox[{"-", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->468300398]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldFundamentalUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldFundamentalUnits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootOfUnityQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootOfUnityQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->79790115],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->273087342]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldRootsOfUnity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 13.7197996}", "context" -> "System`", 
    "keywords" -> {"number field", "roots of unity"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldRootsOfUnity[a] gives the roots of unity for the field \
\\[DoubleStruckCapitalQ][a] generated by the algebraic number a.", 
    "synonyms" -> {"number field roots of unity"}, "title" -> 
    "NumberFieldRootsOfUnity", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldRootsOfUnity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7020, 220, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->73442456]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36375, 1269}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2051, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2674, 78, 1588, 37, 70, "ObjectNameGrid"],
Cell[4265, 117, 803, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5105, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5583, 163, 691, 25, 70, "Notes",
 CellID->1067943069],
Cell[6277, 190, 706, 25, 70, "Notes",
 CellID->1124769981]
}, Closed]],
Cell[CellGroupData[{
Cell[7020, 220, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->73442456],
Cell[CellGroupData[{
Cell[7404, 234, 148, 5, 70, "ExampleSection",
 CellID->276639323],
Cell[CellGroupData[{
Cell[7577, 243, 118, 3, 28, "Input",
 CellID->27183571],
Cell[7698, 248, 532, 17, 36, "Output",
 CellID->387270227]
}, Open  ]],
Cell[CellGroupData[{
Cell[8267, 270, 105, 3, 28, "Input",
 CellID->39775083],
Cell[8375, 275, 286, 9, 36, "Output",
 CellID->1975254779]
}, Open  ]],
Cell[8676, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->506433488],
Cell[CellGroupData[{
Cell[8826, 294, 216, 7, 28, "Input",
 CellID->85240978],
Cell[9045, 303, 1853, 58, 103, "Output",
 CellID->157371680]
}, Open  ]],
Cell[CellGroupData[{
Cell[10935, 366, 105, 3, 70, "Input",
 CellID->85519248],
Cell[11043, 371, 286, 9, 36, "Output",
 CellID->1393456303]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11378, 386, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11602, 395, 63, 1, 70, "ExampleText",
 CellID->742321040],
Cell[CellGroupData[{
Cell[11690, 400, 170, 5, 70, "Input",
 CellID->1457213857],
Cell[11863, 407, 1268, 44, 81, "Output",
 CellID->1510913986]
}, Open  ]],
Cell[13146, 454, 126, 3, 70, "ExampleDelimiter",
 CellID->1291393904],
Cell[13275, 459, 179, 7, 70, "ExampleText",
 CellID->1987607946],
Cell[CellGroupData[{
Cell[13479, 470, 315, 10, 70, "Input",
 CellID->1618619337],
Cell[13797, 482, 3207, 104, 201, "Output",
 CellID->2084720574]
}, Open  ]],
Cell[17019, 589, 126, 3, 70, "ExampleDelimiter",
 CellID->1087724053],
Cell[17148, 594, 201, 7, 70, "ExampleText",
 CellID->1997355507],
Cell[CellGroupData[{
Cell[17374, 605, 435, 14, 70, "Input",
 CellID->89636245],
Cell[17812, 621, 6763, 208, 409, "Output",
 CellID->1702986413]
}, Open  ]],
Cell[24590, 832, 126, 3, 70, "ExampleDelimiter",
 CellID->1780204284],
Cell[24719, 837, 241, 7, 70, "ExampleText",
 CellID->793770281],
Cell[CellGroupData[{
Cell[24985, 848, 310, 10, 70, "Input",
 CellID->546369985],
Cell[25298, 860, 1153, 38, 81, "Output",
 CellID->430596075]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26500, 904, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[26741, 913, 292, 10, 70, "ExampleText",
 CellID->2011480773],
Cell[CellGroupData[{
Cell[27058, 927, 235, 7, 70, "Input",
 CellID->1269780737],
Cell[27296, 936, 1248, 43, 81, "Output",
 CellID->8342135]
}, Open  ]],
Cell[28559, 982, 96, 1, 70, "ExampleText",
 CellID->519108586],
Cell[CellGroupData[{
Cell[28680, 987, 115, 3, 70, "Input",
 CellID->2997921],
Cell[28798, 992, 268, 9, 36, "Output",
 CellID->619825890]
}, Open  ]],
Cell[CellGroupData[{
Cell[29103, 1006, 114, 3, 70, "Input",
 CellID->236851772],
Cell[29220, 1011, 269, 9, 36, "Output",
 CellID->2118045280]
}, Open  ]],
Cell[29504, 1023, 181, 7, 70, "ExampleText",
 CellID->671009316],
Cell[CellGroupData[{
Cell[29710, 1034, 119, 3, 70, "Input",
 CellID->328011022],
Cell[29832, 1039, 267, 9, 36, "Output",
 CellID->1298088288]
}, Open  ]],
Cell[30114, 1051, 125, 3, 70, "ExampleDelimiter",
 CellID->844238877],
Cell[30242, 1056, 228, 8, 70, "ExampleText",
 CellID->698350010],
Cell[CellGroupData[{
Cell[30495, 1068, 218, 7, 70, "Input",
 CellID->1170487215],
Cell[30716, 1077, 1853, 58, 103, "Output",
 CellID->683486543]
}, Open  ]],
Cell[CellGroupData[{
Cell[32606, 1140, 106, 3, 70, "Input",
 CellID->667770082],
Cell[32715, 1145, 285, 9, 36, "Output",
 CellID->468300398]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33061, 1161, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[33380, 1172, 750, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[34167, 1203, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[34488, 1214, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[34684, 1222, 318, 9, 70, "MoreAboutSection",
 CellID->79790115],
Cell[35005, 1233, 156, 3, 70, "MoreAbout",
 CellID->273087342]
}, Open  ]],
Cell[35176, 1239, 27, 0, 70, "History"],
Cell[35206, 1241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

