(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29943,       1132]
NotebookOptionsPosition[     23317,        904]
NotebookOutlinePosition[     24677,        942]
CellTagsIndexPosition[     24592,        937]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CountRoots" :> 
          Documentation`HelpLookup["paclet:ref/CountRoots"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "NumberFieldDiscriminant" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldDiscriminant"], 
          "NumberFieldRegulator" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRegulator"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CountRoots\"\>", 
       2->"\<\"MinimalPolynomial\"\>", 3->"\<\"NumberFieldDiscriminant\"\>", 
       4->"\<\"NumberFieldRegulator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NumberFieldSignature", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberFieldSignature",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberFieldSignature"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the signature of the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"],
     " generated by the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberFieldSignature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldSignature"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " gives a list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"s", ",", "t"}], "}"}], TraditionalForm]], "InlineMath"],
 " of the number of real roots and the number of pairs of conjugate roots for \
the minimal polynomial of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284886919],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->407545742],

Cell[TextData[{
 "Find the signature of the number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1411088690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366756254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197222931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1341586682],

Cell[TextData[{
 "A number field with signature ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "3"}], ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1616554521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "#", "+", 
      RowBox[{"#", "^", "2"}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"#", "^", "3"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"#", "^", "4"}]}], "-", 
      RowBox[{"#", "^", "5"}], "+", 
      RowBox[{"#", "^", "6"}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"#", "^", "7"}]}], "+", 
      RowBox[{"#", "^", "8"}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616216250],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1158533996]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Radical expressions:", "ExampleText",
 CellID->742321040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"1", "+", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1457213857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246643423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1291393904],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1987607946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"4", 
       RowBox[{"#", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"#", "^", "4"}]}], "-", 
      RowBox[{"#", "^", "6"}], "+", 
      RowBox[{"#", "^", "8"}]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1618619337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692571651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1087724053],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1997355507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"#", "^", "3"}]}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89636245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->690371617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1780204284],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldSignature",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldSignature"]], "InlineFormula"],
 " threads automatically over lists:"
}], "ExampleText",
 CellID->793770281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"I", " ", 
       RowBox[{"Pi", "/", "5"}]}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->546369985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221622178]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Signatures of Galois extension fields of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineMath"],
 " are of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"a", ",", "0"}], ")"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "a"}], ")"}], TraditionalForm]], "InlineMath"],
 " for some integer ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->983115021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1991584006],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1067301748]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", "I", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190120199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209575245]
}, Open  ]],

Cell[TextData[{
 "The number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "3"}]], "]"}], TraditionalForm]], "InlineMath"],
 " is not a Galois extension of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1567487196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"3", "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "3"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1423819822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->457961635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "The minimal polynomial of ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox["2"]}]], TraditionalForm]], "InlineMath"],
 " has two real roots and a pair of complex roots:"
}], "ExampleText",
 CellID->1789107627],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "+", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65395260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"MinimalPolynomial", "[", 
   RowBox[{"a", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->465861695],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379808597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"p", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1974211596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.5537739740300374`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "6.162975822039155`*^-33"}], "-", 
      RowBox[{"0.6435942529055826`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "6.162975822039155`*^-33"}], "+", 
      RowBox[{"0.6435942529055826`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.5537739740300374`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{337, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1121690895]
}, Open  ]],

Cell[TextData[{
 "The signature of the number field generated by  ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox["2"]}]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->336493676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", "a", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1451634861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1647418899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186187526],

Cell["The degree of a number field:", "ExampleText",
 CellID->1281069813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s", ",", "t"}], "}"}], "=", " ", 
  RowBox[{"NumberFieldSignature", "[", 
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456093148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->662774722]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "+", 
  RowBox[{"2", "t"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->383458851],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257075665]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " to verify the result:"
}], "ExampleText",
 CellID->224326036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"MinimalPolynomial", "[", 
    RowBox[{
     RowBox[{"2", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}]}], ",", "x"}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1312130604],

Cell[BoxData["3"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2081087538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2026440003],

Cell[TextData[{
 "Find the signature of the number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], ",", "\[ImaginaryI]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1626642100],

Cell[BoxData[
 RowBox[{
  RowBox[{"primitive", " ", "=", " ", 
   RowBox[{
    RowBox[{"ToNumberField", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], ",", "I"}], "}"}], ",", "All"}], 
     "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->657855843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", "primitive", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1794269789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->772092477]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountRoots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountRoots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldDiscriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldDiscriminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRegulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRegulator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->430919025],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->96219544]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberFieldSignature - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 14.7354506}", "context" -> "System`", 
    "keywords" -> {"number field", "signature of a number field"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumberFieldSignature[a] gives the signature of the field \
\\[DoubleStruckCapitalQ][a] generated by the algebraic number a.", 
    "synonyms" -> {"number field signature"}, "title" -> 
    "NumberFieldSignature", "type" -> "Symbol", "uri" -> 
    "ref/NumberFieldSignature"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6290, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->284886919]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24449, 930}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2210, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2833, 81, 1585, 37, 70, "ObjectNameGrid"],
Cell[4421, 120, 764, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5222, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5700, 165, 553, 18, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[6290, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284886919],
Cell[CellGroupData[{
Cell[6675, 202, 148, 5, 70, "ExampleSection",
 CellID->407545742],
Cell[6826, 209, 274, 10, 70, "ExampleText",
 CellID->1411088690],
Cell[CellGroupData[{
Cell[7125, 223, 203, 6, 28, "Input",
 CellID->366756254],
Cell[7331, 231, 203, 7, 36, "Output",
 CellID->197222931]
}, Open  ]],
Cell[7549, 241, 126, 3, 70, "ExampleDelimiter",
 CellID->1341586682],
Cell[7678, 246, 208, 8, 70, "ExampleText",
 CellID->1616554521],
Cell[CellGroupData[{
Cell[7911, 258, 583, 18, 70, "Input",
 CellID->1616216250],
Cell[8497, 278, 204, 7, 36, "Output",
 CellID->1158533996]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8750, 291, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8974, 300, 63, 1, 70, "ExampleText",
 CellID->742321040],
Cell[CellGroupData[{
Cell[9062, 305, 205, 6, 70, "Input",
 CellID->1457213857],
Cell[9270, 313, 203, 7, 36, "Output",
 CellID->246643423]
}, Open  ]],
Cell[9488, 323, 126, 3, 70, "ExampleDelimiter",
 CellID->1291393904],
Cell[9617, 328, 179, 7, 70, "ExampleText",
 CellID->1987607946],
Cell[CellGroupData[{
Cell[9821, 339, 402, 13, 70, "Input",
 CellID->1618619337],
Cell[10226, 354, 203, 7, 36, "Output",
 CellID->692571651]
}, Open  ]],
Cell[10444, 364, 126, 3, 70, "ExampleDelimiter",
 CellID->1087724053],
Cell[10573, 369, 201, 7, 70, "ExampleText",
 CellID->1997355507],
Cell[CellGroupData[{
Cell[10799, 380, 404, 13, 70, "Input",
 CellID->89636245],
Cell[11206, 395, 203, 7, 36, "Output",
 CellID->690371617]
}, Open  ]],
Cell[11424, 405, 126, 3, 70, "ExampleDelimiter",
 CellID->1780204284],
Cell[11553, 410, 235, 7, 70, "ExampleText",
 CellID->793770281],
Cell[CellGroupData[{
Cell[11813, 421, 308, 10, 70, "Input",
 CellID->546369985],
Cell[12124, 433, 350, 13, 36, "Output",
 CellID->221622178]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12523, 452, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[12753, 461, 536, 19, 70, "ExampleText",
 CellID->983115021],
Cell[CellGroupData[{
Cell[13314, 484, 148, 4, 70, "Input",
 CellID->1991584006],
Cell[13465, 490, 204, 7, 36, "Output",
 CellID->1067301748]
}, Open  ]],
Cell[CellGroupData[{
Cell[13706, 502, 116, 3, 70, "Input",
 CellID->190120199],
Cell[13825, 507, 203, 7, 36, "Output",
 CellID->209575245]
}, Open  ]],
Cell[14043, 517, 370, 12, 70, "ExampleText",
 CellID->1567487196],
Cell[CellGroupData[{
Cell[14438, 533, 189, 6, 70, "Input",
 CellID->1423819822],
Cell[14630, 541, 251, 9, 36, "Output",
 CellID->457961635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14930, 556, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[15171, 565, 255, 9, 70, "ExampleText",
 CellID->1789107627],
Cell[15429, 576, 200, 7, 70, "Input",
 CellID->65395260],
Cell[CellGroupData[{
Cell[15654, 587, 170, 5, 70, "Input",
 CellID->465861695],
Cell[15827, 594, 280, 10, 36, "Output",
 CellID->379808597]
}, Open  ]],
Cell[CellGroupData[{
Cell[16144, 609, 157, 5, 70, "Input",
 CellID->1974211596],
Cell[16304, 616, 758, 23, 58, "Output",
 CellID->1121690895]
}, Open  ]],
Cell[17077, 642, 229, 9, 70, "ExampleText",
 CellID->336493676],
Cell[CellGroupData[{
Cell[17331, 655, 117, 3, 70, "Input",
 CellID->1451634861],
Cell[17451, 660, 204, 7, 36, "Output",
 CellID->1647418899]
}, Open  ]],
Cell[17670, 670, 125, 3, 70, "ExampleDelimiter",
 CellID->186187526],
Cell[17798, 675, 73, 1, 70, "ExampleText",
 CellID->1281069813],
Cell[CellGroupData[{
Cell[17896, 680, 267, 9, 70, "Input",
 CellID->1456093148],
Cell[18166, 691, 251, 9, 36, "Output",
 CellID->662774722]
}, Open  ]],
Cell[CellGroupData[{
Cell[18454, 705, 110, 4, 70, "Input",
 CellID->383458851],
Cell[18567, 711, 158, 5, 36, "Output",
 CellID->257075665]
}, Open  ]],
Cell[18740, 719, 355, 13, 70, "ExampleText",
 CellID->224326036],
Cell[CellGroupData[{
Cell[19120, 736, 282, 10, 70, "Input",
 CellID->1312130604],
Cell[19405, 748, 207, 7, 36, "Output",
 CellID->2081087538]
}, Open  ]],
Cell[19627, 758, 126, 3, 70, "ExampleDelimiter",
 CellID->2026440003],
Cell[19756, 763, 274, 10, 70, "ExampleText",
 CellID->1626642100],
Cell[20033, 775, 376, 13, 70, "Input",
 CellID->657855843],
Cell[CellGroupData[{
Cell[20434, 792, 125, 3, 70, "Input",
 CellID->1794269789],
Cell[20562, 797, 251, 9, 36, "Output",
 CellID->772092477]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20874, 813, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[21193, 824, 1021, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[22251, 864, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[22572, 875, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[22768, 883, 319, 9, 70, "MoreAboutSection",
 CellID->430919025],
Cell[23090, 894, 155, 3, 70, "MoreAbout",
 CellID->96219544]
}, Open  ]],
Cell[23260, 900, 27, 0, 70, "History"],
Cell[23290, 902, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

