(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15458,        547]
NotebookOptionsPosition[     11526,        418]
NotebookOutlinePosition[     13050,        458]
CellTagsIndexPosition[     12965,        453]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"], 
          "Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>", 
       2->"\<\"Numerical Precision\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"], "Accuracy" :> 
          Documentation`HelpLookup["paclet:ref/Accuracy"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberForm\"\>", 
       2->"\<\"Precision\"\>", 3->"\<\"Accuracy\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Display of Numbers\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberMarks", "ObjectName",
 CellID->16513],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberMarks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["InputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
     " and related functions that specifies whether ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks should be included in the printed forms of approximate numbers. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1894]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
 " is given by the value of ",
 Cell[BoxData[
  ButtonBox["$NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NumberMarks"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3881],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberMarks", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " indicates that ",
 Cell[BoxData["`"], "InlineFormula"],
 " should be used in all approximate numbers, both machine\[Hyphen]precision \
and arbitrary\[Hyphen]precision ones. "
}], "Notes",
 CellID->2173],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberMarks", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " indicates that ",
 Cell[BoxData["`"], "InlineFormula"],
 " should be used in arbitrary\[Hyphen]precision but not \
machine\[Hyphen]precision numbers. "
}], "Notes",
 CellID->14550],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberMarks", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " indicates that ",
 Cell[BoxData["`"], "InlineFormula"],
 " should never be used in outputting numbers. "
}], "Notes",
 CellID->10296],

Cell["\<\
Number marks are used to indicate the type of numbers, and their precision or \
accuracy. \
\>", "Notes",
 CellID->6271],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"*", "^"}]], "InlineFormula"],
 " form for scientific notation is always used in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", and is independent of ",
 Cell[BoxData[
  ButtonBox["NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3414]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121121142],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->60868976],

Cell["Machine numbers format without number marks by default:", "ExampleText",
 CellID->891933422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"N", "[", 
   RowBox[{"1", "/", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315109163],

Cell["0.3333333333333333", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->36320197]
}, Open  ]],

Cell["The same number with number marks:", "ExampleText",
 CellID->195094700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", 
   RowBox[{"NumberMarks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17858563],

Cell["0.3333333333333333`", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->199708414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->511386803],

Cell["Extended precision numbers include number marks by default:", \
"ExampleText",
 CellID->240263990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"10", "/", "3"}], ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299941724],

Cell["3.33333333333333333333333333333333333333`20.", "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->108177921]
}, Open  ]],

Cell["Without number marks:", "ExampleText",
 CellID->208766706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"10", "/", "3"}], ",", "20"}], "]"}], ",", 
   RowBox[{"NumberMarks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141694954],

Cell["3.33333333333333333333", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->243930702]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30179],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6905],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->13834],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->16281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->248602756],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->840952],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->232720640]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberMarks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 17.0011336}", "context" -> "System`", 
    "keywords" -> {
     "back-tick in numbers", "scientific notation", "precision notation", 
      "accuracy notation", "arbitrary precision numbers", 
      "variable precision numbers", "number I/O", "number representation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumberMarks is an option for InputForm and related functions that \
specifies whether ` marks should be included in the printed forms of \
approximate numbers. ", "synonyms" -> {"number marks", "`", "*^"}, "title" -> 
    "NumberMarks", "type" -> "Symbol", "uri" -> "ref/NumberMarks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6278, 208, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->121121142]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12822, 446}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2354, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2977, 82, 49, 1, 70, "ObjectName",
 CellID->16513],
Cell[3029, 85, 721, 21, 70, "Usage",
 CellID->1894]
}, Open  ]],
Cell[CellGroupData[{
Cell[3787, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4265, 128, 361, 13, 70, "Notes",
 CellID->3881],
Cell[4629, 143, 369, 11, 70, "Notes",
 CellID->2173],
Cell[5001, 156, 357, 11, 70, "Notes",
 CellID->14550],
Cell[5361, 169, 302, 10, 70, "Notes",
 CellID->10296],
Cell[5666, 181, 130, 4, 70, "Notes",
 CellID->6271],
Cell[5799, 187, 442, 16, 70, "Notes",
 CellID->3414]
}, Closed]],
Cell[CellGroupData[{
Cell[6278, 208, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121121142],
Cell[CellGroupData[{
Cell[6663, 222, 147, 5, 70, "ExampleSection",
 CellID->60868976],
Cell[6813, 229, 98, 1, 70, "ExampleText",
 CellID->891933422],
Cell[CellGroupData[{
Cell[6936, 234, 157, 5, 28, "Input",
 CellID->315109163],
Cell[7096, 241, 177, 5, 50, "Output",
 CellID->36320197]
}, Open  ]],
Cell[7288, 249, 77, 1, 70, "ExampleText",
 CellID->195094700],
Cell[CellGroupData[{
Cell[7390, 254, 224, 7, 28, "Input",
 CellID->17858563],
Cell[7617, 263, 179, 5, 50, "Output",
 CellID->199708414]
}, Open  ]],
Cell[7811, 271, 125, 3, 70, "ExampleDelimiter",
 CellID->511386803],
Cell[7939, 276, 104, 2, 70, "ExampleText",
 CellID->240263990],
Cell[CellGroupData[{
Cell[8068, 282, 184, 6, 70, "Input",
 CellID->299941724],
Cell[8255, 290, 204, 5, 50, "Output",
 CellID->108177921]
}, Open  ]],
Cell[8474, 298, 64, 1, 70, "ExampleText",
 CellID->208766706],
Cell[CellGroupData[{
Cell[8563, 303, 254, 8, 70, "Input",
 CellID->141694954],
Cell[8820, 313, 182, 5, 50, "Output",
 CellID->243930702]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9063, 325, 311, 9, 70, "SeeAlsoSection",
 CellID->30179],
Cell[9377, 336, 702, 26, 70, "SeeAlso",
 CellID->17141]
}, Open  ]],
Cell[CellGroupData[{
Cell[10116, 367, 313, 9, 70, "TutorialsSection",
 CellID->6905],
Cell[10432, 378, 191, 4, 70, "Tutorials",
 CellID->13834],
Cell[10626, 384, 148, 3, 70, "Tutorials",
 CellID->16281]
}, Open  ]],
Cell[CellGroupData[{
Cell[10811, 392, 319, 9, 70, "MoreAboutSection",
 CellID->248602756],
Cell[11133, 403, 143, 3, 70, "MoreAbout",
 CellID->840952],
Cell[11279, 408, 175, 3, 70, "MoreAbout",
 CellID->232720640]
}, Open  ]],
Cell[11469, 414, 27, 0, 70, "History"],
Cell[11499, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

