(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11249,        400]
NotebookOptionsPosition[      8135,        299]
NotebookOutlinePosition[      9610,        339]
CellTagsIndexPosition[      9526,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AutoMultiplicationSymbol" :> 
          Documentation`HelpLookup["paclet:ref/AutoMultiplicationSymbol"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"AutoMultiplicationSymbol\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberMultiplier", "ObjectName",
 CellID->25389],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberMultiplier",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberMultiplier"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which gives the string to use as a \
multiplication sign in scientific notation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27880]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{"NumberMultiplier", "->", "\"\<\[Backslash][Times]\>\""}]], 
  "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->263067636]
}], "Notes",
 CellID->916],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "]"}]], "InlineFormula"],
 " is rendered as ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5102]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229974899],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->15980899],

Cell["The default multiplier is \[Times]:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->263067636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"12345678.9", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172619616],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1.23456789\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"7\"\>"]}],
   1.23456789*^7,
   AutoDelete->True],
  NumberForm[#, 10]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->173734404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14385943],

Cell["Use an asterisk instead:", "ExampleText",
 CellID->65928263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"12345678.9", ",", "10", ",", 
   RowBox[{"NumberMultiplier", "\[Rule]", "\"\<*\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181529350],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1.23456789\"\>", "*", 
    SuperscriptBox["10", "\<\"7\"\>"]}],
   1.23456789*^7,
   AutoDelete->True],
  NumberForm[#, 10, NumberMultiplier -> "*"]& ]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->91822581]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2247],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AutoMultiplicationSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoMultiplicationSymbol"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->14343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22004],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->9745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->337884543],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->230191710]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberMultiplier - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 18.0480354}", "context" -> "System`", 
    "keywords" -> {
     "exponent multiplier", "times in scientific notation", 
      "number formatting", "numeric formatting", "number output", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberMultiplier is an option for NumberForm and related functions which \
gives the string to use as a multiplication sign in scientific notation. ", 
    "synonyms" -> {"number multiplier"}, "title" -> "NumberMultiplier", 
    "type" -> "Symbol", "uri" -> "ref/NumberMultiplier"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4430, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->229974899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9383, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1869, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2492, 76, 54, 1, 70, "ObjectName",
 CellID->25389],
Cell[2549, 79, 668, 19, 70, "Usage",
 CellID->27880]
}, Open  ]],
Cell[CellGroupData[{
Cell[3254, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3732, 120, 261, 10, 70, "Notes",
 CellID->916],
Cell[3996, 132, 397, 16, 70, "Notes",
 CellID->5102]
}, Closed]],
Cell[CellGroupData[{
Cell[4430, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229974899],
Cell[CellGroupData[{
Cell[4815, 167, 147, 5, 70, "ExampleSection",
 CellID->15980899],
Cell[4965, 174, 126, 2, 70, "ExampleText",
 CellID->263067636],
Cell[CellGroupData[{
Cell[5116, 180, 139, 4, 28, "Input",
 CellID->172619616],
Cell[5258, 186, 348, 12, 50, "Output",
 CellID->173734404]
}, Open  ]],
Cell[5621, 201, 124, 3, 70, "ExampleDelimiter",
 CellID->14385943],
Cell[5748, 206, 66, 1, 70, "ExampleText",
 CellID->65928263],
Cell[CellGroupData[{
Cell[5839, 211, 202, 5, 70, "Input",
 CellID->181529350],
Cell[6044, 218, 365, 12, 50, "Output",
 CellID->91822581]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6470, 237, 310, 9, 70, "SeeAlsoSection",
 CellID->2247],
Cell[6783, 248, 228, 6, 70, "SeeAlso",
 CellID->14343]
}, Open  ]],
Cell[CellGroupData[{
Cell[7048, 259, 314, 9, 70, "TutorialsSection",
 CellID->22004],
Cell[7365, 270, 159, 3, 70, "Tutorials",
 CellID->9745]
}, Open  ]],
Cell[CellGroupData[{
Cell[7561, 278, 319, 9, 70, "MoreAboutSection",
 CellID->337884543],
Cell[7883, 289, 180, 3, 70, "MoreAbout",
 CellID->230191710]
}, Open  ]],
Cell[8078, 295, 27, 0, 70, "History"],
Cell[8108, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

