(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49524,       1648]
NotebookOptionsPosition[     41736,       1373]
NotebookOutlinePosition[     43041,       1411]
CellTagsIndexPosition[     42955,       1406]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"], 
          "Numeric Quantities" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericQuantities"], 
          "Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Types of Numbers\"\>", 
       2->"\<\"Numeric Quantities\"\>", 
       3->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumericQ" :> Documentation`HelpLookup["paclet:ref/NumericQ"], 
          "IntegerQ" :> Documentation`HelpLookup["paclet:ref/IntegerQ"], 
          "MachineNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/MachineNumberQ"], "TrueQ" :> 
          Documentation`HelpLookup["paclet:ref/TrueQ"], "Complexes" :> 
          Documentation`HelpLookup["paclet:ref/Complexes"], "Assuming" :> 
          Documentation`HelpLookup["paclet:ref/Assuming"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumericQ\"\>", 
       2->"\<\"IntegerQ\"\>", 3->"\<\"MachineNumberQ\"\>", 4->"\<\"TrueQ\"\>",
        5->"\<\"Complexes\"\>", 6->"\<\"Assuming\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], "Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 2->"\<\"Expressions\"\>", 
       3->"\<\"Patterns\"\>", 4->"\<\"Representation of Numbers\"\>", 
       5->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberQ", "ObjectName",
 CellID->17996],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NumberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NumberQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a number, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4335]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is manifestly a number (i.e., has head ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ").",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->273705580],
 " ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->76531195]
}], "Notes",
 CellID->31587],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25821159]
}], "Notes",
 CellID->23714],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   RowBox[{
    ButtonBox["Overflow",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Overflow"], "[", "]"}], "]"}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   RowBox[{
    ButtonBox["Underflow",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Underflow"], "[", "]"}], "]"}]], 
  "InlineFormula"],
 " give ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->784001930]
}], "Notes",
 CellID->6146]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->310750947],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->916893125],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberQ"]], "InlineFormula"],
 " tests whether an object is explicitly a number:"
}], "ExampleText",
 CellID->716711489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "5.6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180814792],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409970793]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59228498],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84607703]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->318363455],

Cell["The expression must be manifestly a number:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->273705580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130474613],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607719064]
}, Open  ]],

Cell[TextData[{
 "You can test if a quantity represents a number with ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101814091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->342289186],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43428851]
}, Open  ]],

Cell[TextData[{
 "On numerical coercion with ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " such quantities generally become numbers:"
}], "ExampleText",
 CellID->102776148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"N", "[", 
   RowBox[{"Sqrt", "[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52742820],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->739681119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4998635],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25821159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473344795],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267822531]
}, Open  ]],

Cell["The same is true for complex and directed infinities:", "ExampleText",
 CellID->351247013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"c", ",", "d"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], "/", "0"}], ",", 
    RowBox[{"Infinity", "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->533166801],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->44694260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ComplexInfinity", ",", 
   RowBox[{"DirectedInfinity", "[", 
    FractionBox[
     RowBox[{"1", "+", "\[ImaginaryI]"}], 
     SqrtBox["2"]], "]"}]}], "}"}]], "Output",
 ImageSize->{292, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93915012]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NumberQ", "[", "c", "]"}], ",", 
   RowBox[{"NumberQ", "[", "d", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->279106978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4609828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->504557256],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   RowBox[{
    ButtonBox["Overflow",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Overflow"], "[", "]"}], "]"}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   RowBox[{
    ButtonBox["Underflow",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Underflow"], "[", "]"}], "]"}]], 
  "InlineFormula"],
 " give ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->784001930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"o", ",", "u"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"$MaxNumber", "*", "2"}], ",", 
    RowBox[{"$MinNumber", "/", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231427015],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->252166918],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->326353867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Overflow", "[", "]"}], ",", 
   RowBox[{"Underflow", "[", "]"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207717721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NumberQ", "[", "o", "]"}], ",", 
   RowBox[{"NumberQ", "[", "u", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6260054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333986766]
}, Open  ]],

Cell[TextData[{
 "They are both treated as ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->322818976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Head", "[", "o", "]"}], ",", 
   RowBox[{"Head", "[", "u", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->450801283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Real", ",", "Real"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1065377651]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->85185891],

Cell["Test if a matrix consists entirely of numbers:", "ExampleText",
 CellID->1858491],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", 
       RowBox[{"5", "+", 
        RowBox[{"6", "I"}]}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34111778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"m", ",", "NumberQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8319531],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219986847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165038918],

Cell["\<\
Define a function that only evaluates when the argument is a number:\
\>", "ExampleText",
 CellID->426098183],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"xp0_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "t"}], "}"}], ",", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"x", "[", "10", "]"}], "/.", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"Sin", "[", 
             RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "xp0"}]}], "}"}],
         ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155729885],

Cell["It does not evaluate with a symbolic argument:", "ExampleText",
 CellID->38971255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "xp0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->641298237],

Cell[BoxData[
 RowBox[{"f", "[", "xp0", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172361189]
}, Open  ]],

Cell["It does evaluate when the argument is a number:", "ExampleText",
 CellID->579602523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "xp0", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"xp0", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->289480735],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200251698]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to find all the solutions of the boundary value problem with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "0", ")"}], "=", 
    RowBox[{
     RowBox[{"x", "(", "10", ")"}], "=", "0"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->175230166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xps", "=", 
  RowBox[{"xp0", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"f", "[", "xp0", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"xp0", ",", ".5", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"f", "[", "xp0", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"xp0", ",", "1.", ",", "1.9"}], "}"}]}], "]"}], ",", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"f", "[", "xp0", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"xp0", ",", "1.9", ",", "2."}], "}"}]}], "]"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->51802404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9248447630895863`", ",", "1.8781667296585447`", ",", 
   "1.9992723814173503`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->223468468]
}, Open  ]],

Cell["Plot the solutions:", "ExampleText",
 CellID->183067520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sols", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"Sin", "[", 
             RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "xp0"}]}], "}"}],
         ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"xp0", ",", "xps"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->58859979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False], "[", "t", "]"}], ",", 
   RowBox[{
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False], "[", "t", "]"}], ",", 
   RowBox[{
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False], "[", "t", "]"}]}], "}"}]], "Output",
 ImageSize->{300, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->108477818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"sols", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->452452644],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->218860964]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->603710682],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberQ"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["MatchQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MatchQ"], "[", 
    RowBox[{"#", ",", 
     RowBox[{"_Integer", "|", "_Rational", "|", "_Real", "|", "_Complex"}]}], 
    "]"}], "&"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->76531195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"NumberQ", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{"#", ",", 
           RowBox[{
           "_Integer", "|", "_Rational", "|", "_Real", "|", "_Complex"}]}], 
          "]"}], "&"}], "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"3", "/", "2"}], ",", "1.5", ",", 
         RowBox[{"1", "+", "I"}], ",", "E", ",", 
         RowBox[{"Sin", "[", "1", "]"}], ",", " ", 
         RowBox[{"Underflow", "[", "]"}], ",", 
         RowBox[{"Overflow", "[", "]"}], ",", "Infinity"}], "}"}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<NumberQ\>\"", ",", "\"\<match\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342933585],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXEtv1DAQ9uaxSx+0UEBqC0gFJODAS1yphIACF6qWCkE5rqqKVuKl0n/A
BfEfuANHjr30p5lM1t4443HecbyFlZp0JuPxzGd7POtJuz483Nv9MDzc3xmu
PD8Yft7b3/my8uzTQcTye4yxo+jnxyKLfufRb/HPEefRPYSrD3T8YX9KcN9E
FyCBH0Z35sdi8Qf4XkQG0T0Q98WS8j2yV5DyUOuXSCZ+FI5pIRgQmnQpD0ld
bFG3n3hIywaJLGOblSzpa3ouN6QnrGy91B8Q/YA1vhheULtUsV252SNb1hpZ
jbvUmmbau20CK7niMFaBsAvYyxXbeWYrNIunkdSNQlLzZA8QefoROSVG8yai
z5KtysS2+txVYUsg7h+NUiqN58R7spXE3zQ+MC4hcZft1F4YoQdbscDTa8vn
+iqS0XulhOwp0jt6xvvIZh+1yvOhWC8qN70esnSfI8Yhi/aYvhdca0DH9L+E
Z+7uWgjRXC1lMDVz5UqYPESBeaVW6zKrvAxXRhasuU5PVXCUUb5oHxSaZXVk
YNpHsnwUj0fq5cfjSZSmonNIYKHu+rrGvNmNkRtnYokWwZFPZH9XK7ecMqOk
IbqIpHCrhRz/zsTMhNYjyb1ciWXSXjVLU8fsPE9nGGDhILrfF/dLpDa7WdAT
ZOM7o1QWtruZuNDzUc192siJZnj3OVFpriP7+ywxkq7nSyca64nKpdzMsKrj
bD/DGq8FbTfymAnjLrItClP3sy0c2QPEk23t5l8YS9fyr9NIah7RZfOxuO/m
8rFAtVdHf4YnOVhWjgZyruVoS4ptcP9ulML5j0p/I1upUSaZp/Hpf6jiJ5tp
uzan18Jt3mXtAc8Tki4d7TB9B9ETWNVQuH2HMbNSI+kUC9nefsXFdFZddC0V
8XIcOSa6ekN5bsoR8r5RFJkL1Ki0WxnSxpqx3H2c9KTV6hLGW/Lw7qfu66G4
3+XuV6bKcOX+u8mt7bcDNGqi4StilCZsN2zUMyt7FvHtBkTV9y2kTks7iwFD
jPoGP0m7AmC0RWBnP4L/r+2X5coIinM+kIPJvMptniOTq1+hBwoN2h6i526d
1FK5AuBSyYtOz0BbGRerp41NeODO2R72Zk74jq3u7hQNW7gRMxO62foj2IMr
uA+4e2dZVSKzerINj9d4lxE5ew6vEdLuxmN8pvu4SM9OxeHmPLAVd8EvIJ8S
ut2Nrzg3xNa7E2expfGMaDXuQuUGmj/i7sVbGTN/G5+qNC2FM4VfNaRUmhnt
KqarDA7b3Oae8RbRbu0Co5bHx8fCFz++RLR4vl6k5053gUL4Wo3ylEXuRHN5
+rmF+N1F7QGiX8CllSiNYwnM7vwoje37acS1i2jWTR6u/h2O/bwbz123Ymol
a53KpKtbbCtzpix0J8bmWetOhtz+SQREinqZ8FHspq0I91Xgdyt5mnqfSMVa
Vi5SFTOuR7dZltRP1JMMaDstcMF89Wwf99EjEfHStjL9b23JGj6a2+NrwZoZ
mVHS9YSCPcQaDLUjX/MROICH+Y2GcbZTxkO30MiIpnS06g6N0GRzQRTU2lZT
fhtWRm0E6Hdz0RzlWbtK7ZlAWivtQuvCGMc2CV8YU7WNElf50f0c8bPegqF9
muLp6Cb9wvmijJy6dXRVkop0c4heIC3C707iMySf7PO19CP1pumcsOSCeHqd
K+9ls9F/dWC9v+VwexQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{186, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->522570481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16792750],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is also ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17087428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"NumberQ", "[", "x", "]"}], ",", 
       RowBox[{"NumericQ", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"3", "/", "2"}], ",", "1.5", ",", 
         RowBox[{"1", "+", "I"}], ",", "E", ",", 
         RowBox[{"Sin", "[", "1", "]"}], ",", " ", 
         RowBox[{"Underflow", "[", "]"}], ",", 
         RowBox[{"Overflow", "[", "]"}], ",", "Infinity"}], "}"}]}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<NumberQ\>\"", ",", "\"\<NumericQ\>\""}],
        "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269347642],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlXMluFDEQdXqZURYCCtskkIUdIbFeCUJAgAtRQoRIOI4ipOSAQCEnxAXl
OyK+BObIMZ9k2j32tLu63G27Nw+MlHHKXS5XPdtVFVfDev9w7+On/uH+bn/l
9UH/y97+7teVV58Poi5/ghByEv0c90j0O41+i39OKI3akH37jI4/5I9B73b0
xUjWH0Yt8WO2+MP6vYgMojbgbc+Q/wI6K+PywOi3gCd+FI5ozhggkrJcHuC6
VKPsXmIhzhskvIRsWmnSychZrEjOgrX2Qn6AzMO08fnyMrHzluPMdo8YWWpl
M73ztUnGrdtBsBInDmIVcL18sZIW4y6qtchoPAW4bmlxXUdnYJ6nE5GTfDVv
A/omOsrEt5XvXeW6BLw9UnLJNNwTP9BRAn/V+rA9EyKtGCfPQhA5UIs5mj5b
Ps2eIuG9Vwx4F1Hr8B3vA519MKrIBr1Z5N70eciTfRZZhzzaI9lYcK0CGcv/
E56F0VUL0UIpJpiqe8VJGD9EWeeVUqNNTrlJr/AsUHKZmWxwFF5edw4MTVMZ
OZh2AC8d+uOhePHxaOKlMe8cIliI6OGhEot2N0RulIklUniPeCLmu2o9ckmN
UgbRHuCCo+YK7DsTdyZ01pM8KOS4j+orZ2nymp2j6QyDadiN2ke8fYhKazYL
egF0/K7kysP2Wy4u+H6Uc586cqJp2n5OZNzrSHyfQVbS9Xzpn8Z6rHIpNzMs
e5ybz7BGZyETjTyiwriNbAvD1P1sC3r2APSJsc3mXxBL1/KvU4DrNKBN87FJ
iu1v63wskPXNoj9NkxwsL0djfK7laPOSbqz9qeSC+Y9MH6OjZC+T7NP49j+U
8RPDMlGb4mfhLjWrJcg3sfYZGJZDoLSxp4P0PUBXWXW4jMmuJHPqOIxNtn6x
pIODZU7TPBJivE5tZAF5XjbbUN1J654bHVtHHqLSWgqGRoUZArBJFfWL/kbQ
WXsMf1izgfXMSqI58BZFsRm1pbAWdIPCE6x/fwLzL7jjRewTcTrkLZMoV5ZY
1cqVuG3SK87uJm0kbnbBWnLmd8jKOBrVKrWggdiD/B3CJpTfjBCaNRohFDhC
SzboeHp3huUWgnEbnliv7m7rRWHNfdw9IczQQm7PKm3yXhf1FBLdlWgm7Sl4
7tbNKRbnGS5WVrR6J1nLujR6+1eFBe7ctUFrZrntUOv2brWghhtxZ0JXWw9k
+sCK6mPq3t2SjWeWb5rZ4zXapkfO38NrCLe7/hjesT7XmdkpP1ydBU35XZZ/
MfIlIttd/wqzRqi9O34WahrviFr9LquksOHPqHv+VvjMgfKpTONcMFP4XYJL
polSLz1ZJjjs0CZjxgdAuxUFhiMHgwG3xY+/Ipo/X9eZudUooIVvo14e08gd
by5uL7dAf3teuwvoN+yrFi8NfQnb3cVeGur3S4lrG96snTxc/ncxzefdcO+6
5VOttHUqk7bXuKnMGdPQHR9bpK07GXL9NxHMU5TLhE9iM5vycEccvye8nUi4
Uu/5yJiLCkWqYkazXm6GJFUW+UaDjZ3SlNEl6veWhSxRZfBQC720LST7b2TR
mjw4A6NvzRocmnkWViQsNMmZE0VC86RL+wDZ5VumyNSPYnltTJGEfsYhDMXp
aAo7bL4qMVOc4dJ642//+ukemhcnK9p7GV6xS9C3p8zPsNKXbyIoECLjM1RB
fLIIDfvz3ufBtZuymrloHvaMWRwo58V32LasjdQ/C+i5Ylsk7jsGGryn2Nu0
s1zyeQriZoprGcgSXMOIOPz/LcjEX8lSBZs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{207, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->114938339]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->406],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachineNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complexes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complexes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25981],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->5191],

Cell[TextData[ButtonBox["Numeric Quantities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericQuantities"]], "Tutorials",
 CellID->99022765],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->29221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->170188653],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->222363556],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->44068741],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->131467508],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->41650864],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->185814651]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 21.7981314}", "context" -> "System`", 
    "keywords" -> {
     "testing for numbers", "testing for numerical expressions", 
      "testing for explicit numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberQ[expr] gives True if expr is a number, and False otherwise. ", 
    "synonyms" -> {"number q"}, "title" -> "NumberQ", "type" -> "Symbol", 
    "uri" -> "ref/NumberQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7613, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->310750947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42812, 1399}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3132, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3755, 94, 45, 1, 70, "ObjectName",
 CellID->17996],
Cell[3803, 97, 833, 28, 70, "Usage",
 CellID->4335]
}, Open  ]],
Cell[CellGroupData[{
Cell[4673, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5151, 147, 1132, 44, 70, "Notes",
 CellID->31587],
Cell[6286, 193, 493, 19, 70, "Notes",
 CellID->23714],
Cell[6782, 214, 794, 32, 70, "Notes",
 CellID->6146]
}, Closed]],
Cell[CellGroupData[{
Cell[7613, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->310750947],
Cell[CellGroupData[{
Cell[7998, 265, 148, 5, 70, "ExampleSection",
 CellID->916893125],
Cell[8149, 272, 223, 7, 70, "ExampleText",
 CellID->716711489],
Cell[CellGroupData[{
Cell[8397, 283, 105, 3, 28, "Input",
 CellID->180814792],
Cell[8505, 288, 161, 5, 36, "Output",
 CellID->409970793]
}, Open  ]],
Cell[CellGroupData[{
Cell[8703, 298, 102, 3, 28, "Input",
 CellID->59228498],
Cell[8808, 303, 161, 5, 36, "Output",
 CellID->84607703]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9018, 314, 220, 7, 70, "ExampleSection",
 CellID->318363455],
Cell[9241, 323, 134, 2, 70, "ExampleText",
 CellID->273705580],
Cell[CellGroupData[{
Cell[9400, 329, 134, 4, 70, "Input",
 CellID->130474613],
Cell[9537, 335, 162, 5, 36, "Output",
 CellID->607719064]
}, Open  ]],
Cell[9714, 343, 235, 8, 70, "ExampleText",
 CellID->101814091],
Cell[CellGroupData[{
Cell[9974, 355, 135, 4, 70, "Input",
 CellID->342289186],
Cell[10112, 361, 160, 5, 36, "Output",
 CellID->43428851]
}, Open  ]],
Cell[10287, 369, 237, 8, 70, "ExampleText",
 CellID->102776148],
Cell[CellGroupData[{
Cell[10549, 381, 162, 5, 70, "Input",
 CellID->52742820],
Cell[10714, 388, 161, 5, 36, "Output",
 CellID->739681119]
}, Open  ]],
Cell[10890, 396, 123, 3, 70, "ExampleDelimiter",
 CellID->4998635],
Cell[11016, 401, 464, 17, 70, "ExampleText",
 CellID->25821159],
Cell[CellGroupData[{
Cell[11505, 422, 110, 3, 70, "Input",
 CellID->473344795],
Cell[11618, 427, 162, 5, 36, "Output",
 CellID->267822531]
}, Open  ]],
Cell[11795, 435, 96, 1, 70, "ExampleText",
 CellID->351247013],
Cell[CellGroupData[{
Cell[11916, 440, 349, 13, 70, "Input",
 CellID->533166801],
Cell[12268, 455, 366, 7, 70, "Message",
 CellID->44694260],
Cell[12637, 464, 337, 11, 55, "Output",
 CellID->93915012]
}, Open  ]],
Cell[CellGroupData[{
Cell[13011, 480, 185, 6, 70, "Input",
 CellID->279106978],
Cell[13199, 488, 210, 7, 36, "Output",
 CellID->4609828]
}, Open  ]],
Cell[13424, 498, 125, 3, 70, "ExampleDelimiter",
 CellID->504557256],
Cell[13552, 503, 765, 30, 70, "ExampleText",
 CellID->784001930],
Cell[CellGroupData[{
Cell[14342, 537, 254, 9, 70, "Input",
 CellID->231427015],
Cell[14599, 548, 357, 7, 70, "Message",
 CellID->252166918],
Cell[14959, 557, 358, 7, 70, "Message",
 CellID->326353867],
Cell[15320, 566, 267, 9, 36, "Output",
 CellID->207717721]
}, Open  ]],
Cell[CellGroupData[{
Cell[15624, 580, 183, 6, 70, "Input",
 CellID->6260054],
Cell[15810, 588, 209, 7, 36, "Output",
 CellID->333986766]
}, Open  ]],
Cell[16034, 598, 200, 8, 70, "ExampleText",
 CellID->322818976],
Cell[CellGroupData[{
Cell[16259, 610, 179, 6, 70, "Input",
 CellID->450801283],
Cell[16441, 618, 210, 7, 36, "Output",
 CellID->1065377651]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16700, 631, 226, 7, 70, "ExampleSection",
 CellID->85185891],
Cell[16929, 640, 87, 1, 70, "ExampleText",
 CellID->1858491],
Cell[17019, 643, 345, 13, 70, "Input",
 CellID->34111778],
Cell[CellGroupData[{
Cell[17389, 660, 130, 4, 70, "Input",
 CellID->8319531],
Cell[17522, 666, 161, 5, 36, "Output",
 CellID->219986847]
}, Open  ]],
Cell[17698, 674, 125, 3, 70, "ExampleDelimiter",
 CellID->165038918],
Cell[17826, 679, 119, 3, 70, "ExampleText",
 CellID->426098183],
Cell[17948, 684, 980, 31, 70, "Input",
 CellID->155729885],
Cell[18931, 717, 88, 1, 70, "ExampleText",
 CellID->38971255],
Cell[CellGroupData[{
Cell[19044, 722, 99, 3, 70, "Input",
 CellID->641298237],
Cell[19146, 727, 187, 6, 36, "Output",
 CellID->172361189]
}, Open  ]],
Cell[19348, 736, 90, 1, 70, "ExampleText",
 CellID->579602523],
Cell[CellGroupData[{
Cell[19463, 741, 215, 7, 70, "Input",
 CellID->289480735],
Cell[19681, 750, 2339, 42, 70, "Output",
 Evaluatable->False,
 CellID->200251698]
}, Open  ]],
Cell[22035, 795, 432, 16, 70, "ExampleText",
 CellID->175230166],
Cell[CellGroupData[{
Cell[22492, 815, 707, 22, 70, "Input",
 CellID->51802404],
Cell[23202, 839, 275, 9, 36, "Output",
 CellID->223468468]
}, Open  ]],
Cell[23492, 851, 62, 1, 70, "ExampleText",
 CellID->183067520],
Cell[CellGroupData[{
Cell[23579, 856, 919, 28, 70, "Input",
 CellID->58859979],
Cell[24501, 886, 1000, 37, 71, "Output",
 CellID->108477818]
}, Open  ]],
Cell[CellGroupData[{
Cell[25538, 928, 186, 6, 70, "Input",
 CellID->452452644],
Cell[25727, 936, 4495, 78, 70, "Output",
 Evaluatable->False,
 CellID->218860964]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30271, 1020, 237, 7, 70, "ExampleSection",
 CellID->603710682],
Cell[30511, 1029, 516, 18, 70, "ExampleText",
 CellID->76531195],
Cell[CellGroupData[{
Cell[31052, 1051, 1110, 33, 70, "Input",
 CellID->342933585],
Cell[32165, 1086, 1952, 36, 70, "Output",
 Evaluatable->False,
 CellID->522570481]
}, Open  ]],
Cell[34132, 1125, 124, 3, 70, "ExampleDelimiter",
 CellID->16792750],
Cell[34259, 1130, 661, 27, 70, "ExampleText",
 CellID->17087428],
Cell[CellGroupData[{
Cell[34945, 1161, 924, 27, 70, "Input",
 CellID->269347642],
Cell[35872, 1190, 2029, 37, 70, "Output",
 Evaluatable->False,
 CellID->114938339]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37962, 1234, 309, 9, 70, "SeeAlsoSection",
 CellID->406],
Cell[38274, 1245, 1439, 53, 70, "SeeAlso",
 CellID->21442]
}, Open  ]],
Cell[CellGroupData[{
Cell[39750, 1303, 314, 9, 70, "TutorialsSection",
 CellID->25981],
Cell[40067, 1314, 140, 3, 70, "Tutorials",
 CellID->5191],
Cell[40210, 1319, 149, 3, 70, "Tutorials",
 CellID->99022765],
Cell[40362, 1324, 170, 3, 70, "Tutorials",
 CellID->29221]
}, Open  ]],
Cell[CellGroupData[{
Cell[40569, 1332, 319, 9, 70, "MoreAboutSection",
 CellID->170188653],
Cell[40891, 1343, 169, 3, 70, "MoreAbout",
 CellID->222363556],
Cell[41063, 1348, 133, 3, 70, "MoreAbout",
 CellID->44068741],
Cell[41199, 1353, 128, 3, 70, "MoreAbout",
 CellID->131467508],
Cell[41330, 1358, 159, 3, 70, "MoreAbout",
 CellID->41650864],
Cell[41492, 1363, 149, 3, 70, "MoreAbout",
 CellID->185814651]
}, Open  ]],
Cell[41656, 1369, 50, 0, 70, "History"],
Cell[41709, 1371, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

