(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10727,        375]
NotebookOptionsPosition[      7709,        277]
NotebookOutlinePosition[      9128,        316]
CellTagsIndexPosition[      9044,        311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Locale & Internationalization\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberSeparator", "ObjectName",
 CellID->6790],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberSeparator",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberSeparator"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which gives the string to insert at breaks \
between digits. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6812]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberSeparator", "->", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " specifies that the string ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " should be inserted at every break between digits specified by ",
 Cell[BoxData[
  ButtonBox["DigitBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitBlock"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32554],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberSeparator", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"sleft\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"sright\", \"TI\"]\)\>\""}], "}"}]}]], "InlineFormula"],
 " specifies different strings to be used on the left and right of the \
decimal point. "
}], "Notes",
 CellID->21317],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"NumberSeparator", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<,\>\"", ",", "\"\< \>\""}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->277]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146445682],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->84463747],

Cell["The default separator is a comma (,):", "ExampleText",
 CellID->366915694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121075417],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"265,252,859,812,191,058,636,308,480,000,000\"\>",
   265252859812191058636308480000000,
   Editable->False],
  NumberForm[#, DigitBlock -> 3]& ]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->111542713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64191683],

Cell["Use spaces instead:", "ExampleText",
 CellID->2769662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "\[Rule]", "3"}], ",", 
   RowBox[{"NumberSeparator", "\[Rule]", "\"\< \>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41250718],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"265 252 859 812 191 058 636 308 480 000 000\"\>",
   265252859812191058636308480000000,
   Editable->False],
  NumberForm[#, DigitBlock -> 3, NumberSeparator -> " "]& ]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->22911379]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10994],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->15968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->281750013],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->54881400],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->476768230]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberSeparator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 23.0325380}", "context" -> "System`", 
    "keywords" -> {
     "separators in number output", "number formatting", "numeric formatting",
       "number output", "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberSeparator is an option for NumberForm and related functions which \
gives the string to insert at breaks between digits. ", 
    "synonyms" -> {"number separator"}, "title" -> "NumberSeparator", "type" -> 
    "Symbol", "uri" -> "ref/NumberSeparator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4361, 149, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->146445682]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8901, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1472, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2095, 64, 52, 1, 70, "ObjectName",
 CellID->6790],
Cell[2150, 67, 645, 19, 70, "Usage",
 CellID->6812]
}, Open  ]],
Cell[CellGroupData[{
Cell[2832, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3310, 108, 445, 14, 70, "Notes",
 CellID->32554],
Cell[3758, 124, 346, 10, 70, "Notes",
 CellID->21317],
Cell[4107, 136, 217, 8, 70, "Notes",
 CellID->277]
}, Closed]],
Cell[CellGroupData[{
Cell[4361, 149, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146445682],
Cell[CellGroupData[{
Cell[4746, 163, 147, 5, 70, "ExampleSection",
 CellID->84463747],
Cell[4896, 170, 80, 1, 70, "ExampleText",
 CellID->366915694],
Cell[CellGroupData[{
Cell[5001, 175, 188, 6, 28, "Input",
 CellID->121075417],
Cell[5192, 183, 347, 10, 50, "Output",
 CellID->111542713]
}, Open  ]],
Cell[5554, 196, 124, 3, 70, "ExampleDelimiter",
 CellID->64191683],
Cell[5681, 201, 60, 1, 70, "ExampleText",
 CellID->2769662],
Cell[CellGroupData[{
Cell[5766, 206, 249, 7, 70, "Input",
 CellID->41250718],
Cell[6018, 215, 370, 10, 50, "Output",
 CellID->22911379]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6449, 232, 314, 9, 70, "TutorialsSection",
 CellID->10994],
Cell[6766, 243, 160, 3, 70, "Tutorials",
 CellID->15968]
}, Open  ]],
Cell[CellGroupData[{
Cell[6963, 251, 319, 9, 70, "MoreAboutSection",
 CellID->281750013],
Cell[7285, 262, 169, 3, 70, "MoreAbout",
 CellID->54881400],
Cell[7457, 267, 180, 3, 70, "MoreAbout",
 CellID->476768230]
}, Open  ]],
Cell[7652, 273, 27, 0, 70, "History"],
Cell[7682, 275, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

