(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13330,        485]
NotebookOptionsPosition[      9972,        376]
NotebookOutlinePosition[     11460,        416]
CellTagsIndexPosition[     11375,        411]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SignPadding" :> 
          Documentation`HelpLookup["paclet:ref/SignPadding"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SignPadding\"\>", 
       2->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberSigns", "ObjectName",
 CellID->26698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberSigns",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberSigns"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which gives strings to use as signs for negative \
and positive numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5017]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberSigns", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"sneg\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"spos\", \"TI\"]\)\>\""}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"sneg\", \"TI\"]\)\>\""], "InlineFormula"],
 " should be given as the sign for negative numbers, and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"spos\", \"TI\"]\)\>\""], "InlineFormula"],
 " for positive numbers. "
}], "Notes",
 CellID->1445],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"NumberSigns", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<-\>\"", ",", "\"\<\>\""}], "}"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->329970510]
}], "Notes",
 CellID->25227],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NumberSigns", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"snleft\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"snright\", \"TI\"]\)\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"spleft\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"spright\", \"TI\"]\)\>\""}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies strings to put both on the left and right of numbers to specify \
their signs. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->168947955]
}], "Notes",
 CellID->17896],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 ", the default setting is ",
 Cell[BoxData[
  RowBox[{"NumberSigns", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}], ",", "\"\<\>\""}], 
    "}"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->598820646]
}], "Notes",
 CellID->13334]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->199051374],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->652139],

Cell["Positive and negative numbers with default number signs:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->329970510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1234.567", ",", 
     RowBox[{"-", "2345.678"}]}], "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336676272],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"1234.6\"\>",
     1234.567,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"-2345.7\"\>",
     -2345.678,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 5]& ]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->28136473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219721432],

Cell["Add explicit positive signs:", "ExampleText",
 CellID->118293173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1234.567", ",", 
     RowBox[{"-", "2345.678"}]}], "}"}], ",", "5", ",", 
   RowBox[{"NumberSigns", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322867868],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"+1234.6\"\>",
     1234.567,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"-2345.7\"\>",
     -2345.678,
     AutoDelete->True]}], "}"}],
  NumberForm[#, 5, NumberSigns -> {"-", "+"}]& ]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->281184883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97230994],

Cell[TextData[{
 "Parentheses are used for negative values in ",
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->598820646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AccountingForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1234.567", ",", 
     RowBox[{"-", "2345.678"}]}], "}"}], ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178121526],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"1234.57\"\>",
     1234.567,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"(2345.68)\"\>",
     -2345.678,
     AutoDelete->True]}], "}"}],
  AccountingForm[#, 6]& ]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//AccountingForm=",
 CellID->83244931]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31371],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SignPadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SignPadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19826],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->3996]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberSigns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 23.8294334}", "context" -> "System`", 
    "keywords" -> {
     "negative sign formatting", "number sign in output", 
      "positive sign formatting", "sign formatting", "number formatting", 
      "numeric formatting", "number output", "number representation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumberSigns is an option for NumberForm and related functions which \
gives strings to use as signs for negative and positive numbers. ", 
    "synonyms" -> {"number signs"}, "title" -> "NumberSigns", "type" -> 
    "Symbol", "uri" -> "ref/NumberSigns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5140, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->199051374]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11232, 404}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1300, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1923, 60, 49, 1, 70, "ObjectName",
 CellID->26698],
Cell[1975, 63, 649, 19, 70, "Usage",
 CellID->5017]
}, Open  ]],
Cell[CellGroupData[{
Cell[2661, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3139, 104, 516, 15, 70, "Notes",
 CellID->1445],
Cell[3658, 121, 301, 11, 70, "Notes",
 CellID->25227],
Cell[3962, 134, 630, 19, 70, "Notes",
 CellID->17896],
Cell[4595, 155, 508, 19, 70, "Notes",
 CellID->13334]
}, Closed]],
Cell[CellGroupData[{
Cell[5140, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->199051374],
Cell[CellGroupData[{
Cell[5525, 193, 145, 5, 70, "ExampleSection",
 CellID->652139],
Cell[5673, 200, 147, 2, 70, "ExampleText",
 CellID->329970510],
Cell[CellGroupData[{
Cell[5845, 206, 213, 7, 28, "Input",
 CellID->336676272],
Cell[6061, 215, 401, 15, 50, "Output",
 CellID->28136473]
}, Open  ]],
Cell[6477, 233, 125, 3, 70, "ExampleDelimiter",
 CellID->219721432],
Cell[6605, 238, 71, 1, 70, "ExampleText",
 CellID->118293173],
Cell[CellGroupData[{
Cell[6701, 243, 330, 10, 70, "Input",
 CellID->322867868],
Cell[7034, 255, 430, 15, 50, "Output",
 CellID->281184883]
}, Open  ]],
Cell[7479, 273, 124, 3, 70, "ExampleDelimiter",
 CellID->97230994],
Cell[7606, 278, 288, 9, 70, "ExampleText",
 CellID->598820646],
Cell[CellGroupData[{
Cell[7919, 291, 217, 7, 70, "Input",
 CellID->178121526],
Cell[8139, 300, 412, 15, 50, "Output",
 CellID->83244931]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8612, 322, 311, 9, 70, "SeeAlsoSection",
 CellID->31371],
Cell[8926, 333, 461, 17, 70, "SeeAlso",
 CellID->17127]
}, Open  ]],
Cell[CellGroupData[{
Cell[9424, 355, 314, 9, 70, "TutorialsSection",
 CellID->19826],
Cell[9741, 366, 159, 3, 70, "Tutorials",
 CellID->3996]
}, Open  ]],
Cell[9915, 372, 27, 0, 70, "History"],
Cell[9945, 374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

