(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14152,        527]
NotebookOptionsPosition[     10394,        395]
NotebookOutlinePosition[     11700,        433]
CellTagsIndexPosition[     11615,        428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DigitCharacter" :> 
          Documentation`HelpLookup["paclet:ref/DigitCharacter"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], "NumberQ" :> 
          Documentation`HelpLookup["paclet:ref/NumberQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DigitCharacter\"\>", 
       2->"\<\"StringExpression\"\>", 
       3->"\<\"NumberQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Manipulation\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberString", "ObjectName",
 CellID->21448],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumberString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberString"]], "InlineFormula"],
     " \[LineSeparator]represents the characters of a number in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31974]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115128798],

Cell["Matches integers or decimal representations:", "ExampleText",
 CellID->595450273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1234\>\"", ",", "NumberString"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544366189],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155777716]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1.234\>\"", ",", "NumberString"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227682971],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->428711737]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15392],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberString"]], "InlineFormula"],
 " is not a sequence of ",
 Cell[BoxData[
  ButtonBox["DigitCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitCharacter"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->72454881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1.23\>\"", ",", "NumberString"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414304882],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237930270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1.23\>\"", ",", 
   RowBox[{"DigitCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1129639],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9525393]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29350],

Cell[TextData[{
 "Several ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " number representations are not ",
 Cell[BoxData[
  ButtonBox["NumberString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberString"]], "InlineFormula"],
 " patterns:"
}], "ExampleText",
 CellID->507201275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1*^2\>\"", ",", "NumberString"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283670277],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->868236642]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1.2`20\>\"", ",", "NumberString"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->587121911],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->475577248]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1*^2", ",", "1.2`20"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->733464336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "1.2`20."}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->751331694]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26352],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9545]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31728],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->932082477],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->326097406],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->564362744]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 24.2981954}", "context" -> "System`", 
    "keywords" -> {
     "AMPL conversion specification", "C format identifiers", 
      "number characters"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NumberString represents the characters of a number in StringExpression.",
     "synonyms" -> {"number string"}, "title" -> "NumberString", "type" -> 
    "Symbol", "uri" -> "ref/NumberString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3595, 108, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11480, 421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2288, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2911, 82, 50, 1, 70, "ObjectName",
 CellID->21448],
Cell[2964, 85, 594, 18, 70, "Usage",
 CellID->31974]
}, Open  ]],
Cell[CellGroupData[{
Cell[3595, 108, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3972, 122, 148, 5, 70, "ExampleSection",
 CellID->115128798],
Cell[4123, 129, 87, 1, 70, "ExampleText",
 CellID->595450273],
Cell[CellGroupData[{
Cell[4235, 134, 153, 4, 28, "Input",
 CellID->544366189],
Cell[4391, 140, 161, 5, 36, "Output",
 CellID->155777716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4589, 150, 154, 4, 28, "Input",
 CellID->227682971],
Cell[4746, 156, 161, 5, 36, "Output",
 CellID->428711737]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4956, 167, 233, 7, 70, "ExampleSection",
 CellID->15392],
Cell[5192, 176, 344, 12, 70, "ExampleText",
 CellID->72454881],
Cell[CellGroupData[{
Cell[5561, 192, 153, 4, 70, "Input",
 CellID->414304882],
Cell[5717, 198, 161, 5, 36, "Output",
 CellID->237930270]
}, Open  ]],
Cell[CellGroupData[{
Cell[5915, 208, 173, 5, 70, "Input",
 CellID->1129639],
Cell[6091, 215, 160, 5, 36, "Output",
 CellID->9525393]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6300, 226, 226, 7, 70, "ExampleSection",
 CellID->29350],
Cell[6529, 235, 294, 11, 70, "ExampleText",
 CellID->507201275],
Cell[CellGroupData[{
Cell[6848, 250, 153, 4, 70, "Input",
 CellID->283670277],
Cell[7004, 256, 162, 5, 36, "Output",
 CellID->868236642]
}, Open  ]],
Cell[CellGroupData[{
Cell[7203, 266, 155, 4, 70, "Input",
 CellID->587121911],
Cell[7361, 272, 162, 5, 36, "Output",
 CellID->475577248]
}, Open  ]],
Cell[CellGroupData[{
Cell[7560, 282, 123, 4, 70, "Input",
 CellID->733464336],
Cell[7686, 288, 212, 7, 36, "Output",
 CellID->751331694]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7959, 302, 311, 9, 70, "SeeAlsoSection",
 CellID->26352],
Cell[8273, 313, 721, 26, 70, "SeeAlso",
 CellID->9545]
}, Open  ]],
Cell[CellGroupData[{
Cell[9031, 344, 314, 9, 70, "TutorialsSection",
 CellID->31728],
Cell[9348, 355, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[9490, 360, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[9705, 369, 319, 9, 70, "MoreAboutSection",
 CellID->932082477],
Cell[10027, 380, 149, 3, 70, "MoreAbout",
 CellID->326097406],
Cell[10179, 385, 141, 3, 70, "MoreAbout",
 CellID->564362744]
}, Open  ]],
Cell[10335, 391, 29, 0, 70, "History"],
Cell[10367, 393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

