(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29032,       1142]
NotebookOptionsPosition[     21922,        890]
NotebookOutlinePosition[     23144,        925]
CellTagsIndexPosition[     23059,        920]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Picking Out Pieces of Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Picking Out Pieces of Algebraic Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Denominator" :> 
          Documentation`HelpLookup["paclet:ref/Denominator"], 
          "ExpandNumerator" :> 
          Documentation`HelpLookup["paclet:ref/ExpandNumerator"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Denominator\"\>", 
       2->"\<\"ExpandNumerator\"\>", 
       3->"\<\"Rational\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Formula Manipulation\"\>", 
       2->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerator", "ObjectName",
 CellID->14456],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Numerator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Numerator"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the numerator of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " picks out terms which do not have superficially negative exponents. ",
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " picks out the remaining terms. "
}], "Notes",
 CellID->11633],

Cell["\<\
An exponent is \"superficially negative\" if it has a negative number as a \
factor. \
\>", "Notes",
 CellID->18846],

Cell[TextData[{
 "The standard representation of rational expressions as products of powers \
means that you cannot simply use ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " to extract numerators. "
}], "Notes",
 CellID->13774],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " can be used on rational numbers. "
}], "Notes",
 CellID->13194]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->289880647],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->21986673],

Cell["Extract the numerator of a rational number:", "ExampleText",
 CellID->290113945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{"2", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->458387881],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329799669]
}, Open  ]],

Cell["Extract the numerator of a rational expression:", "ExampleText",
 CellID->52153719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9136498],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230238891]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11940],

Cell["Rational numbers:", "ExampleText",
 CellID->303603321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{"3", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->660797967],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->676472201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45153912],

Cell["Rational expressions:", "ExampleText",
 CellID->482547240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94199317],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145476036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762649483],

Cell["Select terms without syntactically negative exponents:", "ExampleText",
 CellID->436957419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"a", " ", 
   RowBox[{"x", "^", "n"}], " ", 
   RowBox[{"y", "^", 
    RowBox[{"-", "m"}]}], " ", 
   RowBox[{"Exp", "[", 
    RowBox[{"a", "-", "b", "-", 
     RowBox[{"2", "c"}], "+", 
     RowBox[{"3", "d"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220223837],

Cell[BoxData[
 RowBox[{"a", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"a", "-", "b", "-", 
    RowBox[{"2", " ", "c"}], "+", 
    RowBox[{"3", " ", "d"}]}]], " ", 
  SuperscriptBox["x", "n"], " ", 
  SuperscriptBox["y", 
   RowBox[{"-", "m"}]]}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161928948]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272874461],

Cell[BoxData[
 RowBox[{"a", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"a", "+", 
    RowBox[{"3", " ", "d"}]}]], " ", 
  SuperscriptBox["x", "n"]}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216014110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86008629],

Cell["All exponents syntactically negative:", "ExampleText",
 CellID->79184396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"-", "b"}]}], "/", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62513214],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226897293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434145890],

Cell["No syntactically negative exponents:", "ExampleText",
 CellID->177712008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{"2", 
   RowBox[{"x", "^", "y"}], " ", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28994944],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["b", "2"], " ", 
  SuperscriptBox["x", "y"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247599347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->919848036],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->27341965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "1", ",", "4", ",", "5", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22192271]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8481],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25048],

Cell[TextData[{
 "Find numerators over integers modulo ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->487210857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "x"}], "+", 
      RowBox[{
       RowBox[{"3", "/", "4"}], " ", "y"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "/", "5"}], "x"}], "-", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "y"}]}], ")"}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40258755],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", "x"}], "+", 
  RowBox[{"6", " ", "y"}]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->863515512]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18500],

Cell["Numerators of trigonometric functions:", "ExampleText",
 CellID->141797566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Tan", "[", "x", "]"}], ",", 
     RowBox[{"Csc", "[", "x", "]"}], ",", 
     RowBox[{"Sec", "[", "x", "]"}], ",", 
     RowBox[{"Cot", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127976950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "x", "]"}], ",", "1", ",", "1", ",", 
   RowBox[{"Cos", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263346963]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " gives the terms with negative exponents:"
}], "ExampleText",
 CellID->290280074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{"2", "/", "3"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64699991],

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39892098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114732552],

Cell["\<\
An expression is a quotient of its numerator and denominator:\
\>", "ExampleText",
 CellID->33907498],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"5", "/", "7"}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], 
    RowBox[{"a", "^", "b"}], " ", 
    RowBox[{"c", "^", 
     RowBox[{"-", "d"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49509921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"Numerator", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292824365],

Cell[BoxData[
 RowBox[{"5", " ", 
  SuperscriptBox["a", "b"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218271076]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"den", "=", 
  RowBox[{"Denominator", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->382232114],

Cell[BoxData[
 RowBox[{"7", " ", 
  SuperscriptBox["c", "d"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "3"]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->790465988]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "===", 
  RowBox[{"num", "/", "den"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->146923493],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->88946368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429618857],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " to cancel common factors between the numerator and the denominator:"
}], "ExampleText",
 CellID->23999272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876864933],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "x"}], 
  RowBox[{"1", "+", "x"}]]], "Output",
 ImageSize->{43, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100840501],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " writes an expression as a fraction and cancels common terms:"
}], "ExampleText",
 CellID->348414279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"x", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "+", 
   RowBox[{"x", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "-", 
   RowBox[{"2", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61962394],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "x"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}]]], "Output",
 ImageSize->{43, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107709353]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28732],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Denominator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Denominator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandNumerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandNumerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10046]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9760],

Cell[TextData[ButtonBox["Picking Out Pieces of Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]], "Tutorials",
 CellID->13041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->188326581],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->332486288],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->317204266]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 24.7982082}", "context" -> "System`", 
    "keywords" -> {"fractions", "numer", "numerator", "top of fraction"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Numerator[expr] gives the numerator of expr. ", "synonyms" -> {}, 
    "title" -> "Numerator", "type" -> "Symbol", "uri" -> "ref/Numerator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5005, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->289880647]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22916, 913}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2197, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2820, 81, 47, 1, 70, "ObjectName",
 CellID->14456],
Cell[2870, 84, 548, 18, 70, "Usage",
 CellID->9245]
}, Open  ]],
Cell[CellGroupData[{
Cell[3455, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3933, 124, 400, 12, 70, "Notes",
 CellID->11633],
Cell[4336, 138, 126, 4, 70, "Notes",
 CellID->18846],
Cell[4465, 144, 297, 9, 70, "Notes",
 CellID->13774],
Cell[4765, 155, 203, 7, 70, "Notes",
 CellID->13194]
}, Closed]],
Cell[CellGroupData[{
Cell[5005, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->289880647],
Cell[CellGroupData[{
Cell[5390, 181, 147, 5, 70, "ExampleSection",
 CellID->21986673],
Cell[5540, 188, 86, 1, 70, "ExampleText",
 CellID->290113945],
Cell[CellGroupData[{
Cell[5651, 193, 128, 4, 28, "Input",
 CellID->458387881],
Cell[5782, 199, 158, 5, 36, "Output",
 CellID->329799669]
}, Open  ]],
Cell[5955, 207, 89, 1, 70, "ExampleText",
 CellID->52153719],
Cell[CellGroupData[{
Cell[6069, 212, 323, 12, 28, "Input",
 CellID->9136498],
Cell[6395, 226, 315, 12, 36, "Output",
 CellID->230238891]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6759, 244, 216, 7, 70, "ExampleSection",
 CellID->11940],
Cell[6978, 253, 60, 1, 70, "ExampleText",
 CellID->303603321],
Cell[CellGroupData[{
Cell[7063, 258, 128, 4, 70, "Input",
 CellID->660797967],
Cell[7194, 264, 158, 5, 36, "Output",
 CellID->676472201]
}, Open  ]],
Cell[7367, 272, 124, 3, 70, "ExampleDelimiter",
 CellID->45153912],
Cell[7494, 277, 64, 1, 70, "ExampleText",
 CellID->482547240],
Cell[CellGroupData[{
Cell[7583, 282, 352, 13, 70, "Input",
 CellID->94199317],
Cell[7938, 297, 248, 9, 36, "Output",
 CellID->145476036]
}, Open  ]],
Cell[8201, 309, 125, 3, 70, "ExampleDelimiter",
 CellID->762649483],
Cell[8329, 314, 97, 1, 70, "ExampleText",
 CellID->436957419],
Cell[CellGroupData[{
Cell[8451, 319, 324, 11, 70, "Input",
 CellID->220223837],
Cell[8778, 332, 400, 13, 36, "Output",
 CellID->161928948]
}, Open  ]],
Cell[CellGroupData[{
Cell[9215, 350, 108, 3, 70, "Input",
 CellID->272874461],
Cell[9326, 355, 301, 10, 36, "Output",
 CellID->216014110]
}, Open  ]],
Cell[9642, 368, 124, 3, 70, "ExampleDelimiter",
 CellID->86008629],
Cell[9769, 373, 79, 1, 70, "ExampleText",
 CellID->79184396],
Cell[CellGroupData[{
Cell[9873, 378, 171, 6, 70, "Input",
 CellID->62513214],
Cell[10047, 386, 158, 5, 36, "Output",
 CellID->226897293]
}, Open  ]],
Cell[10220, 394, 125, 3, 70, "ExampleDelimiter",
 CellID->434145890],
Cell[10348, 399, 79, 1, 70, "ExampleText",
 CellID->177712008],
Cell[CellGroupData[{
Cell[10452, 404, 180, 6, 70, "Input",
 CellID->28994944],
Cell[10635, 412, 238, 8, 36, "Output",
 CellID->247599347]
}, Open  ]],
Cell[10888, 423, 125, 3, 70, "ExampleDelimiter",
 CellID->919848036],
Cell[11016, 428, 212, 7, 70, "ExampleText",
 CellID->27341965],
Cell[CellGroupData[{
Cell[11253, 439, 217, 7, 70, "Input",
 CellID->25086],
Cell[11473, 448, 246, 8, 36, "Output",
 CellID->22192271]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11768, 462, 217, 7, 70, "ExampleSection",
 CellID->8481],
Cell[CellGroupData[{
Cell[12010, 473, 224, 7, 70, "ExampleSubsection",
 CellID->25048],
Cell[12237, 482, 158, 6, 70, "ExampleText",
 CellID->487210857],
Cell[CellGroupData[{
Cell[12420, 492, 499, 18, 70, "Input",
 CellID->40258755],
Cell[12922, 512, 226, 8, 36, "Output",
 CellID->863515512]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13197, 526, 221, 7, 70, "ExampleSubsection",
 CellID->18500],
Cell[13421, 535, 81, 1, 70, "ExampleText",
 CellID->141797566],
Cell[CellGroupData[{
Cell[13527, 540, 451, 13, 70, "Input",
 CellID->127976950],
Cell[13981, 555, 368, 11, 36, "Output",
 CellID->263346963]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14410, 573, 233, 7, 70, "ExampleSection",
 CellID->19413],
Cell[14646, 582, 224, 7, 70, "ExampleText",
 CellID->290280074],
Cell[CellGroupData[{
Cell[14895, 593, 274, 10, 70, "Input",
 CellID->64699991],
Cell[15172, 605, 246, 9, 36, "Output",
 CellID->39892098]
}, Open  ]],
Cell[15433, 617, 125, 3, 70, "ExampleDelimiter",
 CellID->114732552],
Cell[15561, 622, 111, 3, 70, "ExampleText",
 CellID->33907498],
Cell[15675, 627, 429, 16, 70, "Input",
 CellID->49509921],
Cell[CellGroupData[{
Cell[16129, 647, 133, 4, 70, "Input",
 CellID->292824365],
Cell[16265, 653, 308, 11, 36, "Output",
 CellID->218271076]
}, Open  ]],
Cell[CellGroupData[{
Cell[16610, 669, 135, 4, 70, "Input",
 CellID->382232114],
Cell[16748, 675, 308, 11, 36, "Output",
 CellID->790465988]
}, Open  ]],
Cell[CellGroupData[{
Cell[17093, 691, 124, 4, 70, "Input",
 CellID->146923493],
Cell[17220, 697, 160, 5, 36, "Output",
 CellID->88946368]
}, Open  ]],
Cell[17395, 705, 125, 3, 70, "ExampleDelimiter",
 CellID->429618857],
Cell[17523, 710, 249, 8, 70, "ExampleText",
 CellID->23999272],
Cell[CellGroupData[{
Cell[17797, 722, 322, 12, 70, "Input",
 CellID->876864933],
Cell[18122, 736, 240, 9, 51, "Output",
 CellID->407405]
}, Open  ]],
Cell[18377, 748, 125, 3, 70, "ExampleDelimiter",
 CellID->100840501],
Cell[18505, 753, 238, 7, 70, "ExampleText",
 CellID->348414279],
Cell[CellGroupData[{
Cell[18768, 764, 518, 19, 70, "Input",
 CellID->61962394],
Cell[19289, 785, 262, 10, 51, "Output",
 CellID->107709353]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19612, 802, 311, 9, 70, "SeeAlsoSection",
 CellID->28732],
Cell[19926, 813, 716, 26, 70, "SeeAlso",
 CellID->10046]
}, Open  ]],
Cell[CellGroupData[{
Cell[20679, 844, 313, 9, 70, "TutorialsSection",
 CellID->9760],
Cell[20995, 855, 195, 4, 70, "Tutorials",
 CellID->13041]
}, Open  ]],
Cell[CellGroupData[{
Cell[21227, 864, 319, 9, 70, "MoreAboutSection",
 CellID->188326581],
Cell[21549, 875, 151, 3, 70, "MoreAbout",
 CellID->332486288],
Cell[21703, 880, 147, 3, 70, "MoreAbout",
 CellID->317204266]
}, Open  ]],
Cell[21865, 886, 27, 0, 70, "History"],
Cell[21895, 888, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

