(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33229,       1086]
NotebookOptionsPosition[     27438,        887]
NotebookOutlinePosition[     28843,        925]
CellTagsIndexPosition[     28758,        920]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Numeric Quantities" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericQuantities"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Numeric Quantities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumericQ" :> Documentation`HelpLookup["paclet:ref/NumericQ"], 
          "NHoldAll" :> Documentation`HelpLookup["paclet:ref/NHoldAll"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NumericQ\"\>", 2->"\<\"NHoldAll\"\>", 
       3->"\<\"N\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumericFunction", "ObjectName",
 CellID->9389],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NumericFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
     "\[LineSeparator]is an attribute that can be assigned to a symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to indicate that ",
     Cell[BoxData[
      RowBox[{"f", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["arg", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["arg", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " should be considered a numeric quantity whenever all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["arg", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are numeric quantities. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Most standard built\[Hyphen]in mathematical functions have the attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19598],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " checks the ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " attribute of every function it encounters. "
}], "Notes",
 CellID->7994],

Cell[TextData[{
 "If you assign the attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " to a function that does not yield numerical values, then ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " will give misleading results. "
}], "Notes",
 CellID->16999]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121290716],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->51047976],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " attribute: "
}], "ExampleText",
 CellID->429994606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Log", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247543514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266977444]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " has an argument that is a number, constant, or numeric, the result is \
numeric:"
}], "ExampleText",
 CellID->716626588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Log", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67181600],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176748488]
}, Open  ]],

Cell[TextData[{
 "In most cases when ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " yields an explicit number. "
}], "ExampleText",
 CellID->44049391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Log", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->592514106],

Cell[BoxData["0.6931471805599453`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->70895639]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25288374],

Cell["Define f to be a numeric function:", "ExampleText",
 CellID->161293336],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NumericFunction"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173788360],

Cell[TextData[{
 "If you have not assigned f to yield numerical values, then ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " gives misleading results:"
}], "ExampleText",
 CellID->212151522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"f", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610059608],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->684374351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->533724692],

Cell[BoxData[
 RowBox[{"f", "[", "2.`", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->586234528]
}, Open  ]],

Cell["\<\
Assign f to evaluate for arguments that are approximate numbers:\
\>", "ExampleText",
 CellID->885711757],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"InexactNumberQ", "[", "#", "]"}], "&"}], ")"}]}], "]"}], ":=", 
  
  RowBox[{
   RowBox[{"Precision", "[", "x", "]"}], "-", 
   RowBox[{"Accuracy", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->348046418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->377359870],

Cell[BoxData["0.3010299956639795`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->517895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236789586],

Cell["The system symbols that are numeric functions:", "ExampleText",
 CellID->229804501],

Cell[BoxData[
 RowBox[{
  RowBox[{"ssymb", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], "]"}], ",", 
     "_Symbol"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90761623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nfuns", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"ssymb", ",", 
    RowBox[{
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Attributes", "[", "#", "]"}], ",", "NumericFunction"}], "]"}],
      "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37578381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Abs", ",", "AiryAi", ",", "AiryAiPrime", ",", "AiryAiZero", ",", "AiryBi", 
   ",", "AiryBiPrime", ",", "AiryBiZero", ",", "AppellF1", ",", "ArcCos", ",",
    "ArcCosh", ",", "ArcCot", ",", "ArcCoth", ",", "ArcCsc", ",", "ArcCsch", 
   ",", "ArcSec", ",", "ArcSech", ",", "ArcSin", ",", "ArcSinh", ",", 
   "ArcTan", ",", "ArcTanh", ",", "Arg", ",", "ArithmeticGeometricMean", ",", 
   "BellB", ",", "BesselI", ",", "BesselJ", ",", "BesselJZero", ",", 
   "BesselK", ",", "BesselY", ",", "BesselYZero", ",", "Beta", ",", 
   "BetaRegularized", ",", "Binomial", ",", "CatalanNumber", ",", "Ceiling", 
   ",", "ChebyshevT", ",", "ChebyshevU", ",", "Clip", ",", "Conjugate", ",", 
   "Cos", ",", "Cosh", ",", "CoshIntegral", ",", "CosIntegral", ",", "Cot", 
   ",", "Coth", ",", "Csc", ",", "Csch", ",", "DedekindEta", ",", "Divide", 
   ",", "EllipticE", ",", "EllipticF", ",", "EllipticK", ",", "EllipticNomeQ",
    ",", "EllipticPi", ",", "Erf", ",", "Erfc", ",", "Erfi", ",", "Exp", ",", 
   "ExpIntegralE", ",", "ExpIntegralEi", ",", "Factorial", ",", "Factorial2", 
   ",", "Fibonacci", ",", "Floor", ",", "FractionalPart", ",", "FresnelC", 
   ",", "FresnelS", ",", "Gamma", ",", "GammaRegularized", ",", "GegenbauerC",
    ",", "HankelH1", ",", "HankelH2", ",", "HarmonicNumber", ",", "HermiteH", 
   ",", "Hypergeometric0F1", ",", "Hypergeometric0F1Regularized", ",", 
   "Hypergeometric1F1", ",", "Hypergeometric1F1Regularized", ",", 
   "Hypergeometric2F1", ",", "Hypergeometric2F1Regularized", ",", 
   "HypergeometricU", ",", "Im", ",", "IntegerPart", ",", 
   "InverseBetaRegularized", ",", "InverseEllipticNomeQ", ",", "InverseErf", 
   ",", "InverseErfc", ",", "InverseGammaRegularized", ",", "InverseJacobiCD",
    ",", "InverseJacobiCN", ",", "InverseJacobiCS", ",", "InverseJacobiDC", 
   ",", "InverseJacobiDN", ",", "InverseJacobiDS", ",", "InverseJacobiNC", 
   ",", "InverseJacobiND", ",", "InverseJacobiNS", ",", "InverseJacobiSC", 
   ",", "InverseJacobiSD", ",", "InverseJacobiSN", ",", "JacobiAmplitude", 
   ",", "JacobiCD", ",", "JacobiCN", ",", "JacobiCS", ",", "JacobiDC", ",", 
   "JacobiDN", ",", "JacobiDS", ",", "JacobiNC", ",", "JacobiND", ",", 
   "JacobiNS", ",", "JacobiP", ",", "JacobiSC", ",", "JacobiSD", ",", 
   "JacobiSN", ",", "JacobiZeta", ",", "KelvinBei", ",", "KelvinBer", ",", 
   "KelvinKei", ",", "KelvinKer", ",", "KleinInvariantJ", ",", "LaguerreL", 
   ",", "LerchPhi", ",", "Log", ",", "LogGamma", ",", "LogIntegral", ",", 
   "LucasL", ",", "MathieuC", ",", "MathieuCharacteristicA", ",", 
   "MathieuCharacteristicB", ",", "MathieuCharacteristicExponent", ",", 
   "MathieuCPrime", ",", "MathieuS", ",", "MathieuSPrime", ",", "Max", ",", 
   "Min", ",", "Minus", ",", "Mod", ",", "ModularLambda", ",", "Multinomial", 
   ",", "NevilleThetaC", ",", "NevilleThetaD", ",", "NevilleThetaN", ",", 
   "NevilleThetaS", ",", "ParabolicCylinderD", ",", "Plus", ",", "Pochhammer",
    ",", "PolyGamma", ",", "PolyLog", ",", "Power", ",", "Quotient", ",", 
   "QuotientRemainder", ",", "RamanujanTau", ",", "RamanujanTauL", ",", 
   "RamanujanTauTheta", ",", "RamanujanTauZ", ",", "Re", ",", "Rescale", ",", 
   "RiemannSiegelTheta", ",", "RiemannSiegelZ", ",", "Round", ",", "Sec", ",",
    "Sech", ",", "SiegelTheta", ",", "Sign", ",", "Sin", ",", "Sinc", ",", 
   "Sinh", ",", "SinhIntegral", ",", "SinIntegral", ",", "SphericalBesselJ", 
   ",", "SphericalBesselY", ",", "SphericalHankelH1", ",", 
   "SphericalHankelH2", ",", "SphericalHarmonicY", ",", 
   "SpheroidalEigenvalue", ",", "SpheroidalJoiningFactor", ",", 
   "SpheroidalPS", ",", "SpheroidalPSPrime", ",", "SpheroidalQS", ",", 
   "SpheroidalQSPrime", ",", "SpheroidalRadialFactor", ",", "SpheroidalS1", 
   ",", "SpheroidalS1Prime", ",", "SpheroidalS2", ",", "SpheroidalS2Prime", 
   ",", "Sqrt", ",", "StruveH", ",", "StruveL", ",", "Subfactorial", ",", 
   "Subtract", ",", "Tan", ",", "Tanh", ",", "Times", ",", "UnitStep", ",", 
   "WhittakerM", ",", "WhittakerW", ",", "Zeta", ",", "ZetaZero"}], 
  "}"}]], "Output",
 ImageSize->{576, 543},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299969835]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->729384577],

Cell["Define a function that can represent an exact value:", "ExampleText",
 CellID->669143867],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "NumericFunction"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14842144],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["a", "TI"], "]"}], "]"}]], "InlineFormula"],
 " to give the derivative with respect to a of the solution of an ODE at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->621332927],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"f", "[", "a_", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"prec_", ",", " ", "acc_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "t", ",", 
      RowBox[{"wp", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"prec", "\[Equal]", "MachinePrecision"}], ",", "prec", ",", 
         RowBox[{"2", "*", "prec"}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"xa", "[", "1", "]"}], "/.", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"Sin", "[", 
             RowBox[{"a", " ", 
              RowBox[{"x", "[", "t", "]"}]}], "]"}]}], "\[Equal]", "0"}], ",",
           
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"xa", "''"}], "[", "t", "]"}], "+", 
            RowBox[{
             RowBox[{"x", "[", "t", "]"}], 
             RowBox[{"Cos", "[", 
              RowBox[{"a", " ", 
               RowBox[{"x", "[", "t", "]"}]}], "]"}]}]}], "\[Equal]", "0"}], 
          ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"xa", "[", "0", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"xa", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "xa"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "wp"}], ",", 
        RowBox[{"Method", "\[Rule]", "\"\<Extrapolation\>\""}]}], "]"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->671501080],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " for approximate numbers:"
}], "ExampleText",
 CellID->27136997],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"InexactNumberQ", "[", "#", "]"}], "&"}], ")"}]}], "]"}], ":=", 
  
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "t"}], "}"}], ",", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"xa", "[", "1", "]"}], "/.", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"Sin", "[", 
             RowBox[{"a", " ", 
              RowBox[{"x", "[", "t", "]"}]}], "]"}]}], "\[Equal]", "0"}], ",",
           
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"xa", "''"}], "[", "t", "]"}], "+", 
            RowBox[{
             RowBox[{"x", "[", "t", "]"}], 
             RowBox[{"Cos", "[", 
              RowBox[{"a", " ", 
               RowBox[{"x", "[", "t", "]"}]}], "]"}]}]}], "\[Equal]", "0"}], 
          ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", 
           RowBox[{"xa", "[", "0", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"xa", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "xa"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", 
         RowBox[{"Precision", "[", "a", "]"}]}], ",", 
        RowBox[{"Method", "\[Rule]", "\"\<Extrapolation\>\""}]}], "]"}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->336402460],

Cell[TextData[{
 StyleBox["f[1]", "MR"],
 " does not evaluate but represents a number:"
}], "ExampleText",
 CellID->3114602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"NumericQ", "[", 
    RowBox[{"f", "[", "1", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24620270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->764453578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->549765998],

Cell[BoxData[
 RowBox[{"-", "0.27448802932240157`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->16470122]
}, Open  ]],

Cell["It will work with any precision (within reasonable limits!):", \
"ExampleText",
 CellID->234329454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", "32"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->58410729],

Cell[BoxData[
 RowBox[{"-", 
  "0.274488029329347665204473857170941866148409875211`32."}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->161867638]
}, Open  ]],

Cell["A plot of the function:", "ExampleText",
 CellID->65009173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->99449132],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->465966900]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1618],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31483]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12926],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->5075],

Cell[TextData[ButtonBox["Numeric Quantities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericQuantities"]], "Tutorials",
 CellID->24504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->127094074]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumericFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 25.7044814}", "context" -> "System`", 
    "keywords" -> {"numeric quantities", "numerical functions"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NumericFunction is an attribute that can be assigned to a symbol f to \
indicate that f[arg_1, arg_2, ...] should be considered a numeric quantity \
whenever all the arg_i are numeric quantities. ", 
    "synonyms" -> {"numeric function"}, "title" -> "NumericFunction", "type" -> 
    "Symbol", "uri" -> "ref/NumericFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5333, 175, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->121290716]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28615, 913}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1981, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2604, 76, 52, 1, 70, "ObjectName",
 CellID->9389],
Cell[2659, 79, 1068, 32, 70, "Usage",
 CellID->30870]
}, Open  ]],
Cell[CellGroupData[{
Cell[3764, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4242, 133, 261, 8, 70, "Notes",
 CellID->19598],
Cell[4506, 143, 360, 12, 70, "Notes",
 CellID->7994],
Cell[4869, 157, 427, 13, 70, "Notes",
 CellID->16999]
}, Closed]],
Cell[CellGroupData[{
Cell[5333, 175, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121290716],
Cell[CellGroupData[{
Cell[5718, 189, 147, 5, 70, "ExampleSection",
 CellID->51047976],
Cell[5868, 196, 326, 12, 70, "ExampleText",
 CellID->429994606],
Cell[CellGroupData[{
Cell[6219, 212, 108, 3, 28, "Input",
 CellID->247543514],
Cell[6330, 217, 272, 9, 36, "Output",
 CellID->266977444]
}, Open  ]],
Cell[6617, 229, 258, 9, 70, "ExampleText",
 CellID->716626588],
Cell[CellGroupData[{
Cell[6900, 242, 133, 4, 28, "Input",
 CellID->67181600],
Cell[7036, 248, 161, 5, 36, "Output",
 CellID->176748488]
}, Open  ]],
Cell[7212, 256, 576, 22, 70, "ExampleText",
 CellID->44049391],
Cell[CellGroupData[{
Cell[7813, 282, 127, 4, 70, "Input",
 CellID->592514106],
Cell[7943, 288, 175, 5, 36, "Output",
 CellID->70895639]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8167, 299, 219, 7, 70, "ExampleSection",
 CellID->25288374],
Cell[8389, 308, 77, 1, 70, "ExampleText",
 CellID->161293336],
Cell[8469, 311, 146, 4, 70, "Input",
 CellID->173788360],
Cell[8618, 317, 267, 8, 70, "ExampleText",
 CellID->212151522],
Cell[CellGroupData[{
Cell[8910, 329, 132, 4, 70, "Input",
 CellID->610059608],
Cell[9045, 335, 161, 5, 36, "Output",
 CellID->684374351]
}, Open  ]],
Cell[CellGroupData[{
Cell[9243, 345, 125, 4, 70, "Input",
 CellID->533724692],
Cell[9371, 351, 187, 6, 36, "Output",
 CellID->586234528]
}, Open  ]],
Cell[9573, 360, 115, 3, 70, "ExampleText",
 CellID->885711757],
Cell[9691, 365, 336, 12, 70, "Input",
 CellID->348046418],
Cell[CellGroupData[{
Cell[10052, 381, 125, 4, 70, "Input",
 CellID->377359870],
Cell[10180, 387, 173, 5, 36, "Output",
 CellID->517895]
}, Open  ]],
Cell[10368, 395, 125, 3, 70, "ExampleDelimiter",
 CellID->236789586],
Cell[10496, 400, 89, 1, 70, "ExampleText",
 CellID->229804501],
Cell[10588, 403, 306, 10, 70, "Input",
 CellID->90761623],
Cell[CellGroupData[{
Cell[10919, 417, 302, 10, 70, "Input",
 CellID->37578381],
Cell[11224, 429, 4211, 62, 564, "Output",
 CellID->299969835]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15484, 497, 227, 7, 70, "ExampleSection",
 CellID->729384577],
Cell[15714, 506, 95, 1, 70, "ExampleText",
 CellID->669143867],
Cell[15812, 509, 164, 5, 70, "Input",
 CellID->14842144],
Cell[15979, 516, 442, 16, 70, "ExampleText",
 CellID->621332927],
Cell[16424, 534, 1985, 58, 70, "Input",
 CellID->671501080],
Cell[18412, 594, 151, 6, 70, "ExampleText",
 CellID->27136997],
Cell[18566, 602, 1826, 55, 70, "Input",
 CellID->336402460],
Cell[20395, 659, 124, 4, 70, "ExampleText",
 CellID->3114602],
Cell[CellGroupData[{
Cell[20544, 667, 209, 7, 70, "Input",
 CellID->24620270],
Cell[20756, 676, 235, 8, 36, "Output",
 CellID->764453578]
}, Open  ]],
Cell[CellGroupData[{
Cell[21028, 689, 125, 4, 70, "Input",
 CellID->549765998],
Cell[21156, 695, 193, 6, 36, "Output",
 CellID->16470122]
}, Open  ]],
Cell[21364, 704, 105, 2, 70, "ExampleText",
 CellID->234329454],
Cell[CellGroupData[{
Cell[21494, 710, 149, 5, 70, "Input",
 CellID->58410729],
Cell[21646, 717, 232, 7, 36, "Output",
 CellID->161867638]
}, Open  ]],
Cell[21893, 727, 65, 1, 70, "ExampleText",
 CellID->65009173],
Cell[CellGroupData[{
Cell[21983, 732, 211, 7, 70, "Input",
 CellID->99449132],
Cell[22197, 741, 3009, 53, 70, "Output",
 Evaluatable->False,
 CellID->465966900]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25267, 801, 310, 9, 70, "SeeAlsoSection",
 CellID->1618],
Cell[25580, 812, 682, 26, 70, "SeeAlso",
 CellID->31483]
}, Open  ]],
Cell[CellGroupData[{
Cell[26299, 843, 314, 9, 70, "TutorialsSection",
 CellID->12926],
Cell[26616, 854, 130, 3, 70, "Tutorials",
 CellID->5075],
Cell[26749, 859, 146, 3, 70, "Tutorials",
 CellID->24504]
}, Open  ]],
Cell[CellGroupData[{
Cell[26932, 867, 299, 8, 70, "MoreAboutSection"],
Cell[27234, 877, 132, 3, 70, "MoreAbout",
 CellID->127094074]
}, Open  ]],
Cell[27381, 883, 27, 0, 70, "History"],
Cell[27411, 885, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

