(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27212,       1033]
NotebookOptionsPosition[     21936,        842]
NotebookOutlinePosition[     23241,        879]
CellTagsIndexPosition[     23156,        874]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfPowerSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Representation of Power Series\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "SeriesData" :> Documentation`HelpLookup["paclet:ref/SeriesData"], 
          "Normal" :> Documentation`HelpLookup["paclet:ref/Normal"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Series\"\>", 
       2->"\<\"SeriesData\"\>", 3->"\<\"Normal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["O", "ObjectName",
 CellID->28890],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"O", "[", 
        StyleBox["x", "TI"], "]"}], "^", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]represents a term of order ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"O", "[", 
        StyleBox["x", "TI"], "]"}], "^", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]is generated to represent omitted higher\[Hyphen]order \
terms in power series. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"O", "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], "]"}], "^", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]represents a term of order ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], ")"}], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9131]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " can be used to truncate power series, and remove ",
 Cell[BoxData[
  ButtonBox["O",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/O"]], "InlineFormula"],
 " terms. "
}], "Notes",
 CellID->9227]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67603945],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61917531],

Cell["A series representing an approximate function: ", "ExampleText",
 CellID->32570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "/", "2"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28651],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 
    Rational[1, 2]}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{92, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18152]
}, Open  ]],

Cell["\<\
Doing operations on the approximate function maintains the appropriate series \
order:\
\>", "ExampleText",
 CellID->28468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Exp", "[", "%", "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13626],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "2"], "-", 
   FractionBox["x", "4"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "8"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "48"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "32"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "5"]}], "960"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "384"], "-", 
   FractionBox[
    RowBox[{"403", " ", 
     SuperscriptBox["x", "7"]}], "80640"], "-", 
   FractionBox[
    RowBox[{"43", " ", 
     SuperscriptBox["x", "8"]}], "23040"], "+", 
   FractionBox[
    RowBox[{"1261", " ", 
     SuperscriptBox["x", "9"]}], "2903040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[x, 0, {
    Rational[1, 2], 
    Rational[-1, 4], 
    Rational[-1, 8], 
    Rational[1, 48], 
    Rational[1, 32], 
    Rational[13, 960], 
    Rational[-1, 384], 
    Rational[-403, 80640], 
    Rational[-43, 23040], 
    Rational[1261, 2903040]}, 0, 10, 1],
  Editable->False]], "Output",
 ImageSize->{443, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4696]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25451],

Cell["\<\
Like approximate numbers, approximate functions are contagious:\
\>", "ExampleText",
 CellID->21721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "6"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2793],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "2"}], "+", "1.3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20735],

Cell[BoxData["11.169604401089359`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6739],

Cell["O can be used to drop higher-order terms:", "ExampleText",
 CellID->1443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", "^", "10"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17382],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[FrontEnd`Cell1675`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[FrontEnd`Cell1675`x, 0, {1}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9269]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7924],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
 " represents a term with expansion point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", 
    RowBox[{"x", ",", "1"}], "]"}], "^", "5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5389],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[ExponentialE]", "+", 
   RowBox[{"\[ExponentialE]", " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "5"],
    SeriesData[x, 1, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[
  x, 1, {E, E, Rational[1, 2] E, Rational[1, 6] E, Rational[1, 24] E}, 0, 5, 
   1],
  Editable->False]], "Output",
 ImageSize->{396, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32183],

Cell[TextData[{
 "With expansion point \[Infinity], the effective variable is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "x"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->19685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], "+", 
  RowBox[{
   RowBox[{"O", "[", 
    RowBox[{"x", ",", "Infinity"}], "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14936],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttu00AQ3cR2SgktL01blUtSWtSnChT4BnjiI6IKqX1AoNL/ywfAPxmP
vSnLySS7M75kkRwptmf3zH08u7b8ZfFw+/Xb4uHuZjH7fL/4cXt383P26ft9
MZQMjBn8MsZMT01xnRdX5Z9+v4t/dVld7RfHYTE5tOd3Qvp9Tf5roCelVRkd
k5XNeTlr0r/0OuIySo63UVol57haQxyXpxRwRFMW92D8zY5wF5Hbd2XHT/po
NoCb2vGRM0/nQza6SY41PfLojYMDsxCHVXKOKdDpGgfm91k5nDCa3BUE9cwi
w59HZo8U/1qI57P23GNF0/MY9a71Y9Rwvo9SH6U+SvFF6ag4ZMxaxEpzaOqC
RD7x8J1YHHZNxB0o5U8CcWg/+uvzP1TPJj/wiUOfLZM90iWPPHeZSsopJ0UQ
CZ3WZjyWZlunNcxj3KeHVUJFL5dLU/1oI1nSdn4I+Kd5dV/jfYf1q5W7z/na
gFySM2Lslsobd2Cnv0K00jFLdaPRrtXjrdLZ51KB9LDOeAy0tEP46qSdDtGN
VvTVV13xd0NulyHxiFsfhsx9x+0Ctj/DN7WvoZinAbi6udXua9rMpnSnIcW7
vSKkkrG3hORu211e137d/ThhuZrJmM4iHVfb2ZsI8V363mYOQztBKI56MvcW
m8tPGohLAiMb8kQb6sdKbzNPcLOW5//PtxJUwdzTCmrrCodRjM0+jPImHB9t
RPms2DUes7Fre6R4zJYP32ctBrwua7gW46rBvX8g8qWCj1bXV0K+1Op7oeBz
6S7tdem6dkv5V3af5fxuJrPjhKMOjG8vBrm2KupEG+mzjvld+40i68gv9b+J
rNfRjzT2nrJX7D3SlRarq6wgccXEcJ+kir6CdNeZ2nWlrL71we9L/BXi88RX
QWipjx/XO4yUj9+luZ4Qwk+Rmir5uD1zm/7WjTfGS14hY+v5AUi68Iwf2jOH
o8vLDeM+uaHj544d2z3EnMyB/gA0fc1L5EerYW5pxM3zf7/+xdxUqzpdVl8Z
m8EfpOID3Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{459, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117605726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4665],

Cell[TextData[{
 "An expression involving ",
 Cell[BoxData[
  ButtonBox["O",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/O"]], "InlineFormula"],
 " is converted to a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->10476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"x", "+", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", "2"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22500],

Cell["SeriesData[x, 0, {1, 1/2}, 1, 10, 1]", "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->4730]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29424],

Cell["Find the lowest-order terms in a large polynomial: ", "ExampleText",
 CellID->30351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", "x"}]}], ")"}], "^", "1000"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27021],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2000", " ", "x"}], "+", 
   RowBox[{"1998000", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"1329336000", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"662673996000", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 2000, 1998000, 1329336000, 1249032416}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{413, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20469]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29635],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2000", " ", "x"}], "+", 
  RowBox[{"1998000", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"1329336000", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"662673996000", " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->954]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8293],

Cell["\<\
Applying a function may give a different number of terms than generating the \
series from scratch:\
\>", "ExampleText",
 CellID->26787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"x", "^", "3"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26971],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "8"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "9"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[x, 0, {}, 2, 10, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 1, 0, 0, 
    Rational[-1, 6], 
    Rational[-1, 2], 
    Rational[-1, 2], 
    Rational[-1, 6]}, 2, 10, 1],
  Editable->False]], "Output",
 ImageSize->{210, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"x", "^", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20441],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["x", "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "8"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "9"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[x, 0, {}, 2, 11, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 1, 0, 0, 
    Rational[-1, 6], 
    Rational[-1, 2], 
    Rational[-1, 2], 
    Rational[-1, 6], 
    Rational[1, 120]}, 2, 11, 1],
  Editable->False]], "Output",
 ImageSize->{248, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26876]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19548],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14312],

Cell[TextData[ButtonBox["The Representation of Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfPowerSeries"]], "Tutorials",
 CellID->24330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->76848927],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->45934415]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"O - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 31.5796318}", "context" -> "System`", 
    "keywords" -> {"big-O notation", "Landau symbol"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "O[x]^n represents a term of order x^n. O[x]^n is generated to represent \
omitted higher-order terms in power series. O[x, x_0]^n represents a term of \
order (x - x_0) n. ", "synonyms" -> {}, "title" -> "O", "type" -> "Symbol", 
    "uri" -> "ref/O"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4986, 168, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67603945]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23014, 867}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1961, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2584, 76, 39, 1, 70, "ObjectName",
 CellID->28890],
Cell[2626, 79, 1478, 50, 70, "Usage",
 CellID->9131]
}, Open  ]],
Cell[CellGroupData[{
Cell[4141, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4619, 151, 330, 12, 70, "Notes",
 CellID->9227]
}, Closed]],
Cell[CellGroupData[{
Cell[4986, 168, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67603945],
Cell[CellGroupData[{
Cell[5370, 182, 147, 5, 70, "ExampleSection",
 CellID->61917531],
Cell[5520, 189, 86, 1, 70, "ExampleText",
 CellID->32570],
Cell[CellGroupData[{
Cell[5631, 194, 198, 7, 28, "Input",
 CellID->28651],
Cell[5832, 203, 469, 17, 54, "Output",
 CellID->18152]
}, Open  ]],
Cell[6316, 223, 133, 4, 70, "ExampleText",
 CellID->28468],
Cell[CellGroupData[{
Cell[6474, 231, 167, 6, 28, "Input",
 CellID->13626],
Cell[6644, 239, 1278, 46, 54, "Output",
 CellID->4696]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7971, 291, 216, 7, 70, "ExampleSection",
 CellID->25451],
Cell[8190, 300, 110, 3, 70, "ExampleText",
 CellID->21721],
Cell[CellGroupData[{
Cell[8325, 307, 169, 6, 70, "Input",
 CellID->2793],
Cell[8497, 315, 722, 26, 54, "Output",
 CellID->5343]
}, Open  ]],
Cell[CellGroupData[{
Cell[9256, 346, 114, 4, 70, "Input",
 CellID->20735],
Cell[9373, 352, 172, 5, 36, "Output",
 CellID->13131]
}, Open  ]],
Cell[9560, 360, 120, 3, 70, "ExampleDelimiter",
 CellID->6739],
Cell[9683, 365, 79, 1, 70, "ExampleText",
 CellID->1443],
Cell[CellGroupData[{
Cell[9787, 370, 174, 6, 70, "Input",
 CellID->17382],
Cell[9964, 378, 422, 14, 36, "Output",
 CellID->9269]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10435, 398, 238, 7, 70, "ExampleSection",
 CellID->7924],
Cell[10676, 407, 449, 18, 70, "ExampleText",
 CellID->21728],
Cell[CellGroupData[{
Cell[11150, 429, 194, 7, 70, "Input",
 CellID->5389],
Cell[11347, 438, 1074, 35, 51, "Output",
 CellID->29028]
}, Open  ]],
Cell[12436, 476, 121, 3, 70, "ExampleDelimiter",
 CellID->32183],
Cell[12560, 481, 208, 7, 70, "ExampleText",
 CellID->19685],
Cell[CellGroupData[{
Cell[12793, 492, 271, 10, 70, "Input",
 CellID->14936],
Cell[13067, 504, 1261, 25, 70, "Output",
 Evaluatable->False,
 CellID->117605726]
}, Open  ]],
Cell[14343, 532, 120, 3, 70, "ExampleDelimiter",
 CellID->4665],
Cell[14466, 537, 343, 13, 70, "ExampleText",
 CellID->10476],
Cell[CellGroupData[{
Cell[14834, 554, 238, 8, 70, "Input",
 CellID->22500],
Cell[15075, 564, 191, 5, 50, "Output",
 CellID->4730]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15315, 575, 223, 7, 70, "ExampleSection",
 CellID->29424],
Cell[15541, 584, 90, 1, 70, "ExampleText",
 CellID->30351],
Cell[CellGroupData[{
Cell[15656, 589, 236, 9, 70, "Input",
 CellID->27021],
Cell[15895, 600, 670, 21, 36, "Output",
 CellID->20469]
}, Open  ]],
Cell[CellGroupData[{
Cell[16602, 626, 98, 3, 70, "Input",
 CellID->29635],
Cell[16703, 631, 401, 13, 36, "Output",
 CellID->954]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17153, 650, 232, 7, 70, "ExampleSection",
 CellID->8293],
Cell[17388, 659, 146, 4, 70, "ExampleText",
 CellID->26787],
Cell[CellGroupData[{
Cell[17559, 667, 231, 8, 70, "Input",
 CellID->26971],
Cell[17793, 677, 780, 28, 54, "Output",
 CellID->32333]
}, Open  ]],
Cell[CellGroupData[{
Cell[18610, 710, 289, 10, 70, "Input",
 CellID->20441],
Cell[18902, 722, 864, 31, 54, "Output",
 CellID->26876]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19827, 760, 311, 9, 70, "SeeAlsoSection",
 CellID->19548],
Cell[20141, 771, 692, 26, 70, "SeeAlso",
 CellID->14499]
}, Open  ]],
Cell[CellGroupData[{
Cell[20870, 802, 314, 9, 70, "TutorialsSection",
 CellID->14312],
Cell[21187, 813, 175, 3, 70, "Tutorials",
 CellID->24330]
}, Open  ]],
Cell[CellGroupData[{
Cell[21399, 821, 318, 9, 70, "MoreAboutSection",
 CellID->76848927],
Cell[21720, 832, 144, 3, 70, "MoreAbout",
 CellID->45934415]
}, Open  ]],
Cell[21879, 838, 27, 0, 70, "History"],
Cell[21909, 840, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

