(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20344,        774]
NotebookOptionsPosition[     15199,        593]
NotebookOutlinePosition[     16483,        631]
CellTagsIndexPosition[     16398,        626]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Types of Numbers\"\>", 
       3->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerQ" :> Documentation`HelpLookup["paclet:ref/IntegerQ"], 
          "EvenQ" :> Documentation`HelpLookup["paclet:ref/EvenQ"], "TrueQ" :> 
          Documentation`HelpLookup["paclet:ref/TrueQ"], "Divisible" :> 
          Documentation`HelpLookup["paclet:ref/Divisible"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerQ\"\>", 2->"\<\"EvenQ\"\>", 
       3->"\<\"TrueQ\"\>", 4->"\<\"Divisible\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OddQ", "ObjectName",
 CellID->31545],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OddQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OddQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is an odd integer, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OddQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OddQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is manifestly an odd integer (i.e., has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", and is odd). "
}], "Notes",
 CellID->1458]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->980666263],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->434139816],

Cell["Test whether 9 is odd:", "ExampleText",
 CellID->488273937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OddQ", "[", "9", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32595936],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503176545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341019475],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OddQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OddQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " for non-numeric expressions:"
}], "ExampleText",
 CellID->135536325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OddQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124118107],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127612436]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31354],

Cell["Test whether a vector consists of odd integers:", "ExampleText",
 CellID->1645025371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "11"}], "}"}], ",", "OddQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1236938919],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1869594593]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "7", ",", "11"}], "}"}], ",", "OddQ"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->295601647],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1047205618]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8343],

Cell[TextData[{
 "An integer is either odd or even. Use ",
 Cell[BoxData[
  ButtonBox["EvenQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvenQ"]], "InlineFormula"],
 " to check that an integer is even:"
}], "ExampleText",
 CellID->1821314591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OddQ", "[", "2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->602426599],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316438440]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvenQ", "[", "2", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->753917437],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1211351108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->729171824],

Cell[TextData[{
 "Odd integers are not divisible by ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1649156186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OddQ", "[", "15", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1944069920],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->882816977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"Divisible", "[", 
   RowBox[{"15", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585108001],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1051872849]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21429],

Cell[TextData[{
 "Expressions that represent odd integers, but do not evaluate explicitly \
will still give ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1557175484],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"3", 
    RowBox[{"(", 
     RowBox[{"GoldenRatio", " ", "-", " ", 
      RowBox[{"1", "/", "GoldenRatio"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65153599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OddQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2033001876],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1917356432]
}, Open  ]],

Cell["It is necessary to use symbolic simplification first:", "ExampleText",
 CellID->128736334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1155533009],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2017429389]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8670],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvenQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvenQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7096],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->26135],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->13861],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->847635199],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->308672319],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->9604627]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
OddQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OddQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 27.0951420}", "context" -> "System`", 
    "keywords" -> {
     "isOdd", "odd numbers", "predicate to test oddness", 
      "testing for odd integers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OddQ[expr] gives True if expr is an odd integer, and False otherwise. ", 
    "synonyms" -> {"odd q"}, "title" -> "OddQ", "type" -> "Symbol", "uri" -> 
    "ref/OddQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5211, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->980666263]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16255, 619}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2562, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3185, 86, 42, 1, 70, "ObjectName",
 CellID->31545],
Cell[3230, 89, 834, 28, 70, "Usage",
 CellID->17716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4101, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4579, 139, 595, 22, 70, "Notes",
 CellID->1458]
}, Closed]],
Cell[CellGroupData[{
Cell[5211, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->980666263],
Cell[CellGroupData[{
Cell[5596, 180, 148, 5, 70, "ExampleSection",
 CellID->434139816],
Cell[5747, 187, 65, 1, 70, "ExampleText",
 CellID->488273937],
Cell[CellGroupData[{
Cell[5837, 192, 99, 3, 28, "Input",
 CellID->32595936],
Cell[5939, 197, 161, 5, 36, "Output",
 CellID->503176545]
}, Open  ]],
Cell[6115, 205, 125, 3, 70, "ExampleDelimiter",
 CellID->341019475],
Cell[6243, 210, 323, 12, 70, "ExampleText",
 CellID->135536325],
Cell[CellGroupData[{
Cell[6591, 226, 100, 3, 70, "Input",
 CellID->124118107],
Cell[6694, 231, 162, 5, 36, "Output",
 CellID->127612436]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6905, 242, 223, 7, 70, "ExampleSection",
 CellID->31354],
Cell[7131, 251, 91, 1, 70, "ExampleText",
 CellID->1645025371],
Cell[CellGroupData[{
Cell[7247, 256, 203, 7, 70, "Input",
 CellID->1236938919],
Cell[7453, 265, 162, 5, 36, "Output",
 CellID->1869594593]
}, Open  ]],
Cell[CellGroupData[{
Cell[7652, 275, 202, 7, 70, "Input",
 CellID->295601647],
Cell[7857, 284, 163, 5, 36, "Output",
 CellID->1047205618]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8069, 295, 232, 7, 70, "ExampleSection",
 CellID->8343],
Cell[8304, 304, 249, 8, 70, "ExampleText",
 CellID->1821314591],
Cell[CellGroupData[{
Cell[8578, 316, 100, 3, 70, "Input",
 CellID->602426599],
Cell[8681, 321, 162, 5, 36, "Output",
 CellID->316438440]
}, Open  ]],
Cell[CellGroupData[{
Cell[8880, 331, 101, 3, 70, "Input",
 CellID->753917437],
Cell[8984, 336, 162, 5, 36, "Output",
 CellID->1211351108]
}, Open  ]],
Cell[9161, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->729171824],
Cell[9289, 349, 137, 5, 70, "ExampleText",
 CellID->1649156186],
Cell[CellGroupData[{
Cell[9451, 358, 102, 3, 70, "Input",
 CellID->1944069920],
Cell[9556, 363, 161, 5, 36, "Output",
 CellID->882816977]
}, Open  ]],
Cell[CellGroupData[{
Cell[9754, 373, 160, 5, 70, "Input",
 CellID->585108001],
Cell[9917, 380, 162, 5, 36, "Output",
 CellID->1051872849]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10128, 391, 226, 7, 70, "ExampleSection",
 CellID->21429],
Cell[10357, 400, 268, 9, 70, "ExampleText",
 CellID->1557175484],
Cell[10628, 411, 246, 8, 70, "Input",
 CellID->65153599],
Cell[CellGroupData[{
Cell[10899, 423, 101, 3, 70, "Input",
 CellID->2033001876],
Cell[11003, 428, 163, 5, 36, "Output",
 CellID->1917356432]
}, Open  ]],
Cell[11181, 436, 96, 1, 70, "ExampleText",
 CellID->128736334],
Cell[CellGroupData[{
Cell[11302, 441, 109, 3, 70, "Input",
 CellID->1155533009],
Cell[11414, 446, 159, 5, 36, "Output",
 CellID->2017429389]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11634, 458, 310, 9, 70, "SeeAlsoSection",
 CellID->8670],
Cell[11947, 469, 931, 35, 70, "SeeAlso",
 CellID->18290]
}, Open  ]],
Cell[CellGroupData[{
Cell[12915, 509, 313, 9, 70, "TutorialsSection",
 CellID->7096],
Cell[13231, 520, 170, 3, 70, "Tutorials",
 CellID->26135],
Cell[13404, 525, 141, 3, 70, "Tutorials",
 CellID->13861],
Cell[13548, 530, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[13783, 539, 319, 9, 70, "MoreAboutSection",
 CellID->847635199],
Cell[14105, 550, 145, 3, 70, "MoreAbout",
 CellID->308672319],
Cell[14253, 555, 147, 3, 70, "MoreAbout",
 CellID->9604627]
}, Open  ]],
Cell[CellGroupData[{
Cell[14437, 563, 305, 8, 70, "RelatedLinksSection"],
Cell[14745, 573, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[15142, 589, 27, 0, 70, "History"],
Cell[15172, 591, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

