(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20127,        708]
NotebookOptionsPosition[     16077,        573]
NotebookOutlinePosition[     17445,        611]
CellTagsIndexPosition[     17360,        606]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenWrite" :> Documentation`HelpLookup["paclet:ref/OpenWrite"],
           "OpenRead" :> Documentation`HelpLookup["paclet:ref/OpenRead"], 
          "OpenWrite" :> Documentation`HelpLookup["paclet:ref/OpenWrite"], 
          "Close" :> Documentation`HelpLookup["paclet:ref/Close"], 
          "PutAppend" :> Documentation`HelpLookup["paclet:ref/PutAppend"], 
          "Streams" :> Documentation`HelpLookup["paclet:ref/Streams"], 
          "LinkCreate" :> 
          Documentation`HelpLookup["paclet:ref/LinkCreate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OpenWrite\"\>", 
       2->"\<\"OpenRead\"\>", 3->"\<\"OpenWrite\"\>", 4->"\<\"Close\"\>", 
       5->"\<\"PutAppend\"\>", 6->"\<\"Streams\"\>", 
       7->"\<\"LinkCreate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OpenAppend", "ObjectName",
 CellID->16390],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OpenAppend",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OpenAppend"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a file to append output to it, and returns an ",
     Cell[BoxData[
      ButtonBox["OutputStream",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
     " object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32419]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->22729],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BinaryFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BinaryFormat"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to use binary format for the file ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what raw character encoding to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell[
    "default format for printing expressions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberMarks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMarks"], 
    ButtonBox["$NumberMarks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$NumberMarks"], Cell[TextData[{
     "when to use ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks in approximate numbers "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "78", Cell[
    "number of character widths per line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TotalWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TotalWidth"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "maximum number of character widths for a single expression ", 
     "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->27477],

Cell[TextData[{
 "On computer systems that support pipes, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OpenAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenAppend"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " runs the external program specified by ",
 Cell[BoxData[
  StyleBox["command", "TI"]], "InlineFormula"],
 ", and opens a pipe to send input to it. "
}], "Notes",
 CellID->26603],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 " does not succeed in opening a particular file or pipe, it generates a \
message, and returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20455],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 " resolves file names according to the procedure described in ",
 ButtonBox["Files and Streams",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FilesAndStreams"],
 ". "
}], "Notes",
 CellID->20334],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OutputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputStream"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is the full name of a file or command, and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a serial number that is unique across all streams opened in the current \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->30808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " can be used to change the properties of an output stream, after it is \
already open. "
}], "Notes",
 CellID->23883],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " automatically open the files or pipes they need, if they are not already \
open. "
}], "Notes",
 CellID->19662],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryFormat"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData["\"\<ASCII\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10971]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->392210005],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->40291901],

Cell["Create a file and write an expression to it:", "ExampleText",
 CellID->536346040],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", " ", "\"\<test1\>\""}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1677069123],

Cell[BoxData[
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"OpenWrite", "[", "file", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->513468680],

Cell[BoxData[
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"str", ",", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", "-", " ", 
     RowBox[{"y", "^", "2"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1278811114],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->834208091],

Cell["Read the file:", "ExampleText",
 CellID->145064067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->697834724],

Cell["x^2 - y^2", "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->486879861]
}, Open  ]],

Cell[TextData[{
 "Open the file using ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->777883386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", " ", "=", " ", 
  RowBox[{"OpenAppend", "[", "file", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5625566],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1\"\>", ",", "35"}], "]"}]], "Output",
 ImageSize->{527, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->207433631]
}, Open  ]],

Cell["Write an expression and close the stream:", "ExampleText",
 CellID->760198409],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"str", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1274444060],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1236620422],

Cell["Read the file:", "ExampleText",
 CellID->2055892895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->579421242],

Cell["\<\
x^2 - y^2
x^2 + y^2\
\>", "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->37804484]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32197],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenWrite",
    ButtonNote->"ObsLink: OpenTemporary -> OpenWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Close",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Close"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PutAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PutAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkCreate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19192]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13284],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->321101400],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->97862081]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OpenAppend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 4, 57.6584244}", "context" -> "System`", 
    "keywords" -> {
     "append-mode", "open file for writing", "opening streams for writing", 
      "open stream for output", "appending to a file"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OpenAppend[\"file\"] opens a file to append output to it, and returns an \
OutputStream object. ", "synonyms" -> {"open append"}, "title" -> 
    "OpenAppend", "type" -> "Symbol", "uri" -> "ref/OpenAppend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9764, 314, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->392210005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17217, 599}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2428, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3051, 83, 48, 1, 70, "ObjectName",
 CellID->16390],
Cell[3102, 86, 677, 20, 70, "Usage",
 CellID->32419]
}, Open  ]],
Cell[CellGroupData[{
Cell[3816, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4294, 128, 69, 1, 70, "Notes",
 CellID->22729],
Cell[4366, 131, 2226, 59, 70, "3ColumnTableMod",
 CellID->27477],
Cell[6595, 192, 441, 13, 70, "Notes",
 CellID->26603],
Cell[7039, 207, 397, 14, 70, "Notes",
 CellID->20455],
Cell[7439, 223, 342, 11, 70, "Notes",
 CellID->20334],
Cell[7784, 236, 751, 26, 70, "Notes",
 CellID->30808],
Cell[8538, 264, 258, 8, 70, "Notes",
 CellID->23883],
Cell[8799, 274, 382, 14, 70, "Notes",
 CellID->19662],
Cell[9184, 290, 543, 19, 70, "Notes",
 CellID->10971]
}, Closed]],
Cell[CellGroupData[{
Cell[9764, 314, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->392210005],
Cell[CellGroupData[{
Cell[10149, 328, 147, 5, 70, "ExampleSection",
 CellID->40291901],
Cell[10299, 335, 87, 1, 70, "ExampleText",
 CellID->536346040],
Cell[10389, 338, 189, 6, 70, "Input",
 CellID->1677069123],
Cell[10581, 346, 152, 5, 70, "Input",
 CellID->513468680],
Cell[10736, 353, 238, 8, 70, "Input",
 CellID->1278811114],
Cell[10977, 363, 121, 4, 70, "Input",
 CellID->834208091],
Cell[11101, 369, 57, 1, 70, "ExampleText",
 CellID->145064067],
Cell[CellGroupData[{
Cell[11183, 374, 108, 3, 70, "Input",
 CellID->697834724],
Cell[11294, 379, 90, 2, 70, "Print",
 CellID->486879861]
}, Open  ]],
Cell[11399, 384, 207, 8, 70, "ExampleText",
 CellID->777883386],
Cell[CellGroupData[{
Cell[11631, 396, 142, 4, 70, "Input",
 CellID->5625566],
Cell[11776, 402, 302, 8, 36, "Output",
 CellID->207433631]
}, Open  ]],
Cell[12093, 413, 84, 1, 70, "ExampleText",
 CellID->760198409],
Cell[12180, 416, 201, 7, 70, "Input",
 CellID->1274444060],
Cell[12384, 425, 122, 4, 70, "Input",
 CellID->1236620422],
Cell[12509, 431, 58, 1, 70, "ExampleText",
 CellID->2055892895],
Cell[CellGroupData[{
Cell[12592, 436, 108, 3, 70, "Input",
 CellID->579421242],
Cell[12703, 441, 107, 5, 70, "Print",
 CellID->37804484]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12871, 453, 311, 9, 70, "SeeAlsoSection",
 CellID->32197],
Cell[13185, 464, 1733, 63, 70, "SeeAlso",
 CellID->19192]
}, Open  ]],
Cell[CellGroupData[{
Cell[14955, 532, 314, 9, 70, "TutorialsSection",
 CellID->13284],
Cell[15272, 543, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[15500, 552, 319, 9, 70, "MoreAboutSection",
 CellID->321101400],
Cell[15822, 563, 158, 3, 70, "MoreAbout",
 CellID->97862081]
}, Open  ]],
Cell[15995, 569, 52, 0, 70, "History"],
Cell[16050, 571, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

