(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25538,        809]
NotebookOptionsPosition[     21436,        674]
NotebookOutlinePosition[     22868,        713]
CellTagsIndexPosition[     22783,        708]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenAppend" :> 
          Documentation`HelpLookup["paclet:ref/OpenAppend"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"], "Close" :> 
          Documentation`HelpLookup["paclet:ref/Close"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "Streams" :> 
          Documentation`HelpLookup["paclet:ref/Streams"], "LinkCreate" :> 
          Documentation`HelpLookup["paclet:ref/LinkCreate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OpenAppend\"\>", 
       2->"\<\"OpenRead\"\>", 3->"\<\"Close\"\>", 4->"\<\"Put\"\>", 
       5->"\<\"Streams\"\>", 6->"\<\"LinkCreate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"File Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["OpenWrite", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OpenWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OpenWrite"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a file to write output to it, and returns an ",
     Cell[BoxData[
      ButtonBox["OutputStream",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
     " object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OpenWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OpenWrite"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a new file in the default area for temporary \
files on your computer system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " deletes any existing contents in a file, and prepares to write output \
starting at the beginning of the file. "
}], "Notes",
 CellID->22685],

Cell["The following options can be given: ", "Notes",
 CellID->22729],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BinaryFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BinaryFormat"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to use binary format for the file ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what raw character encoding to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell[
    "default format for printing expressions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberMarks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMarks"], 
    ButtonBox["$NumberMarks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$NumberMarks"], Cell[TextData[{
     "when to use ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks in approximate numbers "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "78", Cell[
    "number of character widths per line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TotalWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TotalWidth"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "maximum number of character widths for a single expression ", 
     "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, Left, {Left}}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->27477],

Cell[TextData[{
 "On computer systems that support pipes, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OpenWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenWrite"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " runs the external program specified by ",
 Cell[BoxData[
  StyleBox["command", "TI"]], "InlineFormula"],
 ", and opens a pipe to send input to it. "
}], "Notes",
 CellID->26603],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " does not succeed in opening a particular file or pipe, it generates a \
message, and returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20455],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " resolves file names according to the procedure described in ",
 ButtonBox["Files and Streams",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FilesAndStreams"],
 ". "
}], "Notes",
 CellID->20334],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OutputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputStream"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is the full name of a file or command, and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a serial number that is unique across all streams opened in the current \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->30808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " can be used to change the properties of an output stream, after it is \
already open. "
}], "Notes",
 CellID->23883],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " automatically open the files or pipes they need, if they are not already \
open. "
}], "Notes",
 CellID->19662],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryFormat"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData["\"\<ASCII\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10971],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OpenWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenWrite"], "[", "]"}]], "InlineFormula"],
 " always creates a new file, that does not already exist. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17405],

Cell[TextData[{
 "The global variable ",
 Cell[BoxData[
  ButtonBox["$TemporaryPrefix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TemporaryPrefix"]], "InlineFormula"],
 " gives the path and the beginning of the file name used by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OpenWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenWrite"], "[", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12104]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72701385],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->70124781],

Cell["Create and open a new stream for writing: ", "ExampleText",
 CellID->91485792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"OpenWrite", "[", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<testfile\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65933930],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\testfile\"\>", ",", "97"}], "]"}]], "Output",
 ImageSize->{548, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139298600]
}, Open  ]],

Cell["Write an expression to the stream: ", "ExampleText",
 CellID->229672728],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"s", ",", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "10"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431471178],

Cell["Close the stream:", "ExampleText",
 CellID->115617759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "s", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->258264527],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\testfile\"\>"], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->637747882]
}, Open  ]],

Cell["Print the resulting file: ", "ExampleText",
 CellID->122353559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", 
  RowBox[{"$TemporaryPrefix", "<>", "\"\<testfile\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->559377919],

Cell["\<\
x^10 + 10*x^9*y + 45*x^8*y^2 + 120*x^7*y^3 + 210*x^6*y^4 + 252*x^5*y^5 + 
 210*x^4*y^6 + 120*x^3*y^7 + 45*x^2*y^8 + 10*x*y^9 + y^10\
\>", "Print",
 CellLabel->"During evaluation of In[18]:=",
 CellID->42168510]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21450],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Close",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Close"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkCreate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9503]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1021],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->21327523],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->111850139],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->202311034],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->741942851],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->121843148]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OpenWrite - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 7.5805534}", "context" -> "System`", 
    "keywords" -> {
     "open file for writing", "opening output streams", 
      "opening streams for writing", "write-mode"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OpenWrite[\"file\"] opens a file to write output to it, and returns an \
OutputStream object. OpenWrite[] opens a new file in the default area for \
temporary files on your computer system.", "synonyms" -> {"open write"}, 
    "title" -> "OpenWrite", "type" -> "Symbol", "uri" -> "ref/OpenWrite"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15648, 450, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->72701385]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22640, 701}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2721, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3344, 88, 4193, 83, 70, "ObjectNameGrid"],
Cell[7540, 173, 987, 29, 70, "Usage",
 CellID->5053]
}, Open  ]],
Cell[CellGroupData[{
Cell[8564, 207, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9042, 224, 281, 8, 70, "Notes",
 CellID->22685],
Cell[9326, 234, 69, 1, 70, "Notes",
 CellID->22729],
Cell[9398, 237, 2148, 57, 70, "3ColumnTableMod",
 CellID->27477],
Cell[11549, 296, 439, 13, 70, "Notes",
 CellID->26603],
Cell[11991, 311, 395, 14, 70, "Notes",
 CellID->20455],
Cell[12389, 327, 340, 11, 70, "Notes",
 CellID->20334],
Cell[12732, 340, 749, 26, 70, "Notes",
 CellID->30808],
Cell[13484, 368, 258, 8, 70, "Notes",
 CellID->23883],
Cell[13745, 378, 382, 14, 70, "Notes",
 CellID->19662],
Cell[14130, 394, 543, 19, 70, "Notes",
 CellID->10971],
Cell[14676, 415, 382, 11, 70, "Notes",
 CellID->17405],
Cell[15061, 428, 550, 17, 70, "Notes",
 CellID->12104]
}, Closed]],
Cell[CellGroupData[{
Cell[15648, 450, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72701385],
Cell[CellGroupData[{
Cell[16032, 464, 147, 5, 70, "ExampleSection",
 CellID->70124781],
Cell[16182, 471, 84, 1, 70, "ExampleText",
 CellID->91485792],
Cell[CellGroupData[{
Cell[16291, 476, 182, 5, 28, "Input",
 CellID->65933930],
Cell[16476, 483, 305, 8, 36, "Output",
 CellID->139298600]
}, Open  ]],
Cell[16796, 494, 78, 1, 70, "ExampleText",
 CellID->229672728],
Cell[16877, 497, 237, 8, 70, "Input",
 CellID->431471178],
Cell[17117, 507, 60, 1, 70, "ExampleText",
 CellID->115617759],
Cell[CellGroupData[{
Cell[17202, 512, 101, 3, 70, "Input",
 CellID->258264527],
Cell[17306, 517, 243, 6, 36, "Output",
 CellID->637747882]
}, Open  ]],
Cell[17564, 526, 69, 1, 70, "ExampleText",
 CellID->122353559],
Cell[CellGroupData[{
Cell[17658, 531, 159, 4, 70, "Input",
 CellID->559377919],
Cell[17820, 537, 220, 5, 70, "Print",
 CellID->42168510]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18101, 549, 311, 9, 70, "SeeAlsoSection",
 CellID->21450],
Cell[18415, 560, 1420, 53, 70, "SeeAlso",
 CellID->9503]
}, Open  ]],
Cell[CellGroupData[{
Cell[19872, 618, 313, 9, 70, "TutorialsSection",
 CellID->1021],
Cell[20188, 629, 191, 4, 70, "Tutorials",
 CellID->11451]
}, Open  ]],
Cell[CellGroupData[{
Cell[20416, 638, 318, 9, 70, "MoreAboutSection",
 CellID->21327523],
Cell[20737, 649, 173, 3, 70, "MoreAbout",
 CellID->111850139],
Cell[20913, 654, 141, 3, 70, "MoreAbout",
 CellID->202311034],
Cell[21057, 659, 122, 3, 70, "MoreAbout",
 CellID->741942851],
Cell[21182, 664, 159, 3, 70, "MoreAbout",
 CellID->121843148]
}, Open  ]],
Cell[21356, 670, 50, 0, 70, "History"],
Cell[21409, 672, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

