(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21904,        849]
NotebookOptionsPosition[     16762,        668]
NotebookOutlinePosition[     18014,        704]
CellTagsIndexPosition[     17929,        699]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Working with Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithOperators"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Working with Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Through" :> Documentation`HelpLookup["paclet:ref/Through"], 
          "Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], "Heads" :> 
          Documentation`HelpLookup["paclet:ref/Heads"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Through\"\>", 2->"\<\"Apply\"\>", 
       3->"\<\"Heads\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Functional Programming\"\>", 
       2->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Operate", "ObjectName",
 CellID->4659],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Operate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Operate"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        RowBox[{
         StyleBox["f", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["p", "TI"], "[", 
        StyleBox["f", "TI"], "]"}], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Operate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Operate"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in the head of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25027]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Operate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Operate"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " effectively applies the functional operator ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " to the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26315],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Operate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Operate"]], "InlineFormula"],
 " is essentially a generalization of ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ", which allows you to apply an operator to the head of an expression, \
rather than simply to replace the head. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1759650719,
  ButtonNote->"1759650719"]
}], "Notes",
 CellID->3642]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->778837961],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->52850903],

Cell[TextData[{
 "Operate on the head of the expression with ",
 Cell[BoxData["p"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"p", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14464],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "f", "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124546694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3150],

Cell["Use a pure function:", "ExampleText",
 CellID->8267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", "a", "]"}], "&"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21931],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->803261267]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12169],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Level Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1126202645],

Cell["Operate at level 1, the head of the expression (default):", \
"ExampleText",
 CellID->1755133922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"Framed", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}], "[", "z", "]"}], ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1860563125],

Cell[BoxData[
 RowBox[{
  FrameBox[
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}],
   StripOnInput->False], "[", "z", "]"}]], "Output",
 ImageSize->{84, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17792129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"Framed", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}], "[", "z", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1572958599],

Cell[BoxData[
 RowBox[{
  FrameBox[
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}],
   StripOnInput->False], "[", "z", "]"}]], "Output",
 ImageSize->{84, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->387201568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->388060603],

Cell["Operate at level 2 (the head of the head of the expression):", \
"ExampleText",
 CellID->1661825514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"Framed", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}], "[", "z", "]"}], ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->783165280],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FrameBox[
    RowBox[{"f", "[", "x", "]"}],
    StripOnInput->False], "[", "y", "]"}], "[", "z", "]"}]], "Output",
 ImageSize->{84, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13119749]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->187252363],

Cell["Operate can be iterated:", "ExampleText",
 CellID->1382190333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"Framed", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23615],

Cell[BoxData[
 RowBox[{
  FrameBox["f",
   StripOnInput->False], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{61, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39900100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{"Framed", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12855],

Cell[BoxData[
 RowBox[{
  FrameBox[
   FrameBox["f",
    StripOnInput->False],
   StripOnInput->False], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{71, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->470412457]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Operate", "[", 
     RowBox[{"Framed", ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2127690459],

Cell[BoxData[
 RowBox[{
  FrameBox[
   FrameBox[
    FrameBox[
     FrameBox["f",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False],
   StripOnInput->False], "[", "x", "]"}]], "Output",
 ImageSize->{72, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->326565137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436002848],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Operate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Operate"]], "InlineFormula"],
 " that replaces the head of the expression:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1759650719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Operate", "[", 
  RowBox[{
   RowBox[{"g", "&"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1675509838],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->797892650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15002461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Operate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Operate"]], "InlineFormula"],
 " followed by ",
 Cell[BoxData[
  ButtonBox["Through",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Through"]], "InlineFormula"],
 " is a form of composition:"
}], "ExampleText",
 CellID->1573620813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{"Operate", "[", 
   RowBox[{"p", ",", 
    RowBox[{"f", "[", "x", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->736481880],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34218887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"p", ",", "f"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->827930043],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322646040]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8670],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Through",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Through"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32586],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "Tutorials",
 CellID->27892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->235362580],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->555604859],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->222922329]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 8.5024520}", "context" -> "System`", 
    "keywords" -> {"performing operations on heads"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Operate[p, f[x, y]] gives p[f][x, y]. Operate[p, expr, n] applies p at \
level n in the head of expr. ", "synonyms" -> {}, "title" -> "Operate", 
    "type" -> "Symbol", "uri" -> "ref/Operate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5873, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->778837961]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17786, 692}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2124, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2747, 79, 44, 1, 70, "ObjectName",
 CellID->4659],
Cell[2794, 82, 1475, 51, 70, "Usage",
 CellID->25027]
}, Open  ]],
Cell[CellGroupData[{
Cell[4306, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4784, 155, 503, 19, 70, "Notes",
 CellID->26315],
Cell[5290, 176, 546, 17, 70, "Notes",
 CellID->3642]
}, Closed]],
Cell[CellGroupData[{
Cell[5873, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->778837961],
Cell[CellGroupData[{
Cell[6258, 212, 147, 5, 70, "ExampleSection",
 CellID->52850903],
Cell[6408, 219, 141, 5, 70, "ExampleText",
 CellID->12174],
Cell[CellGroupData[{
Cell[6574, 228, 176, 6, 28, "Input",
 CellID->14464],
Cell[6753, 236, 236, 8, 36, "Output",
 CellID->124546694]
}, Open  ]],
Cell[7004, 247, 120, 3, 70, "ExampleDelimiter",
 CellID->3150],
Cell[7127, 252, 58, 1, 70, "ExampleText",
 CellID->8267],
Cell[CellGroupData[{
Cell[7210, 257, 225, 8, 70, "Input",
 CellID->21931],
Cell[7438, 267, 236, 8, 36, "Output",
 CellID->803261267]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7723, 281, 216, 7, 70, "ExampleSection",
 CellID->12169],
Cell[CellGroupData[{
Cell[7964, 292, 242, 7, 70, "ExampleSubsection",
 CellID->1126202645],
Cell[8209, 301, 103, 2, 70, "ExampleText",
 CellID->1755133922],
Cell[CellGroupData[{
Cell[8337, 307, 236, 8, 70, "Input",
 CellID->1860563125],
Cell[8576, 317, 280, 10, 43, "Output",
 CellID->17792129]
}, Open  ]],
Cell[CellGroupData[{
Cell[8893, 332, 225, 8, 70, "Input",
 CellID->1572958599],
Cell[9121, 342, 281, 10, 43, "Output",
 CellID->387201568]
}, Open  ]],
Cell[9417, 355, 125, 3, 70, "ExampleDelimiter",
 CellID->388060603],
Cell[9545, 360, 106, 2, 70, "ExampleText",
 CellID->1661825514],
Cell[CellGroupData[{
Cell[9676, 366, 235, 8, 70, "Input",
 CellID->783165280],
Cell[9914, 376, 281, 10, 43, "Output",
 CellID->13119749]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10256, 393, 237, 7, 70, "ExampleSection",
 CellID->187252363],
Cell[10496, 402, 68, 1, 70, "ExampleText",
 CellID->1382190333],
Cell[CellGroupData[{
Cell[10589, 407, 181, 6, 70, "Input",
 CellID->23615],
Cell[10773, 415, 244, 9, 41, "Output",
 CellID->39900100]
}, Open  ]],
Cell[CellGroupData[{
Cell[11054, 429, 127, 4, 70, "Input",
 CellID->12855],
Cell[11184, 435, 284, 11, 51, "Output",
 CellID->470412457]
}, Open  ]],
Cell[CellGroupData[{
Cell[11505, 451, 249, 8, 70, "Input",
 CellID->2127690459],
Cell[11757, 461, 345, 14, 71, "Output",
 CellID->326565137]
}, Open  ]],
Cell[12117, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->436002848],
Cell[12245, 483, 406, 13, 70, "ExampleText",
 CellID->1759650719],
Cell[CellGroupData[{
Cell[12676, 500, 210, 7, 70, "Input",
 CellID->1675509838],
Cell[12889, 509, 218, 7, 36, "Output",
 CellID->797892650]
}, Open  ]],
Cell[13122, 519, 124, 3, 70, "ExampleDelimiter",
 CellID->15002461],
Cell[13249, 524, 337, 12, 70, "ExampleText",
 CellID->1573620813],
Cell[CellGroupData[{
Cell[13611, 540, 191, 6, 70, "Input",
 CellID->736481880],
Cell[13805, 548, 212, 7, 36, "Output",
 CellID->34218887]
}, Open  ]],
Cell[CellGroupData[{
Cell[14054, 560, 159, 5, 70, "Input",
 CellID->827930043],
Cell[14216, 567, 213, 7, 36, "Output",
 CellID->322646040]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14490, 581, 310, 9, 70, "SeeAlsoSection",
 CellID->8670],
Cell[14803, 592, 682, 26, 70, "SeeAlso",
 CellID->15602]
}, Open  ]],
Cell[CellGroupData[{
Cell[15522, 623, 314, 9, 70, "TutorialsSection",
 CellID->32586],
Cell[15839, 634, 153, 3, 70, "Tutorials",
 CellID->27892]
}, Open  ]],
Cell[CellGroupData[{
Cell[16029, 642, 319, 9, 70, "MoreAboutSection",
 CellID->235362580],
Cell[16351, 653, 155, 3, 70, "MoreAbout",
 CellID->555604859],
Cell[16509, 658, 181, 3, 70, "MoreAbout",
 CellID->222922329]
}, Open  ]],
Cell[16705, 664, 27, 0, 70, "History"],
Cell[16735, 666, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

