(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10217,        339]
NotebookOptionsPosition[      7974,        268]
NotebookOutlinePosition[      9133,        299]
CellTagsIndexPosition[      9090,        296]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Styles and the Inheritance of Option Settings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Styles and the Inheritance of Option Settings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Option Inspector" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/OptionInspector"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Option Inspector\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OptionInspectorSettings", "ObjectName",
 CellID->27753],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->540941721],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OptionInspectorSettings", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     " \[LineSeparator]is a global option that specifies the display of \
options in the Option Inspector."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options may be specified:", "Notes",
 CellID->8594],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Scope\>\"", "\"\<Notebook\>\"", Cell[
    TextData[{
     "level displayed in ",
     StyleBox["Option Inspector", "DialogElementName"],
     " window"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ViewAs\>\"", "\"\<Browser\>\"", Cell[
    TextData[{
     "display format for ",
     StyleBox["Option Inspector", "DialogElementName"],
     " window."
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowMargins\>\"", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"20", ",", 
        ButtonBox["Automatic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Automatic"]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"45", ",", 
        ButtonBox["Automatic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Automatic"]}], "}"}]}], "}"}], Cell[
    TextData[{
     "margin size around ",
     StyleBox["Option Inspector", "DialogElementName"],
     " window"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowSize\>\"", 
    RowBox[{"{", 
     RowBox[{"913", ",", "508"}], "}"}], Cell[TextData[{
     "size of the ",
     StyleBox["Option Inspector", "DialogElementName"],
     " window"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->14945],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<Scope\>\"", "->", "\"\<Selection\>\""}]], "InlineFormula"],
 ", only those options that can be set at the level of the selection are \
displayed in the window. All other options are dimmed."
}], "Notes",
 CellID->8909],

Cell[TextData[{
 "The possible settings, in increasing order of precedence, are ",
 Cell[BoxData["\"\<Global\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Notebook\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<Selection\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->32209],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<ViewAs\>\"", "->", "\"\<Browser\>\""}]], "InlineFormula"],
 ", the options are grouped into categories according to their inheritance \
levels (Global, Notebook, or Selection) and function. There is some overlap \
between the different categories, with some options listed in more than one \
place."
}], "Notes",
 CellID->9758],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<ViewAs\>\"", "->", "\"\<Alphabetical\>\""}]], 
  "InlineFormula"],
 ", the options are listed in alphabetical order."
}], "Notes",
 CellID->24221],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<ViewAs\>\"", "->", 
   ButtonBox["\"\<Text\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/Text"]}]], "InlineFormula"],
 ", only those options whose settings differ from their default values are \
listed, as plain text."
}], "Notes",
 CellID->18588]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29168],

Cell[TextData[StyleBox[ButtonBox["Option Inspector",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/menuitem/OptionInspector"], "MenuName",
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6422],

Cell[TextData[ButtonBox["Styles and the Inheritance of Option Settings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]], "Tutorials",
 CellID->24946]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OptionInspectorSettings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 9.6431062}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OptionInspectorSettings -> {opt_1 -> val_1, opt_2 -> val_2, ...} is a \
global option that specifies the display of options in the Option Inspector.",
     "synonyms" -> {"option inspector settings"}, "title" -> 
    "OptionInspectorSettings", "type" -> "Symbol", "uri" -> 
    "ref/OptionInspectorSettings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1278, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1901, 60, 61, 1, 70, "ObjectName",
 CellID->27753],
Cell[1965, 63, 218, 6, 70, "AwaitingReviewNote",
 CellID->540941721],
Cell[2186, 71, 941, 29, 70, "Usage",
 CellID->32757]
}, Open  ]],
Cell[CellGroupData[{
Cell[3164, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3642, 122, 71, 1, 70, "Notes",
 CellID->8594],
Cell[3716, 125, 1543, 44, 70, "3ColumnTableMod",
 CellID->14945],
Cell[5262, 171, 294, 7, 70, "Notes",
 CellID->8909],
Cell[5559, 180, 292, 9, 70, "Notes",
 CellID->32209],
Cell[5854, 191, 403, 9, 70, "Notes",
 CellID->9758],
Cell[6260, 202, 214, 7, 70, "Notes",
 CellID->24221],
Cell[6477, 211, 333, 10, 70, "Notes",
 CellID->18588]
}, Closed]],
Cell[CellGroupData[{
Cell[6847, 226, 311, 9, 70, "SeeAlsoSection",
 CellID->29168],
Cell[7161, 237, 188, 4, 70, "SeeAlso",
 CellID->900]
}, Open  ]],
Cell[CellGroupData[{
Cell[7386, 246, 313, 9, 70, "TutorialsSection",
 CellID->6422],
Cell[7702, 257, 198, 4, 70, "Tutorials",
 CellID->24946]
}, Open  ]],
Cell[7915, 264, 29, 0, 70, "History"],
Cell[7947, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

