(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21549,        751]
NotebookOptionsPosition[     17846,        630]
NotebookOutlinePosition[     19299,        669]
CellTagsIndexPosition[     19214,        664]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Setting Up Functions with Optional Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"], 
          "Manipulating Options" :> 
          Documentation`HelpLookup["paclet:tutorial/ManipulatingOptions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Setting Up Functions with Optional Arguments\"\>", 
       2->"\<\"Manipulating Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OptionsPattern" :> 
          Documentation`HelpLookup["paclet:ref/OptionsPattern"], "Options" :> 
          Documentation`HelpLookup["paclet:ref/Options"], "AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], 
          "FilterRules" :> 
          Documentation`HelpLookup["paclet:ref/FilterRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OptionsPattern\"\>", 
       2->"\<\"Options\"\>", 3->"\<\"AbsoluteOptions\"\>", 
       4->"\<\"FilterRules\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options Management\"\>", 
       2->"\<\"Package Development\"\>", 
       3->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["OptionValue", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OptionValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OptionValue"], "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the value of ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " in options matched by ",
     Cell[BoxData[
      ButtonBox["OptionsPattern",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OptionsPattern"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OptionValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OptionValue"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the value of ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " for options associated with the head ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OptionValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OptionValue"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["opts", "TI"], ",", 
        StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]extracts option values from the explicit list of rules \
",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives explicit forms for default option values."
}], "Notes",
 CellID->29350],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " allows either ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["opt", "TI"], 
    StyleBox["i", "TI"]], "->", 
   SubscriptBox[
    StyleBox["val", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " as specifications of default option values. Each head is treated as the \
list of rules obtained from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18823],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 " uses the match for the first ",
 Cell[BoxData[
  ButtonBox["OptionsPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OptionsPattern"]], "InlineFormula"],
 " object that appears as an argument of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14485],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   StyleBox["name", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is the head of the left-hand side of the transformation rule in which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   StyleBox["name", "TI"], "]"}]], "InlineFormula"],
 " appears."
}], "Notes",
 CellID->20556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 "and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   StyleBox["name", "TI"], "]"}]], "InlineFormula"],
 "always first use option values obtained from an explicit match for an ",
 Cell[BoxData[
  ButtonBox["OptionsPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OptionsPattern"]], "InlineFormula"],
 ", then use defaults specified by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23216],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["opts", "TI"], ",", 
    StyleBox["name", "TI"], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 " returns the option value with ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " wrapped around it. "
}], "Notes",
 CellID->1626],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   RowBox[{
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["name", "TI"], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"], "[", 
   StyleBox["name", "TI"], "]"}]], "InlineFormula"],
 ", except that the option value is returned with ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " wrapped around it."
}], "Notes",
 CellID->9357]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1447449],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->19042223],

Cell[TextData[{
 "Define default option values for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12717],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "->", "a0"}], ",", 
     RowBox[{"b", "->", "b0"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18696],

Cell[TextData[{
 "Define ",
 Cell[BoxData["f"], "InlineFormula"],
 ", allowing options to be given:"
}], "ExampleText",
 CellID->11585],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"OptionValue", "[", "a", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24041],

Cell[TextData[{
 "Use ",
 Cell[BoxData["f"], "InlineFormula"],
 " with an explicit option setting:"
}], "ExampleText",
 CellID->24423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"7", ",", 
   RowBox[{"a", "->", "uuu"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "uuu"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24229]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["f"], "InlineFormula"],
 " with options taken to have their default values:"
}], "ExampleText",
 CellID->4565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "7", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "a0"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->8932]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23869],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FilterRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilterRules"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8526],

Cell[TextData[ButtonBox["Setting Up Functions with Optional Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]], "Tutorials",
 CellID->208660540],

Cell[TextData[ButtonBox["Manipulating Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingOptions"]], "Tutorials",
 CellID->2793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->80488617],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->872688122],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->233168203],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->24857447]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OptionValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 12.7525608}", "context" -> "System`", 
    "keywords" -> {"default option value", "parsing option value"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "OptionValue[name] gives the value of name in options matched by \
OptionsPattern. OptionValue[f, name] gives the value of name for options \
associated with the head f. OptionValue[f, opts, name] extracts option values \
from the explicit list of rules opts.", "synonyms" -> {"option value"}, 
    "title" -> "OptionValue", "type" -> "Symbol", "uri" -> 
    "ref/OptionValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12581, 412, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1447449]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19072, 657}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2626, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3249, 87, 1576, 37, 70, "ObjectNameGrid"],
Cell[4828, 126, 1752, 56, 70, "Usage",
 CellID->6072]
}, Open  ]],
Cell[CellGroupData[{
Cell[6617, 187, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7095, 204, 577, 20, 70, "Notes",
 CellID->29350],
Cell[7675, 226, 1154, 43, 70, "Notes",
 CellID->18823],
Cell[8832, 271, 541, 19, 70, "Notes",
 CellID->14485],
Cell[9376, 292, 809, 28, 70, "Notes",
 CellID->20556],
Cell[10188, 322, 875, 30, 70, "Notes",
 CellID->23216],
Cell[11066, 354, 562, 20, 70, "Notes",
 CellID->1626],
Cell[11631, 376, 913, 31, 70, "Notes",
 CellID->9357]
}, Closed]],
Cell[CellGroupData[{
Cell[12581, 412, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1447449],
Cell[CellGroupData[{
Cell[12964, 426, 147, 5, 70, "ExampleSection",
 CellID->19042223],
Cell[13114, 433, 144, 5, 70, "ExampleText",
 CellID->12717],
Cell[13261, 440, 246, 9, 70, "Input",
 CellID->18696],
Cell[13510, 451, 135, 5, 70, "ExampleText",
 CellID->11585],
Cell[13648, 458, 267, 9, 70, "Input",
 CellID->24041],
Cell[13918, 469, 134, 5, 70, "ExampleText",
 CellID->24423],
Cell[CellGroupData[{
Cell[14077, 478, 143, 5, 70, "Input",
 CellID->24129],
Cell[14223, 485, 201, 7, 36, "Output",
 CellID->24229]
}, Open  ]],
Cell[14439, 495, 149, 5, 70, "ExampleText",
 CellID->4565],
Cell[CellGroupData[{
Cell[14613, 504, 92, 3, 70, "Input",
 CellID->6559],
Cell[14708, 509, 199, 7, 36, "Output",
 CellID->8932]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14968, 523, 311, 9, 70, "SeeAlsoSection",
 CellID->23869],
Cell[15282, 534, 971, 35, 70, "SeeAlso",
 CellID->29361]
}, Open  ]],
Cell[CellGroupData[{
Cell[16290, 574, 313, 9, 70, "TutorialsSection",
 CellID->8526],
Cell[16606, 585, 201, 4, 70, "Tutorials",
 CellID->208660540],
Cell[16810, 591, 149, 3, 70, "Tutorials",
 CellID->2793]
}, Open  ]],
Cell[CellGroupData[{
Cell[16996, 599, 318, 9, 70, "MoreAboutSection",
 CellID->80488617],
Cell[17317, 610, 147, 3, 70, "MoreAbout",
 CellID->872688122],
Cell[17467, 615, 149, 3, 70, "MoreAbout",
 CellID->233168203],
Cell[17619, 620, 155, 3, 70, "MoreAbout",
 CellID->24857447]
}, Open  ]],
Cell[17789, 626, 27, 0, 70, "History"],
Cell[17819, 628, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

