(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16383,        591]
NotebookOptionsPosition[     13100,        480]
NotebookOutlinePosition[     14429,        518]
CellTagsIndexPosition[     14344,        513]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Optional and Default Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionalAndDefaultArguments"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Optional and Default Arguments\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Default" :> Documentation`HelpLookup["paclet:ref/Default"], 
          "Alternatives" :> 
          Documentation`HelpLookup["paclet:ref/Alternatives"], 
          "PatternSequence" :> 
          Documentation`HelpLookup["paclet:ref/PatternSequence"], "Shortest" :> 
          Documentation`HelpLookup["paclet:ref/Shortest"], 
          "BlankNullSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankNullSequence"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Default\"\>", 
       2->"\<\"Alternatives\"\>", 3->"\<\"PatternSequence\"\>", 
       4->"\<\"Shortest\"\>", 5->"\<\"BlankNullSequence\"\>", 
       6->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Optional ",
 StyleBox["(:)", "OperatorCharacter"]
}], "ObjectName",
 CellID->24393],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], ":", 
       StyleBox["v", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object which represents an expression of \
the form ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ", which, if omitted, should be replaced by ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Optional",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Optional"]], "InlineFormula"],
 " is used to specify \"optional arguments\" in functions represented by \
patterns. The pattern object ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " gives the form the argument should have, if it is present. The expression \
",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " gives the \[OpenCurlyDoubleQuote]default value\[CloseCurlyDoubleQuote] to \
use if the argument is absent. "
}], "Notes",
 CellID->19629],

Cell[TextData[{
 "The form ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["s", "TI"], "_:"}]], 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"], "[", 
   RowBox[{
    StyleBox[
     RowBox[{
      StyleBox["s", "TI"], "_"}]], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 ". This form is also equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], ":", 
   RowBox[{"_", ":", 
    StyleBox["v", "TI"]}]}]], "InlineFormula"],
 ". There is no syntactic ambiguity since ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " must be a symbol in this case. "
}], "Notes",
 CellID->12623],

Cell[TextData[{
 "The special form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["s", "TI"], "_."}]]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"], "[", 
   StyleBox[
    RowBox[{
     StyleBox["s", "TI"], "_"}]], "]"}]], "InlineFormula"],
 " and can be used to represent function arguments which, if omitted, should \
be replaced by default values globally specified for the functions in which \
they occur. "
}], "Notes",
 CellID->24084],

Cell[TextData[{
 "Values for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Default",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Default"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " specify default values to be used when ",
 Cell[BoxData["_."], "InlineFormula"],
 " appears as an argument of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". Any assignments for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Default",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Default"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " must be made ",
 Cell[BoxData[
  RowBox[{
   StyleBox["before", "TI"], "_."}]], "InlineFormula"],
 " first appears as an argument of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19954],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Optional",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Optional"], "[", 
   StyleBox[
    RowBox[{
     StyleBox["s", "TI"], "_", 
     StyleBox["h", "TI"]}]], "]"}]], "InlineFormula"],
 " represents a function which can be omitted, but which, if present, must \
have head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ". There is no simpler syntactic form for this case. "
}], "Notes",
 CellID->18756],

Cell[TextData[{
 "Functions with built\[Hyphen]in default values include ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11840]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376817604],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->2745656],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"y_:", "0"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16118],

Cell["Use the function with both arguments specified explicitly:", \
"ExampleText",
 CellID->2082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16541]
}, Open  ]],

Cell["The second argument is now taken to have its default value:", \
"ExampleText",
 CellID->4833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29658]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32439],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Default",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Default"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alternatives",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alternatives"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankNullSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankNullSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4966],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Optional and Default Arguments",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionalAndDefaultArguments"]], "Tutorials",
 CellID->7376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1145771],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->469663495]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Optional (:) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 9.1899696}", "context" -> "System`", 
    "keywords" -> {
     "optional value", "optional parameters", "optional argument"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "p : v is a pattern object which represents an expression of the form p, \
which, if omitted, should be replaced by v. ", 
    "synonyms" -> {"_.", "_:", ":"}, "title" -> "Optional", "type" -> 
    "Symbol", "uri" -> "ref/Optional"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8236, 283, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->376817604]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14201, 506}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2559, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3182, 88, 101, 4, 70, "ObjectName",
 CellID->24393],
Cell[3286, 94, 622, 20, 70, "Usage",
 CellID->3548]
}, Open  ]],
Cell[CellGroupData[{
Cell[3945, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4423, 136, 578, 16, 70, "Notes",
 CellID->19629],
Cell[5004, 154, 771, 30, 70, "Notes",
 CellID->12623],
Cell[5778, 186, 558, 19, 70, "Notes",
 CellID->24084],
Cell[6339, 207, 910, 33, 70, "Notes",
 CellID->19954],
Cell[7252, 242, 480, 16, 70, "Notes",
 CellID->18756],
Cell[7735, 260, 464, 18, 70, "Notes",
 CellID->11840]
}, Closed]],
Cell[CellGroupData[{
Cell[8236, 283, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376817604],
Cell[CellGroupData[{
Cell[8621, 297, 146, 5, 70, "ExampleSection",
 CellID->2745656],
Cell[8770, 304, 211, 8, 70, "Input",
 CellID->16118],
Cell[8984, 314, 98, 2, 70, "ExampleText",
 CellID->2082],
Cell[CellGroupData[{
Cell[9107, 320, 116, 4, 28, "Input",
 CellID->22929],
Cell[9226, 326, 199, 7, 36, "Output",
 CellID->16541]
}, Open  ]],
Cell[9440, 336, 99, 2, 70, "ExampleText",
 CellID->4833],
Cell[CellGroupData[{
Cell[9564, 342, 93, 3, 70, "Input",
 CellID->31115],
Cell[9660, 347, 198, 7, 36, "Output",
 CellID->4639]
}, Open  ]],
Cell[9873, 357, 121, 3, 70, "ExampleDelimiter",
 CellID->29658]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10043, 366, 311, 9, 70, "SeeAlsoSection",
 CellID->32439],
Cell[10357, 377, 1485, 53, 70, "SeeAlso",
 CellID->24626]
}, Open  ]],
Cell[CellGroupData[{
Cell[11879, 435, 313, 9, 70, "TutorialsSection",
 CellID->4966],
Cell[12195, 446, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[12376, 451, 167, 3, 70, "Tutorials",
 CellID->7376]
}, Open  ]],
Cell[CellGroupData[{
Cell[12580, 459, 317, 9, 70, "MoreAboutSection",
 CellID->1145771],
Cell[12900, 470, 128, 3, 70, "MoreAbout",
 CellID->469663495]
}, Open  ]],
Cell[13043, 476, 27, 0, 70, "History"],
Cell[13073, 478, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

