(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     85284,       2543]
NotebookOptionsPosition[     73883,       2143]
NotebookOutlinePosition[     75409,       2184]
CellTagsIndexPosition[     75323,       2179]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], 
          "Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Solving Logical Combinations of Equations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Xor" :> Documentation`HelpLookup["paclet:ref/Xor"], 
          "LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "BitOr" :> 
          Documentation`HelpLookup["paclet:ref/BitOr"], "Nor" :> 
          Documentation`HelpLookup["paclet:ref/Nor"], "And" :> 
          Documentation`HelpLookup["paclet:ref/And"], "Not" :> 
          Documentation`HelpLookup["paclet:ref/Not"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Xor\"\>", 2->"\<\"LogicalExpand\"\>", 
       3->"\<\"BitOr\"\>", 4->"\<\"Nor\"\>", 5->"\<\"And\"\>", 
       6->"\<\"Not\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Or ",
 StyleBox["(||, \[Or])", "OperatorCharacter"]
}], "ObjectName",
 CellID->24778],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], "||", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], "||", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "\[LineSeparator]is the logical OR function. It evaluates its arguments \
in order, giving ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " immediately if any of them are ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if they are all ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7200]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[Or]", 
    SubscriptBox["e", "2"], "\[Or]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". The character ",
 Cell[BoxData["\[Or]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]||\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]or\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Or]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->5071],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and explicitly controls the evaluation of its arguments. In ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "||", 
    SubscriptBox["e", "2"], "||", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are evaluated in order, stopping if any of them is found to be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1885],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " gives symbolic results when necessary, removing initial arguments that are \
",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21974]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->691721337],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->344350584],

Cell["Combine assertions with ||:", "ExampleText",
 CellID->48276095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", ">", "2"}], "||", 
  RowBox[{"Pi", ">", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129342052],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61525506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->272543387],

Cell["A symbolic disjunction:", "ExampleText",
 CellID->257061919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "||", "b", "||", 
  RowBox[{"!", "c"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40726281],

Cell[BoxData[
 RowBox[{"a", "||", "b", "||", 
  RowBox[{"!", "c"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2594568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->629075941],

Cell["A system of equations:", "ExampleText",
 CellID->497418773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}]}], "\[Equal]", "3"}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"4", "x"}], "+", 
    RowBox[{"5", "y"}]}], "\[Equal]", "6"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370474334],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}], "\[Equal]", "3"}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}]}], "\[Equal]", "6"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466843801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26922785],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]or\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "\[Or]", "q"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"p", "||", "q"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->986921474]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->332304048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " works with any number of arguments:"
}], "ExampleText",
 CellID->234037899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Or", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11849551],

Cell[BoxData[
 RowBox[{"x", "||", "y", "||", "z"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241617557]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " is associative:"
}], "ExampleText",
 CellID->60318973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Or", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Or", "[", 
     RowBox[{"y", ",", "z"}], "]"}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237186586],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Or", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->332553704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213761091],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " with explicit ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " arguments will simplify:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18400621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Or", "[", 
  RowBox[{"x", ",", "False", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534512268],

Cell[BoxData[
 RowBox[{"x", "||", "z"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312629956]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "[", 
  RowBox[{"x", ",", "True", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599319570],

Cell[BoxData[
 RowBox[{"x", "&&", "z"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744987459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39071304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " evaluates its arguments in order, stopping when an argument evaluates to \
",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->76232233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Or", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "True"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201736223],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->99836030],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->613786455]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Or", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "False"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200768372],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2690402],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->110865545]
}, Open  ]],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126298193]
}, Open  ]],

Cell["The order of arguments may be important:", "ExampleText",
 CellID->128888979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "\[Equal]", "0"}], "||", 
   RowBox[{"y", "\[Equal]", 
    RowBox[{"1", "/", "x"}]}]}], "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->700237770],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->395370997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "\[Equal]", 
    RowBox[{"1", "/", "x"}]}], "||", 
   RowBox[{"x", "\[Equal]", "0"}]}], "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->602059520],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->97819134],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->665463754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375923361],

Cell["\<\
Symbolic transformations will not preserve argument ordering:\
\>", "ExampleText",
 CellID->531520307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "||", "y", "||", "y", "||", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18042936],

Cell[BoxData[
 RowBox[{"z", "||", "y", "||", "y", "||", "x"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373821336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172565786],

Cell[BoxData[
 RowBox[{"x", "||", "y", "||", "z"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->210189064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161860430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->299487167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "||", "y", "||", "z"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229221090],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Or]", "y", "\[Or]", "z"}], TraditionalForm]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->243169804]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4686],

Cell[TextData[{
 "Combine conditions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code:"
}], "ExampleText",
 CellID->102489113],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotRealNegativeQ", "[", 
   RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Head", "[", "x", "]"}], "===", "Complex"}], "||", 
   RowBox[{"x", "\[GreaterEqual]", "0"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->930520182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotRealNegativeQ", "[", 
  RowBox[{"-", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15657092],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272252054]
}, Open  ]],

Cell[TextData[{
 "If an argument of ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", any subsequent arguments are not evaluated:"
}], "ExampleText",
 CellID->284165656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotRealNegativeQ", "[", "I", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->115100274],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1573202]
}, Open  ]],

Cell[TextData[{
 "The argument order in ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " matters; if we reverse the last two arguments, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"], "\[GreaterEqual]", "0"}]], "InlineFormula"],
 " is evaluated:"
}], "ExampleText",
 CellID->35985314],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotRealNegativeQ2", "[", 
   RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "\[GreaterEqual]", "0"}], "||", 
   RowBox[{
    RowBox[{"Head", "[", "x", "]"}], "===", "Complex"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->779001943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotRealNegativeQ2", "[", "I", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9685162],

Cell[BoxData[
 RowBox[{
  RowBox[{"GreaterEqual", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"GreaterEqual::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->148424993],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->926131114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->811689623],

Cell["Combine assumptions:", "ExampleText",
 CellID->66247382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], "^", "2"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "\[LessEqual]", 
     RowBox[{"-", "1"}]}], "||", 
    RowBox[{"x", "\[GreaterEqual]", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57293133],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190669155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16685823],

Cell[TextData[{
 "Combine equations and inequalities; ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " is used both in the input and in the output:"
}], "ExampleText",
 CellID->4442628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "\[Equal]", "1"}], "||", 
    RowBox[{
     RowBox[{"x", "^", "3"}], "\[LessEqual]", 
     RowBox[{"1", "/", "8"}]}]}], ",", "x", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->966390519],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   FractionBox["1", "2"]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{87, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385040657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112718518],

Cell["Use || to combine conditions:", "ExampleText",
 CellID->141137913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "||", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152893273],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mftPHFUUx4d9Q0EeArsLpWx9xZj4m/+CRat92Yd92Xal1PYHg6n85A9t
YjRG0zRRG80qKSE0q1hSKpqaNTQoNbS0RCJGIgmRhIQfaDBEIjEkJPg9987u
bM/OzJ6h1k2YmTN7Puece+65586w25IdJ9teT3acak0mWk4n3zh5qvXNxJb2
07jlLzEM4wz+3o4ZuF7Dlfo7s7aGc+GxGscAFGI4+3GuxdmXJ0fN731Ku4aO
dFtJhhHPk+lSfR+wZG0nXyPKLGi75aYXP9OuMu8HPPvhcolSq3WJRmaXRkwp
JnsPzmZ1AeM90/UFGtYc+kyLdK7Lm/H8+2oubCpGH0PmzHQoKcxmNYhzu6E+
fvMW+beZ4QAjK9n3YSZHmFzBZN99fp/zt7S0RJclKvJSpkWjIPE1JaysrPT1
9WVHaK+dL5+gQxDUwMDAhdQ3Y2NjlqdQwawFGd1Gh5Cmr9+Y6+kd0QY0HzZn
L8So42pwOWrs139yoOmZZ741OzZNGD4wht+OIn9c25+nTXr2PpKMCjj6yKeO
MSoooo4yKiSijjAq7JoFrh0RZeEwo0pFkR1iVJmIOsioDSLqAKPKRdR+RlW4
5o5rPyTK3T5GVYoi28uoKhG1h1HVImo3o2pcs8C1HxZlYRejam19UG/w23SU
nYyus6V55+V78g5mpd7Wipf9gC63M6tRcWwkPk1CcHFxcWJiYmhoCDY6OzuN
YCqVMoJdXV2QR0ZGpqamlpeX9Z6b5ymW9WRGK8vCU3SIwOPw8HA6nX7v3KWL
l3648u3Ed9f/uP3L36pTRW7+/BfEL6/cSV3M9PT0YO8YHx9HCBUsgvi65uFJ
Nea5uTlYgfvLX48P37qr10UQVrvTN+ATycAGZ5Qxjw2OdWO3pzyh3GOsmUzm
/Md9GJOqnACGi6EjATAcZh4aRWvmcSUjKx+c/2Ig87uZCQylt7d3dnbWrGDL
6kbXNfWYilNrY/iYBxVF4Kc7f3706VXEubq66mMWm0Tr7hElIwOYQwzfaCYq
hDhhZUV9tLlNolFvVvLCwsK5D7+iOdusovz+x9kB9YGdZpGdRNYOJgW1ZjwK
ygc6IaKblYxy7O/vpyi2iKhNSkYiESgiNlpcZ0T7GB0dTV8eJcUWUbablDw/
P4/8EPCcKDJNYYL0Y4+Q2qhktAasUQKeF1GN2Syg/lFdxlbXLHAfW0VZ0D6Q
ZhQcp5wja1Ay1vy773cT8IIHyorQCzU4OHj12m/uFGVBj4caxq27XNs5C/Hs
ej37zmcEvCiKLJ5dGegrzlTEjIzvk5qemZmhh3ZHWnW8e57geYeOs6x6sUNm
HPl7dqoHG0ehnenp6U86r92/Hexc6FvrnR2rwmUVoWsVRYRGKa1VNEa0OHmt
ah9QIUWPq8jqdl4odCBkgTqQjNLjsvqxpG9hh4APbKbCvqUpPG/hwUfeUbkv
GdXEMu5lp0DuMMH0DOBMWXuY3q0pMtkepqnJycnPuwcJkO2uiez8mON51gOF
HmnuRjKqOUuZT0LOEVpZsLS97OQW5WVPtij7WqD+4LfpLo2Mtq/xYv+7aWBW
7NdXMStxZsW+Vzn91ynG6G22/b9YDFFmZfu6RlLPrOzw1LPrGL1TVAe1jNrl
WqFc+yVRhdYwarcoMv4OuUdEVTFqr4iqZNQ+1yxw7ZdFWeBvpPtFkZUz6oCI
2sCogyKKv8EeElGljDrsmjuu/Yood/zN94goshCjjooo/j58TEQFGJV0zQLX
flWUBf5e3er4bJj7nSeco/GxyONF/xtiZC2EchZyeJu8uwW1bHk+YcuW2YyU
xGfeOntB3ceZLqNMjuHgd7RQMBaX3st/yygme+X/b3//Ne/23tGeqx6qbf0r
VuGvXEbJv8R+mBM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{126, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121535848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "<", "1"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "<", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182583579],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125612805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152582693],

Cell[TextData[{
 "A cellular automaton based on ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12039839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Or", "@@", "#"}], "&"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "True", "}"}], ",", "False"}], "}"}], ",", "20"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368008395],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNlsFLAkEYR2fRBQMFg4oSNjTYIISEhISCBJE2SFEo8NoggnsQTb107OzR
o8eOXjr0/+VbEfEc9mMH5vG9713mOE077fcGdhp2bT4Y21E/7E7yj8Mxq4Rj
jPnhvp0a5l+m9Y1WnEQ0r4/5Bs6+tsntlrOMFv/bdl7hgi80Ja4HYIGmxTUD
5mhWXA/BDD0S1xPwiZ7FqubAB+qJ6zl4RwviegFC1BfXS2DRK3Etgg56Hata
Ai30RlzLIEBvxbUCquiduN6DCvogrlVQQmuxqnXgo4G4PgEPfRbXBjhGW+La
Bhn0RVxfgYt2xPVvf83NT9ZZAQZ/oNQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281218648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228432876],

Cell["\<\
Find the area of the union of sets given by algebraic conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], "||", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "\[Pi]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114899061]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmg9sVdUdxw/vta8tTvEPUlCEAio4dWp0mzGI/0FFs8UlZpvR2DAnalAC
Mh3aIKgxGmPin8x0kpIGrFaIOMZq6jBMXKpoMyJmRDIykiYmY8EQiWQhIbn7
/H7nnp77zrvn3YqCxti09/a8e76/8/t/fud3343t98+/Y0H7/XfNa2+bs6h9
4fy75i1um33fIj4qjzLGbOTvzfGG/xP+07+NScK99jqda5kJU7iXuJ+Zjqdx
b+DeqrNmyFU+TvTHTJZLgx9bXHbGtMzYDNNpS6k2fGl6pwfjcYfJ1xnB+ORv
mM7Umhmtw3YRe0zN2EXuZ6T38RF72usYrmuYNUpHlVTrjcHaoRXC5191fKTp
fxvWk3AzpinzxBwFTY89wpJ93fS9pkw5VRE/JTeso6mQkzAP3JAz367UEjyR
lWS4Kr3nz8iOu4dpVZIwSkMJ/VzxhZLD5M4YcxSfCCfd6f3orvzd5zb75Fb1
kH379n3qfsqDg4OmPDQ0ZIemxOXiGml/KbimvXv37ty5E8CGDRt6eno6Ozuf
eHqNKT/z/Lry6t4BU37uxTf4n19TkkuFCStXrmTy5s2bt23bBuULolr7hVxa
4Gz79u19fX2rVq166plXOrv6Ifzm2//e8v5/zXGDH//PtHzw0ReMX9+4vbvn
XRZhifXr1w8MDCCB+VFU7p8r/1DfunVrb28vbHet+dtf/vqv9/7xuZkgdCtv
vTP06usfIgErw+7u3bvPjlK7US6VQ4cOoQ1LrWft1s0D/2lTStCEvRc6/wyl
LVu2sOiMKKW5cmncv38/E1evXo28kDFnCp1G6Kz90zaIIyDs6N6aT+U6RwXG
H3+yG5TIdbZQaUAuWFm3bh0kTo9SmKN+cfDgQTQJBfg/X9Fvv/spaBjYs2fP
1Cj6GkWjD4yMX6DHi9zaTz/72qZNmw4cONBW41MWBWGYw5iw/FNBld/o+ydK
xQ3MpKi3XOlWxJ4sgdIu0RUhgmHhF62fFuX3Ch2jLyZiOTNL14VbONm1a5eZ
GEVermMcmZnoxlyuSHzyDyv7UJ05NYq8TMdIhdOKda5SJKrq7+9H72ZCks3M
Agxz9ywdY2IkFPA1SmFD/ycEGLJorWUpNAfIcLeaqWOreUxtrlVKyAMlYlxr
u8PbBy9xfmTtAsnrlTbxm9IeV5dLGV6o3oyO8SbCAhzuYEpEuikTUhhMSN6g
dNFkSvfExFaPxdKfp5kGjdlMA11MggMSNmQWib+bAtpj6/KcHZ/jMsOOHTtQ
LqFk88yvHEU+FFudVGXtvH34h6oFAge3IjO81L1J/O3WjKXEa06M+tuMDN7G
pHjd7YqHIQSXCSdE8dNVPEyA8gHj4vMUi/r5kYfHR7F66pBdZjiyf6tYUglZ
SB6OiWJt5cS6pH+ReL7THHwgTYAUzU1zPodMrAandwdSHpvE8siUJM0E6JP5
ZoEiScNkdofM57NNx3gHOUT4vFeRf//wM2QWPuPIyQ6J2zHfLFQkcUhoy6Mf
RJGTHLfoRqy5SJEMICaPjokiT9MxfMGt7KWLXe4g+9RHTtQxHp3KuSRYc3QB
EqEQTUBLgjWrkWIfiyB08HaZ/ECwVnPUjqfoGI9jMg5gHgzWaolyaZGYn9gX
0O8VScShLLdmPnJCwO1Si+wdoECqjxzvdEpgigc85HIk45EgSVzpHvCwIsm0
JHN51BRFtjoPICeJhjqCaC5CEpEEl4A6Am6rkWKf1kC+ZYEdG6N21H5JmSRB
qhCQRSIsIsujSpRLiyTgCWOP9B4QR2pPpEz+WPFEl2jmEZdx2GxGgvTcLlck
FRuO6OSsh/SxYZEUEZQfI0GiWAzgkWRo8nwtUrR8srM88snkFYFmGqLWsKda
KmvKYo8kC5Dj6nM5NvDTFYFOi5DUjJSBAnpUkcAwkOO2HtJHskXi7iTMkSC9
Th8NosojXQbK70TAJSJ6CiR4yphqCtqDqTqj5/cSli57ARqHQ0tIFdEoJa67
cOT5qaXVsfxFAu3roRVaLY9WfavZUt5T8PFb5DEEEGF0OL5G0k3rWIukCE2f
FyFJEKQJH1PUq1RGSZ3IJ+mSej3C10VFkU8GX/bYHyUnWiQVMgV57Vq1+cnn
4eVBBi9C+pyxPIjCIiRGw3QCesSdyghIZCjcNVAgavS7hs9wRUi2etnwh5E+
Dxch/U68LKiNq5HDXfSMt3XkyJdvx9bAAzrcCZsEK4/iu3645sNBZVyE9Gs+
5Lhl/5EzS1FF5XfFpQG3RUh0yppScSwNckEceUoQVQ8GURWvHE8NPP2BwNOr
kb6+RQdwKVX479yZgSQmdmyJ2tEiCQREEp9ZEqwVr8Jt5Y/RMJ2AFgdrxit/
e9rwdd+iYM04cnIQGwtdVHGGkDXjJ5w2h0xr6vsCO8aR9iRHNZ72VxYEvhM/
j+m7LenppCfOe5yGGMtJ7rgaO9ozKqme5CT9k7uD6i1+3lSk9K1wchjFze4M
Tn/xk7G+k2uAT7KcPVX/xvkq2Ur0Gj+RazdATvPkHIwCtt1VZEgpHYl4J+As
uTTitZiFEMYy0iO5zUU1taH0jX0nQmJN4OF+Lf1U1xshuFjXdk1vCTKLp1T0
5kP6vdqVznZ1Mflb7wyZm4PT2Ekjpio9atNsO9E4Dz5L7QO30m3u6i9pp9uW
mL4P5dcpfrPzkyTNj6gNkU1JO/DUrempfm4O5yN7EzTTUU5j4DoXsSmlcXV5
y44vdZTSmJjtrM02JZ3Z6l5jXm01KxMjbCHmandqZCzdbN/vzO+U4idsPvi5
uVKRaNweIDVj1+vr4uXIL/lV+7oNcA0Z2zCL92e1o1y20SU94Zm6Kp7EqlA0
8W7yVUkS9KIvzqxre9GTkjCHzFYUGX04mn/sMhYxKitOTmJZZE51NLPQBboi
eoZb22+fEuX32kw8Q8A298y5GQooHkVPi1K4XinY3qLPCDOEgry1gCJ0LRHt
BeZT0XeiFfiw+QDVUV+SdqcKnQo8oQpyKqRYBkeaHqX0M6WELqlO4QfrQwmW
JgqlJjiCEqHLI3RDjpYq5KwotZvk0oQnQA2+QMEFMklWGSsUmyENRayGriiQ
IUocQ/ScGivfrLTQFKsihc0lWJykaWwmIfPj2vyailxGYwE+55dIQxCOSvDA
ClgbdZ4X9Ylfq01wNY7rg/rDhmKacXtTwRT2IwIPuXDVi6LSf/PvKL8r71q/
DXJIlZ73TSY/I/tGw9SdOfLvIYwOnrhuQ1fi3tHkzag9f/px+H2K8HtN4XO/
Cxf3Eb7/ftFXX6+2FnhZP6n9zpcZ9X8Fxgbq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21865579]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30080],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->470387246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Or", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"True", "True"},
    {"True", "False"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{75, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72002570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->485940985],

Cell[TextData[{
 Cell[BoxData["&&"], "InlineFormula"],
 " has higher precedence than ",
 Cell[BoxData["||"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->135203284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "||", 
   RowBox[{"q", "&&", "r"}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692597311],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Or", "[", 
    RowBox[{"p", ",", 
     RowBox[{"And", "[", 
      RowBox[{"q", ",", "r"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->239265482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457007913],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->567610107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "b"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"c", "||", "d", "||", "e"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306334394],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "b"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"c", "||", "d", "||", "e"}], ")"}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54886778]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->622865612],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "d"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "e"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "d"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "e"}], ")"}]}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->478730752]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75538029],

Cell[TextData[{
 "De Morgan's laws relate ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->346309266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "&&", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238943236],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "||", 
  RowBox[{"!", "b"}]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59139015]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "||", "b", "||", "c"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->864089889],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "&&", 
  RowBox[{"!", "b"}], "&&", 
  RowBox[{"!", "c"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27275223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->703424975],

Cell[TextData[{
 "Disjunction of conditions corresponds to ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->257207371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"Boole", "[", "a", "]"}], ",", 
    RowBox[{"Boole", "[", "b", "]"}]}], "]"}], "-", 
  RowBox[{"Boole", "[", 
   RowBox[{"a", "||", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551050724],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Boole", "[", 
    RowBox[{"a", "||", "b"}], "]"}]}], "+", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"Boole", "[", "a", "]"}], ",", 
    RowBox[{"Boole", "[", "b", "]"}]}], "]"}]}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152755044]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40654382],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211513355]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14295],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Xor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["And",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1071],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->11333],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], "Tutorials",
 CellID->4500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->866786000],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->37602435]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Or (||, \[Or]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 21.4090324}", "context" -> "System`", 
    "keywords" -> {
     "alternation", "Bar", "disjunction", "or ", "Vel", "vertical bar", 
      "inclusive or", "union", "join", "logical connective", 
      "Boolean algebra", "switching algebra", "logical sum", "logical +", 
      "logical plus"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "e_1 || e_2 || ... is the logical OR function. It evaluates its arguments \
in order, giving True immediately if any of them are True, and False if they \
are all False. ", "synonyms" -> {"|", "||"}, "title" -> "Or", "type" -> 
    "Symbol", "uri" -> "ref/Or"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7416, 250, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->691721337]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 75180, 2172}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2459, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3082, 85, 103, 4, 70, "ObjectName",
 CellID->24778],
Cell[3188, 91, 1195, 39, 70, "Usage",
 CellID->7200]
}, Open  ]],
Cell[CellGroupData[{
Cell[4420, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4898, 152, 1324, 48, 70, "Notes",
 CellID->5071],
Cell[6225, 202, 798, 28, 70, "Notes",
 CellID->1885],
Cell[7026, 232, 353, 13, 70, "Notes",
 CellID->21974]
}, Closed]],
Cell[CellGroupData[{
Cell[7416, 250, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->691721337],
Cell[CellGroupData[{
Cell[7801, 264, 148, 5, 70, "ExampleSection",
 CellID->344350584],
Cell[7952, 271, 69, 1, 70, "ExampleText",
 CellID->48276095],
Cell[CellGroupData[{
Cell[8046, 276, 140, 5, 28, "Input",
 CellID->129342052],
Cell[8189, 283, 160, 5, 36, "Output",
 CellID->61525506]
}, Open  ]],
Cell[8364, 291, 125, 3, 70, "ExampleDelimiter",
 CellID->272543387],
Cell[8492, 296, 66, 1, 70, "ExampleText",
 CellID->257061919],
Cell[CellGroupData[{
Cell[8583, 301, 121, 4, 70, "Input",
 CellID->40726281],
Cell[8707, 307, 208, 7, 36, "Output",
 CellID->2594568]
}, Open  ]],
Cell[8930, 317, 125, 3, 70, "ExampleDelimiter",
 CellID->629075941],
Cell[9058, 322, 65, 1, 70, "ExampleText",
 CellID->497418773],
Cell[CellGroupData[{
Cell[9148, 327, 261, 10, 70, "Input",
 CellID->370474334],
Cell[9412, 339, 365, 13, 36, "Output",
 CellID->466843801]
}, Open  ]],
Cell[9792, 355, 124, 3, 70, "ExampleDelimiter",
 CellID->26922785],
Cell[9919, 360, 189, 7, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[10133, 371, 96, 3, 70, "Input",
 CellID->162312622],
Cell[10232, 376, 181, 6, 36, "Output",
 CellID->986921474]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10462, 388, 220, 7, 70, "ExampleSection",
 CellID->332304048],
Cell[10685, 397, 201, 7, 70, "ExampleText",
 CellID->234037899],
Cell[CellGroupData[{
Cell[10911, 408, 130, 4, 70, "Input",
 CellID->11849551],
Cell[11044, 414, 192, 6, 36, "Output",
 CellID->241617557]
}, Open  ]],
Cell[11251, 423, 180, 7, 70, "ExampleText",
 CellID->60318973],
Cell[CellGroupData[{
Cell[11456, 434, 210, 7, 70, "Input",
 CellID->237186586],
Cell[11669, 443, 354, 13, 50, "Output",
 CellID->332553704]
}, Open  ]],
Cell[12038, 459, 125, 3, 70, "ExampleDelimiter",
 CellID->213761091],
Cell[12166, 464, 490, 18, 70, "ExampleText",
 CellID->18400621],
Cell[CellGroupData[{
Cell[12681, 486, 135, 4, 70, "Input",
 CellID->534512268],
Cell[12819, 492, 181, 6, 36, "Output",
 CellID->312629956]
}, Open  ]],
Cell[CellGroupData[{
Cell[13037, 503, 135, 4, 70, "Input",
 CellID->599319570],
Cell[13175, 509, 181, 6, 36, "Output",
 CellID->744987459]
}, Open  ]],
Cell[13371, 518, 124, 3, 70, "ExampleDelimiter",
 CellID->39071304],
Cell[13498, 523, 405, 14, 70, "ExampleText",
 CellID->76232233],
Cell[CellGroupData[{
Cell[13928, 541, 244, 8, 70, "Input",
 CellID->201736223],
Cell[14175, 551, 90, 2, 70, "Print",
 CellID->99836030],
Cell[14268, 555, 161, 5, 36, "Output",
 CellID->613786455]
}, Open  ]],
Cell[CellGroupData[{
Cell[14466, 565, 245, 8, 70, "Input",
 CellID->200768372],
Cell[CellGroupData[{
Cell[14736, 577, 89, 2, 70, "Print",
 CellID->2690402],
Cell[14828, 581, 91, 2, 70, "Print",
 CellID->110865545]
}, Open  ]],
Cell[14934, 586, 162, 5, 36, "Output",
 CellID->126298193]
}, Open  ]],
Cell[15111, 594, 83, 1, 70, "ExampleText",
 CellID->128888979],
Cell[CellGroupData[{
Cell[15219, 599, 233, 8, 70, "Input",
 CellID->700237770],
Cell[15455, 609, 161, 5, 36, "Output",
 CellID->395370997]
}, Open  ]],
Cell[CellGroupData[{
Cell[15653, 619, 233, 8, 70, "Input",
 CellID->602059520],
Cell[15889, 629, 366, 7, 70, "Message",
 CellID->97819134],
Cell[16258, 638, 161, 5, 36, "Output",
 CellID->665463754]
}, Open  ]],
Cell[16434, 646, 125, 3, 70, "ExampleDelimiter",
 CellID->375923361],
Cell[16562, 651, 112, 3, 70, "ExampleText",
 CellID->531520307],
Cell[CellGroupData[{
Cell[16699, 658, 114, 3, 70, "Input",
 CellID->18042936],
Cell[16816, 663, 203, 6, 36, "Output",
 CellID->373821336]
}, Open  ]],
Cell[CellGroupData[{
Cell[17056, 674, 104, 3, 70, "Input",
 CellID->172565786],
Cell[17163, 679, 192, 6, 36, "Output",
 CellID->210189064]
}, Open  ]],
Cell[17370, 688, 125, 3, 70, "ExampleDelimiter",
 CellID->161860430],
Cell[17498, 693, 203, 7, 70, "ExampleText",
 CellID->299487167],
Cell[CellGroupData[{
Cell[17726, 704, 142, 4, 70, "Input",
 CellID->229221090],
Cell[17871, 710, 244, 7, 50, "Output",
 CellID->243169804]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18164, 723, 222, 7, 70, "ExampleSection",
 CellID->4686],
Cell[18389, 732, 140, 6, 70, "ExampleText",
 CellID->102489113],
Cell[18532, 740, 294, 9, 70, "Input",
 CellID->930520182],
Cell[CellGroupData[{
Cell[18851, 753, 129, 4, 70, "Input",
 CellID->15657092],
Cell[18983, 759, 162, 5, 36, "Output",
 CellID->272252054]
}, Open  ]],
Cell[19160, 767, 363, 13, 70, "ExampleText",
 CellID->284165656],
Cell[CellGroupData[{
Cell[19548, 784, 112, 3, 70, "Input",
 CellID->115100274],
Cell[19663, 789, 159, 5, 36, "Output",
 CellID->1573202]
}, Open  ]],
Cell[19837, 797, 403, 14, 70, "ExampleText",
 CellID->35985314],
Cell[20243, 813, 295, 9, 70, "Input",
 CellID->779001943],
Cell[CellGroupData[{
Cell[20563, 826, 111, 3, 70, "Input",
 CellID->9685162],
Cell[20677, 831, 391, 7, 70, "Message",
 CellID->148424993],
Cell[21071, 840, 161, 5, 36, "Output",
 CellID->926131114]
}, Open  ]],
Cell[21247, 848, 125, 3, 70, "ExampleDelimiter",
 CellID->811689623],
Cell[21375, 853, 62, 1, 70, "ExampleText",
 CellID->66247382],
Cell[CellGroupData[{
Cell[21462, 858, 383, 13, 70, "Input",
 CellID->57293133],
Cell[21848, 873, 222, 8, 36, "Output",
 CellID->190669155]
}, Open  ]],
Cell[22085, 884, 124, 3, 70, "ExampleDelimiter",
 CellID->16685823],
Cell[22212, 889, 249, 8, 70, "ExampleText",
 CellID->4442628],
Cell[CellGroupData[{
Cell[22486, 901, 310, 10, 70, "Input",
 CellID->966390519],
Cell[22799, 913, 267, 9, 51, "Output",
 CellID->385040657]
}, Open  ]],
Cell[23081, 925, 125, 3, 70, "ExampleDelimiter",
 CellID->112718518],
Cell[23209, 930, 72, 1, 70, "ExampleText",
 CellID->141137913],
Cell[CellGroupData[{
Cell[23306, 935, 480, 17, 70, "Input",
 CellID->152893273],
Cell[23789, 954, 2120, 39, 70, "Output",
 Evaluatable->False,
 CellID->121535848]
}, Open  ]],
Cell[CellGroupData[{
Cell[25946, 998, 757, 26, 70, "Input",
 CellID->182583579],
Cell[26706, 1026, 30586, 505, 70, "Output",
 Evaluatable->False,
 CellID->125612805]
}, Open  ]],
Cell[57307, 1534, 125, 3, 70, "ExampleDelimiter",
 CellID->152582693],
Cell[57435, 1539, 200, 8, 70, "ExampleText",
 CellID->12039839],
Cell[CellGroupData[{
Cell[57660, 1551, 440, 15, 70, "Input",
 CellID->368008395],
Cell[58103, 1568, 549, 13, 70, "Output",
 Evaluatable->False,
 CellID->281218648]
}, Open  ]],
Cell[58667, 1584, 125, 3, 70, "ExampleDelimiter",
 CellID->228432876],
Cell[58795, 1589, 116, 3, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[58936, 1596, 662, 22, 70, "Input",
 CellID->310451651],
Cell[59601, 1620, 207, 7, 36, "Output",
 CellID->114899061]
}, Open  ]],
Cell[59823, 1630, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[59908, 1635, 595, 21, 70, "Input",
 CellID->167686269],
Cell[60506, 1658, 3542, 62, 70, "Output",
 Evaluatable->False,
 CellID->21865579]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64097, 1726, 233, 7, 70, "ExampleSection",
 CellID->30080],
Cell[64333, 1735, 187, 8, 70, "ExampleText",
 CellID->470387246],
Cell[CellGroupData[{
Cell[64545, 1747, 280, 10, 70, "Input",
 CellID->95768180],
Cell[64828, 1759, 353, 13, 48, "Output",
 CellID->72002570]
}, Open  ]],
Cell[65196, 1775, 125, 3, 70, "ExampleDelimiter",
 CellID->485940985],
Cell[65324, 1780, 170, 6, 70, "ExampleText",
 CellID->135203284],
Cell[CellGroupData[{
Cell[65519, 1790, 149, 5, 70, "Input",
 CellID->692597311],
Cell[65671, 1797, 405, 15, 50, "Output",
 CellID->239265482]
}, Open  ]],
Cell[66091, 1815, 125, 3, 70, "ExampleDelimiter",
 CellID->457007913],
Cell[66219, 1820, 451, 18, 70, "ExampleText",
 CellID->567610107],
Cell[CellGroupData[{
Cell[66695, 1842, 200, 7, 70, "Input",
 CellID->306334394],
Cell[66898, 1851, 288, 10, 36, "Output",
 CellID->54886778]
}, Open  ]],
Cell[CellGroupData[{
Cell[67223, 1866, 109, 3, 70, "Input",
 CellID->622865612],
Cell[67335, 1871, 514, 18, 36, "Output",
 CellID->478730752]
}, Open  ]],
Cell[67864, 1892, 124, 3, 70, "ExampleDelimiter",
 CellID->75538029],
Cell[67991, 1897, 430, 18, 70, "ExampleText",
 CellID->346309266],
Cell[CellGroupData[{
Cell[68446, 1919, 177, 6, 70, "Input",
 CellID->238943236],
Cell[68626, 1927, 216, 8, 36, "Output",
 CellID->59139015]
}, Open  ]],
Cell[CellGroupData[{
Cell[68879, 1940, 188, 6, 70, "Input",
 CellID->864089889],
Cell[69070, 1948, 245, 9, 36, "Output",
 CellID->27275223]
}, Open  ]],
Cell[69330, 1960, 125, 3, 70, "ExampleDelimiter",
 CellID->703424975],
Cell[69458, 1965, 346, 13, 70, "ExampleText",
 CellID->257207371],
Cell[CellGroupData[{
Cell[69829, 1982, 271, 9, 70, "Input",
 CellID->551050724],
Cell[70103, 1993, 380, 13, 36, "Output",
 CellID->152755044]
}, Open  ]],
Cell[CellGroupData[{
Cell[70520, 2011, 103, 3, 70, "Input",
 CellID->40654382],
Cell[70626, 2016, 158, 5, 36, "Output",
 CellID->211513355]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70845, 2028, 311, 9, 70, "SeeAlsoSection",
 CellID->14295],
Cell[71159, 2039, 1395, 53, 70, "SeeAlso",
 CellID->32168]
}, Open  ]],
Cell[CellGroupData[{
Cell[72591, 2097, 313, 9, 70, "TutorialsSection",
 CellID->1071],
Cell[72907, 2108, 172, 3, 70, "Tutorials",
 CellID->11333],
Cell[73082, 2113, 191, 4, 70, "Tutorials",
 CellID->4500]
}, Open  ]],
Cell[CellGroupData[{
Cell[73310, 2122, 319, 9, 70, "MoreAboutSection",
 CellID->866786000],
Cell[73632, 2133, 156, 3, 70, "MoreAbout",
 CellID->37602435]
}, Open  ]],
Cell[73803, 2139, 50, 0, 70, "History"],
Cell[73856, 2141, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

