(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23424,        606]
NotebookOptionsPosition[     20771,        516]
NotebookOutlinePosition[     21968,        552]
CellTagsIndexPosition[     21883,        547]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightOrange" :> 
          Documentation`HelpLookup["paclet:ref/LightOrange"], "ColorData" :> 
          Documentation`HelpLookup["paclet:ref/ColorData"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightOrange\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Orange", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Orange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Orange"]], "InlineFormula"],
     "\[LineSeparator]represents the color orange in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Orange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orange"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"1", ",", "0.5", ",", "0"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108857021],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->219675885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Orange", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->407885797]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->285006848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Orange", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->610652863,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightOrange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightOrange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->45135351]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Orange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 13.9400912}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Orange represents the color orange in graphics or style specifications. \
", "synonyms" -> {}, "title" -> "Orange", "type" -> "Symbol", "uri" -> 
    "ref/Orange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3717, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->108857021]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21740, 540}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1677, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2300, 64, 43, 1, 70, "ObjectName",
 CellID->6361],
Cell[2346, 67, 446, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2829, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3307, 103, 373, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[3717, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108857021],
Cell[CellGroupData[{
Cell[4102, 136, 148, 5, 70, "ExampleSection",
 CellID->219675885],
Cell[CellGroupData[{
Cell[4275, 145, 184, 6, 28, "Input",
 CellID->511908593],
Cell[4462, 153, 265, 8, 121, "Output",
 CellID->407885797]
}, Open  ]],
Cell[CellGroupData[{
Cell[4764, 166, 267, 8, 28, "Input",
 CellID->245967023],
Cell[5034, 176, 2362, 43, 109, "Output",
 Evaluatable->False,
 CellID->285006848]
}, Open  ]],
Cell[CellGroupData[{
Cell[7433, 224, 187, 6, 70, "Input",
 CellID->82364862],
Cell[7623, 232, 10556, 178, 129, 88, 2, "CachedBoxData", "BoxData", "Output",
 CellID->610652863]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18240, 417, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[18554, 428, 1661, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[20252, 495, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[20574, 506, 123, 3, 70, "MoreAbout",
 CellID->45135351]
}, Open  ]],
Cell[20712, 512, 29, 0, 70, "History"],
Cell[20744, 514, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

