(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27369,       1019]
NotebookOptionsPosition[     21713,        811]
NotebookOutlinePosition[     22974,        847]
CellTagsIndexPosition[     22889,        842]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Structural Operations\"\>", 
       2->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Order" :> Documentation`HelpLookup["paclet:ref/Order"], 
          "Signature" :> Documentation`HelpLookup["paclet:ref/Signature"], 
          "Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Order\"\>", 2->"\<\"Signature\"\>", 
       3->"\<\"Sort\"\>", 4->"\<\"Ordering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderedQ", "ObjectName",
 CellID->335],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OrderedQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OrderedQ"], "[", 
       RowBox[{
        StyleBox["h", "TI"], "[", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
     " ",
     "\[LineSeparator]",
     "gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are in canonical order, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["e", "TI"], ",", 
     StyleBox["e", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11192],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["OrderedQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OrderedQ"]], "InlineFormula"],
 " uses canonical order as described in the notes for ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7605],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " uses the function ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " to determine whether each pair of elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " is in order. "
}], "Notes",
 CellID->25264]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37428591],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->514638849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31627],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29541],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26129]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27813],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OrderedQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OrderedQ"]], "InlineFormula"],
 " works with any expressions:"
}], "ExampleText",
 CellID->29174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", 
    RowBox[{"x", "+", "y"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20601],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20215],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OrderedQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OrderedQ"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "a", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8213],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25824],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " to test for ordering:"
}], "ExampleText",
 CellID->5601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}], ",", "Greater"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23392],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15759]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26428],

Cell["Find tuples that are in order:", "ExampleText",
 CellID->28027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "4"}], "]"}], ",", 
   "OrderedQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{441, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18786],

Cell["Find which tuples are in order:", "ExampleText",
 CellID->15498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24970],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFFPwjAQ7lYncxFBXsA3fo0++SMWYgIPRoP8d3iDdoBZPu7s9TaNmpKs
6bXffb1vd+s6nuvN8uW13qwW9fxpXb8vV4uP+ePb2g3ZzJhsa4wZzYzr712v
ufxv5y5jrnxrz2P7C/sG7FEAX32z/7Sj//iPxX/fcf2+/UPxW98c28AquTOR
3Z7GMQot/iESP/kl8Uwi+bV4jAfzlIuy6ee9WcD4gBlH/1LId+2awoT3LCnf
nZIvZ/xKpV6OT6uX49PqrRg/bX45Pq1ejk+qV1blDar4tBufI7d/kgbsLHJ6
NL4VvuZGdD+suFdIWTlc2ekO/BROq/qWwXXLO8eqVc3xSVRfPhF5AGVJ7UNy
FPeIoYgLTys6Fo8qiBhCbNT7Il4ZzsdqouY1aizjp88XxabJGBeVRCXWZNbE
r9vL6TuBvqiQ5gqds2UsodN2aBW6YmNZus7HqsBdTJcXZIlVgf4hFX2eKlIl
6lZJlUjZqRJTJdIsqRJlulMl/s9KlKDsqV4soQq/q9p4/92Fp1UOP43An7/n
pPF4/DiSfybEVy1+STxtfAw/Fw/977Pv7gQ9kx0Ax2exCA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{503, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415219445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "False", ",", "False", ",", "True", ",", "False", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32604]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"OrderedQ", "/@", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "6"}], "]"}]}], ",", "True"}], 
    "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->503],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWb1TE0EU3+SSQKOFVRxxCCiYRq1Q0YGxUStLhYqYYdRQOEGgoEM76MhY
BO1s7dAK7aS0c5zhD7DIjNhZUK77cXe7+/Jyu/c1xBkzcHfv9r3fvn3vt2/3
7h42N1pPXzQ3VpabtQdrzdXWyvJ67X57jd3yCoSwP0LeVwm7puxK/PNfgf3L
y8FXt9jRYwZT/rnIzkV2vuTLpCTU/N8EE0qa1qQvm1pjQrjDj17gCxWIpKRk
iaJrTADZA/I4P5SlHB77UGqaHLqmtZ/PybtaaoS8PNPbsYhNAhm2S79mqcz5
tJs/SsO3uxzXi5BJs6Blys2Dsu4B8dlKKrodbj1uxb8gbt/WRsbPHlVzp+gz
r+jPmqh2iXbOl36Hkt7jMXq3LOSjoyNf/olqyRmwuLjIbtXrdTICrCDKd4Fy
hh3/iPmM43W7XXZrc3NT2pdOTk5GR0dlBRAaZf1Or9fz+4HeK7liaU+r/78/
pE4M4BSUWbar1WqYbZh9jV2w17ijOJuyfdjx8KiLSmedMVeAPB2zfSzsm9+8
CDL7DfUMrzwSWdWMr6iWqNQaNw5DLV7pptAxRyEpXw9RLdzXY6PXOPXVHc/c
AQX7o6DiwzxKBLGqDFxnCOlfd6CcBoeLw+BHHjjXqcnOA2nnqRwFmdEzxM/S
UjH2M8qAqxRj7gGqe42azMURFadUXrLhaNZ4ivP6k0A00+UiEKTvdLkhcbwI
K/uMSWKNRUUfR5rRuDA7n7o3nBzVMjUgItkwIi8UPZ9Cw+Gphct8Yvyipz1P
EBTnLOS7SrtZ3hSyWj32DSTZqlaIjyjGDD/0rRD7qO4NIasVAkfExgOy7BTh
rJgh3vuM0ICR4UUclgOL2CxPOk+ym3HW+DrlJN91+rTxuOVdas6pCpDhO4g9
FHOemnOvAmT4LPqWulafOYrNV7Gpd36zobzflf1qfSSpnXK0qi5UgIw/mavR
dxJ7wen7CB1pNiNbAJ5LT7OfzaFGAqQnIKfbNJjdRYLve7lxA+RgB+XxEhrb
bVS3AWKFI/6LdcS2a811x5wQiYsrgBlbmfnWoiZ7XtGgfiVl8XOKMW3LiH9o
lwBfeqzYKT2OmiV5PDu8BBmB9biNYqyCaMP6Cd+TP0NR2miEPfQu/q5U9bAU
4ael7hurFOynYUTrNbDH1zTclx1g20C1XGrAGzD2x32ctNWEDhjlQh9CUlbv
ohGx7Vnu0YD76fbXHRBj2y4H+jWXwg9usNfHJ5wh8LvSfEbjfwfGD/nutgeb
kb1lUJU/oP64f0+DsnwLH++N8X7EmAczI62n6lsF9+kTFgcHnrjVQptcCn3R
4/LFwhV7rYzjM/7t5kdMH0pGVLNaC0nhL14sOn4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{256, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{256., Automatic}},
 CellLabel->"Out[3]=",
 CellID->713923090]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22663],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " by default sorts using ",
 Cell[BoxData[
  ButtonBox["OrderedQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OrderedQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"y", "^", "2"}], ",", 
    RowBox[{"x", "+", "y"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"], ",", "y", ",", 
   SuperscriptBox["y", "2"], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 ImageSize->{129, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"y", "^", "2"}], ",", 
     RowBox[{"x", "+", "y"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"OrderedQ", "[", 
     RowBox[{"{", 
      RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"], ",", "y", ",", 
   SuperscriptBox["y", "2"], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 ImageSize->{129, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27489]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18240],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OrderedQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OrderedQ"]], "InlineFormula"],
 " by default works structurally, not by numerical value:"
}], "ExampleText",
 CellID->12164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "E", ",", "Pi"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25542],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7619]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "E", ",", "Pi"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20913],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7591]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "E", ",", "Pi"}], "}"}], ",", "Less"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6704],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31818]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29292],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12181],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->28503],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->3829]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->48183579],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->112060878]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderedQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 14.8151136}", "context" -> "System`", 
    "keywords" -> {"testing for ordering", "ordered"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OrderedQ[h[e_1, e_2, ...]] gives True if the e_i are in canonical order, \
and False otherwise. ", "synonyms" -> {"ordered q"}, "title" -> "OrderedQ", 
    "type" -> "Symbol", "uri" -> "ref/OrderedQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5967, 202, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37428591]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22747, 835}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2307, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2930, 80, 44, 1, 70, "ObjectName",
 CellID->335],
Cell[2977, 83, 1189, 41, 70, "Usage",
 CellID->8759]
}, Open  ]],
Cell[CellGroupData[{
Cell[4203, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4681, 146, 416, 17, 70, "Notes",
 CellID->11192],
Cell[5100, 165, 353, 13, 70, "Notes",
 CellID->7605],
Cell[5456, 180, 474, 17, 70, "Notes",
 CellID->25264]
}, Closed]],
Cell[CellGroupData[{
Cell[5967, 202, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37428591],
Cell[CellGroupData[{
Cell[6351, 216, 148, 5, 70, "ExampleSection",
 CellID->514638849],
Cell[CellGroupData[{
Cell[6524, 225, 157, 5, 28, "Input",
 CellID->31627],
Cell[6684, 232, 157, 5, 36, "Output",
 CellID->6467]
}, Open  ]],
Cell[CellGroupData[{
Cell[6878, 242, 157, 5, 28, "Input",
 CellID->29541],
Cell[7038, 249, 157, 5, 36, "Output",
 CellID->26129]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7244, 260, 216, 7, 70, "ExampleSection",
 CellID->27813],
Cell[7463, 269, 201, 7, 70, "ExampleText",
 CellID->29174],
Cell[CellGroupData[{
Cell[7689, 280, 182, 6, 70, "Input",
 CellID->20601],
Cell[7874, 288, 156, 5, 36, "Output",
 CellID->6077]
}, Open  ]],
Cell[8045, 296, 121, 3, 70, "ExampleDelimiter",
 CellID->20215],
Cell[8169, 301, 320, 12, 70, "ExampleText",
 CellID->8683],
Cell[CellGroupData[{
Cell[8514, 317, 161, 5, 70, "Input",
 CellID->8213],
Cell[8678, 324, 158, 5, 36, "Output",
 CellID->23992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8885, 335, 239, 7, 70, "ExampleSection",
 CellID->25824],
Cell[9127, 344, 201, 8, 70, "ExampleText",
 CellID->5601],
Cell[CellGroupData[{
Cell[9353, 356, 201, 7, 70, "Input",
 CellID->23392],
Cell[9557, 365, 157, 5, 36, "Output",
 CellID->15759]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9763, 376, 223, 7, 70, "ExampleSection",
 CellID->26428],
Cell[9989, 385, 69, 1, 70, "ExampleText",
 CellID->28027],
Cell[CellGroupData[{
Cell[10083, 390, 253, 9, 70, "Input",
 CellID->4084],
Cell[10339, 401, 1365, 37, 71, "Output",
 CellID->10075]
}, Open  ]],
Cell[11719, 441, 121, 3, 70, "ExampleDelimiter",
 CellID->18786],
Cell[11843, 446, 70, 1, 70, "ExampleText",
 CellID->15498],
Cell[CellGroupData[{
Cell[11938, 451, 201, 7, 70, "Input",
 CellID->24970],
Cell[12142, 460, 809, 17, 70, "Output",
 Evaluatable->False,
 CellID->415219445]
}, Open  ]],
Cell[CellGroupData[{
Cell[12988, 482, 96, 3, 70, "Input",
 CellID->23847],
Cell[13087, 487, 307, 9, 36, "Output",
 CellID->32604]
}, Open  ]],
Cell[CellGroupData[{
Cell[13431, 501, 395, 13, 70, "Input",
 CellID->503],
Cell[13829, 516, 1648, 31, 70, "Output",
 Evaluatable->False,
 CellID->713923090]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15526, 553, 233, 7, 70, "ExampleSection",
 CellID->22663],
Cell[15762, 562, 313, 12, 70, "ExampleText",
 CellID->5706],
Cell[CellGroupData[{
Cell[16100, 578, 247, 8, 70, "Input",
 CellID->2363],
Cell[16350, 588, 303, 10, 39, "Output",
 CellID->9010]
}, Open  ]],
Cell[CellGroupData[{
Cell[16690, 603, 387, 13, 70, "Input",
 CellID->22171],
Cell[17080, 618, 304, 10, 39, "Output",
 CellID->27489]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17433, 634, 226, 7, 70, "ExampleSection",
 CellID->18240],
Cell[17662, 643, 228, 7, 70, "ExampleText",
 CellID->12164],
Cell[CellGroupData[{
Cell[17915, 654, 168, 5, 70, "Input",
 CellID->25542],
Cell[18086, 661, 156, 5, 36, "Output",
 CellID->7619]
}, Open  ]],
Cell[CellGroupData[{
Cell[18279, 671, 201, 7, 70, "Input",
 CellID->20913],
Cell[18483, 680, 157, 5, 36, "Output",
 CellID->7591]
}, Open  ]],
Cell[CellGroupData[{
Cell[18677, 690, 198, 7, 70, "Input",
 CellID->6704],
Cell[18878, 699, 158, 5, 36, "Output",
 CellID->31818]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19097, 711, 311, 9, 70, "SeeAlsoSection",
 CellID->29292],
Cell[19411, 722, 928, 35, 70, "SeeAlso",
 CellID->5997]
}, Open  ]],
Cell[CellGroupData[{
Cell[20376, 762, 314, 9, 70, "TutorialsSection",
 CellID->12181],
Cell[20693, 773, 152, 3, 70, "Tutorials",
 CellID->28503],
Cell[20848, 778, 169, 3, 70, "Tutorials",
 CellID->3829]
}, Open  ]],
Cell[CellGroupData[{
Cell[21054, 786, 299, 8, 70, "MoreAboutSection"],
Cell[21356, 796, 133, 3, 70, "MoreAbout",
 CellID->48183579],
Cell[21492, 801, 149, 3, 70, "MoreAbout",
 CellID->112060878]
}, Open  ]],
Cell[21656, 807, 27, 0, 70, "History"],
Cell[21686, 809, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

