(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39134,       1484]
NotebookOptionsPosition[     30775,       1198]
NotebookOutlinePosition[     32719,       1244]
CellTagsIndexPosition[     32633,       1239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ordering in Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/OrderingInLists"], 
          "Structural Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Ordering in Lists\"\>", 
       2->"\<\"Structural Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], "SortBy" :> 
          Documentation`HelpLookup["paclet:ref/SortBy"], "Max" :> 
          Documentation`HelpLookup["paclet:ref/Max"], "Min" :> 
          Documentation`HelpLookup["paclet:ref/Min"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "OrderedQ" :> 
          Documentation`HelpLookup["paclet:ref/OrderedQ"], "Median" :> 
          Documentation`HelpLookup["paclet:ref/Median"], "Order" :> 
          Documentation`HelpLookup["paclet:ref/Order"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Sort\"\>", 2->"\<\"SortBy\"\>", 3->"\<\"Max\"\>",
        4->"\<\"Min\"\>", 5->"\<\"Position\"\>", 6->"\<\"OrderedQ\"\>", 
       7->"\<\"Median\"\>", 8->"\<\"Order\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Elements of Lists\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ordering", "ObjectName",
 CellID->21132],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ordering",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ordering"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the positions in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " at which each successive element of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " appears. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ordering",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ordering"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the positions in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " at which the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " appear. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ordering",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ordering"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the positions of the last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Ordering",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Ordering"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sort"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24472]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In a numerical list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives the positions of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " smallest elements. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " gives the positions of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " largest elements. "
}], "Notes",
 CellID->27152],

Cell[TextData[{
 "If there are several smallest elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " will give only the position of the one that appears first. "
}], "Notes",
 CellID->25087],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"Ordering", "[", 
     StyleBox["list", "TI"], "]"}], "]"}], "]"}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28570],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["seq", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    RowBox[{"Ordering", "[", 
     StyleBox["list", "TI"], "]"}], ",", 
    StyleBox["seq", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29763],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " gives the position at which all elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " appear in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29901],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ordering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ordering"]], "InlineFormula"],
 " can be used on expressions with any head, not only ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17103]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->650274623],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->9966311],

Cell["Find the ordering that sorts a list:", "ExampleText",
 CellID->2088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{"{", 
   RowBox[{"c", ",", "a", ",", "b"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332233393]
}, Open  ]],

Cell["Apply the ordering:", "ExampleText",
 CellID->22409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"c", ",", "a", ",", "b"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417261553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4681],

Cell["Find the positions of the 4 smallest elements in a list:", "ExampleText",
 CellID->1588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}],
     "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "1", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41417900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32060],

Cell["Find the position of the largest element:", "ExampleText",
 CellID->21221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}],
     "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1758],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408531828]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14146],

Cell[TextData[{
 "Find positions of elements from the 4",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " smallest to the largest:"
}], "ExampleText",
 CellID->690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "7", ",", "2", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25077590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21430],

Cell[TextData[{
 "Find positions of elements in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["Greater",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Greater"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}],
     "}"}], ",", "All", ",", "Greater"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2", ",", "7", ",", "6", ",", "1", ",", "5", ",", "3"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150721740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}],
     "}"}], ",", "Greater"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "6", ",", "3", ",", "2", ",", "2", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89936252]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18035],

Cell["Use expressions with any head:", "ExampleText",
 CellID->32226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{"f", "[", 
   RowBox[{"3", ",", "1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1067002806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->214190283],

Cell["Find a permutation that sorts a list:", "ExampleText",
 CellID->11224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "1", ",", "6", ",", "7", ",", "2", ",", "4"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19923]
}, Open  ]],

Cell["Apply the permutation:", "ExampleText",
 CellID->3359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"2", ",", "6", ",", "1", ",", "9", ",", "1", ",", "2", ",", "3"}], 
   "}"}], "[", 
  RowBox[{"[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "3", ",", "6", ",", "9"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91707177],

Cell["Find the inverse of a permutation:", "ExampleText",
 CellID->14955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32726]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"b", ",", "c", ",", "a", ",", "d", ",", "e"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "2", ",", "3"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "b", ",", "c", ",", "a"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21025]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "a", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33125709],

Cell["Sort a list of lists with respect to a particular position:", \
"ExampleText",
 CellID->261689346],

Cell[BoxData[
 RowBox[{
  RowBox[{"sll", "[", 
   RowBox[{"ll_", ",", "elem_"}], "]"}], " ", ":=", " ", 
  RowBox[{"ll", "[", 
   RowBox[{"[", 
    RowBox[{"Ordering", "[", 
     RowBox[{"ll", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "elem"}], "]"}], "]"}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->458745561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "5", ",", "1"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23285322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "5", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377523818]
}, Open  ]],

Cell[TextData[{
 "The same as ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ", but ",
 Cell[BoxData[
  ButtonBox["Ordering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ordering"]], "InlineFormula"],
 " keeps the original ordering when elements are the same:"
}], "ExampleText",
 CellID->33059051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "5", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], " ", "<", 
      RowBox[{"#2", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481752938],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->503298667]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Ordering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ordering"]], "InlineFormula"],
 " this way is much faster for large sets of lists:"
}], "ExampleText",
 CellID->110569258],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "5"}], ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->522107773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{
      RowBox[{"sll", "[", 
       RowBox[{"data", ",", "3"}], "]"}], ";"}], "]"}], ",", 
    RowBox[{"Timing", "[", 
     RowBox[{"Sort", "[", 
      RowBox[{"data", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], " ", "<", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}], "]"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->497373485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.7228219678931964`*^-14", ",", "6.453000000000027`"}], 
  "}"}]], "Output",
 ImageSize->{154, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->164288495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->493106001],

Cell["Find the position of the maximum element:", "ExampleText",
 CellID->9496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ordering", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", 
     RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18584],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->567165863]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", 
     RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Max", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", 
      RowBox[{"-", "2"}], ",", "3"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "2", "}"}], "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266784968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160844349],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"Ordering", "[", 
     StyleBox["list", "TI"], "]"}], "]"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->87001366],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"47", ",", "13"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338990403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", "list", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3625846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "8", ",", "9", ",", "10", ",", "17", ",", "20", ",", 
   "24", ",", "25", ",", "27", ",", "27", ",", "39", ",", "43"}], 
  "}"}]], "Output",
 ImageSize->{307, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->430207802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "[", 
  RowBox[{"[", 
   RowBox[{"Ordering", "[", "list", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413706816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "8", ",", "9", ",", "10", ",", "17", ",", "20", ",", 
   "24", ",", "25", ",", "27", ",", "27", ",", "39", ",", "43"}], 
  "}"}]], "Output",
 ImageSize->{307, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->367925473]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14015],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SortBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SortBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14423],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "Tutorials",
 CellID->3527],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->19437]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->809566249],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->343529292],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->137996817]
}, Open  ]],

Cell["New in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ordering - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 15.7057614}", "context" -> "System`", 
    "keywords" -> {
     "alphabetic", "alphabetizing of lists", "alphabetizing of strings", 
      "arrange", "ascending order", "canonical order", "collating of strings",
       "collation", "decreasing order", "descending order", 
      "element positions", "expressions ordering", "grade", "grade in APL", 
      "increasing order", "largest", "lists ordering", "order in lists", 
      "order statistics", "ranking", "smallest element", "sorting", 
      "sorting of lists", "sorting of strings", "string order"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Ordering[list] gives the positions in list at which each successive \
element of Sort[list] appears. Ordering[list, n] gives the positions in list \
at which the first n elements of Sort[list] appear. Ordering[list, -n] gives \
the positions of the last n elements of Sort[list]. Ordering[list, n, p] uses \
Sort[list, p]. ", "synonyms" -> {}, "title" -> "Ordering", "type" -> "Symbol",
     "uri" -> "ref/Ordering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10052, 340, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->650274623]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32489, 1232}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2863, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3486, 91, 46, 1, 70, "ObjectName",
 CellID->21132],
Cell[3535, 94, 2788, 92, 70, "Usage",
 CellID->24472]
}, Open  ]],
Cell[CellGroupData[{
Cell[6360, 191, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6838, 208, 756, 28, 70, "Notes",
 CellID->27152],
Cell[7597, 238, 420, 14, 70, "Notes",
 CellID->25087],
Cell[8020, 254, 411, 16, 70, "Notes",
 CellID->28570],
Cell[8434, 272, 545, 21, 70, "Notes",
 CellID->29763],
Cell[8982, 295, 693, 26, 70, "Notes",
 CellID->29901],
Cell[9678, 323, 337, 12, 70, "Notes",
 CellID->17103]
}, Closed]],
Cell[CellGroupData[{
Cell[10052, 340, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->650274623],
Cell[CellGroupData[{
Cell[10437, 354, 146, 5, 70, "ExampleSection",
 CellID->9966311],
Cell[10586, 361, 74, 1, 70, "ExampleText",
 CellID->2088],
Cell[CellGroupData[{
Cell[10685, 366, 156, 5, 28, "Input",
 CellID->2943],
Cell[10844, 373, 213, 7, 36, "Output",
 CellID->332233393]
}, Open  ]],
Cell[11072, 383, 58, 1, 70, "ExampleText",
 CellID->22409],
Cell[CellGroupData[{
Cell[11155, 388, 232, 8, 28, "Input",
 CellID->26463],
Cell[11390, 398, 213, 7, 36, "Output",
 CellID->417261553]
}, Open  ]],
Cell[11618, 408, 120, 3, 70, "ExampleDelimiter",
 CellID->4681],
Cell[11741, 413, 94, 1, 70, "ExampleText",
 CellID->1588],
Cell[CellGroupData[{
Cell[11860, 418, 227, 7, 70, "Input",
 CellID->11342],
Cell[12090, 427, 222, 7, 36, "Output",
 CellID->41417900]
}, Open  ]],
Cell[12327, 437, 121, 3, 70, "ExampleDelimiter",
 CellID->32060],
Cell[12451, 442, 80, 1, 70, "ExampleText",
 CellID->21221],
Cell[CellGroupData[{
Cell[12556, 447, 245, 8, 70, "Input",
 CellID->1758],
Cell[12804, 457, 180, 6, 36, "Output",
 CellID->408531828]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13033, 469, 216, 7, 70, "ExampleSection",
 CellID->14146],
Cell[13252, 478, 201, 7, 70, "ExampleText",
 CellID->690],
Cell[CellGroupData[{
Cell[13478, 489, 296, 10, 70, "Input",
 CellID->7949],
Cell[13777, 501, 222, 7, 36, "Output",
 CellID->25077590]
}, Open  ]],
Cell[14014, 511, 121, 3, 70, "ExampleDelimiter",
 CellID->21430],
Cell[14138, 516, 365, 14, 70, "ExampleText",
 CellID->25620],
Cell[CellGroupData[{
Cell[14528, 534, 243, 7, 70, "Input",
 CellID->748],
Cell[14774, 543, 257, 8, 36, "Output",
 CellID->150721740]
}, Open  ]],
Cell[CellGroupData[{
Cell[15068, 556, 228, 7, 70, "Input",
 CellID->4536],
Cell[15299, 565, 256, 8, 36, "Output",
 CellID->89936252]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15604, 579, 239, 7, 70, "ExampleSection",
 CellID->18035],
Cell[15846, 588, 69, 1, 70, "ExampleText",
 CellID->32226],
Cell[CellGroupData[{
Cell[15940, 593, 162, 5, 70, "Input",
 CellID->15185],
Cell[16105, 600, 214, 7, 36, "Output",
 CellID->1067002806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16368, 613, 227, 7, 70, "ExampleSection",
 CellID->214190283],
Cell[16598, 622, 76, 1, 70, "ExampleText",
 CellID->11224],
Cell[CellGroupData[{
Cell[16699, 627, 201, 6, 70, "Input",
 CellID->15748],
Cell[16903, 635, 253, 8, 36, "Output",
 CellID->19923]
}, Open  ]],
Cell[17171, 646, 60, 1, 70, "ExampleText",
 CellID->3359],
Cell[CellGroupData[{
Cell[17256, 651, 217, 7, 70, "Input",
 CellID->32257],
Cell[17476, 660, 253, 8, 36, "Output",
 CellID->24766]
}, Open  ]],
Cell[17744, 671, 124, 3, 70, "ExampleDelimiter",
 CellID->91707177],
Cell[17871, 676, 73, 1, 70, "ExampleText",
 CellID->14955],
Cell[CellGroupData[{
Cell[17969, 681, 180, 6, 70, "Input",
 CellID->23318],
Cell[18152, 689, 229, 7, 36, "Output",
 CellID->32726]
}, Open  ]],
Cell[CellGroupData[{
Cell[18418, 701, 275, 9, 70, "Input",
 CellID->25411],
Cell[18696, 712, 229, 7, 36, "Output",
 CellID->21025]
}, Open  ]],
Cell[CellGroupData[{
Cell[18962, 724, 198, 7, 70, "Input",
 CellID->20355],
Cell[19163, 733, 229, 7, 36, "Output",
 CellID->31001]
}, Open  ]],
Cell[19407, 743, 124, 3, 70, "ExampleDelimiter",
 CellID->33125709],
Cell[19534, 748, 104, 2, 70, "ExampleText",
 CellID->261689346],
Cell[19641, 752, 349, 12, 70, "Input",
 CellID->458745561],
Cell[CellGroupData[{
Cell[20015, 768, 445, 15, 70, "Input",
 CellID->23285322],
Cell[20463, 785, 460, 15, 36, "Output",
 CellID->377523818]
}, Open  ]],
Cell[20938, 803, 371, 13, 70, "ExampleText",
 CellID->33059051],
Cell[CellGroupData[{
Cell[21334, 820, 641, 21, 70, "Input",
 CellID->481752938],
Cell[21978, 843, 460, 15, 36, "Output",
 CellID->503298667]
}, Open  ]],
Cell[22453, 861, 237, 8, 70, "ExampleText",
 CellID->110569258],
Cell[22693, 871, 263, 10, 70, "Input",
 CellID->522107773],
Cell[CellGroupData[{
Cell[22981, 885, 593, 20, 70, "Input",
 CellID->497373485],
Cell[23577, 907, 247, 8, 39, "Output",
 CellID->164288495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23873, 921, 237, 7, 70, "ExampleSection",
 CellID->493106001],
Cell[24113, 930, 79, 1, 70, "ExampleText",
 CellID->9496],
Cell[CellGroupData[{
Cell[24217, 935, 232, 8, 70, "Input",
 CellID->18584],
Cell[24452, 945, 180, 6, 36, "Output",
 CellID->567165863]
}, Open  ]],
Cell[CellGroupData[{
Cell[24669, 956, 337, 11, 70, "Input",
 CellID->17964],
Cell[25009, 969, 203, 7, 36, "Output",
 CellID->266784968]
}, Open  ]],
Cell[25227, 979, 125, 3, 70, "ExampleDelimiter",
 CellID->160844349],
Cell[25355, 984, 421, 16, 70, "ExampleText",
 CellID->87001366],
Cell[25779, 1002, 191, 6, 70, "Input",
 CellID->338990403],
Cell[CellGroupData[{
Cell[25995, 1012, 101, 3, 70, "Input",
 CellID->3625846],
Cell[26099, 1017, 333, 10, 36, "Output",
 CellID->430207802]
}, Open  ]],
Cell[CellGroupData[{
Cell[26469, 1032, 162, 5, 70, "Input",
 CellID->413706816],
Cell[26634, 1039, 333, 10, 36, "Output",
 CellID->367925473]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27028, 1056, 311, 9, 70, "SeeAlsoSection",
 CellID->14015],
Cell[27342, 1067, 1878, 71, 70, "SeeAlso",
 CellID->5565]
}, Open  ]],
Cell[CellGroupData[{
Cell[29257, 1143, 314, 9, 70, "TutorialsSection",
 CellID->14423],
Cell[29574, 1154, 142, 3, 70, "Tutorials",
 CellID->3527],
Cell[29719, 1159, 152, 3, 70, "Tutorials",
 CellID->19437]
}, Open  ]],
Cell[CellGroupData[{
Cell[29908, 1167, 299, 8, 70, "MoreAboutSection"],
Cell[30210, 1177, 151, 3, 70, "MoreAbout",
 CellID->809566249],
Cell[30364, 1182, 144, 3, 70, "MoreAbout",
 CellID->343529292],
Cell[30511, 1187, 190, 4, 70, "MoreAbout",
 CellID->137996817]
}, Open  ]],
Cell[30716, 1194, 29, 0, 70, "History"],
Cell[30748, 1196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

