(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21975,        812]
NotebookOptionsPosition[     16808,        636]
NotebookOutlinePosition[     18259,        675]
CellTagsIndexPosition[     18174,        670]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat and Orderless Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FlatAndOrderlessFunctions"], "Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flat and Orderless Functions\"\>", 
       2->"\<\"Attributes\"\>", 
       3->"\<\"Patterns and Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], 
          "OrderedQ" :> Documentation`HelpLookup["paclet:ref/OrderedQ"], 
          "Flat" :> Documentation`HelpLookup["paclet:ref/Flat"], 
          "OneIdentity" :> 
          Documentation`HelpLookup["paclet:ref/OneIdentity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sort\"\>", 2->"\<\"OrderedQ\"\>", 
       3->"\<\"Flat\"\>", 4->"\<\"OneIdentity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], "Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Orderless", "ObjectName",
 CellID->14625],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Orderless",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
     "\[LineSeparator]is an attribute that can be assigned to a symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to indicate that the elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in expressions of the form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " should automatically be sorted into canonical order. This property is \
accounted for in pattern matching. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2011]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " attribute for a function corresponds to the mathematical property of \
commutativity. "
}], "Notes",
 CellID->32637],

Cell[TextData[{
 "Functions with the ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " attribute use canonical order as described in the notes for ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4186],

Cell[TextData[{
 "For an object that represents a matrix or a tensor, the ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " attribute represents symmetry among indices. "
}], "Notes",
 CellID->19690],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1650],

Cell[TextData[{
 "In matching patterns with ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " functions, all possible orders of arguments are tried. "
}], "Notes",
 CellID->5662],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " attribute must be assigned before defining any values for an ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " function. "
}], "Notes",
 CellID->21634]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183651821],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->428279698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", "+", "a"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4348368],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258239961]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54324703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->280807853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302287796],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Orderless"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5006344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127339938],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254527857]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->462646465],

Cell["\<\
All possible argument orderings are tried to match a definition for an \
orderless function:\
\>", "ExampleText",
 CellID->73789620],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Orderless"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_Integer", ",", "y_Real"}], "]"}], ":=", 
  RowBox[{"y", "^", "x"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->48303593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"2", ",", "3.0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->858077218],

Cell[BoxData["9.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142543245]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"3.0", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->788240383],

Cell[BoxData["9.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->299310790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51721598],

Cell["\<\
Elements of an expression whose head is orderless are sorted into standard \
order:\
\>", "ExampleText",
 CellID->70966177],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"h", ",", "Orderless"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587032863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"z", ",", 
   RowBox[{"-", "1.0"}], ",", 
   RowBox[{"g", "[", "]"}], ",", "I", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->729797176],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", "\[ImaginaryI]", ",", "1", ",", "z", ",", 
   RowBox[{"g", "[", "]"}]}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508870507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderedQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->387900060],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->61069509]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->270174493],

Cell["\<\
Pattern matching with orderless functions can lead to a large number of \
possible cases:\
\>", "ExampleText",
 CellID->534811449],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"h", ",", "Orderless"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->578563088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->296344379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2103909]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7262],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OneIdentity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OneIdentity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22233]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10893],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "Tutorials",
 CellID->10353],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->21416],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->172614647],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->247034543],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->31207097],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->120890069]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Orderless"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Orderless - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 17.9870698}", "context" -> "System`", 
    "keywords" -> {
     "attribute", "commutative", "reordering arguments", "sorted arguments"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Orderless is an attribute that can be assigned to a symbol f to indicate \
that the elements e_i in expressions of the form f[e_1, e_2, ...] should \
automatically be sorted into canonical order. This property is accounted for \
in pattern matching. ", "synonyms" -> {}, "title" -> "Orderless", "type" -> 
    "Symbol", "uri" -> "ref/Orderless"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6964, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->183651821]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18031, 663}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2607, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3230, 86, 47, 1, 70, "ObjectName",
 CellID->14625],
Cell[3280, 89, 1139, 34, 70, "Usage",
 CellID->2011]
}, Open  ]],
Cell[CellGroupData[{
Cell[4456, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4934, 145, 265, 9, 70, "Notes",
 CellID->32637],
Cell[5202, 156, 371, 13, 70, "Notes",
 CellID->4186],
Cell[5576, 171, 276, 8, 70, "Notes",
 CellID->19690],
Cell[5855, 181, 434, 18, 70, "Notes",
 CellID->1650],
Cell[6292, 201, 255, 8, 70, "Notes",
 CellID->5662],
Cell[6550, 211, 377, 13, 70, "Notes",
 CellID->21634]
}, Closed]],
Cell[CellGroupData[{
Cell[6964, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183651821],
Cell[CellGroupData[{
Cell[7349, 243, 148, 5, 70, "ExampleSection",
 CellID->428279698],
Cell[CellGroupData[{
Cell[7522, 252, 90, 3, 28, "Input",
 CellID->4348368],
Cell[7615, 257, 180, 6, 36, "Output",
 CellID->258239961]
}, Open  ]],
Cell[CellGroupData[{
Cell[7832, 268, 108, 3, 28, "Input",
 CellID->54324703],
Cell[7943, 273, 301, 9, 36, "Output",
 CellID->280807853]
}, Open  ]],
Cell[8259, 285, 125, 3, 70, "ExampleDelimiter",
 CellID->302287796],
Cell[8387, 290, 157, 5, 70, "Input",
 CellID->5006344],
Cell[CellGroupData[{
Cell[8569, 299, 120, 4, 70, "Input",
 CellID->127339938],
Cell[8692, 305, 208, 7, 36, "Output",
 CellID->254527857]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8949, 318, 237, 7, 70, "ExampleSection",
 CellID->462646465],
Cell[9189, 327, 142, 4, 70, "ExampleText",
 CellID->73789620],
Cell[9334, 333, 282, 9, 70, "Input",
 CellID->48303593],
Cell[CellGroupData[{
Cell[9641, 346, 122, 4, 70, "Input",
 CellID->858077218],
Cell[9766, 352, 160, 5, 36, "Output",
 CellID->142543245]
}, Open  ]],
Cell[CellGroupData[{
Cell[9963, 362, 122, 4, 70, "Input",
 CellID->788240383],
Cell[10088, 368, 160, 5, 36, "Output",
 CellID->299310790]
}, Open  ]],
Cell[10263, 376, 124, 3, 70, "ExampleDelimiter",
 CellID->51721598],
Cell[10390, 381, 133, 4, 70, "ExampleText",
 CellID->70966177],
Cell[10526, 387, 159, 5, 70, "Input",
 CellID->587032863],
Cell[CellGroupData[{
Cell[10710, 396, 195, 6, 70, "Input",
 CellID->729797176],
Cell[10908, 404, 296, 9, 36, "Output",
 CellID->508870507]
}, Open  ]],
Cell[CellGroupData[{
Cell[11241, 418, 104, 3, 70, "Input",
 CellID->387900060],
Cell[11348, 423, 160, 5, 36, "Output",
 CellID->61069509]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11557, 434, 230, 7, 70, "ExampleSection",
 CellID->270174493],
Cell[11790, 443, 140, 4, 70, "ExampleText",
 CellID->534811449],
Cell[11933, 449, 159, 5, 70, "Input",
 CellID->578563088],
Cell[CellGroupData[{
Cell[12117, 458, 361, 11, 70, "Input",
 CellID->296344379],
Cell[12481, 471, 596, 19, 36, "Output",
 CellID->2103909]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13138, 497, 310, 9, 70, "SeeAlsoSection",
 CellID->7262],
Cell[13451, 508, 931, 35, 70, "SeeAlso",
 CellID->22233]
}, Open  ]],
Cell[CellGroupData[{
Cell[14419, 548, 314, 9, 70, "TutorialsSection",
 CellID->10893],
Cell[14736, 559, 164, 3, 70, "Tutorials",
 CellID->10353],
Cell[14903, 564, 131, 3, 70, "Tutorials",
 CellID->21416],
Cell[15037, 569, 178, 3, 70, "Tutorials",
 CellID->244552785]
}, Open  ]],
Cell[CellGroupData[{
Cell[15252, 577, 319, 9, 70, "MoreAboutSection",
 CellID->172614647],
Cell[15574, 588, 132, 3, 70, "MoreAbout",
 CellID->247034543],
Cell[15709, 593, 127, 3, 70, "MoreAbout",
 CellID->31207097],
Cell[15839, 598, 165, 3, 70, "MoreAbout",
 CellID->120890069]
}, Open  ]],
Cell[CellGroupData[{
Cell[16041, 606, 305, 8, 70, "RelatedLinksSection"],
Cell[16349, 616, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[16751, 632, 27, 0, 70, "History"],
Cell[16781, 634, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

