(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50202,       1930]
NotebookOptionsPosition[     39672,       1555]
NotebookOutlinePosition[     41034,       1593]
CellTagsIndexPosition[     40948,       1588]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Forms of Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FormsOfInputAndOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Forms of Input and Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], 
          "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"], "TeXForm" :> 
          Documentation`HelpLookup["paclet:ref/TeXForm"], "MathMLForm" :> 
          Documentation`HelpLookup["paclet:ref/MathMLForm"], "Short" :> 
          Documentation`HelpLookup["paclet:ref/Short"], "FullForm" :> 
          Documentation`HelpLookup["paclet:ref/FullForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StandardForm\"\>", 
       2->"\<\"TraditionalForm\"\>", 3->"\<\"InputForm\"\>", 
       4->"\<\"TeXForm\"\>", 5->"\<\"MathMLForm\"\>", 6->"\<\"Short\"\>", 
       7->"\<\"FullForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Display of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OutputForm", "ObjectName",
 CellID->1670],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OutputForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OutputForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a two\[Hyphen]dimensional representation of ",
     
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " using only keyboard characters. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " is an approximation to ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " which uses only ordinary keyboard characters. "
}], "Notes",
 CellID->5651],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of many kinds of expressions is quite different from their internal \
representation. "
}], "Notes",
 CellID->2258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->45936541]
}], "Notes",
 CellID->7213],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " cannot be used directly for input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->9860],

Cell[TextData[{
 "When possible, ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " uses approximations to special characters. Thus ",
 Cell[BoxData["\[GreaterEqual]"], "InlineFormula"],
 " is given as ",
 Cell[BoxData[">="], "InlineFormula"],
 " and ",
 Cell[BoxData["\[EAcute]"], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"e", "'"}]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->323855770]
}], "Notes",
 CellID->25783]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->980967601],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->345156607],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of a typeset expression:"
}], "ExampleText",
 CellID->134753518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{
   FractionBox["x", 
    SqrtBox["5"]], "+", 
   SuperscriptBox["y", "2"], "+", 
   RowBox[{"1", "/", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330426462],

Cell[OutputFormData["\<\
x/Sqrt[5] + y^2 + z^(-1)\
\>", "\<\
   x       2   1
------- + y  + -
Sqrt[5]        z\
\>"], "Output",
 ImageSize->{119, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//OutputForm=",
 CellID->326850274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->456767245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of a graphic:"
}], "ExampleText",
 CellID->241319587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[{
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0, 1], 
     RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
      NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}}], "//", 
  "OutputForm"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->519156385],

Cell[OutputFormData["\<\
Graphics[{{RGBColor[1, 0, 0], Disk[{0, 0}]}, 
  {RGBColor[0, 0, 1], Rectangle[{1/2, 1/2}]}}]\
\>", "\<\
-Graphics-\
\>"], "Output",
 ImageSize->{70, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//OutputForm=",
 CellID->96447718]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->37742246],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Objects",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->186548374],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->17800827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"OutputForm", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"1", "/", "23"}], ",", "1.23", ",", 
     RowBox[{"1", "+", 
      RowBox[{"23", "\[ImaginaryI]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540624369],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktOwzAQdeykVT+orGgFmy5A4rfkArAoKw4RVUjtAgFNToPY95jGju2o
fYxrO0IqleLJfJM38+r4paxXr29lvV6W8+dN+bFaL6v54n2jTCJjjG3V9TBj
6l6qu+baSqnk7/VarYUKEEoKJevWyrRZup+6Z5y0Vo280atofawP+mcTdQvW
Hhl1B1b9brx9t3vw5mSNbgh0mXyvE76+xa+uw9zKKjE/t+i/rCwaqwDU36Dz
fxI1A/0M9EvQH6Or6l5Mrbyy8ikq203CScf9AuJ61j/y2B0v8451BpA3tDoy
2qDgYMWn0NymrY5TA6gx8th3kf7FM7ALsTUxF3uQmThhhCT2IeQC+k9AR74O
E/PdjEN52CXNGb2Va0QGVWj+yBrcW0PIKJYfysf4UD4ipGeH80FUmOWYeRpA
N47MQxS+PLTT/9kQGuwR+kMzQ38o/yIQjzPqhiplJ5oEEKbsDlhrmpCLc49D
7tigWbl7dpjI/e/T2OM/B/vhL8Dxv+Z0FH1CMacXlv0AUSSv5A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202190233]
}, Open  ]],

Cell[TextData[{
 "Arbitrary precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->311286961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "/", "3"}], ",", 
      RowBox[{
       RowBox[{"10", "/", "3"}], "\[ImaginaryI]"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28481542],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFEOgjAMLQwkKAY//eQ0+qWcgRgT+DAa5Cp6B+MhcQOmUppIlMSRlGTr
3tu6NOvWlW2SIt0fkiLbJdE6T05ptjtHq2MuKWEBWFsACJcg26VsVUV9sSwA
jqqF5kq4IHxDWFRaArFXWdkS3hFvk6MVVtBptNw3bJJ0kd3eSOyeSulC17e0
NyrWfeJqTD3K1nN0emkdZv/B6t3okb3sx7Gws7J9LunTayPWQ/jTLIzbOOT1
+wn7COM701JV586Z8KrzrjVo1/bLlPRNG5Sv/M8kuTDcvuCrVedYwbFifLGC
zvF8kjUh+2S2Zucky34zne3390SxotFWcqgXmKFkaLh9+qWJeuGrQdyjBdYD
rNXHLQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{334, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9546371]
}, Open  ]],

Cell["Special constants:", "ExampleText",
 CellID->532475715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"{", 
   RowBox[{"\[ImaginaryI]", ",", "\[Pi]", ",", "\[ExponentialE]"}], 
   "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->70178760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU0sOgjAQHdoCagRiYtQlV2GjKw/REBNYGA1y/zotjZ9hEGIg6bTvTfvm
03LWbXW56rYudX5q9L2qy0d+vDVIyQAAChzZAXBtcOVGYQzOylppsftgSfCO
4Ixg6VQkYVdoBMK9nzfEL9hTlg2hn1OERnqe84doIobno9Bdyue4YFS5fbFz
vngXYyi2GNFMR/wJwTHBwaQKU9+/X+q2huiv/rka1Bv3e5H4+HPpC6/3+Rbn
zH9rpt+w+j5tuhdqK1ZMx9eme6k0p+4vKgYsBE9HqvuZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->346988665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->857536694],

Cell["Characters and strings of characters:", "ExampleText",
 CellID->287551178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<\[Alpha]\>\"", ",", "\"\<\[CirclePlus]\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48683404],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VdsOwiAMZcC8xkuiJj7ua/TJj1iMiT4Yjfqyr0fKYM4zCGiiSwY7pbQ9
pSu78nE8nMvHaV8W21t5PZ7292JzuWmRyBhjlX5na6a/lf4yb6WUniWNgrB5
2BDwXA9cQ5pJvLQ4B70x4D5g1BfGuwDpyFpHa6g3B7z06PvsIDuMinujIpyz
rhytmXXZYJux2ol7jFc9kydpZ6Ml21o84BFPaxBZj2E/X+6CbHi4ACmno8jZ
hHfHtT6R+rhRfHgq3+WE+1h2Ypgl2Mr/wh4jCXnGis9UqOJlAr/2vqbUv+Tp
fMaY/bLGp5FspfDlrFs9jezVHTx/N+76DXPCwnO2SVzfuht3x2a7Vrv/1RJp
faFt9I19Oo3JKsIglh/sFBPAeMuk3R7oZQG4ZzPn+lWuXn2V2xqkGfel3ahV
YGTZE5V3Ogk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264660278]
}, Open  ]],

Cell["Control characters for strings:", "ExampleText",
 CellID->51418980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "\"\<A first line\nA second line\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49753538],

Cell[OutputFormData["\<\
\"A first line\\nA second line\"\
\>", "\<\
A first line
A second line\
\>"], "Output",
 ImageSize->{91, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//OutputForm=",
 CellID->384345478]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Input Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->523581364],

Cell[TextData[{
 "Different ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->388790367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "^", "x"}], ",", 
    SuperscriptBox["a", "x"], ",", 
    RadicalBox["a", "3"], ",", 
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"1", "/", "x"}], ",", 
    FractionBox["1", "x"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25296522],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVc1OwzAMbpt2ahk/m8bGjhUgxAMgTnCFE+9ANSFtBwQauwDPgLjvZUOc
pCX9YtaCirRKjWPH+fLFdpK7YjV/eCxWi1mR3y6L5/li9pLfPC2VSYRBEKzV
fzENVF+qnv7XUirpt6+qjZRDZOUu6Jn2eqM2Jhz9qc6+Z9nR4t3OG1jZ32Bt
j9qO5U97bN8STqLwDkHmSvYoqNorpTapWBqi2ret9Zi1doouvqM4sbvYszKr
9kqhHoN0ZxPaZYesRIWXWW0C8oRdvdgQr/tabtxsxtJUx4eVibYKiM4n6NGW
eA2ZLLr6acP4AeiD1qtSrI4c6Y73Ybw80ciWR09l/dzGMI7nGsfLCkZc8hNl
hn+B17N4be1mVxFY9R1Vu7USu55/n5UjmA12Ja/i40bcjMHl7Bip0MAII8pY
u5meNjDugT6SfGVgXdI8erSIQcjGF2vuv5jwMcFay7zYjz0LnhpEFpaRPxPr
AjnyFdl0zkag412B/FAfwnxk9TeW19yqXs3jrLNO1r6yO0nrGZDmHjmX9dsN
K2pb3gjei3/3zJsYhF9RRj6i\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{154, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474011267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->518543444],

Cell["Special typeset expressions:", "ExampleText",
 CellID->52269911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Product]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{"x", "\[Element]", "Reals"}], ",", 
    RowBox[{
     RowBox[{"x", "\[And]", "y"}], "\[Or]", "z"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177296101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    FrameBox["\<\"y'[x]\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[
     Derivative[1][$CellContext`y][$CellContext`x]],
    Editable->False], ",", 
   InterpretationBox[
    FrameBox["\<\"Integrate[y[x], x]\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[
     Integrate[
      $CellContext`y[$CellContext`x], $CellContext`x]],
    Editable->False], ",", 
   InterpretationBox[
    FrameBox["\<\"Sum[y[k], {k, 1, n}]\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[
     Sum[
      $CellContext`y[$CellContext`k], {$CellContext`k, 1, $CellContext`n}]],
    Editable->False], ",", 
   InterpretationBox[
    FrameBox["\<\"Product[y[k], {k, 1, n}]\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[
     Product[
      $CellContext`y[$CellContext`k], {$CellContext`k, 1, $CellContext`n}]],
    Editable->False], ",", 
   InterpretationBox[
    FrameBox["\<\"x \\\\[Element] Reals\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[
     Element[$CellContext`x, Reals]],
    Editable->False], ",", 
   InterpretationBox[
    FrameBox["\<\"(x && y) || z\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[
     Or[
      And[$CellContext`x, $CellContext`y], $CellContext`z]],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{426, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->798093250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72758442],

Cell["Different list structures:", "ExampleText",
 CellID->582738955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287661578],

Cell[OutputFormData["\<\
{1, 2, 3}\
\>", "\<\
{1, 2, 3}\
\>"], "Output",
 ImageSize->{63, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//OutputForm=",
 CellID->264296782]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"}
      }], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->250695724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    FrameBox["\<\"{{a, b, c}, {d, e, f}}\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[{{$CellContext`a, $CellContext`b, $CellContext`c}, \
{$CellContext`d, $CellContext`e, $CellContext`f}}],
    Editable->False], ",", 
   InterpretationBox[
    FrameBox["\<\"{{a, b, c}, {d, e, f}}\"\>",
     BoxFrame->False,
     FrameMargins->False],
    OutputForm[{{$CellContext`a, $CellContext`b, $CellContext`c}, \
{$CellContext`d, $CellContext`e, $CellContext`f}}],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50359861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52207789],

Cell["Inputs with subscripts, superscripts, etc.: ", "ExampleText",
 CellID->250099490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SuperscriptBox["x", "a"], ",", 
    OverscriptBox["x", "a"], ",", 
    UnderscriptBox["x", "a"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246234492],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNFMtuwjAsTVJKxyhMaMBhQ0j8Czsh7twqNAkOE6jj/4PdOrRzTNmEpq1S
/KpfiR+r/LR7/8hP+20+fyvy426//ZwvDwWITKSU2sBZTBXQDqjybJwDHMIh
wBgUeoA1YE14xPiM9Lql1QAhss5/QKs+YnuRAvEcSDLRMm3xmlEGE8KyVnq5
jRVsvLwtzr3ZYwxDfm69JOo9XKlIBS1prwjHpdQgNHVGa8brf6L1xPgx4weM
H37bK68qYh6tYW2btWpWocdsfH/zmMkVecz8WTEHzaQsJyAeXd0VYWf5Lkhu
//3itcPiRpXYVAhhh2xfRc99UeqnCncArhn0Gon39JnNXD2PzblMxPz4G+vg
Xi8/yDac51isUXufYERDW0eabrnufz+Bv68lb6hqe6noDApDVhA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{90, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74322315]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Output Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->62872202],

Cell["Some objects use a special output representation:", "ExampleText",
 CellID->483444329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ser", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270064825],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49425446]
}, Open  ]],

Cell[TextData[{
 "Compare the ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " with the underlying ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of the expression:"
}], "ExampleText",
 CellID->18535822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "ser", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49083534],

Cell[OutputFormData["\<\
SeriesData[x, 0, {1, 0, -1/6}, 1, 4, 1]\
\>", "\<\
     3
    x        4
x - -- + O[x]
    6\
\>"], "Output",
 ImageSize->{105, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//OutputForm=",
 CellID->19604682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "ser", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152587590],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SeriesData", "[", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", "0", ",", 
       RowBox[{"Rational", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "6"}], "]"}]}], "]"}], ",", "1", ",", "4", 
     ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->209702914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206695726],

Cell["Some objects use an elided output representation:", "ExampleText",
 CellID->65245750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470286855],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2912788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->191304613],

Cell[OutputFormData["\<\
SparseArray[Automatic, {5, 5}, 0, {1, {{0, 1, 1, 1, 1, 1}, {{2}}}, {1}}]\
\>", "\<\
SparseArray[<1>, {5, 5}]\
\>"], "Output",
 ImageSize->{168, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//OutputForm=",
 CellID->184922843]
}, Open  ]],

Cell[TextData[{
 "The elided information is visible in the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->444663507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "sp", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->268605706],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SparseArray", "[", 
    RowBox[{"Automatic", ",", 
     RowBox[{"List", "[", 
      RowBox[{"5", ",", "5"}], "]"}], ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", 
       RowBox[{"List", "[", 
        RowBox[{
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
          "]"}], ",", 
         RowBox[{"List", "[", 
          RowBox[{"List", "[", "2", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"List", "[", "1", "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{423, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->624241379]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->68444370],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " affects display but not evaluation:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->45936541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"x", "^", "n"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145860351],

Cell[OutputFormData["\<\
x^(1 + n)/(1 + n)\
\>", "\<\
 1 + n
x
------
1 + n\
\>"], "Output",
 ImageSize->{49, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//OutputForm=",
 CellID->8026368]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " to the evaluated integral:"
}], "ExampleText",
 CellID->306237246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167840055],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->286867911]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->46625405],

Cell[OutputFormData["\<\
x^(1 + n)/(1 + n)\
\>", "\<\
 1 + n
x
------
1 + n\
\>"], "Output",
 ImageSize->{49, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//OutputForm=",
 CellID->178424887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301618057],

Cell["Special characters format as keyboard characters:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->323855770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "\[GreaterEqual]", "b"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->868524893],

Cell[BoxData[
 RowBox[{"a", "\[GreaterEqual]", "b"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629504429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->540020462],

Cell[OutputFormData["\<\
a >= b\
\>", "\<\
a >= b\
\>"], "Output",
 ImageSize->{42, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//OutputForm=",
 CellID->708931176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3670004],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " formats in two dimensions:"
}], "ExampleText",
 CellID->100794910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210440999],

Cell[OutputFormData["\<\
E^((I*x)/n)\
\>", "\<\
 (I x)/n
E\
\>"], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//OutputForm=",
 CellID->272274110]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " are two\[Hyphen]dimensional with additional formatting:"
}], "ExampleText",
 CellID->457767460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52050003],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]]], "Output",
 ImageSize->{27, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->365849344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16589577],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]], TraditionalForm]], "Output",
 ImageSize->{23, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->21449065]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " provide one-dimensional formatting:"
}], "ExampleText",
 CellID->13054338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114959516],

Cell["E^((I*x)/n)", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->344120129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->223015926],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"E", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Complex", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"n", ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{320, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//FullForm=",
 CellID->427630841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295760989],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " to generate a string in ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->280553715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "a"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", "OutputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367460198],

Cell[BoxData["\<\"1    2\\n- + x\\na\"\>"], "Output",
 ImageSize->{46, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268763240]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106513457],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117138289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98254711],

Cell[TextData[{
 "Add formatting via ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->810203101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "OutputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161343839],

Cell[OutputFormData["\<\
bin[x, y]\
\>", "\<\
bin[x, y]\
\>"], "Output",
 ImageSize->{63, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//OutputForm=",
 CellID->253442709]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"bin", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ",", "OutputForm"}], "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734130829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "OutputForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->88224750],

Cell[OutputFormData["\<\
bin[x, y]\
\>", "\<\
x

y\
\>"], "Output",
 ImageSize->{14, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//OutputForm=",
 CellID->109759492]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18434],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TeXForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TeXForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathMLForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21286],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->8610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->230073921],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->463395369],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->111224993]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OutputForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 31.2842852}", "context" -> "System`", 
    "keywords" -> {
     "ascii 2D output", "ascii output", "string 2D output", 
      "two-dimensional format", "two-dimensional output"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "OutputForm[expr] prints as a two-dimensional representation of expr \
using only keyboard characters. ", "synonyms" -> {"output form"}, "title" -> 
    "OutputForm", "type" -> "Symbol", "uri" -> "ref/OutputForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6304, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->980967601]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40805, 1581}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2614, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3237, 87, 47, 1, 70, "ObjectName",
 CellID->1670],
Cell[3287, 90, 619, 19, 70, "Usage",
 CellID->32528]
}, Open  ]],
Cell[CellGroupData[{
Cell[3943, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4421, 131, 373, 12, 70, "Notes",
 CellID->5651],
Cell[4797, 145, 266, 9, 70, "Notes",
 CellID->2258],
Cell[5066, 156, 368, 11, 70, "Notes",
 CellID->7213],
Cell[5437, 169, 264, 10, 70, "Notes",
 CellID->9860],
Cell[5704, 181, 563, 20, 70, "Notes",
 CellID->25783]
}, Closed]],
Cell[CellGroupData[{
Cell[6304, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->980967601],
Cell[CellGroupData[{
Cell[6689, 220, 148, 5, 70, "ExampleSection",
 CellID->345156607],
Cell[6840, 227, 206, 7, 70, "ExampleText",
 CellID->134753518],
Cell[CellGroupData[{
Cell[7071, 238, 224, 8, 46, "Input",
 CellID->330426462],
Cell[7298, 248, 271, 11, 75, "Output",
 CellID->326850274]
}, Open  ]],
Cell[7584, 262, 125, 3, 70, "ExampleDelimiter",
 CellID->456767245],
Cell[7712, 267, 195, 7, 70, "ExampleText",
 CellID->241319587],
Cell[CellGroupData[{
Cell[7932, 278, 374, 10, 70, "Input",
 CellID->519156385],
Cell[8309, 290, 297, 10, 55, "Output",
 CellID->96447718]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8655, 306, 219, 7, 70, "ExampleSection",
 CellID->37742246],
Cell[CellGroupData[{
Cell[8899, 317, 234, 7, 70, "ExampleSubsection",
 CellID->186548374],
Cell[9136, 326, 555, 22, 70, "ExampleText",
 CellID->17800827],
Cell[CellGroupData[{
Cell[9716, 352, 293, 9, 70, "Input",
 CellID->540624369],
Cell[10012, 363, 752, 16, 70, "Output",
 Evaluatable->False,
 CellID->202190233]
}, Open  ]],
Cell[10779, 382, 330, 13, 70, "ExampleText",
 CellID->311286961],
Cell[CellGroupData[{
Cell[11134, 399, 300, 11, 70, "Input",
 CellID->28481542],
Cell[11437, 412, 584, 14, 70, "Output",
 Evaluatable->False,
 CellID->9546371]
}, Open  ]],
Cell[12036, 429, 61, 1, 70, "ExampleText",
 CellID->532475715],
Cell[CellGroupData[{
Cell[12122, 434, 192, 6, 70, "Input",
 CellID->70178760],
Cell[12317, 442, 499, 12, 70, "Output",
 Evaluatable->False,
 CellID->346988665]
}, Open  ]],
Cell[12831, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->857536694],
Cell[12959, 462, 80, 1, 70, "ExampleText",
 CellID->287551178],
Cell[CellGroupData[{
Cell[13064, 467, 209, 7, 70, "Input",
 CellID->48683404],
Cell[13276, 476, 651, 15, 70, "Output",
 Evaluatable->False,
 CellID->264660278]
}, Open  ]],
Cell[13942, 494, 73, 1, 70, "ExampleText",
 CellID->51418980],
Cell[CellGroupData[{
Cell[14040, 499, 142, 4, 70, "Input",
 CellID->49753538],
Cell[14185, 505, 254, 10, 65, "Output",
 CellID->384345478]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14488, 521, 240, 7, 70, "ExampleSubsection",
 CellID->523581364],
Cell[14731, 530, 199, 8, 70, "ExampleText",
 CellID->388790367],
Cell[CellGroupData[{
Cell[14955, 542, 341, 11, 70, "Input",
 CellID->25296522],
Cell[15299, 555, 785, 17, 70, "Output",
 Evaluatable->False,
 CellID->474011267]
}, Open  ]],
Cell[16099, 575, 125, 3, 70, "ExampleDelimiter",
 CellID->518543444],
Cell[16227, 580, 70, 1, 70, "ExampleText",
 CellID->52269911],
Cell[CellGroupData[{
Cell[16322, 585, 698, 22, 70, "Input",
 CellID->177296101],
Cell[17023, 609, 1536, 53, 54, "Output",
 CellID->798093250]
}, Open  ]],
Cell[18574, 665, 124, 3, 70, "ExampleDelimiter",
 CellID->72758442],
Cell[18701, 670, 69, 1, 70, "ExampleText",
 CellID->582738955],
Cell[CellGroupData[{
Cell[18795, 675, 163, 5, 70, "Input",
 CellID->287661578],
Cell[18961, 682, 214, 9, 55, "Output",
 CellID->264296782]
}, Open  ]],
Cell[CellGroupData[{
Cell[19212, 696, 419, 16, 70, "Input",
 CellID->250695724],
Cell[19634, 714, 715, 21, 36, "Output",
 CellID->50359861]
}, Open  ]],
Cell[20364, 738, 124, 3, 70, "ExampleDelimiter",
 CellID->52207789],
Cell[20491, 743, 87, 1, 70, "ExampleText",
 CellID->250099490],
Cell[CellGroupData[{
Cell[20603, 748, 270, 9, 70, "Input",
 CellID->246234492],
Cell[20876, 759, 628, 14, 70, "Output",
 Evaluatable->False,
 CellID->74322315]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21553, 779, 240, 7, 70, "ExampleSubsection",
 CellID->62872202],
Cell[21796, 788, 92, 1, 70, "ExampleText",
 CellID->483444329],
Cell[CellGroupData[{
Cell[21913, 793, 244, 8, 70, "Input",
 CellID->270064825],
Cell[22160, 803, 499, 17, 54, "Output",
 CellID->49425446]
}, Open  ]],
Cell[22674, 823, 361, 13, 70, "ExampleText",
 CellID->18535822],
Cell[CellGroupData[{
Cell[23060, 840, 107, 3, 70, "Input",
 CellID->49083534],
Cell[23170, 845, 276, 12, 85, "Output",
 CellID->19604682]
}, Open  ]],
Cell[CellGroupData[{
Cell[23483, 862, 106, 3, 70, "Input",
 CellID->152587590],
Cell[23592, 867, 564, 19, 50, "Output",
 CellID->209702914]
}, Open  ]],
Cell[24171, 889, 125, 3, 70, "ExampleDelimiter",
 CellID->206695726],
Cell[24299, 894, 91, 1, 70, "ExampleText",
 CellID->65245750],
Cell[CellGroupData[{
Cell[24415, 899, 318, 11, 70, "Input",
 CellID->470286855],
Cell[24736, 912, 477, 17, 36, "Output",
 CellID->2912788]
}, Open  ]],
Cell[CellGroupData[{
Cell[25250, 934, 107, 3, 70, "Input",
 CellID->191304613],
Cell[25360, 939, 293, 9, 55, "Output",
 CellID->184922843]
}, Open  ]],
Cell[25668, 951, 224, 8, 70, "ExampleText",
 CellID->444663507],
Cell[CellGroupData[{
Cell[25917, 963, 105, 3, 70, "Input",
 CellID->268605706],
Cell[26025, 968, 812, 25, 68, "Output",
 CellID->624241379]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26898, 1000, 236, 7, 70, "ExampleSection",
 CellID->68444370],
Cell[27137, 1009, 264, 8, 70, "ExampleText",
 CellID->45936541],
Cell[CellGroupData[{
Cell[27426, 1021, 191, 6, 70, "Input",
 CellID->145860351],
Cell[27620, 1029, 232, 12, 85, "Output",
 CellID->8026368]
}, Open  ]],
Cell[27867, 1044, 219, 8, 70, "ExampleText",
 CellID->306237246],
Cell[CellGroupData[{
Cell[28111, 1056, 152, 5, 70, "Input",
 CellID->167840055],
Cell[28266, 1063, 249, 9, 54, "Output",
 CellID->286867911]
}, Open  ]],
Cell[CellGroupData[{
Cell[28552, 1077, 105, 3, 70, "Input",
 CellID->46625405],
Cell[28660, 1082, 234, 12, 85, "Output",
 CellID->178424887]
}, Open  ]],
Cell[28909, 1097, 125, 3, 70, "ExampleDelimiter",
 CellID->301618057],
Cell[29037, 1102, 140, 2, 70, "ExampleText",
 CellID->323855770],
Cell[CellGroupData[{
Cell[29202, 1108, 106, 3, 70, "Input",
 CellID->868524893],
Cell[29311, 1113, 194, 6, 36, "Output",
 CellID->629504429]
}, Open  ]],
Cell[CellGroupData[{
Cell[29542, 1124, 106, 3, 70, "Input",
 CellID->540020462],
Cell[29651, 1129, 208, 9, 55, "Output",
 CellID->708931176]
}, Open  ]],
Cell[29874, 1141, 123, 3, 70, "ExampleDelimiter",
 CellID->3670004],
Cell[30000, 1146, 208, 7, 70, "ExampleText",
 CellID->100794910],
Cell[CellGroupData[{
Cell[30233, 1157, 185, 6, 70, "Input",
 CellID->210440999],
Cell[30421, 1165, 217, 10, 65, "Output",
 CellID->272274110]
}, Open  ]],
Cell[30653, 1178, 384, 12, 70, "ExampleText",
 CellID->457767460],
Cell[CellGroupData[{
Cell[31062, 1194, 186, 6, 70, "Input",
 CellID->52050003],
Cell[31251, 1202, 266, 8, 58, "Output",
 CellID->365849344]
}, Open  ]],
Cell[CellGroupData[{
Cell[31554, 1215, 189, 6, 70, "Input",
 CellID->16589577],
Cell[31746, 1223, 299, 9, 58, "Output",
 CellID->21449065]
}, Open  ]],
Cell[32060, 1235, 343, 12, 70, "ExampleText",
 CellID->13054338],
Cell[CellGroupData[{
Cell[32428, 1251, 184, 6, 70, "Input",
 CellID->114959516],
Cell[32615, 1259, 170, 5, 50, "Output",
 CellID->344120129]
}, Open  ]],
Cell[CellGroupData[{
Cell[32822, 1269, 183, 6, 70, "Input",
 CellID->223015926],
Cell[33008, 1277, 579, 20, 50, "Output",
 CellID->427630841]
}, Open  ]],
Cell[33602, 1300, 125, 3, 70, "ExampleDelimiter",
 CellID->295760989],
Cell[33730, 1305, 340, 13, 70, "ExampleText",
 CellID->280553715],
Cell[CellGroupData[{
Cell[34095, 1322, 210, 7, 70, "Input",
 CellID->367460198],
Cell[34308, 1331, 183, 5, 71, "Output",
 CellID->268763240]
}, Open  ]],
Cell[CellGroupData[{
Cell[34528, 1341, 100, 3, 70, "Input",
 CellID->106513457],
Cell[34631, 1346, 163, 5, 36, "Output",
 CellID->117138289]
}, Open  ]],
Cell[34809, 1354, 124, 3, 70, "ExampleDelimiter",
 CellID->98254711],
Cell[34936, 1359, 198, 8, 70, "ExampleText",
 CellID->810203101],
Cell[CellGroupData[{
Cell[35159, 1371, 156, 5, 70, "Input",
 CellID->161343839],
Cell[35318, 1378, 214, 9, 55, "Output",
 CellID->253442709]
}, Open  ]],
Cell[35547, 1390, 357, 12, 70, "Input",
 CellID->734130829],
Cell[CellGroupData[{
Cell[35929, 1406, 155, 5, 70, "Input",
 CellID->88224750],
Cell[36087, 1413, 209, 11, 75, "Output",
 CellID->109759492]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36357, 1431, 311, 9, 70, "SeeAlsoSection",
 CellID->18434],
Cell[36671, 1442, 1695, 62, 70, "SeeAlso",
 CellID->5841]
}, Open  ]],
Cell[CellGroupData[{
Cell[38403, 1509, 314, 9, 70, "TutorialsSection",
 CellID->21286],
Cell[38720, 1520, 156, 3, 70, "Tutorials",
 CellID->8610]
}, Open  ]],
Cell[CellGroupData[{
Cell[38913, 1528, 319, 9, 70, "MoreAboutSection",
 CellID->230073921],
Cell[39235, 1539, 193, 4, 70, "MoreAbout",
 CellID->463395369],
Cell[39431, 1545, 146, 3, 70, "MoreAbout",
 CellID->111224993]
}, Open  ]],
Cell[39592, 1551, 50, 0, 70, "History"],
Cell[39645, 1553, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

