(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23560,        919]
NotebookOptionsPosition[     17559,        708]
NotebookOutlinePosition[     18826,        744]
CellTagsIndexPosition[     18741,        739]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Value Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingValueLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Value Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Set" :> Documentation`HelpLookup["paclet:ref/Set"], 
          "SetDelayed" :> Documentation`HelpLookup["paclet:ref/SetDelayed"], 
          "Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], 
          "Information" :> Documentation`HelpLookup["paclet:ref/Information"],
           "Save" :> Documentation`HelpLookup["paclet:ref/Save"], 
          "DownValues" :> 
          Documentation`HelpLookup["paclet:ref/DownValues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Set\"\>", 2->"\<\"SetDelayed\"\>", 
       3->"\<\"Clear\"\>", 4->"\<\"Information\"\>", 5->"\<\"Save\"\>", 
       6->"\<\"DownValues\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OwnValues", "ObjectName",
 CellID->23445],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["OwnValues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/OwnValues"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the rule corresponding to any ownvalue defined \
for the symbol ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->561011091],

Cell[TextData[{
 "Set a value for ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->389723192],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "7"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64103473],

Cell["Display its ownvalues:", "ExampleText",
 CellID->356203880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158697168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "7"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289758372]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OwnValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OwnValues"]], "InlineFormula"],
 " returns rules corresponding to definitions made for symbols:"
}], "ExampleText",
 CellID->123597838],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38630326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->368018852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "5"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109298555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->626673923],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OwnValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OwnValues"]], "InlineFormula"],
 " can be used to set values directly:"
}], "ExampleText",
 CellID->197205122],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OwnValues", "[", "y", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"y", "\[RuleDelayed]", "17"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20518693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "y", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->500664459],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuTIwMPBLMADZ/4Es
MIYBdyAG8pkhFAgwIUk7gYXBksxwYbisI1ZZNiABMoMfSLMCaRYcuuXgukGq
2aE0C1QXB5ou/KYwIcmC/CCFppoVh25ZhG4WhCwDAw8OV+A3BxaKIJLpP6b7
Qf4TJMlEkATE6zDAisMcNhzmyIA1y6PJgl3HipwOGJA4kDCVQ4sRVFkYz51E
HgMjAOXlgXQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->859468016]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["y"], "Input",
 CellLabel->"In[3]:=",
 CellID->282754999],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17117360]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->144],

Cell["Values can be defined by immediate or delayed assignments:", \
"ExampleText",
 CellID->237517932],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "17"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", ":=", 
   RowBox[{"Random", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->199882610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OwnValues", "[", "x", "]"}], ",", 
   RowBox[{"OwnValues", "[", "r", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->894639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "17"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "r", "]"}], "\[RuleDelayed]", 
     RowBox[{"Random", "[", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{356, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51040403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375649716],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " is used to protect the rules from their own definitions:"
}], "ExampleText",
 CellID->46349163],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276034557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93379875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "5"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76343692]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[RuleDelayed]", "5"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240430453],

Cell[BoxData[
 RowBox[{"5", "\[RuleDelayed]", "5"}]], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34397019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148222258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OwnValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OwnValues"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " to protect against its argument's values:"
}], "ExampleText",
 CellID->30178673],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "y"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187774619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OwnValues", "[", "x", "]"}], ",", 
   RowBox[{"OwnValues", "[", 
    RowBox[{"Evaluate", "[", "x", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677800211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "y"}], "}"}], 
   ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->314307055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68063005],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " display ownvalues but do not return them as values:"
}], "ExampleText",
 CellID->172195385],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17094182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->509726874],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuTIwMPBLMADZ/4Es
MIYBdyBGcLHxmIDKmYAsEC0IpJmRtOuCVTCwQiiIGJDBwAakWaE0AyuyfQxI
HB2I+VCzxUA8hOFwVVooqtihJnPhVY3pIiGsLkf3GzYTISrFCcqyYPiM+DBG
5TEwAgACGxLj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400495185]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OwnValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OwnValues"]], "InlineFormula"],
 " returns a value that can be used in a program:"
}], "ExampleText",
 CellID->257978063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14087175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "5"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->198793475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145564896],

Cell["\<\
Evaluation of a symbol is equivalent to applying the rules for its \
definition:\
\>", "ExampleText",
 CellID->1118000],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355817968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", "x", "]"}], "/.", 
  RowBox[{"OwnValues", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53388353],

Cell[BoxData[
 RowBox[{"Hold", "[", "5", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22072618]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23154],

Cell["Copy a symbol's value to another symbol:", "ExampleText",
 CellID->8029391],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "17"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256737240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"OwnValues", "[", "y", "]"}], "=", 
  RowBox[{
   RowBox[{"OwnValues", "[", "x", "]"}], "/.", 
   RowBox[{
    RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", 
    "y"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24746943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "y", "]"}], "\[RuleDelayed]", "17"}], 
  "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49020453]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["y"], "Input",
 CellLabel->"In[3]:=",
 CellID->291521977],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->694522142]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23015],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DownValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DownValues"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8055]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16741],

Cell[TextData[ButtonBox["Manipulating Value Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingValueLists"]], "Tutorials",
 CellID->30262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->368969846]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OwnValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 42.6439510}", "context" -> "System`", 
    "keywords" -> {"values", "definitions", "evaluation", "symbol table"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "OwnValues[x] gives the rule corresponding to any ownvalue defined for \
the symbol x.", "synonyms" -> {"own values"}, "title" -> "OwnValues", "type" -> 
    "Symbol", "uri" -> "ref/OwnValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3520, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18606, 732}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2220, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2843, 80, 47, 1, 70, "ObjectName",
 CellID->23445],
Cell[2893, 83, 590, 19, 70, "Usage",
 CellID->18610]
}, Open  ]],
Cell[CellGroupData[{
Cell[3520, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3897, 121, 148, 5, 70, "ExampleSection",
 CellID->561011091],
Cell[4048, 128, 118, 5, 70, "ExampleText",
 CellID->389723192],
Cell[4169, 135, 109, 4, 70, "Input",
 CellID->64103473],
Cell[4281, 141, 65, 1, 70, "ExampleText",
 CellID->356203880],
Cell[CellGroupData[{
Cell[4371, 146, 105, 3, 28, "Input",
 CellID->158697168],
Cell[4479, 151, 259, 9, 36, "Output",
 CellID->289758372]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4787, 166, 215, 7, 70, "ExampleSection",
 CellID->1608],
Cell[5005, 175, 240, 7, 70, "ExampleText",
 CellID->123597838],
Cell[5248, 184, 109, 4, 70, "Input",
 CellID->38630326],
Cell[CellGroupData[{
Cell[5382, 192, 105, 3, 70, "Input",
 CellID->368018852],
Cell[5490, 197, 259, 9, 36, "Output",
 CellID->109298555]
}, Open  ]],
Cell[5764, 209, 125, 3, 70, "ExampleDelimiter",
 CellID->626673923],
Cell[5892, 214, 215, 7, 70, "ExampleText",
 CellID->197205122],
Cell[6110, 223, 209, 7, 70, "Input",
 CellID->20518693],
Cell[CellGroupData[{
Cell[6344, 234, 106, 3, 70, "Input",
 CellID->500664459],
Cell[6453, 239, 468, 12, 70, "Output",
 Evaluatable->False,
 CellID->859468016]
}, Open  ]],
Cell[CellGroupData[{
Cell[6958, 256, 70, 2, 70, "Input",
 CellID->282754999],
Cell[7031, 260, 158, 5, 36, "Output",
 CellID->17117360]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7238, 271, 231, 7, 70, "ExampleSection",
 CellID->144],
Cell[7472, 280, 103, 2, 70, "ExampleText",
 CellID->237517932],
Cell[7578, 284, 194, 7, 70, "Input",
 CellID->199882610],
Cell[CellGroupData[{
Cell[7797, 295, 186, 6, 70, "Input",
 CellID->894639],
Cell[7986, 303, 445, 15, 36, "Output",
 CellID->51040403]
}, Open  ]],
Cell[8446, 321, 125, 3, 70, "ExampleDelimiter",
 CellID->375649716],
Cell[8574, 326, 239, 7, 70, "ExampleText",
 CellID->46349163],
Cell[8816, 335, 110, 4, 70, "Input",
 CellID->276034557],
Cell[CellGroupData[{
Cell[8951, 343, 104, 3, 70, "Input",
 CellID->93379875],
Cell[9058, 348, 258, 9, 36, "Output",
 CellID->76343692]
}, Open  ]],
Cell[CellGroupData[{
Cell[9353, 362, 105, 3, 70, "Input",
 CellID->240430453],
Cell[9461, 367, 192, 6, 36, "Output",
 CellID->34397019]
}, Open  ]],
Cell[9668, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->148222258],
Cell[9796, 381, 357, 12, 70, "ExampleText",
 CellID->30178673],
Cell[10156, 395, 110, 4, 70, "Input",
 CellID->187774619],
Cell[CellGroupData[{
Cell[10291, 403, 226, 7, 70, "Input",
 CellID->677800211],
Cell[10520, 412, 330, 12, 36, "Output",
 CellID->314307055]
}, Open  ]],
Cell[10865, 427, 124, 3, 70, "ExampleDelimiter",
 CellID->68063005],
Cell[10992, 432, 368, 12, 70, "ExampleText",
 CellID->172195385],
Cell[11363, 446, 109, 4, 70, "Input",
 CellID->17094182],
Cell[CellGroupData[{
Cell[11497, 454, 106, 3, 70, "Input",
 CellID->509726874],
Cell[11606, 459, 407, 11, 70, "Output",
 Evaluatable->False,
 CellID->400495185]
}, Open  ]],
Cell[12028, 473, 226, 7, 70, "ExampleText",
 CellID->257978063],
Cell[CellGroupData[{
Cell[12279, 484, 104, 3, 70, "Input",
 CellID->14087175],
Cell[12386, 489, 259, 9, 36, "Output",
 CellID->198793475]
}, Open  ]],
Cell[12660, 501, 125, 3, 70, "ExampleDelimiter",
 CellID->145564896],
Cell[12788, 506, 129, 4, 70, "ExampleText",
 CellID->1118000],
Cell[12920, 512, 110, 4, 70, "Input",
 CellID->355817968],
Cell[CellGroupData[{
Cell[13055, 520, 159, 5, 70, "Input",
 CellID->53388353],
Cell[13217, 527, 187, 6, 36, "Output",
 CellID->22072618]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13453, 539, 224, 7, 70, "ExampleSection",
 CellID->23154],
Cell[13680, 548, 81, 1, 70, "ExampleText",
 CellID->8029391],
Cell[13764, 551, 111, 4, 70, "Input",
 CellID->256737240],
Cell[CellGroupData[{
Cell[13900, 559, 270, 9, 70, "Input",
 CellID->24746943],
Cell[14173, 570, 259, 9, 36, "Output",
 CellID->49020453]
}, Open  ]],
Cell[CellGroupData[{
Cell[14469, 584, 70, 2, 70, "Input",
 CellID->291521977],
Cell[14542, 588, 159, 5, 36, "Output",
 CellID->694522142]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14762, 600, 311, 9, 70, "SeeAlsoSection",
 CellID->23015],
Cell[15076, 611, 1420, 53, 70, "SeeAlso",
 CellID->8055]
}, Open  ]],
Cell[CellGroupData[{
Cell[16533, 669, 314, 9, 70, "TutorialsSection",
 CellID->16741],
Cell[16850, 680, 157, 3, 70, "Tutorials",
 CellID->30262]
}, Open  ]],
Cell[CellGroupData[{
Cell[17044, 688, 299, 8, 70, "MoreAboutSection"],
Cell[17346, 698, 141, 3, 70, "MoreAbout",
 CellID->368969846]
}, Open  ]],
Cell[17502, 704, 27, 0, 70, "History"],
Cell[17532, 706, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

