(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41607,       1452]
NotebookOptionsPosition[     33346,       1165]
NotebookOutlinePosition[     34796,       1205]
CellTagsIndexPosition[     34710,       1200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Discrete Distributions\"\>", 
       2->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CDF" :> Documentation`HelpLookup["paclet:ref/CDF"], 
          "ExpectedValue" :> 
          Documentation`HelpLookup["paclet:ref/ExpectedValue"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "BinCounts" :> 
          Documentation`HelpLookup["paclet:ref/BinCounts"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CDF\"\>", 
       2->"\<\"ExpectedValue\"\>", 3->"\<\"Mean\"\>", 
       4->"\<\"BinCounts\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"Statistical Distributions\"\>", 3->"\<\"Statistics\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PDF", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PDF"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the probability density function for the symbolic \
distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     " evaluated at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PDF"], "[", 
       StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the PDF as a pure function."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For continuous distributions, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["PDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PDF"], "[", 
    RowBox[{
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"]}], "]"}], 
   StyleBox["dx", "TI"]}]], "InlineFormula"],
 " gives the probability that an observed value will lie between ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   StyleBox["dx", "TI"]}]], "InlineFormula"],
 " for infinitesimal ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18716],

Cell[TextData[{
 "For discrete distributions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives the probability that an observed value will be ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->421815088],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->334772969],

Cell["\<\
The PDF of a normal distribution with zero mean and unit standard deviation:\
\>", "ExampleText",
 CellID->39814893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150465643],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->559401765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447267421],

Cell["The PDF of a hypergeometric distribution:", "ExampleText",
 CellID->471683942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"HypergeometricDistribution", "[", 
    RowBox[{"n", ",", "ns", ",", "nt"}], "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486381718],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"ns", ",", "k"}], "]"}], " ", 
   RowBox[{"Binomial", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "ns"}], "+", "nt"}], ",", 
     RowBox[{
      RowBox[{"-", "k"}], "+", "n"}]}], "]"}]}], 
  RowBox[{"Binomial", "[", 
   RowBox[{"nt", ",", "n"}], "]"}]]], "Output",
 ImageSize->{278, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164678169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177632771],

Cell["The PDF of a Poisson distribution as a pure function:", "ExampleText",
 CellID->376034106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15529018],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "\[Mu]"}]], " ", 
    SuperscriptBox["\[Mu]", "#1"]}], 
   RowBox[{"#1", "!"}]], "&"}]], "Output",
 ImageSize->{57, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->432695998]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Obtain exact numeric results:", "ExampleText",
 CellID->659006259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"2", ",", "5"}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191583331],

Cell[BoxData[
 FractionBox["8", 
  RowBox[{"25", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"16", "/", "25"}]]}]]], "Output",
 ImageSize->{58, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158418298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NegativeBinomialDistribution", "[", 
    RowBox[{"20", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359728176],

Cell[BoxData[
 FractionBox["453376", "282429536481"]], "Output",
 ImageSize->{99, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21592412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15255080],

Cell["Obtain a machine-precision result:", "ExampleText",
 CellID->416017623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"2", ",", "5"}], "]"}], ",", "4."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610607049],

Cell[BoxData["0.16873357569377553`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263342177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19374803],

Cell["\<\
Obtain a result at any precision for a continuous distribution:\
\>", "ExampleText",
 CellID->157989833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"2", ",", "5"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"4", ",", "25"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235751636],

Cell[BoxData["0.1687335756937755383179822747412206344`24.642065152999542"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->717494048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13432999],

Cell["\<\
Obtain a result at any precision for a discrete distribution with inexact \
parameters:\
\>", "ExampleText",
 CellID->737502524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NegativeBinomialDistribution", "[", 
    RowBox[{"20", ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", "30"}], "]"}]}], "]"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229388],

Cell[BoxData["1.605271196663597373912088511692648979446863`28.647817481888637*^\
-6"], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325974102]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Plot the PDF for a standard normal distribution:", "ExampleText",
 CellID->526665614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->346682293],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225142549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331526780],

Cell["Plot the PDF for a Poisson distribution:", "ExampleText",
 CellID->57844831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"PoissonDistribution", "[", "10", "]"}], ",", "x"}], "]"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224981200],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8tOFEEUbaZnHBODCjKDiS5woQsVXbrRGGPEhTHRBDDRhU6QBFRAkW/w
7QcQUYmAH4CIWx8bX8GluGCDCxZoIiYkRmLaqq6avlW3qrvn0TPTPfQkdM/t
qrp1zqnXrRr6dG6kr3cgN9Lfk2s7OZy73tffc7OtY2iYPDIbDMOYIX83thvk
u0W+2X8zlkXu6nU/uZokQ4bfE+SeIPdmbhtJOxv/0KdJIVcTt9VctKzJc5l2
4kF6pY8t+2Nso5ck2MyrmGMrsk1deorZzlXxskWwHahCejNKp+WpiA30XiHk
TWV7qAVqXZ0KK8HW+U/ky6lIjHaeni0MKeTg5TLF4iNfW7R1yUq2o3KZwvCl
RHwUj90CG8Ry+tKbff23aJjKmA9wTVosGIP5cZ3go0C03dKpZupYFmeQDMI2
Zj9lCCcn5kjC/XtvjWHbnpr8cvTI6MMH7zgjsM18fmLT/ImAbTZBUXbjTn9j
GD+8XyRPZl9+5WXOdT0n9onjY4CR2HfvvIHxsLLyxxL7N7Z/LK+CTRJ5QzF7
dfWvZK+t/XOx8fhz/JMskk1ceuKpED5RH2hTrB+2md6vZucV2+F77eo0tAdu
n9LtJPTXtDg2SY6hwReAiCAmvYYiZoiWln5LCmJboyjJIin6ffGXpODCwk+d
rW9xkii1OHEmtXil8U08m5NGraZFJf3AbkR8WpFtQosITzcgL4W0QoIwNANR
/9v8coDql44LeiFW9ZCjGp2RG9elOqDGYW0f2mRZzvpy+9ZrbR+KviowMo95
qOA9n0VfBeDnpYL3fBJ9FYAfqJCP6OqJbYe2jZvqguX40898PNczy+7O/Hit
Z5YwHoFlPYzHUzYbHrrZHyVq5TuspKGetkS9bTl7aXduc3TdrxsaFdhJixyd
1J8KuF9Qm5qMvRyV1B973OYJZDMV5Kgk/Co8efyJr1DBqJCNBGvoq66sCzjX
iyZ36KHqzE936uLpYYrfW0PO7KxNAccdYW+PGHUtUMf9OUYdbdSG+Wj0I1+1
z0SmX4urLkPtt+fAsQbOk0VaJELJGtZbzrqEKFtl3d05JZ0mh4d1lxvLlIEi
Kt1+Mos0iwy7jWq8yK40hqIEd0SFibLzzUeCYjvFbKrARhOZ6+ZE+nxnKBng
VTWcOscog0UZ90dPlGkHFfnAmWF3SBFC1BZWhBAtAMIw9MHzNhq/KFc8a6m5
rir6QE7GYi7h4RKGWNSVg7JHMF1HBpxchwa95/944siNsYDfTms/O4kxpnhn
8yjek1UbKV532mIUIUBB+8eu+tUg7aCwxFjtQo0QQCxWKwRkFhgcmKazACCo
Rh+4aNdWaixV6fHB0QUSX8RYC8DqeqpDwcUKRhqrz+/R1UdU3Tmu2mu7V63w
/4vVUBb/plEdjvaKJsS1la51d3hrSTu1WPloh74ndUlqqz1le4Yohnn2WtVN
w/3UvnyOsKfhSKR50n5vxXNPh+1y2/ZyxFFQc71rUAEURayIwdRY1ljXeqsM
xmgyx+/fBeMVnyQhr2nHq5Wf2+l7tL0eHmGv5+8R5nTwSHXc51sS5mBW0m81
ENN1v4ju9dG033IZ2dI7pE5QHJx/j3kC8wyiDmV/bLH5uVK+A8Ff1OxaYC1F
zJ7MIx6f8Fb7FUvt2/i9TrAht1qH+zu2+lLsLXyj4T8NCMF/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75243664]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
The integral or sum over the support of the distribution is unity:\
\>", "ExampleText",
 CellID->133566827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"GammaDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"\[Beta]", ">", "0"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->512651574],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141210483]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"GeometricDistribution", "[", "p", "]"}], ",", "k"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218932912],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298000544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244148105],

Cell[TextData[{
 "Integrating the ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " for continuous distributions:"
}], "ExampleText",
 CellID->101458639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "y"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Lambda]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->815734516],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "y"}], " ", "\[Lambda]"}]]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173539929]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}], ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498810307],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVM0KwjAMrms7nfhzUbaDh4keBMU3EG968gE8jTEEPYiivn/NukxHCNtw
Fpr0S9N8aVJ6iF/n0zV+XZI43D/i+/mSPMPd7QEm2RJCRDD9QMDawMrOyBjQ
EqQEePwgkUJjxx+sGxAKYMDubgn2WS8XhAY4QD0l+5pgD+8k2WgdgvsFDFLM
QTug26itv/74o5dTK7bGjCXhmBHsIZdbwuWgT7cif1nI3dZTfX0zhqpbOUw9
yxipv0vwiOWiXWuSUfoyFNaxaKfn0pv3TPY6hEIKO4YNujxG9jxiJhXX85oM
ef8mJIZG+9yUvfD8BeO24Kq9YE+ua3mtMP6S3f3tz/j+QVGWdOsNj1BdKw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{95, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334296811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12189208],

Cell[TextData[{
 "Summing the ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " for discrete distributions:"
}], "ExampleText",
 CellID->107144637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"GeometricDistribution", "[", "p", "]"}], ",", "m"}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", 
      RowBox[{"Floor", "[", "n", "]"}]}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325017733],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], 
   RowBox[{"1", "+", 
    RowBox[{"Floor", "[", "n", "]"}]}]]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233210552]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"GeometricDistribution", "[", "p", "]"}], ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->429809195],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VlFLwzAQztKkraKbMmUDFQaKiD9CQUGf/Af6UIawPYgy92982i+N13rt
0q9nW9cZaC/fJbn7LrkLeUqWs9e3ZDmfJpPHRfIxm08/Jw/vC1IFPaXUir7R
WFHfUS/7Vs6RDOgfEPwqkEqhy9oWtGeAh+zPgv5FXH0K+BgwWnkWrYT0swQP
QK9ZPyBpBE43zFWZzCw3w6siHg1EnzFg9G0AD7JwCswOcdatOAt5x+Is3Yqn
5ejCBr75PNuBd+pDk6zjq3nO7r/s5yVbj1j2xVUxj4YNPH3LOxvw1apqBzGe
1wngCPDeL3ZNy73vElOffXCJqCJXje/PCuzyusql9qT29KWdyu2srVNnX+CA
ud2lXg6ROeBRwx5Zj1sxLnPhVUqMs2Zdad75H2LNq+KocmapdoyR4HmInuT7
YnvxXbi6W/le4liJDM8ov4P8DDRSTQlZedWKR1iJA21jnmGdy37u3Pp+8zMt
bUNXvvuuRQubvQDWL4qfV4bqfQO4q2tv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->825359042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->576288974],

Cell[TextData[{
 "The integral or sum of a function times the ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of the function:"
}], "ExampleText",
 CellID->301259266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Nu]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->681923683],

Cell[BoxData["\[Nu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45760595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{"x", ",", 
   RowBox[{"ChiSquareDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22100871],

Cell[BoxData["\[Nu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->720037180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "^", "2"}], " ", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "k"}], "]"}]}],
    ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->309247236],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  SuperscriptBox["\[Mu]", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->75612335]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"k", "^", "2"}], ",", 
   RowBox[{"PoissonDistribution", "[", "\[Mu]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->422822880],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  SuperscriptBox["\[Mu]", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->445593098]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
Substitution of invalid values into symbolic outputs gives results that are \
not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"ChiSquareDistribution", "[", "3", "]"}], ",", "x"}], "]"}], "/.",
   
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29801],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "\[ExponentialE]"}], 
  SqrtBox["\[Pi]"]]], "Output",
 ImageSize->{33, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328993442]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with PDF",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=PDF"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->753910994],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->368169697],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->91677244],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->74477381],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->3861965]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PDF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 8, 26.4918954}", "context" -> "System`", 
    "keywords" -> {
     "density function", "distribution", "mass function", "prob", 
      "probability density function", "probability distribution", 
      "probability function", "probability mass function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PDF[dist, x] gives the probability density function for the symbolic \
distribution dist evaluated at x. PDF[dist] gives the PDF as a pure \
function.", "synonyms" -> {}, "title" -> "PDF", "type" -> "Symbol", "uri" -> 
    "ref/PDF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7666, 231, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->421815088]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34567, 1193}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2838, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3461, 90, 1568, 37, 70, "ObjectNameGrid"],
Cell[5032, 129, 1014, 33, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6083, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6561, 184, 658, 25, 70, "Notes",
 CellID->18716],
Cell[7222, 211, 407, 15, 70, "Notes",
 CellID->19169]
}, Closed]],
Cell[CellGroupData[{
Cell[7666, 231, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->421815088],
Cell[CellGroupData[{
Cell[8051, 245, 148, 5, 70, "ExampleSection",
 CellID->334772969],
Cell[8202, 252, 126, 3, 70, "ExampleText",
 CellID->39814893],
Cell[CellGroupData[{
Cell[8353, 259, 193, 6, 28, "Input",
 CellID->150465643],
Cell[8549, 267, 325, 12, 68, "Output",
 CellID->559401765]
}, Open  ]],
Cell[8889, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->447267421],
Cell[9017, 287, 84, 1, 70, "ExampleText",
 CellID->471683942],
Cell[CellGroupData[{
Cell[9126, 292, 213, 6, 70, "Input",
 CellID->486381718],
Cell[9342, 300, 483, 17, 53, "Output",
 CellID->164678169]
}, Open  ]],
Cell[9840, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->177632771],
Cell[9968, 325, 96, 1, 70, "ExampleText",
 CellID->376034106],
Cell[CellGroupData[{
Cell[10089, 330, 148, 4, 70, "Input",
 CellID->15529018],
Cell[10240, 336, 336, 12, 54, "Output",
 CellID->432695998]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10625, 354, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[10849, 363, 72, 1, 70, "ExampleText",
 CellID->659006259],
Cell[CellGroupData[{
Cell[10946, 368, 194, 6, 70, "Input",
 CellID->191583331],
Cell[11143, 376, 268, 9, 53, "Output",
 CellID->158418298]
}, Open  ]],
Cell[CellGroupData[{
Cell[11448, 390, 230, 7, 70, "Input",
 CellID->359728176],
Cell[11681, 399, 193, 6, 51, "Output",
 CellID->21592412]
}, Open  ]],
Cell[11889, 408, 124, 3, 70, "ExampleDelimiter",
 CellID->15255080],
Cell[12016, 413, 77, 1, 70, "ExampleText",
 CellID->416017623],
Cell[CellGroupData[{
Cell[12118, 418, 195, 6, 70, "Input",
 CellID->610607049],
Cell[12316, 426, 177, 5, 36, "Output",
 CellID->263342177]
}, Open  ]],
Cell[12508, 434, 124, 3, 70, "ExampleDelimiter",
 CellID->19374803],
Cell[12635, 439, 114, 3, 70, "ExampleText",
 CellID->157989833],
Cell[CellGroupData[{
Cell[12774, 446, 249, 8, 70, "Input",
 CellID->235751636],
Cell[13026, 456, 218, 6, 36, "Output",
 CellID->717494048]
}, Open  ]],
Cell[13259, 465, 124, 3, 70, "ExampleDelimiter",
 CellID->13432999],
Cell[13386, 470, 138, 4, 70, "ExampleText",
 CellID->737502524],
Cell[CellGroupData[{
Cell[13549, 478, 291, 10, 70, "Input",
 CellID->229388],
Cell[13843, 490, 227, 6, 36, "Output",
 CellID->325974102]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14119, 502, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[14349, 511, 91, 1, 70, "ExampleText",
 CellID->526665614],
Cell[CellGroupData[{
Cell[14465, 516, 334, 11, 70, "Input",
 CellID->346682293],
Cell[14802, 529, 2795, 50, 70, "Output",
 Evaluatable->False,
 CellID->225142549]
}, Open  ]],
Cell[17612, 582, 125, 3, 70, "ExampleDelimiter",
 CellID->331526780],
Cell[17740, 587, 82, 1, 70, "ExampleText",
 CellID->57844831],
Cell[CellGroupData[{
Cell[17847, 592, 466, 15, 70, "Input",
 CellID->224981200],
Cell[18316, 609, 1907, 35, 70, "Output",
 Evaluatable->False,
 CellID->75243664]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20272, 650, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[20513, 659, 117, 3, 70, "ExampleText",
 CellID->133566827],
Cell[CellGroupData[{
Cell[20655, 666, 478, 14, 70, "Input",
 CellID->512651574],
Cell[21136, 682, 158, 5, 36, "Output",
 CellID->141210483]
}, Open  ]],
Cell[CellGroupData[{
Cell[21331, 692, 299, 10, 70, "Input",
 CellID->218932912],
Cell[21633, 704, 158, 5, 36, "Output",
 CellID->298000544]
}, Open  ]],
Cell[21806, 712, 125, 3, 70, "ExampleDelimiter",
 CellID->244148105],
Cell[21934, 717, 343, 13, 70, "ExampleText",
 CellID->101458639],
Cell[CellGroupData[{
Cell[22302, 734, 392, 12, 70, "Input",
 CellID->815734516],
Cell[22697, 748, 270, 9, 36, "Output",
 CellID->173539929]
}, Open  ]],
Cell[CellGroupData[{
Cell[23004, 762, 184, 6, 70, "Input",
 CellID->498810307],
Cell[23191, 770, 577, 14, 70, "Output",
 Evaluatable->False,
 CellID->334296811]
}, Open  ]],
Cell[23783, 787, 124, 3, 70, "ExampleDelimiter",
 CellID->12189208],
Cell[23910, 792, 337, 13, 70, "ExampleText",
 CellID->107144637],
Cell[CellGroupData[{
Cell[24272, 809, 373, 13, 70, "Input",
 CellID->325017733],
Cell[24648, 824, 312, 11, 36, "Output",
 CellID->233210552]
}, Open  ]],
Cell[CellGroupData[{
Cell[24997, 840, 174, 6, 70, "Input",
 CellID->429809195],
Cell[25174, 848, 732, 16, 70, "Output",
 Evaluatable->False,
 CellID->825359042]
}, Open  ]],
Cell[25921, 867, 125, 3, 70, "ExampleDelimiter",
 CellID->576288974],
Cell[26049, 872, 375, 13, 70, "ExampleText",
 CellID->301259266],
Cell[CellGroupData[{
Cell[26449, 889, 417, 13, 70, "Input",
 CellID->681923683],
Cell[26869, 904, 161, 5, 36, "Output",
 CellID->45760595]
}, Open  ]],
Cell[CellGroupData[{
Cell[27067, 914, 197, 6, 70, "Input",
 CellID->22100871],
Cell[27267, 922, 162, 5, 36, "Output",
 CellID->720037180]
}, Open  ]],
Cell[CellGroupData[{
Cell[27466, 932, 353, 12, 70, "Input",
 CellID->309247236],
Cell[27822, 946, 211, 7, 36, "Output",
 CellID->75612335]
}, Open  ]],
Cell[CellGroupData[{
Cell[28070, 958, 220, 7, 70, "Input",
 CellID->422822880],
Cell[28293, 967, 212, 7, 36, "Output",
 CellID->445593098]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28554, 980, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[28788, 989, 140, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[28953, 997, 269, 10, 70, "Input",
 CellID->29801],
Cell[29225, 1009, 243, 8, 55, "Output",
 CellID->328993442]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29529, 1024, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[29848, 1035, 939, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[30824, 1075, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[31145, 1086, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[31301, 1091, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[31495, 1099, 305, 8, 70, "RelatedLinksSection"],
Cell[31803, 1109, 346, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32186, 1125, 299, 8, 70, "MoreAboutSection"],
Cell[32488, 1135, 155, 3, 70, "MoreAbout",
 CellID->753910994],
Cell[32646, 1140, 161, 3, 70, "MoreAbout",
 CellID->368169697],
Cell[32810, 1145, 131, 3, 70, "MoreAbout",
 CellID->91677244],
Cell[32944, 1150, 178, 3, 70, "MoreAbout",
 CellID->74477381],
Cell[33125, 1155, 149, 3, 70, "MoreAbout",
 CellID->3861965]
}, Open  ]],
Cell[33289, 1161, 27, 0, 70, "History"],
Cell[33319, 1163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

