(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50728,       1788]
NotebookOptionsPosition[     42755,       1512]
NotebookOutlinePosition[     44368,       1553]
CellTagsIndexPosition[     44282,       1548]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingLists"], 
          "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], 
          "Partitioning and Padding Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningAndPaddingLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rearranging Lists\"\>", 
       2->"\<\"Nested Lists\"\>", 
       3->"\<\"Partitioning and Padding Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadRight" :> Documentation`HelpLookup["paclet:ref/PadRight"], 
          "Join" :> Documentation`HelpLookup["paclet:ref/Join"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "ListCorrelate" :> 
          Documentation`HelpLookup["paclet:ref/ListCorrelate"], "Riffle" :> 
          Documentation`HelpLookup["paclet:ref/Riffle"], "RotateLeft" :> 
          Documentation`HelpLookup["paclet:ref/RotateLeft"], "ArrayQ" :> 
          Documentation`HelpLookup["paclet:ref/ArrayQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PadRight\"\>", 2->"\<\"Join\"\>", 
       3->"\<\"Partition\"\>", 4->"\<\"ListCorrelate\"\>", 
       5->"\<\"Riffle\"\>", 6->"\<\"RotateLeft\"\>", 
       7->"\<\"ArrayQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Rearranging & Restructuring Lists\"\>", 
       3->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["PadLeft", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadLeft"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a list of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " by padding ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with zeros on the left. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadLeft"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads by repeating the element ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadLeft"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads by cyclically repeating the elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadLeft"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["padding", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]leaves a margin of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " elements of padding on the right. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadLeft"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a nested list with length ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PadLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/PadLeft"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads a ragged array ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with zeros to make it full. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->29515]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " always returns a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", except in some special cases where ",
 Cell[BoxData[
  StyleBox["padding", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27621],

Cell[TextData[{
 "With padding ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["s", "TI"]]}], "}"}]], "InlineFormula"],
 " cyclic repetitions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are effectively laid down and then the list is superimposed on top of \
them, with the last element of the list lying on an occurrence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27189,
  ButtonNote->"27189"]
}], "Notes",
 CellID->29993],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["padding", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["m", "TI"]}]}], "]"}]], "InlineFormula"],
 " truncates the last ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15826],

Cell[TextData[{
 "A margin of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"], "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      StyleBox["n", "TI"], "-", 
      RowBox[{
       ButtonBox["Length",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Length"], "[", 
       StyleBox["list", "TI"], "]"}]}], ")"}], "/", "2"}], "]"}]], 
  "InlineFormula"],
 " effectively centers ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15722],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " effectively treats ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as cyclic. "
}], "Notes",
 CellID->23838],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     StyleBox["xlist", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 " can be used to repeat an individual element that is itself a list. "
}], "Notes",
 CellID->24828],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " repeats the sequence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as many times as fits in a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12581],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " creates a full array with dimensions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " even if ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " is ragged. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6038,
  ButtonNote->"6038"]
}], "Notes",
 CellID->24399],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " pads with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to make a full array. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8978],

Cell[TextData[{
 "Negative ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specify to pad on the right. "
}], "Notes",
 CellID->11891],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["12", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["21", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " pads by repeating the block of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1023],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " effectively treats ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as cyclic in every dimension. "
}], "Notes",
 CellID->26943],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["padding", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " uses margin ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " at level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24834],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " need not have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14243],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->7349]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36682584],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->6890243],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["0"], "InlineFormula"],
 " to make the list be of length 10:"
}], "ExampleText",
 CellID->31690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13162],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "a", 
   ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29126],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "a", 
   ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26260],

Cell[TextData[{
 "Pad by repeating ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "z", ",", "x", ",", "y", ",", "z", ",", "x", ",", "y", ",", "z", ",", "a", 
   ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2663],

Cell["Leave margin 2 on the right:", "ExampleText",
 CellID->20722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", "x", ",", "2"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "a", ",", "b", ",", "c", 
   ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16360],

Cell[TextData[{
 "Pad to make a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "5"}], TraditionalForm]], "InlineMath"],
 " array:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadLeft", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", "c", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18588],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwOAOxtgQDkP0fyAJj
5///gTQmyQQkmYEKeAjQTGDVDMwQCkSCRZghHBCTA0SwwvkQhQxcFIsy0stm
JBOZh7OdAxLC3ECahU52CfwnJmUL/seeI8jJKSAncEDpEZBTaGwzLK0MrC+Z
oHHJSBP/MUNpBhaogWBA3bQjiaYXYiyudCwJ9TPrf+rlixFWg4zaPKJtJi0n
QHIPAyMA5B0PVg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{67, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->94562488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28245],

Cell["Pad to make a full array:", "ExampleText",
 CellID->9467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadLeft", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32425],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqAKxtgQDkP0fyAJj
1f//gTQmyQQkmYEKeKA0N5BmBdKMYFkGZggFIkEqGZghHBCTA0SwwvkQhWD9
yKqYRs1BMYeLJuGLHou8UBpiC664x58aWKGuZaHAtVxoqpgHgTkkhD5yOMNc
gWEmYbM4gQRIP7IaLmhIE05HPGh8PpSY4oOaLUBGTIO8wgGleYh2D54YIiNs
SIlvkF4WnHaRl0aYYH4m6CZGlHAH50MWqMFgwPMfOa8IoJkpBBblh9ooghQT
DIwAcv7tIA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->431468833]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10542],

Cell["Negative length specifications pad on the right:", "ExampleText",
 CellID->13063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"-", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29617],

Cell["\<\
Lay down repetitions of the padding, then superimpose the original array:\
\>", "ExampleText",
 CellID->9099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadLeft", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"aa", ",", "bb"}], "}"}], ",", 
      RowBox[{"{", "cc", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], "]"}], "//", "TableForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->25023],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "y", "x", "y"},
    {"z", "z", "z", "z"},
    {"x", "y", "aa", "bb"},
    {"z", "z", "z", "cc"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{70, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->17226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31203],

Cell["Use different margins for rows and columns:", "ExampleText",
 CellID->30048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadLeft", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"aa", ",", "bb"}], "}"}], ",", 
      RowBox[{"{", "cc", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", "z", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21051],

Cell[BoxData[
 TagBox[GridBox[{
    {"y", "x", "y", "x", "y"},
    {"z", "z", "z", "z", "z"},
    {"y", "aa", "bb", "x", "y"},
    {"z", "z", "cc", "z", "z"},
    {"y", "x", "y", "x", "y"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{85, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->1570]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8636],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "8", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25967],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "a", ",", "b", ",", "c"}],
   "]"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8456]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11531],

Cell["Put a 1 at the center of a list of 0s:", "ExampleText",
 CellID->29962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", "19", ",", "0", ",", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26819],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10556],

Cell["Pad digit lists to be the same length:", "ExampleText",
 CellID->7531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", 
     RowBox[{
      RowBox[{"i", "^", "2"}], ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30591],

Cell["Lay out an array of tiles:", "ExampleText",
 CellID->26803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"PadLeft", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3388],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnT9LI1EUxccMzKS0sNjSMo2wnYXVNtlqSWNjGcKCCy67ZMU0NhY2ptAi
EWxWBAdFsQhIBO20EYR0Nha2+QB+gOx5d82+P85kloUtJu888DnXe+9785vc
kOOdkHyqr69+/lpf/9Koz39s1r+vfmn8mK9+a+JP4UwQBPvq512A4xGO5Gd/
NMJvcw7VHCZJ8lNGMKum8PDwMMNeyPGn21h/JCOYMXZVrt8jUlNYq9UGg4Fy
xeI/Ozt7eXlRh5HYT09PjUZDhcYS7/qHw+HV1ZXOb7ValUpFrw/D8sNAis7H
Yjs7O3r9u7s7bGn5seU4v4TTLUscOF7pVFwJDOUxH6lJTWpSk5rU00BdkxFE
ago3Njb6/T6SglhN4fHx8f39vTqMxL65udna2lKhscS7/tvb2/Pzc53fbrdx
lfT6MCw/DKTofCzW6XT0+r1eD1tafmw5zi/hdMsSB46BDIkrgaEs8aS2qI3K
CEKEqlX+VBjKbW5uTlfo0tISik5XqOtHBaOodb5bwTAsv/sMwGJGBctVwpaW
33gGWJVsPFPTKp/UpCY1qUlN6qJSv3e6LpFjxzn+D5hC+xoae7/VtynXME/f
TrxGrr5NuYZ5+ta8hln6Nr9ySE1qUpOa1KQuFvXEHkWn01lZWdH+tbW1vB5F
u93W/rwehevHZnk9CsOf2aMw/05q33uPpCY1qUlNalIXi7olI4jUpBQoVsW5
BLGawqOjo8vLS3UYiX1xcbG3t6dCY4l3/VAVSZLo/G63C1Wj14dh+WEgRedj
sYODA73+6ekptrT82HKcX8LpliUOHFcyJK4EhrLEZ1IPZQSRmpS2wmOpHp5Y
TeHu7u7i4qI6jMReXl6+vr5WobHEu/5qtQownQ+kx8dHvT4Myw8DKTofi52c
nOj1m80mtrT82HKcX8LpliUOHBUZElcCQ1ni2XskNalJTWpSTwm1n6/XhqYR
hYlrqbURhNLm5qbWVtvb25BLWlu5flBAjul8V3vBsPyudsNihvYKQghBbGn5
De1maTBDY1qaLZ3aqAyPeqSkJjWpSU1qUheLemIHKUWl5HWQJqoQt4OUolLy
OkimSsnqIOWrFEPJie6FytOKEPLw+flZK8qHhweIRK0oXT8UJ8B1vqs4YVh+
V7FiMUNxBiHkL7a0/IZitZSnoawtpfoPFT61PVJSk5rUpCZ1can9fL328+6e
URke9UhJTWpSk5rUpC4WtZ/3uSYq0pR7mnmKdOI9S1eRptzTzFOk5j3NLEXa
yL2naVSGRz1SUpOa1KQmdXGp/Xy99vPu3sQKn9oeKalJTWpSk5rUxaL28z6X
oeQ8ele8URke9UhJTWpSk5rUpC4MNT/7kR1XUpOa1KQmtZfUNRm+fQqin9QT
K3xqe4+kJjWpSU1qUheG+j90Zoy9/ehukZrUpCY1qUldQGrjf/sg7Pf7+P9e
9whSehS9Xi+7h4GztHoU7jeD5vUwsJjxzaDy7hJsmdXDsL4h1Oi1/EWPwk9q
ozI86j2SmtSkJjWpSV0g6m63+9plmXW6Lq69kONPt5MksXbdfzMHM78AAZ7T
4Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->201187440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12319],

Cell["Pad with an element that is itself a list:", "ExampleText",
 CellID->6272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", "a", ",", "b", ",", "c"}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10133],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "u", ",", "v", ",", "u", ",", "a", ",", "b", ",", "c"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1775]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15891],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2702],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "Tutorials",
 CellID->8707],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->20502],

Cell[TextData[ButtonBox["Partitioning and Padding Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningAndPaddingLists"]], "Tutorials",
 CellID->25141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->177202771],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->100064739],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->139653853],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->106269594]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
PadLeft"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PadLeft - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 45.0502626}", "context" -> "System`", 
    "keywords" -> {"dithering", "padding"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PadLeft[list, n] makes a list of length n by padding list with zeros on \
the left. PadLeft[list, n, x] pads by repeating the element x. PadLeft[list, \
n, {x_1, x_2, ...}] pads by cyclically repeating the elements x_i. \
PadLeft[list, n, padding, m] leaves a margin of m elements of padding on the \
right. PadLeft[list, {n_1, n_2, ...}] makes a nested list with length n_i at \
level i. PadLeft[list] pads a ragged array list with zeros to make it full. ",
     "synonyms" -> {"pad left"}, "title" -> "PadLeft", "type" -> "Symbol", 
    "uri" -> "ref/PadLeft"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21230, 692, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36682584]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44139, 1541}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3018, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3641, 93, 4191, 83, 70, "ObjectNameGrid"],
Cell[7835, 178, 3643, 118, 70, "Usage",
 CellID->29515]
}, Open  ]],
Cell[CellGroupData[{
Cell[11515, 301, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11993, 318, 573, 21, 70, "Notes",
 CellID->27621],
Cell[12569, 341, 890, 32, 70, "Notes",
 CellID->29993],
Cell[13462, 375, 516, 20, 70, "Notes",
 CellID->15826],
Cell[13981, 397, 549, 22, 70, "Notes",
 CellID->15722],
Cell[14533, 421, 396, 15, 70, "Notes",
 CellID->23838],
Cell[14932, 438, 394, 13, 70, "Notes",
 CellID->24828],
Cell[15329, 453, 750, 28, 70, "Notes",
 CellID->12581],
Cell[16082, 483, 981, 37, 70, "Notes",
 CellID->24399],
Cell[17066, 522, 589, 20, 70, "Notes",
 CellID->8978],
Cell[17658, 544, 192, 8, 70, "Notes",
 CellID->11891],
Cell[17853, 554, 1119, 41, 70, "Notes",
 CellID->1023],
Cell[18975, 597, 636, 23, 70, "Notes",
 CellID->26943],
Cell[19614, 622, 991, 38, 70, "Notes",
 CellID->24834],
Cell[20608, 662, 262, 11, 70, "Notes",
 CellID->14243],
Cell[20873, 675, 320, 12, 70, "Notes",
 CellID->7349]
}, Closed]],
Cell[CellGroupData[{
Cell[21230, 692, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36682584],
Cell[CellGroupData[{
Cell[21614, 706, 146, 5, 70, "ExampleSection",
 CellID->6890243],
Cell[21763, 713, 140, 5, 70, "ExampleText",
 CellID->31690],
Cell[CellGroupData[{
Cell[21928, 722, 182, 6, 28, "Input",
 CellID->13162],
Cell[22113, 730, 286, 9, 36, "Output",
 CellID->8935]
}, Open  ]],
Cell[22414, 742, 121, 3, 70, "ExampleDelimiter",
 CellID->29126],
Cell[22538, 747, 107, 5, 70, "ExampleText",
 CellID->19410],
Cell[CellGroupData[{
Cell[22670, 756, 195, 7, 70, "Input",
 CellID->19877],
Cell[22868, 765, 287, 9, 36, "Output",
 CellID->11382]
}, Open  ]],
Cell[23170, 777, 121, 3, 70, "ExampleDelimiter",
 CellID->26260],
Cell[23294, 782, 220, 8, 70, "ExampleText",
 CellID->27189],
Cell[CellGroupData[{
Cell[23539, 794, 251, 8, 70, "Input",
 CellID->26705],
Cell[23793, 804, 287, 9, 36, "Output",
 CellID->13874]
}, Open  ]],
Cell[24095, 816, 120, 3, 70, "ExampleDelimiter",
 CellID->2663],
Cell[24218, 821, 67, 1, 70, "ExampleText",
 CellID->20722],
Cell[CellGroupData[{
Cell[24310, 826, 205, 7, 70, "Input",
 CellID->32195],
Cell[24518, 835, 287, 9, 36, "Output",
 CellID->22566]
}, Open  ]],
Cell[24820, 847, 121, 3, 70, "ExampleDelimiter",
 CellID->16360],
Cell[24944, 852, 222, 8, 70, "ExampleText",
 CellID->6038],
Cell[CellGroupData[{
Cell[25191, 864, 339, 12, 28, "Input",
 CellID->18588],
Cell[25533, 878, 481, 12, 78, "Output",
 Evaluatable->False,
 CellID->94562488]
}, Open  ]],
Cell[26029, 893, 121, 3, 70, "ExampleDelimiter",
 CellID->28245],
Cell[26153, 898, 63, 1, 70, "ExampleText",
 CellID->9467],
Cell[CellGroupData[{
Cell[26241, 903, 332, 11, 28, "Input",
 CellID->32425],
Cell[26576, 916, 539, 13, 78, "Output",
 Evaluatable->False,
 CellID->431468833]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27164, 935, 216, 7, 70, "ExampleSection",
 CellID->10542],
Cell[27383, 944, 87, 1, 70, "ExampleText",
 CellID->13063],
Cell[CellGroupData[{
Cell[27495, 949, 201, 7, 70, "Input",
 CellID->21547],
Cell[27699, 958, 287, 9, 36, "Output",
 CellID->30502]
}, Open  ]],
Cell[28001, 970, 121, 3, 70, "ExampleDelimiter",
 CellID->29617],
Cell[28125, 975, 119, 3, 70, "ExampleText",
 CellID->9099],
Cell[CellGroupData[{
Cell[28269, 982, 487, 18, 70, "Input",
 CellID->25023],
Cell[28759, 1002, 612, 19, 92, "Output",
 CellID->17226]
}, Open  ]],
Cell[29386, 1024, 121, 3, 70, "ExampleDelimiter",
 CellID->31203],
Cell[29510, 1029, 82, 1, 70, "ExampleText",
 CellID->30048],
Cell[CellGroupData[{
Cell[29617, 1034, 546, 19, 70, "Input",
 CellID->21051],
Cell[30166, 1055, 662, 20, 108, "Output",
 CellID->1570]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30877, 1081, 238, 7, 70, "ExampleSection",
 CellID->8636],
Cell[31118, 1090, 192, 8, 70, "ExampleText",
 CellID->9458],
Cell[CellGroupData[{
Cell[31335, 1102, 199, 7, 70, "Input",
 CellID->25967],
Cell[31537, 1111, 270, 9, 36, "Output",
 CellID->8456]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31856, 1126, 223, 7, 70, "ExampleSection",
 CellID->11531],
Cell[32082, 1135, 77, 1, 70, "ExampleText",
 CellID->29962],
Cell[CellGroupData[{
Cell[32184, 1140, 167, 5, 70, "Input",
 CellID->26819],
Cell[32354, 1147, 380, 10, 36, "Output",
 CellID->7975]
}, Open  ]],
Cell[32749, 1160, 121, 3, 70, "ExampleDelimiter",
 CellID->10556],
Cell[32873, 1165, 76, 1, 70, "ExampleText",
 CellID->7531],
Cell[CellGroupData[{
Cell[32974, 1170, 301, 10, 70, "Input",
 CellID->31495],
Cell[33278, 1182, 627, 18, 36, "Output",
 CellID->8044]
}, Open  ]],
Cell[33920, 1203, 121, 3, 70, "ExampleDelimiter",
 CellID->30591],
Cell[34044, 1208, 65, 1, 70, "ExampleText",
 CellID->26803],
Cell[CellGroupData[{
Cell[34134, 1213, 591, 19, 70, "Input",
 CellID->3388],
Cell[34728, 1234, 1855, 35, 70, "Output",
 Evaluatable->False,
 CellID->201187440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36632, 1275, 226, 7, 70, "ExampleSection",
 CellID->12319],
Cell[36861, 1284, 80, 1, 70, "ExampleText",
 CellID->6272],
Cell[CellGroupData[{
Cell[36966, 1289, 266, 9, 70, "Input",
 CellID->25791],
Cell[37235, 1300, 449, 16, 36, "Output",
 CellID->29383]
}, Open  ]],
Cell[CellGroupData[{
Cell[37721, 1321, 240, 8, 70, "Input",
 CellID->10133],
Cell[37964, 1331, 252, 8, 36, "Output",
 CellID->1775]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38277, 1346, 311, 9, 70, "SeeAlsoSection",
 CellID->15891],
Cell[38591, 1357, 1676, 62, 70, "SeeAlso",
 CellID->24637]
}, Open  ]],
Cell[CellGroupData[{
Cell[40304, 1424, 313, 9, 70, "TutorialsSection",
 CellID->2702],
Cell[40620, 1435, 143, 3, 70, "Tutorials",
 CellID->8707],
Cell[40766, 1440, 134, 3, 70, "Tutorials",
 CellID->20502],
Cell[40903, 1445, 168, 3, 70, "Tutorials",
 CellID->25141]
}, Open  ]],
Cell[CellGroupData[{
Cell[41108, 1453, 319, 9, 70, "MoreAboutSection",
 CellID->177202771],
Cell[41430, 1464, 153, 3, 70, "MoreAbout",
 CellID->100064739],
Cell[41586, 1469, 177, 3, 70, "MoreAbout",
 CellID->139653853],
Cell[41766, 1474, 164, 3, 70, "MoreAbout",
 CellID->106269594]
}, Open  ]],
Cell[CellGroupData[{
Cell[41967, 1482, 305, 8, 70, "RelatedLinksSection"],
Cell[42275, 1492, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[42675, 1508, 50, 0, 70, "History"],
Cell[42728, 1510, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

