(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19463,        546]
NotebookOptionsPosition[     16051,        436]
NotebookOutlinePosition[     17684,        481]
CellTagsIndexPosition[     17566,        475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageBreakBelow" :> 
          Documentation`HelpLookup["paclet:ref/PageBreakBelow"], 
          "ShowPageBreaks" :> 
          Documentation`HelpLookup["paclet:ref/ShowPageBreaks"], 
          "PageHeaders" :> 
          Documentation`HelpLookup["paclet:ref/PageHeaders"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PageBreakBelow\"\>", 
       2->"\<\"ShowPageBreaks\"\>", 
       3->"\<\"PageHeaders\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Page Layout & Printing Control\"\>",
        2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageBreakAbove", "ObjectName",
 CellID->12993],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PageBreakAbove",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PageBreakAbove"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a page break should be made immediately above \
the cell if the notebook that contains the cell is printed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28782]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " specifies that a page break should be made if necessary. "
}], "Notes",
 CellID->32203],

Cell[TextData[{
 "A setting of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " specifies that a page break should always be made, while a setting of ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " specifies that it should never be made. "
}], "Notes",
 CellID->17461]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->553650017],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->189876109],

Cell["Create a document and select the seventh cell in it:", "ExampleText",
 CellID->151053419],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<abcde\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], ",", 
     RowBox[{"ShowPageBreaks", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->317531434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149495162],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3W1zFeUZB/B0+r7DV+g34CMwbV/XmY59085UcApoO06n/QCt41RtpXaK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   "], {{0, 0}, {458, 219}}, {0, 255}],
  ImageSize->{458 0.75, 219 0.75},
  PlotRange->{{0, 458}, {0, 219}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->20072502]
}, Open  ]],

Cell["Set a page break above that cell:", "ExampleText",
 CellID->800775401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"PageBreakAbove", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36655570],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3W1zVOUZB/B0+r7DV+g34CNk2r6uMx19085UcApoO06n/QCVcaq2UjvF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   "], {{0, 0}, {458, 219}}, {0, 255}],
  ImageSize->{458 0.75, 219 0.75},
  PlotRange->{{0, 458}, {0, 219}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->250398605]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31151],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageBreakBelow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageBreakBelow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowPageBreaks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowPageBreaks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageHeaders",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageHeaders"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18423]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8290],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->19662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->190973346],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout",
 CellID->305787425],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->242952355]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageBreakAbove - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 51.6441814}", "context" -> "System`", 
    "keywords" -> {"set page break", "page break", "pagination"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PageBreakAbove is an option for Cell which specifies whether a page \
break should be made immediately above the cell if the notebook that contains \
the cell is printed. ", "synonyms" -> {"page break above"}, "title" -> 
    "PageBreakAbove", "type" -> "Symbol", "uri" -> "ref/PageBreakAbove"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4709, 152, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->553650017]},
 "Notebook Image"->{
  Cell[5941, 199, 3689, 63, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->20072502],
  Cell[9969, 278, 3747, 64, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->250398605]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17196, 461},
 {"Notebook Image", 17337, 465}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2143, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2766, 80, 52, 1, 70, "ObjectName",
 CellID->12993],
Cell[2821, 83, 681, 19, 70, "Usage",
 CellID->28782]
}, Open  ]],
Cell[CellGroupData[{
Cell[3539, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4017, 124, 245, 8, 70, "Notes",
 CellID->32203],
Cell[4265, 134, 407, 13, 70, "Notes",
 CellID->17461]
}, Closed]],
Cell[CellGroupData[{
Cell[4709, 152, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->553650017],
Cell[CellGroupData[{
Cell[5094, 166, 148, 5, 70, "ExampleSection",
 CellID->189876109],
Cell[5245, 173, 95, 1, 70, "ExampleText",
 CellID->151053419],
Cell[5343, 176, 411, 13, 70, "Input",
 CellID->317531434],
Cell[CellGroupData[{
Cell[5779, 193, 159, 4, 70, "Input",
 CellID->149495162],
Cell[5941, 199, 3689, 63, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->20072502]
}, Open  ]],
Cell[9645, 265, 76, 1, 70, "ExampleText",
 CellID->800775401],
Cell[CellGroupData[{
Cell[9746, 270, 220, 6, 70, "Input",
 CellID->36655570],
Cell[9969, 278, 3747, 64, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->250398605]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13777, 349, 311, 9, 70, "SeeAlsoSection",
 CellID->31151],
Cell[14091, 360, 726, 26, 70, "SeeAlso",
 CellID->18423]
}, Open  ]],
Cell[CellGroupData[{
Cell[14854, 391, 313, 9, 70, "TutorialsSection",
 CellID->8290],
Cell[15170, 402, 143, 3, 70, "Tutorials",
 CellID->19662]
}, Open  ]],
Cell[CellGroupData[{
Cell[15350, 410, 319, 9, 70, "MoreAboutSection",
 CellID->190973346],
Cell[15672, 421, 170, 3, 70, "MoreAbout",
 CellID->305787425],
Cell[15845, 426, 134, 3, 70, "MoreAbout",
 CellID->242952355]
}, Open  ]],
Cell[15994, 432, 27, 0, 70, "History"],
Cell[16024, 434, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

