(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18808,        527]
NotebookOptionsPosition[     15461,        419]
NotebookOutlinePosition[     17094,        464]
CellTagsIndexPosition[     16976,        458]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageBreakAbove" :> 
          Documentation`HelpLookup["paclet:ref/PageBreakAbove"], 
          "ShowPageBreaks" :> 
          Documentation`HelpLookup["paclet:ref/ShowPageBreaks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PageBreakAbove\"\>", 
       2->"\<\"ShowPageBreaks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Page Layout & Printing Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageBreakBelow", "ObjectName",
 CellID->10481],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PageBreakBelow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PageBreakBelow"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a page break should be made immediately below \
the cell if the notebook that contains the cell is printed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " specifies that a page break should be made if necessary. "
}], "Notes",
 CellID->19567],

Cell[TextData[{
 "A setting of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " specifies that a page break should always be made, while a setting of ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " specifies that it should never be made. "
}], "Notes",
 CellID->18493]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->625744311],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2413462],

Cell["Create a document and select the seventh cell in it:", "ExampleText",
 CellID->151053419],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<abcde\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], ",", 
     RowBox[{"ShowPageBreaks", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->317531434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149495162],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3W1zFeUZB/B0+r7DV+g34CMwbV/XmU77pp2p4BTQdpxO+wFax6naSu0U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   "], {{0, 0}, {458, 221}}, {0, 255}],
  ImageSize->{458 0.75, 221 0.75},
  PlotRange->{{0, 458}, {0, 221}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->34638624]
}, Open  ]],

Cell["Set a page break below that cell:", "ExampleText",
 CellID->800775401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"PageBreakBelow", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36655570],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3W1zVOUZB/B0+r7DV+g34CMwbV/XmU77pp2p4BRQO06nfW91nKpFai0q
QZQHpQEFHxCoiNgA8hCSgAkQkBAJtkl0CoIoUxgp0NOzObsnZzcJWXb3ipb8
fnOZua9z3+fEV/85s7Pk+v59v/nJfd9ta2sbTv/r/U5bW2m9ZMnvlVJKRdSN
m7eUUkq1sPJ0fW3z+0oppVpSNen6jb9CK6XUXVBTpmsCQBOWVD5rla4ALSRd
ASJIV4AI0hUggnQFiCBdASJIV4CGLViQtLWVa968qi3pCtASacAWSVeAlrij
dG2ryNeF50y0bQWTTwLMBfWnax6V+c/J7e23AOaOBt5dkztMV++uwBw0O++u
0hWYa+703TVf1PO5a81dAHNHY98ZqCcwhSowBxW/8lpUT7rW8zmqz1qBOc73
XQFapfjiOn9+1ZZ0BYggXQEiSFeACNIVIIJ0BYggXQEiSFeACNIVIIJ0BYgg
XQEiSFeAhplaCBDNX3EBiCBdASKYCQsQwUxYgAhmwgJEMBMWIIKZsAAt1MzU
wsRMWICZmAkL0CqmFgLMMukKEGG6dH3mmWceAaBR06XrsmXL7gWgUdOla0dH
x0oAGjVduj788MMPAtCo6dJ169at3/SHFgD/x3xnACCCdAWIIF0BGtM2lXxX
ugI0RroCREizdO/eNE7LdfmydAVogUlvrdIVoAWaSdfiJwn1/PXsKU8C3JUa
Ttc8KpPqIQVJ9R/Kvs0WwF2s+XfXxNRCgEm+kXdX6Qrc9Zp8d615SM1jp9wV
rcBc0Ey6Fh9Szy9q8f86wLdYFqrFr7zeabrW8zmqz1qBuaYl764A1Kh5ce3v
l64ALdA2lXxXugI0bLpoTaQrQBOmi9ZEugLEkK4AEaQrQATpChBBugJEkK4A
EaQrQATpCtCwBQuStrZyzZtXtSVdAVqi5t8TSFeAlpCuABHuKF2L/362ntkE
U54EmAvqT9c8KpPC3IGa9vZbAHNHA++uiZmwADOZnXdX6QrMNXf67pov6vnc
teYugLte8SuvRWbCArREA+laz+eoPmsF5qDii+v8+VVbvu8KEEG6AkSQrgAR
pCtABOkKEEG6AkSQrgARpCtABOkKEEG6AkSQrgARpCtAw8yEBYhmaiFABFML
ASKYWggQwdRCgAimFgJEMLUQIIKphQAt1MxMWFMLAWbk+64ArWImLMAsk64A
EaQrQATpChBBugJEkK4AEaQrQATpChBBugJEkK4AEaQrQMNMLQSI5q+4AESQ
rgARzIQFiGAmLEAEM2EBIpgJCxDBTFiAFmpmamFiJizATMyEBWgVUwsBZpl0
BYggXQEiSFeACNIVIIJ0BYggXQEiSFeACNIVIIJ0BYggXQEiSFeAhpkJCxDN
1EKACKYWAkQwtRAggqmFABFMLQSIYGohQARTCwFaqJmZsKYWAszI910BWsVM
WIBZJl0BIkhXgAjSFSCCdAWIIF0BIkhXgAjSFSCCdAWIIF0BIkhXgIaZWggQ
zV9xAYggXQEimAkLEMFMWIAIZsICRDATFiCCmbAALdTM1MLETFiAmZgJC9Aq
phYCzDLpChBBugJEkK4AEaQrQATpChBBugJEkK4AEaQrQATpChBBugJEkK4A
DTMTFiCaqYUAEUwtBIhgaiFABFMLASKYWggQwdRCgAimFgK0UDMzYU0tBJiR
77sCtIqZsACzTLoCRJguXRcsWNAGQKOmS9f169c/AkCjpkvXRx999GcANKqY
rr9+aPnw2X9s29H91PIOpZRSTdaN/9zo6j7929+tWPLQ02m6pnXmzDmllFJN
VjFdzwyOJsmtW7duKqWUaqb+e+tmMV0/OjVy48bNq9e+TuvaeJXXV9Of1/P2
6tXygfRifjhfF+uaVqvVfkvbO860F9ZsXvvTH2y654cb7/nR5Eqvp7vpmezG
r7++fvXq9TxdTxz/5KsrVy9e+uripS/Hf35VWX9Zu/6ieCA/n1+8Ur2r1Wq1
36q2kUzb/tMf33zu+eTlDcm6dVPUyxvS3fRMduOlL0q35Ona33/2s39dGhn7
fGT0/PfmzSvWyNj5kbEL5fVocX0hrcKxzyuLC/k6ayeuF85PeXjiyeOHs91s
UXtX9a5Wq9XW1ZZC7Pz4xezK+cr1SpW3zpfuqjzh46WLkp3vJFu3TFs730nP
ZPeOfvr56NjFPF2PHB06+8lnZz4ezeIrXWRVaccmrg9NnKksRsYPl88MVT1k
pNjWPLxmN22rD5R2i4dvv6vVarUztpXF2MTFoeq2tB4pnCk9YWjJomT7tuT1
V8v/HCtdZJW327elZ8ZvGRs6O/bx8Gd5unb3DA6c+uT4wHCWYOni2MBwsc0X
U108N+X1Y9UPOVb98Mm7x6rX2W7x8O13tVqtts72ePV6Up0r3pUuatM19UZh
XUnX7K4TJ4dPfvTPPF3TxZG+wd4PT2cJ1nN0sPvIYM/RibayOF1clxcfDvYc
OT3RHsnvOt2bni+0NZ8ATD6crburT3aXfmnVbv7kdKHVarX1t71HB9Pqqfzs
KV0fLF0fT7zscJ5p+ROGlixMtm9NtmwsVY1N65ON65K3Nqfp2pM988PBvmNn
83Q91HXqYNfAga6BLMHSxYFDA/u7TpTbQ1XXay7uH7944FB++MTE9a6BYpvf
uH+aw+X1oRP5vdnh5ne1Wq02S7DsSrqeuFK+Xq480/InnPnVvaVc3fBSsuHF
5JXVE9G6rj1Z+3zy0rNpwJ5ZfG/llhPdvYN7PziepevBrlN79vWnlWVU5wel
9Z4P+rI2v55X8XDlSl/Noqbt3NffWX1LZ+khfVM9vC87nO3m7XS72aOKv27y
vVqtVjvelq90lq9XVeF81RNK6dqxNlm9InlhRe2763NPJ8/+KVm7Ok3X/DkH
u07+bWd3lq4HDp3ctbvnvfd7s4xKF1ll7a73j7xXqt73dvem61K7+0jh8PhW
6Xrv+Mn8rqnbmsPFNn/g5N08e2+/W+cv0mq1c7PdNXF9ikzLdidn2pnFC5N1
q2/+ZXmeqdf/PLG+tuzJZNXKocULx+/t3bW7d9/+Y69t2VNO14Mnd+zseufd
7iyg0kVWNW1NVe8eztvC9cOT20LVtjUPrHN3/GLVb5/xF2m1Wu1MdTj/Wfrc
ddXKK08+kcXpv//4xJXxytrLjz+erHw+PZPf27m3b826HZV0PbV12+FtO7oj
Ksu91p5s7b1KKXWbGr5/UdLefvGxxy4//ofJlV5PVrUPL12YHX57e/fuv/ev
eG5LOV0PfPTG6wfferNLKaVUTfU98PPkxVXJqrTap6j29uTFNUcf/GV2+M03
ut7d2ffU8o4sXfftG9jwSuemjr1KKaVq6oU1m/sX/+LcA/edXbpocp27f1Hf
0kXpmezwxr/ueXtrt3RVSqnWlnRVSqmIkq5KKRVRNem6/8BAx4bOVzftVUop
1Uxt2rhn+7aJdB0d+2L43IXhc+eVUko1WZ9++mWerkoppVpbabr+D4pgYp8=

   "], {{0, 0}, {458, 221}}, {0, 255}],
  ImageSize->{458 0.75, 221 0.75},
  PlotRange->{{0, 458}, {0, 221}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->138519318]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7670],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageBreakAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageBreakAbove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowPageBreaks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowPageBreaks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28596],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->19161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->116140478],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout",
 CellID->318704946]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageBreakBelow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 52.0191910}", "context" -> "System`", 
    "keywords" -> {"set page break", "page break", "pagination"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PageBreakBelow is an option for Cell which specifies whether a page \
break should be made immediately below the cell if the notebook that contains \
the cell is printed. ", "synonyms" -> {"page break below"}, "title" -> 
    "PageBreakBelow", "type" -> "Symbol", "uri" -> "ref/PageBreakBelow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4476, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->625744311]},
 "Notebook Image"->{
  Cell[5706, 195, 3697, 63, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->34638624],
  Cell[9742, 274, 3772, 65, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->138519318]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16606, 444},
 {"Notebook Image", 16747, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1910, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2533, 76, 52, 1, 70, "ObjectName",
 CellID->10481],
Cell[2588, 79, 681, 19, 70, "Usage",
 CellID->30614]
}, Open  ]],
Cell[CellGroupData[{
Cell[3306, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3784, 120, 245, 8, 70, "Notes",
 CellID->19567],
Cell[4032, 130, 407, 13, 70, "Notes",
 CellID->18493]
}, Closed]],
Cell[CellGroupData[{
Cell[4476, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->625744311],
Cell[CellGroupData[{
Cell[4861, 162, 146, 5, 70, "ExampleSection",
 CellID->2413462],
Cell[5010, 169, 95, 1, 70, "ExampleText",
 CellID->151053419],
Cell[5108, 172, 411, 13, 70, "Input",
 CellID->317531434],
Cell[CellGroupData[{
Cell[5544, 189, 159, 4, 70, "Input",
 CellID->149495162],
Cell[5706, 195, 3697, 63, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->34638624]
}, Open  ]],
Cell[9418, 261, 76, 1, 70, "ExampleText",
 CellID->800775401],
Cell[CellGroupData[{
Cell[9519, 266, 220, 6, 70, "Input",
 CellID->36655570],
Cell[9742, 274, 3772, 65, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->138519318]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13575, 346, 310, 9, 70, "SeeAlsoSection",
 CellID->7670],
Cell[13888, 357, 475, 17, 70, "SeeAlso",
 CellID->20538]
}, Open  ]],
Cell[CellGroupData[{
Cell[14400, 379, 314, 9, 70, "TutorialsSection",
 CellID->28596],
Cell[14717, 390, 143, 3, 70, "Tutorials",
 CellID->19161]
}, Open  ]],
Cell[CellGroupData[{
Cell[14897, 398, 319, 9, 70, "MoreAboutSection",
 CellID->116140478],
Cell[15219, 409, 170, 3, 70, "MoreAbout",
 CellID->318704946]
}, Open  ]],
Cell[15404, 415, 27, 0, 70, "History"],
Cell[15434, 417, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

