(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11199,        374]
NotebookOptionsPosition[      8340,        283]
NotebookOutlinePosition[      9827,        325]
CellTagsIndexPosition[      9711,        319]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageHeaders" :> 
          Documentation`HelpLookup["paclet:ref/PageHeaders"], 
          "PageBreakBelow" :> 
          Documentation`HelpLookup["paclet:ref/PageBreakBelow"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PageHeaders\"\>", 
       2->"\<\"PageBreakBelow\"\>", 
       3->"\<\"CurrentValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Page Layout & Printing Control\"\>",
        2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageFooters", "ObjectName",
 CellID->32145],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PageFooters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PageFooters"]], "InlineFormula"],
     "\[LineSeparator]is an option for notebooks that specifies what should \
be inserted as the footer of each page of a notebook when it is printed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14878]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PageFooters", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["ll", "TI"], ",", " ", 
       StyleBox["lc", "TI"], ",", " ", 
       StyleBox["lr", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["rl", "TI"], ",", " ", 
       StyleBox["rc", "TI"], ",", " ", 
       StyleBox["rr", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies the left, center, and right footers for left pages and the left, \
center, and right footers for right pages."
}], "Notes",
 CellID->6923],

Cell[TextData[{
 "Individual footers can be strings or cell expressions, or the symbol ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->270945240],

Cell[TextData[{
 "Footers can also be specified using the dialog box accessed from the ",
 StyleBox["File \[FilledRightTriangle] Printing Settings \
\[FilledRightTriangle] Headers and Footers", "MenuName"],
 " menu item."
}], "Notes",
 CellID->23024]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->718291357],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->811082081],

Cell["Create a document with page footer settings:", "ExampleText",
 CellID->277575079],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "+", "y"}], "}"}], ",", 
     RowBox[{"PageFooters", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<a1\>\"", ",", "\"\<a2\>\"", ",", "\"\<a3\>\""}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"\"\<a4\>\"", ",", "\"\<a5\>\"", ",", "\"\<a6\>\""}], 
         "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706859407],

Cell["\<\
Here is how the bottom of a right-hand printed page will look:\
\>", "ExampleText",
 CellID->937642925],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\
eJztVjtuwkAQHbCdKFyBfJDIJWjyaaBKEdFHMiiSKaJEhIorcAIKilRcgANw
C1JEqZKOOzj7xjuwxkZxaEDKILFvfzNv5s0s4i4cRI9P4aDXDWutfvgS9bqv
teZz32x5JaLyFxHd1wjz2ExliKnTeaDJ5E1RUfGfoXn++w5BUVFxP0jfew9B
UVExjaXkcR4D1v/VPzB4yZFBMcDX334zSB99bndS5tEjvhvHyRcjD+8YvE3H
xa8rmZIpmZIpmZIpmZIVJ7viMaAoimg4HNJ0OuVzoMdnOWxnPPWp0WjQeDym
2WyGO2Waz+f2vmzz/XO+X8klwQnMYDAajWi5XN4WSVsClz1jx/MkhCRw8GG9
EXjAgQsxPjAWIwS1WCzWRqc2+jwmrNvtNiOMTHaZ6AtX4YjFEbciiJn7lLhj
Qd1CVG0+CAFhYSUC+44IOUaVbWTMJQIYx3+oRoWDcAnlDnik2kRuVwSiG6+Q
Iewl+EzrVX8hwp4QmSrvUoxrHk9WXSndKgJjLY3DFhf2OUiS1kAaCrpKjzhd
mE8AAdCd2IMohdRvOkwQYPXwLu0BPK7K6h7gI121i1Yt6wf5SQ35pO6ElCqg
MMsrAhZKsuUYpuSsW/nFo80pw4ZQIPnNof8mK5mSKZmSKdnhklHpB/HFN4Y=
\
\>"], "Graphics",
  ImageSize->{544., 59.5},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->20394310]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8692],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageHeaders",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageHeaders"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageBreakBelow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageBreakBelow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout",
 CellID->735687877],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->127989254]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageFooters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 53.3004738}", "context" -> "System`", 
    "keywords" -> {"footers", "page footers", "page numbering"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "PageFooters is an option for notebooks that specifies what should be \
inserted as the footer of each page of a notebook when it is printed.", 
    "synonyms" -> {"page footers"}, "title" -> "PageFooters", "type" -> 
    "Symbol", "uri" -> "ref/PageFooters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4393, 145, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->718291357]},
 "Notebook Image"->{
  Cell[5677, 193, 859, 17, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->20394310]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9445, 308},
 {"Notebook Image", 9586, 312}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1571, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2194, 65, 49, 1, 70, "ObjectName",
 CellID->32145],
Cell[2246, 68, 517, 14, 70, "Usage",
 CellID->14878]
}, Open  ]],
Cell[CellGroupData[{
Cell[2800, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3278, 104, 584, 18, 70, "Notes",
 CellID->6923],
Cell[3865, 124, 238, 8, 70, "Notes",
 CellID->270945240],
Cell[4106, 134, 250, 6, 70, "Notes",
 CellID->23024]
}, Closed]],
Cell[CellGroupData[{
Cell[4393, 145, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->718291357],
Cell[CellGroupData[{
Cell[4778, 159, 148, 5, 70, "ExampleSection",
 CellID->811082081],
Cell[4929, 166, 87, 1, 70, "ExampleText",
 CellID->277575079],
Cell[5019, 169, 539, 17, 70, "Input",
 CellID->706859407],
Cell[5561, 188, 113, 3, 70, "ExampleText",
 CellID->937642925],
Cell[5677, 193, 859, 17, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->20394310]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6585, 216, 310, 9, 70, "SeeAlsoSection",
 CellID->8692],
Cell[6898, 227, 722, 26, 70, "SeeAlso",
 CellID->19539]
}, Open  ]],
Cell[CellGroupData[{
Cell[7657, 258, 299, 8, 70, "MoreAboutSection"],
Cell[7959, 268, 170, 3, 70, "MoreAbout",
 CellID->735687877],
Cell[8132, 273, 134, 3, 70, "MoreAbout",
 CellID->127989254]
}, Open  ]],
Cell[8281, 279, 29, 0, 70, "History"],
Cell[8313, 281, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

