(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15942,        548]
NotebookOptionsPosition[     12281,        426]
NotebookOutlinePosition[     13653,        465]
CellTagsIndexPosition[     13568,        460]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"], 
          "Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreams"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Text and Font Options\"\>", 
       2->"\<\"Options for Notebooks\"\>", 3->"\<\"Files and Streams\"\>", 
       4->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TotalWidth" :> 
          Documentation`HelpLookup["paclet:ref/TotalWidth"], 
          "TextJustification" :> 
          Documentation`HelpLookup["paclet:ref/TextJustification"], 
          "AutoIndent" :> 
          Documentation`HelpLookup["paclet:ref/AutoIndent"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TotalWidth\"\>", 
       2->"\<\"TextJustification\"\>", 
       3->"\<\"AutoIndent\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageWidth", "ObjectName",
 CellID->7283],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["PageWidth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
     "\[LineSeparator]is an option for output streams and for cells which \
specifies how wide each line of text should be allowed to be. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings for output streams are: ", "Notes",
 CellID->17553],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "an infinite width (no linebreaking) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell["explicit width in characters ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->24705],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    RowBox[{"PageWidth", "->", 
     StyleBox["val", "TI"]}]}], "]"}]], "InlineFormula"],
 " resets the line width allowed for an open stream. "
}], "Notes",
 CellID->27091],

Cell["Possible settings for cells are: ", "Notes",
 CellID->1259],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "WindowWidth", Cell[
    "the width of the window on the screen ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "PaperWidth", Cell[
    "the width of the page as it would be printed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell["\<\
explicit width given in printer\[CloseCurlyQuote]s points \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->25386],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PageWidth", "->", "WindowWidth"}]], "InlineFormula"],
 " allows each line to use the full width of the displayed window, taking \
into account settings for ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31687]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->351176004],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->124936307],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " to be 60 characters for a stream: "
}], "ExampleText",
 CellID->280573051],

Cell[BoxData[
 RowBox[{
  RowBox[{"file1", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179329578],

Cell[BoxData[{
 RowBox[{
  RowBox[{"stream", "=", 
   RowBox[{"OpenWrite", "[", 
    RowBox[{"file1", ",", 
     RowBox[{"PageWidth", "\[Rule]", "60"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stream", ",", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}], "^", "5"}], "]"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Close", "[", "stream", "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->694287890],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " to be 30 characters for a stream: "
}], "ExampleText",
 CellID->377445682],

Cell[BoxData[
 RowBox[{
  RowBox[{"file2", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test2\>\""}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54838315],

Cell[BoxData[{
 RowBox[{
  RowBox[{"stream", "=", 
   RowBox[{"OpenWrite", "[", 
    RowBox[{"file2", ",", 
     RowBox[{"PageWidth", "\[Rule]", "30"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stream", ",", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}], "^", "5"}], "]"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Close", "[", "stream", "]"}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->205315132],

Cell["Compare the two resulting files: ", "ExampleText",
 CellID->36717047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file1", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->308122416],

Cell["x^5 + 5*x^4*y + 10*x^3*y^2 + 10*x^2*y^3 + 5*x*y^4 + y^5", "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->1347149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file2", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->76020921],

Cell["\<\
x^5 + 5*x^4*y + 10*x^3*y^2 + 
 10*x^2*y^3 + 5*x*y^4 + y^5\
\>", "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->593093227]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13388],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TotalWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TotalWidth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoIndent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoIndent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4629],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->42],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreams"]], "Tutorials",
 CellID->478647659],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->28317]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->170696039],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->340038676]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageWidth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 5, 57.5974588}", "context" -> "System`", 
    "keywords" -> {
     "breaking", "line length", "lines", "termcap", "width", "window", 
      "window size", "wrapping"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "PageWidth is an option for output streams and for cells which specifies \
how wide each line of text should be allowed to be. ", 
    "synonyms" -> {"page width"}, "title" -> "PageWidth", "type" -> "Symbol", 
    "uri" -> "ref/PageWidth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6606, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->351176004]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13425, 453}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2518, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3141, 87, 46, 1, 70, "ObjectName",
 CellID->7283],
Cell[3190, 90, 500, 14, 70, "Usage",
 CellID->8160]
}, Open  ]],
Cell[CellGroupData[{
Cell[3727, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4205, 126, 75, 1, 70, "Notes",
 CellID->17553],
Cell[4283, 129, 695, 17, 70, "2ColumnTableMod",
 CellID->24705],
Cell[4981, 148, 361, 12, 70, "Notes",
 CellID->27091],
Cell[5345, 162, 65, 1, 70, "Notes",
 CellID->1259],
Cell[5413, 165, 793, 18, 70, "2ColumnTableMod",
 CellID->25386],
Cell[6209, 185, 360, 11, 70, "Notes",
 CellID->31687]
}, Closed]],
Cell[CellGroupData[{
Cell[6606, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->351176004],
Cell[CellGroupData[{
Cell[6991, 215, 148, 5, 70, "ExampleSection",
 CellID->124936307],
Cell[7142, 222, 227, 8, 70, "ExampleText",
 CellID->280573051],
Cell[7372, 232, 166, 5, 70, "Input",
 CellID->179329578],
Cell[7541, 239, 497, 17, 70, "Input",
 CellID->694287890],
Cell[8041, 258, 227, 8, 70, "ExampleText",
 CellID->377445682],
Cell[8271, 268, 165, 5, 70, "Input",
 CellID->54838315],
Cell[8439, 275, 497, 17, 70, "Input",
 CellID->205315132],
Cell[8939, 294, 75, 1, 70, "ExampleText",
 CellID->36717047],
Cell[CellGroupData[{
Cell[9039, 299, 109, 3, 70, "Input",
 CellID->308122416],
Cell[9151, 304, 134, 2, 70, "Print",
 CellID->1347149]
}, Open  ]],
Cell[CellGroupData[{
Cell[9322, 311, 108, 3, 70, "Input",
 CellID->76020921],
Cell[9433, 316, 147, 5, 70, "Print",
 CellID->593093227]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9641, 328, 311, 9, 70, "SeeAlsoSection",
 CellID->13388],
Cell[9955, 339, 722, 26, 70, "SeeAlso",
 CellID->25452]
}, Open  ]],
Cell[CellGroupData[{
Cell[10714, 370, 313, 9, 70, "TutorialsSection",
 CellID->4629],
Cell[11030, 381, 147, 3, 70, "Tutorials",
 CellID->42],
Cell[11180, 386, 155, 3, 70, "Tutorials",
 CellID->232099468],
Cell[11338, 391, 147, 3, 70, "Tutorials",
 CellID->478647659],
Cell[11488, 396, 191, 4, 70, "Tutorials",
 CellID->28317]
}, Open  ]],
Cell[CellGroupData[{
Cell[11716, 405, 319, 9, 70, "MoreAboutSection",
 CellID->170696039],
Cell[12038, 416, 148, 3, 70, "MoreAbout",
 CellID->340038676]
}, Open  ]],
Cell[12201, 422, 50, 0, 70, "History"],
Cell[12254, 424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

