(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56571,       1912]
NotebookOptionsPosition[     49012,       1651]
NotebookOutlinePosition[     50464,       1690]
CellTagsIndexPosition[     50378,       1685]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Deploy" :> Documentation`HelpLookup["paclet:ref/Deploy"], 
          "Editable" :> Documentation`HelpLookup["paclet:ref/Editable"], 
          "Selectable" :> Documentation`HelpLookup["paclet:ref/Selectable"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"], "Labeled" :> 
          Documentation`HelpLookup["paclet:ref/Labeled"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Deploy\"\>", 2->"\<\"Editable\"\>", 
       3->"\<\"Selectable\"\>", 4->"\<\"Style\"\>", 5->"\<\"Pane\"\>", 
       6->"\<\"Labeled\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 
       3->"\<\"Document Generation\"\>", 4->"\<\"Palettes\"\>", 
       5->"\<\"Stand-Alone Interfaces\"\>", 
       6->"\<\"User Interface Structuring & Layout\"\>", 
       7->"\<\"Viewers and Annotation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Panel", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Panel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Panel"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays as a panel containing ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Panel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Panel"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["title", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the panel the specified title. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Panel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Panel"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["title", "TI"], ",", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]places ",
     Cell[BoxData[
      StyleBox["title", "TI"]], "InlineFormula"],
     " at a position specified by ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Panel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Panel"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["title", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["title", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pos", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]places ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["title", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Panel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Panel"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]displays an empty panel. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"], "[", 
   RowBox[{"Panel", "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 " produces a deployed version, in which elements such as sliders and buttons \
are active, but general editing and selection is disabled. "
}], "Notes",
 CellID->27918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " by default displays ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<Panel\>\""], "InlineFormula"],
 " style, which typically uses the system panel font. "
}], "Notes",
 CellID->9625],

Cell[TextData[{
 "Possible forms for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pos", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->21219],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["side", "TI"], Cell[
    "centered on the specified side ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["side", "TI"], ",", 
      StyleBox["align", "TI"]}], "}"}], Cell[
    "on the specified side with the specified alignment ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->17584],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["side", "TI"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18174],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["align", "TI"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10984],

Cell["The following options can be given: ", "Notes",
 CellID->10459],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[
    "how to align elements in the panel ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the panel", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the panel is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins inside the frame of the panel ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed panel ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed panel ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for the tab area", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->13149],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<Panel\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<PanelLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467515890],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->512870264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"x", "+", "y", "+", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201264523],

Cell[BoxData[
 PanelBox[
  RowBox[{"x", "+", "y", "+", "z"}]]], "Output",
 ImageSize->{64, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17440579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"Slider", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288119007],

Cell[BoxData[
 PanelBox[
  SliderBox[0.542]]], "Output",
 ImageSize->{226, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406027008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318314721],

Cell["A panel with a title:", "ExampleText",
 CellID->42272629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", "\"\<a title\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125793643],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     ItemBox[
      InterpretationBox[
       StyleBox["\<\"a title\"\>", "Panel",
        StripOnInput->False,
        Background->None],
       "Labeled",
       Editable->True],
      Alignment->{Left, Inherited}]},
    {
     TagBox[
      InterpretationBox[
       PanelBox[
        SliderBox[0.47800000000000004`]],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"]}
   },
   BaselinePosition->{2, 1},
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Panel[
    Slider[]], {
    Style["a title", "Panel", Background -> None]}, {{Top, Left}}]]], "Output",\

 ImageSize->{226, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51375271]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25917],

Cell["Put any expression in a panel:", "ExampleText",
 CellID->304436036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->784327229],

Cell[BoxData[
 PanelBox[
  GraphicsBox[{{}, {}, {
     {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwt13k4lN3/B3BLRCTuKcoy90QiCW2KyudoU7RRVJIKD0qWiuJJWdKCR0nK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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
   Axes->True,
   Method->{},
   PlotRange->{{0, 10}, {-0.999999368003951, 0.999999575573002}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]]], "Output",
 ImageSize->{206, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2815764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65899841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Panel", "[", 
    RowBox[{"i", "!"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->553385772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PanelBox["1"], ",", 
   PanelBox["2"], ",", 
   PanelBox["6"], ",", 
   PanelBox["24"], ",", 
   PanelBox["120"], ",", 
   PanelBox["720"], ",", 
   PanelBox["5040"], ",", 
   PanelBox["40320"], ",", 
   PanelBox["362880"], ",", 
   PanelBox["3628800"]}], "}"}]], "Output",
 ImageSize->{544, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301502416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495498716],

Cell["A panel with titles on several sides:", "ExampleText",
 CellID->5757998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Top", ",", "Bottom", ",", "Left", ",", "Right"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->291259431],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"", 
     InterpretationBox[
      StyleBox["x", "Panel",
       StripOnInput->False,
       Background->None],
      "Labeled",
      Editable->True], ""},
    {
     InterpretationBox[
      StyleBox["z", "Panel",
       StripOnInput->False,
       Background->None],
      "Labeled",
      Editable->True], 
     TagBox[
      InterpretationBox[
       PanelBox[
        SliderBox[0.5]],
       "Labeled",
       Editable->True],
      "SkipImageSizeLevel"], 
     InterpretationBox[
      StyleBox["w", "Panel",
       StripOnInput->False,
       Background->None],
      "Labeled",
      Editable->True]},
    {"", 
     InterpretationBox[
      StyleBox["y", "Panel",
       StripOnInput->False,
       Background->None],
      "Labeled",
      Editable->True], ""}
   },
   BaselinePosition->{2, 2},
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Panel[
    Slider[]], {
    Style[$CellContext`x, "Panel", Background -> None], 
    Style[$CellContext`y, "Panel", Background -> None], 
    Style[$CellContext`z, "Panel", Background -> None], 
    Style[$CellContext`w, "Panel", Background -> None]}, {
   Top, Bottom, Left, Right}]]], "Output",
 ImageSize->{255, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95118422]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->68406580],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->896818357],

Cell["Align expressions within panel:", "ExampleText",
 CellID->11517942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Panel", "[", 
     RowBox[{
      RowBox[{"x", "+", "y", "+", "z"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"100", ",", "50"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92528656],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Left, Top},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Center, Top},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Right, Top},
      ImageSize->{100, 50}]},
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Left, Center},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Center, Center},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Right, Center},
      ImageSize->{100, 50}]},
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Left, Bottom},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Center, Bottom},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Right, Bottom},
      ImageSize->{100, 50}]}
   }],
  "Grid"]], "Output",
 ImageSize->{320, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38632786]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->101137848],

Cell["Align with surrounding text:", "ExampleText",
 CellID->36773253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Panel", "[", 
      RowBox[{
       RowBox[{"x", "+", "y", "+", "z"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95619783],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    BaselinePosition->Top], "xxx", 
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    BaselinePosition->Center], "xxx", 
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    BaselinePosition->Bottom]}],
  Row[{
    Panel[$CellContext`x + $CellContext`y + $CellContext`z, BaselinePosition -> 
     Top], 
    Panel[$CellContext`x + $CellContext`y + $CellContext`z, BaselinePosition -> 
     Center], 
    Panel[$CellContext`x + $CellContext`y + $CellContext`z, BaselinePosition -> 
     Bottom]}, "xxx"]]], "Output",
 ImageSize->{238, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190166802]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->81661325],

Cell["Add margins within the panel:", "ExampleText",
 CellID->180505377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Panel", "[", 
    RowBox[{
     RowBox[{"x", "+", "y", "+", "z"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495219569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    FrameMargins->0], ",", 
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    FrameMargins->10], ",", 
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    FrameMargins->30]}], "}"}]], "Output",
 ImageSize->{253, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183746880]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->303685270],

Cell["Add margins outside of the panel:", "ExampleText",
 CellID->742898549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Panel", "[", 
    RowBox[{
     RowBox[{"x", "+", "y", "+", "z"}], ",", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->637675346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    ImageMargins->0], ",", 
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    ImageMargins->10], ",", 
   PanelBox[
    RowBox[{"x", "+", "y", "+", "z"}],
    ImageMargins->30]}], "}"}]], "Output",
 ImageSize->{301, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529287691]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->216722608],

Cell["Specify the overall image size:", "ExampleText",
 CellID->114789737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Panel", "[", 
     RowBox[{
      RowBox[{"x", "+", "y", "+", "z"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "40", ",", "50"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13321135],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{50, 30}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{70, 30}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{100, 30}]},
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{50, 40}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{70, 40}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{100, 40}]},
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{50, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{70, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      ImageSize->{100, 50}]}
   }],
  "Grid"]], "Output",
 ImageSize->{240, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108254424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126528145],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " to force line breaking at a certain width:"
}], "ExampleText",
 CellID->186803482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "10"}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"200", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692631116],

Cell[BoxData[
 PanelBox[
  RowBox[{
   SuperscriptBox["x", "10"], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "9"], " ", "y"}], "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["x", "8"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "7"], " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"210", " ", 
    SuperscriptBox["x", "6"], " ", 
    SuperscriptBox["y", "4"]}], "+", 
   RowBox[{"252", " ", 
    SuperscriptBox["x", "5"], " ", 
    SuperscriptBox["y", "5"]}], "+", 
   RowBox[{"210", " ", 
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "6"]}], "+", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox["y", "7"]}], "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"10", " ", "x", " ", 
    SuperscriptBox["y", "9"]}], "+", 
   SuperscriptBox["y", "10"]}],
  ImageSize->{200, Automatic}]], "Output",
 ImageSize->{204, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114531611]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11725573],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " construct uses ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->159415699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669850533],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$94$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$94$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422745542]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", 
          RowBox[{"Manipulator", "[", 
           RowBox[{"Dynamic", "[", "y", "]"}], "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74939528],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      InterpretationBox[
       RowBox[{"\<\"x\"\>", "\[InvisibleSpace]", 
        TagBox[
         PaneBox[
          
          DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
           Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
           StyleBox[
            
            DynamicBox[FEPrivate`FrontEndResource[
             "FEExpressions", "Manipulator04"][
              Dynamic[$CellContext`y], 
              Dynamic[$CellContext`y], {0, 1}, Medium, Small, Automatic, True,
               Automatic, False, True, True, All, False, {}, 
              Dynamic[Typeset`open$$], 
              Dynamic[Typeset`paused$$], 
              Dynamic[Typeset`rate$$], 
              Dynamic[Typeset`dir$$]],
             ImageSizeCache->{212., {9., 14.}}],
            DynamicUpdating->True],
           DynamicModuleValues:>{}],
          BaselinePosition->Baseline,
          ImageMargins->0],
         Manipulate`InterpretManipulator[
          Dynamic[$CellContext`y], {0, 1}, {}]]}],
       Row[{"x", 
         Manipulator[
          Dynamic[$CellContext`y]]}]]},
     {
      DynamicBox[ToBoxes[$CellContext`y, StandardForm],
       ImageSizeCache->{10., {0., 8.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}}],
   "Column"],
  FrameMargins->15]], "Output",
 ImageSize->{258, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29534863]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Panel", ",", 
   RowBox[{"Framed", "[", "x", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14427299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox["x",
    StripOnInput->False], ",", 
   PanelBox[
    FrameBox["x",
     StripOnInput->False]], ",", 
   PanelBox[
    PanelBox[
     FrameBox["x",
      StripOnInput->False]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      FrameBox["x",
       StripOnInput->False]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       FrameBox["x",
        StripOnInput->False]]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       PanelBox[
        FrameBox["x",
         StripOnInput->False]]]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       PanelBox[
        PanelBox[
         FrameBox["x",
          StripOnInput->False]]]]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       PanelBox[
        PanelBox[
         PanelBox[
          FrameBox["x",
           StripOnInput->False]]]]]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       PanelBox[
        PanelBox[
         PanelBox[
          PanelBox[
           FrameBox["x",
            StripOnInput->False]]]]]]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       PanelBox[
        PanelBox[
         PanelBox[
          PanelBox[
           PanelBox[
            FrameBox["x",
             StripOnInput->False]]]]]]]]]], ",", 
   PanelBox[
    PanelBox[
     PanelBox[
      PanelBox[
       PanelBox[
        PanelBox[
         PanelBox[
          PanelBox[
           PanelBox[
            PanelBox[
             FrameBox["x",
              StripOnInput->False]]]]]]]]]]]}], "}"}]], "Output",
 ImageSize->{551, 588},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72798185]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1537],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Editable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Editable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5695],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->813600194],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->491883293],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->39041667],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->783259752],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->55050289],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->21309769],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->788618531],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->115078766]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Panel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 6, 0.2381514}", "context" -> "System`", 
    "keywords" -> {"background panel", "display panel"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Panel[expr] displays as a panel containing expr. Panel[expr, title] \
gives the panel the specified title. Panel[expr, title, pos] places title at \
a position specified by pos. Panel[expr, {title_1, title_2, ...}, {pos_1, \
...}] places title_i at position pos_i. Panel[] displays an empty panel. ", 
    "synonyms" -> {}, "title" -> "Panel", "type" -> "Symbol", "uri" -> 
    "ref/Panel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15060, 466, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->467515890]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50234, 1678}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3147, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3770, 95, 1570, 37, 70, "ObjectNameGrid"],
Cell[5343, 134, 2730, 90, 70, "Usage",
 CellID->21244]
}, Open  ]],
Cell[CellGroupData[{
Cell[8110, 229, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8588, 246, 388, 11, 70, "Notes",
 CellID->27918],
Cell[8979, 259, 357, 12, 70, "Notes",
 CellID->9625],
Cell[9339, 273, 184, 8, 70, "Notes",
 CellID->21219],
Cell[9526, 283, 737, 19, 70, "2ColumnTableMod",
 CellID->17584],
Cell[10266, 304, 617, 26, 70, "Notes",
 CellID->18174],
Cell[10886, 332, 740, 31, 70, "Notes",
 CellID->10984],
Cell[11629, 365, 69, 1, 70, "Notes",
 CellID->10459],
Cell[11701, 368, 2778, 74, 70, "3ColumnTableMod",
 CellID->13149],
Cell[14482, 444, 541, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[15060, 466, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467515890],
Cell[CellGroupData[{
Cell[15445, 480, 148, 5, 70, "ExampleSection",
 CellID->512870264],
Cell[CellGroupData[{
Cell[15618, 489, 134, 4, 28, "Input",
 CellID->201264523],
Cell[15755, 495, 202, 7, 58, "Output",
 CellID->17440579]
}, Open  ]],
Cell[CellGroupData[{
Cell[15994, 507, 129, 4, 28, "Input",
 CellID->288119007],
Cell[16126, 513, 187, 7, 68, "Output",
 CellID->406027008]
}, Open  ]],
Cell[16328, 523, 125, 3, 70, "ExampleDelimiter",
 CellID->318314721],
Cell[16456, 528, 63, 1, 70, "ExampleText",
 CellID->42272629],
Cell[CellGroupData[{
Cell[16544, 533, 167, 5, 70, "Input",
 CellID->125793643],
Cell[16714, 540, 977, 36, 70, "Output",
 CellID->51375271]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17740, 582, 216, 7, 70, "ExampleSection",
 CellID->25917],
Cell[17959, 591, 73, 1, 70, "ExampleText",
 CellID->304436036],
Cell[CellGroupData[{
Cell[18057, 596, 250, 8, 70, "Input",
 CellID->784327229],
Cell[18310, 606, 6775, 120, 70, "Output",
 CellID->2815764]
}, Open  ]],
Cell[25100, 729, 124, 3, 70, "ExampleDelimiter",
 CellID->65899841],
Cell[CellGroupData[{
Cell[25249, 736, 227, 8, 70, "Input",
 CellID->553385772],
Cell[25479, 746, 447, 17, 70, "Output",
 CellID->301502416]
}, Open  ]],
Cell[25941, 766, 125, 3, 70, "ExampleDelimiter",
 CellID->495498716],
Cell[26069, 771, 78, 1, 70, "ExampleText",
 CellID->5757998],
Cell[CellGroupData[{
Cell[26172, 776, 318, 10, 70, "Input",
 CellID->291259431],
Cell[26493, 788, 1546, 56, 70, "Output",
 CellID->95118422]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28088, 850, 221, 7, 70, "ExampleSection",
 CellID->68406580],
Cell[CellGroupData[{
Cell[28334, 861, 230, 7, 70, "ExampleSubsection",
 CellID->896818357],
Cell[28567, 870, 73, 1, 70, "ExampleText",
 CellID->11517942],
Cell[CellGroupData[{
Cell[28665, 875, 730, 23, 70, "Input",
 CellID->92528656],
Cell[29398, 900, 1279, 47, 70, "Output",
 CellID->38632786]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30726, 953, 237, 7, 70, "ExampleSubsection",
 CellID->101137848],
Cell[30966, 962, 70, 1, 70, "ExampleText",
 CellID->36773253],
Cell[CellGroupData[{
Cell[31061, 967, 475, 15, 70, "Input",
 CellID->95619783],
Cell[31539, 984, 752, 23, 70, "Output",
 CellID->190166802]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32340, 1013, 232, 7, 70, "ExampleSubsection",
 CellID->81661325],
Cell[32575, 1022, 72, 1, 70, "ExampleText",
 CellID->180505377],
Cell[CellGroupData[{
Cell[32672, 1027, 375, 12, 70, "Input",
 CellID->495219569],
Cell[33050, 1041, 426, 16, 70, "Output",
 CellID->183746880]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33525, 1063, 233, 7, 70, "ExampleSubsection",
 CellID->303685270],
Cell[33761, 1072, 76, 1, 70, "ExampleText",
 CellID->742898549],
Cell[CellGroupData[{
Cell[33862, 1077, 375, 12, 70, "Input",
 CellID->637675346],
Cell[34240, 1091, 426, 16, 70, "Output",
 CellID->529287691]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34715, 1113, 230, 7, 70, "ExampleSubsection",
 CellID->216722608],
Cell[34948, 1122, 74, 1, 70, "ExampleText",
 CellID->114789737],
Cell[CellGroupData[{
Cell[35047, 1127, 602, 20, 70, "Input",
 CellID->13321135],
Cell[35652, 1149, 977, 38, 70, "Output",
 CellID->108254424]
}, Open  ]],
Cell[36644, 1190, 125, 3, 70, "ExampleDelimiter",
 CellID->126528145],
Cell[36772, 1195, 231, 8, 70, "ExampleText",
 CellID->186803482],
Cell[CellGroupData[{
Cell[37028, 1207, 336, 11, 70, "Input",
 CellID->692631116],
Cell[37367, 1220, 1103, 35, 70, "Output",
 CellID->114531611]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[38531, 1262, 236, 7, 70, "ExampleSection",
 CellID->11725573],
Cell[38770, 1271, 325, 13, 70, "ExampleText",
 CellID->159415699],
Cell[CellGroupData[{
Cell[39120, 1288, 188, 6, 70, "Input",
 CellID->669850533],
Cell[39311, 1296, 1556, 35, 70, "Output",
 CellID->422745542]
}, Open  ]],
Cell[CellGroupData[{
Cell[40904, 1336, 552, 16, 70, "Input",
 CellID->74939528],
Cell[41459, 1354, 1484, 43, 70, "Output",
 CellID->29534863]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42992, 1403, 224, 7, 70, "ExampleSection",
 CellID->20877],
Cell[CellGroupData[{
Cell[43241, 1414, 175, 5, 70, "Input",
 CellID->14427299],
Cell[43419, 1421, 1768, 84, 70, "Output",
 CellID->72798185]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45248, 1512, 310, 9, 70, "SeeAlsoSection",
 CellID->1537],
Cell[45561, 1523, 1415, 53, 70, "SeeAlso",
 CellID->26814]
}, Open  ]],
Cell[CellGroupData[{
Cell[47013, 1581, 313, 9, 70, "TutorialsSection",
 CellID->5695],
Cell[47329, 1592, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[47512, 1600, 319, 9, 70, "MoreAboutSection",
 CellID->813600194],
Cell[47834, 1611, 158, 3, 70, "MoreAbout",
 CellID->491883293],
Cell[47995, 1616, 167, 3, 70, "MoreAbout",
 CellID->39041667],
Cell[48165, 1621, 149, 3, 70, "MoreAbout",
 CellID->783259752],
Cell[48317, 1626, 127, 3, 70, "MoreAbout",
 CellID->55050289],
Cell[48447, 1631, 153, 3, 70, "MoreAbout",
 CellID->21309769],
Cell[48603, 1636, 180, 3, 70, "MoreAbout",
 CellID->788618531],
Cell[48786, 1641, 154, 3, 70, "MoreAbout",
 CellID->115078766]
}, Open  ]],
Cell[48955, 1647, 27, 0, 70, "History"],
Cell[48985, 1649, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

