(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40928,       1357]
NotebookOptionsPosition[     33969,       1113]
NotebookOutlinePosition[     35232,       1150]
CellTagsIndexPosition[     35146,       1145]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WhittakerW" :> 
          Documentation`HelpLookup["paclet:ref/WhittakerW"], 
          "HypergeometricU" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricU"], 
          "Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"], 
          "HermiteH" :> Documentation`HelpLookup["paclet:ref/HermiteH"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"WhittakerW\"\>", 
       2->"\<\"HypergeometricU\"\>", 3->"\<\"Hypergeometric1F1\"\>", 
       4->"\<\"HermiteH\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/HypergeometricFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hypergeometric Functions\"\>", 
       2->"\<\"New in 6.0: Mathematical Functions\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ParabolicCylinderD", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ParabolicCylinderD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ParabolicCylinderD"], "[", 
       RowBox[{
        StyleBox["\[Nu]", "TR"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the parabolic cylinder function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["D", "\[Nu]"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", "\[Nu]"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the Weber differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Nu]", "+", 
        FractionBox["1", "2"], "-", 
        RowBox[{
         FractionBox["1", "4"], 
         SuperscriptBox["z", "2"]}]}], ")"}], "y"}]}], "\[LongEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29256],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ParabolicCylinderD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->15176927],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParabolicCylinderD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParabolicCylinderD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParabolicCylinderD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParabolicCylinderD"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19692]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->218875906],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->339494391],

Cell["Evaluate numerically:", "ExampleText",
 CellID->93627584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParabolicCylinderD", "[", 
  RowBox[{"0", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142257040],

Cell[BoxData["0.569782824730923`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408517552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142934889],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     TagBox["D",
      ParabolicCylinderD], "5"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->359040548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ParabolicCylinderD", "[", 
    RowBox[{"5", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75937857],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WkmoHFUUrXR3VQ+/f/f/JmrMoBGjxiHz4AASpyQOiLgwLoKLGIQE1EiM
G93oRje60Y0BMQsHcIKIoggKYkAMiIIoiAqiIHGhCIqLgNDe9+5979w6v/5X
RJukf72q9+65w7n3DdW37D28/+579x4+sG/vql2H9t6//8C+B1btPHhIbrUX
FUXxlvy/Z2kh1xO5iv/fmkzk757w3Q7t+Cl2x7tXxrsnT/529LlPvv/+1+Ls
xl5XhO/yl1/+OLD/mHTcd9drcl2sXKDvo4+89/5738rlG8e+fPKJ47FvS7re
EftcHr67IuOO2186depPacn3zTcele9iRaPUMKIl0O34NEsvls/bu2iLcDEs
XLZi+523v3r8sQ/mH3VZvPvZpz8evO/NeJl8I4IWHhU0Kwlz2QIY4sBvvv45
XHZi++GH3j3+4XdpFPy0LT4VP9126/PRrbH94gufHXnmRBPGKLZF9Jdf/BQu
dzgpsF6lnPj4hwcPv90kZToqJqh37nlZNfVyoGtJ2i1J/rLn7Ua5qr1q4+VK
+H///VS4rKi9OPhEFClKic0kfURuMY5qCCnFXuksegQGXR+fbk2+kJGRbrGt
fcPlaVEbjbaQSSjF+g6jMlmutNQbXv6rr3z+9FMfQb5wXRif5ZfyULqA3S2L
b/RFlWMgH+3pZcPTXcJS2aK4OkQvjOWsfx4lH7XTY8DLXWLFbBydNZeWhE2C
14wiwZSQ6i31uaJsoSj0YlsqjXALKLktH2VGI4rLG32+47pnVbXiWoeG/FA0
6SIdw+WMfAWhcXQpRBA6gE0j8ohiiGKiHmMgNv3YFopIIiSMUA+KjmovwkQk
2zM1qedOm6R6LGjUJw4P5KuT7DHuFbkNnQKwInJ1U9YBcTPFa0CsnnEaZKRO
ZmJitqs2iqPTAOOA0QOK3IzlSRzdyezK8pWLkA+7vHyhshAa8pX/4XKcmKEh
iVJi1NqKAs5hruH5QJE2JUmW4ezniNRRhhcFfAYPJZvgRZ0Vtl91xNhyjUOC
5CnSR21CBqvv0E44mKM61AZO8MU0aTGiSLadZV4+RnTILm8H7g6JraPGCCOL
W5nNsF3nIvBEkTbGu5qB4XKa8mdEozpOkxCpIWVDaZ651kmXhJW0hXTk8Kgx
qlrDIB3xKcm/3gboOE15O2qMqTIfKPPP/h4FMZim/FQU1FtFQcUZmmcq8phK
3xDv5npr0pCN0xSn5GdfMQfkh5LGACmMHBOiIoCrpctBzcopilZFFl/tLMGc
MCIeTjfGVDmCaCBaFclTlPXkxRnKq+aYan+gQPeKbPMoyLMZ0q0eU52rIB3a
VBQZL70+L/rcGxKPqyTVqu+APNs1bTTO68jPs5R7Q2pXSZuadPCDV1hXOxTM
ALOO9UBhzlgQ5DNw0QcK2ooS7qZVSaht5yR/6+4o3m9bdUVdBmcUVRxRsw11
pEtsGpm88wlXp764Zuog74o568oVFLmSng+IneolXt9r4qX+wa6e4xm8Dbnn
NWoWNr2Lwl+9ZfN3nGfz+mEha8KuLnRotgIMa2Z9KFLe68iCHvWf+RfW/H0s
llMsqkYrEHueN7uJKzUrsG5SK1AT/h8rlqXIG+Nj/c/rCTBCteesleSsaY98
VO2xaxiZ3Av+Q615P0z7XceA5moQdm6+WsDXPYrFiOSf/w+s6E6Q2+HvihRv
VxvgaWBzDquu4YTIexozjOoK9o9N7mrC1/S8aGK5JZ4I8T4ztuv7mlpFMFTd
/2Al2Ld+WkfXJJ1N6lKKD+9leuRPbSM3+uSr7RFFuSOEksCIvQJ0FskdEG7G
sZmwl+Ju6/g+8UJxYmaV4nHJbPGMkDgs6JabxbxayRg2J/RIZp8yZzs4bqd/
oZItCV9dMUwEC6BQV2YZKS5hs7eSGNHMVtGgphH698m750Y/imTpL/9E1Yje
zscIxpWQVa+n7JsTM653nIPc5hzi51XiuV8nVvn5ZL79fJZja6kecYLPlvJO
w5g9bpLX17ZQTDwjbhNx4iZxYagWXInZEvXepkb7UVE5Kv3Uv3aCghWQRh2Z
GnMsZIP4S5QU5/D5reoRT4NcLWzOARllbNHn4DfnlFYMyQhRJThktUNhTmKf
kVFsTufZjSvEGRNkjZimFddQ4INmpguK5Zo+x/onVTeVLjcl1YINFzjp9eoR
esdRRTHnTEsrAarU6TTeS+Xah3bW2aR2iReKgnqyhNoXZpSga5908NJDZc4z
X+0kA+3FyUZBD9V/jbMBfmaOZBQNKFYHFn1e+ygK1vweBes+5khGsVNX3jnw
OjGe1bp9kEfhc1HMpxlFU89QsFfjM5NZisdFDgXZ3k2Msz1z4lTU3/Tlk5Qh
sX2WvK5IO8jqinw9SPbYTNMlKbxf0+qGOnyxQ+HdM3iTUWxjryjYKfGeM53V
XuKk824O/MnSlRwmHXmt0utnmF5bbwMqakX8ySi2na9SLlhm8vnqmDzlbQFf
KmpnFNvWc7z4HGNsnrrUSYelfAIAXvGJEWLFJzJjipW3A7zmk4xoh62B1dMl
RW2a/DciXG8R1kd8LuNxFL2kuPHbg7RbX+vkw7/8jsvL1ywoKWIj0ojPjNWO
nZSH6nVk/JTD0epfEh/51HKY/Gfn22sdDp86wqseR3lSklw+e+XTUI/DZ6jo
5XE0J/g9LJ8mcw3wOHwSjFl1KjMaDOZT+hFlJp/1ASm9Lw5/h84C5YfKRdUe
U+bwPLbOWQD0DlnkPSUfUVt7YA4ak9wpYrjHYS8gQmG9107nKWXGszm5TdnJ
J5u8zvOY0IzfW/AuoFXHtplasbk+Yw5VbOSkYu+Kd1HHWikfaiulebE1AIbd
/B4tXPYpFusdNr/1RJY1YbcjS2GljsEpgiIj3/vEG4+MOKgU1OF0QkNR1sCa
tXz2ixzk9aHHRK8W8Y93OJ06tr1i4/jMEuP6FGWPjXz3b1QTw4K9hDmJiWS9
MXvMUrtH0d3gMNFLpVDl7XuszAR1iq0tUd175DGPU/8Nwpx1Sw0n222rz8U0
okvxU5wbom+yjpqu+cxN8yLzzOrBYsoDXlN5yblm2+ou1tue11sh9Vt3KKh/
/GZqo5Oc2WEvtPiUoJXslbHh+RLyM6/hvOzsd3ut2CxbzDU9VTZmuHy6b/mr
sm+cWK4IXYIv+PxAz6T4l0PgQDwXKG5KrLfaxroto2jwGk6l7LEILydNO0lH
y2f0Zgz8fgrrm/l7z/0VA6K6eYFR+IVQetu/pbE326ERwmzTjBFHVZnf8tFq
uXWB3qKRGKxFUvMGvYNH45lbR3glMoVa8m9bo7SViX9iU7hs7rV7gbvFor8A
SF0WcQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572563385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11859574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ParabolicCylinderD", "[", 
    RowBox[{"5", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171393362],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"15", " ", "x"}], "-", 
   FractionBox[
    RowBox[{"55", " ", 
     SuperscriptBox["x", "3"]}], "4"], "+", 
   FractionBox[
    RowBox[{"127", " ", 
     SuperscriptBox["x", "5"]}], "32"], "-", 
   FractionBox[
    RowBox[{"77", " ", 
     SuperscriptBox["x", "7"]}], "128"], "+", 
   FractionBox[
    RowBox[{"367", " ", 
     SuperscriptBox["x", "9"]}], "6144"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {15, 0, 
    Rational[-55, 4], 0, 
    Rational[127, 32], 0, 
    Rational[-77, 128], 0, 
    Rational[367, 6144]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{279, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->806621291]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2774],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->951198993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParabolicCylinderD", "[", 
  RowBox[{
   RowBox[{"2", "+", "I"}], ",", " ", 
   RowBox[{"1.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204619223],

Cell[BoxData[
 RowBox[{"6.032679072067764`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.22616287269513746`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252572008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->582996088],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->1565418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ParabolicCylinderD", "[", 
    RowBox[{"0", ",", "5"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203516115],

Cell[BoxData["0.\
001930454136227709242213511975650732143585407919243576211998565724`50."], \
"Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38420471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267616024],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->334799518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParabolicCylinderD", "[", 
  RowBox[{"0", ",", "5.000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5991520],

Cell[BoxData["0.001930454136227709242213511975650732143585407919`29.\
493486370852153"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493074326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133013977],

Cell["Simple exact input gives exact results:", "ExampleText",
 CellID->407918155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParabolicCylinderD", "[", 
  RowBox[{"n", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66258578],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"n", "/", "2"}]], " ", 
   SqrtBox["\[Pi]"]}], 
  RowBox[{"Gamma", "[", 
   FractionBox[
    RowBox[{"1", "-", "n"}], "2"], "]"}]]], "Output",
 ImageSize->{77, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55178805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112385281],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ParabolicCylinderD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->353875807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParabolicCylinderD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79001476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5240284678777446`", ",", "1.1004597825432636`", ",", 
   "1.70309252060267`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312021952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279845572],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->728284987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParabolicCylinderD", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267386826],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    TagBox["D",
     ParabolicCylinderD], "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->264826921]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10134],

Cell[TextData[{
 "Series expansion for symbolic ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->228616014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ParabolicCylinderD", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487814169],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{508, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5443623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->413154318],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->185285404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ParabolicCylinderD", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90727225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{534, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169593587]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19533],

Cell["\<\
Find the solution of the Schr\[ODoubleDot]dinger equation for a quadratic \
oscillator for arbitrary energies:\
\>", "ExampleText",
 CellID->194812099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
     RowBox[{"\[ScriptCapitalE]", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29301357],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"ParabolicCylinderD", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"2", " ", "\[ScriptCapitalE]"}]}], ")"}]}], ",", 
        RowBox[{"\[ImaginaryI]", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"ParabolicCylinderD", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "\[ScriptCapitalE]"}]}], ")"}]}], ",", "x"}], 
       "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{586, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39163264]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28878],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["ParabolicCylinderD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFormula"],
 " into other functions:"
}], "ExampleText",
 CellID->333200773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"ParabolicCylinderD", "[", 
   RowBox[{"2", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8034759],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "4"]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]}], ")"}]}]], "Output",
 ImageSize->{111, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528690957]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", "[", 
   RowBox[{"ParabolicCylinderD", "[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "x"}], "]"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122734016],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "4"]}]], " ", 
  RowBox[{"HermiteH", "[", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    FractionBox["x", 
     SqrtBox["2"]]}], "]"}]}]], "Output",
 ImageSize->{167, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123853334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420146355],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["ParabolicCylinderD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParabolicCylinderD"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->368350005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ParabolicCylinderD", "[", 
       RowBox[{"n", ",", "x"}], "]"}], "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625199043],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], ",", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"6", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"24", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]}], ",", 
   RowBox[{"120", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]}]}], "}"}]], "Output",
 ImageSize->{299, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187907280]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5820],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhittakerW",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerW"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermiteH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermiteH"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14835]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7640],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->12087]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->53560354],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->593350134],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->108274145],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->214771190]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParabolicCylinderD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 6, 7.3945846}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ParabolicCylinderD[\\[Nu], z] gives the parabolic cylinder function \
D_\\[Nu] (z). ", "synonyms" -> {"parabolic cylinder D"}, "title" -> 
    "ParabolicCylinderD", "type" -> "Symbol", "uri" -> 
    "ref/ParabolicCylinderD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8036, 255, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->218875906]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35003, 1138}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2519, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3142, 87, 1583, 37, 70, "ObjectNameGrid"],
Cell[4728, 126, 713, 23, 70, "Usage",
 CellID->29869]
}, Open  ]],
Cell[CellGroupData[{
Cell[5478, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5956, 171, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6079, 177, 592, 22, 70, "Notes",
 CellID->29256],
Cell[6674, 201, 267, 8, 70, "Notes",
 CellID->15176927],
Cell[6944, 211, 238, 7, 70, "Notes",
 CellID->31226],
Cell[7185, 220, 221, 7, 70, "Notes",
 CellID->28162],
Cell[7409, 229, 590, 21, 70, "Notes",
 CellID->19692]
}, Closed]],
Cell[CellGroupData[{
Cell[8036, 255, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->218875906],
Cell[CellGroupData[{
Cell[8421, 269, 148, 5, 70, "ExampleSection",
 CellID->339494391],
Cell[8572, 276, 63, 1, 70, "ExampleText",
 CellID->93627584],
Cell[CellGroupData[{
Cell[8660, 281, 139, 4, 28, "Input",
 CellID->142257040],
Cell[8802, 287, 175, 5, 36, "Output",
 CellID->408517552]
}, Open  ]],
Cell[8992, 295, 125, 3, 70, "ExampleDelimiter",
 CellID->142934889],
Cell[9120, 300, 229, 11, 70, "ExampleText",
 CellID->359040548],
Cell[CellGroupData[{
Cell[9374, 315, 275, 9, 28, "Input",
 CellID->75937857],
Cell[9652, 326, 3576, 63, 129, "Output",
 Evaluatable->False,
 CellID->572563385]
}, Open  ]],
Cell[13243, 392, 124, 3, 70, "ExampleDelimiter",
 CellID->11859574],
Cell[CellGroupData[{
Cell[13392, 399, 256, 8, 70, "Input",
 CellID->171393362],
Cell[13651, 409, 905, 31, 54, "Output",
 CellID->806621291]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14605, 446, 215, 7, 70, "ExampleSection",
 CellID->2774],
Cell[14823, 455, 89, 1, 70, "ExampleText",
 CellID->951198993],
Cell[CellGroupData[{
Cell[14937, 460, 192, 6, 70, "Input",
 CellID->204619223],
Cell[15132, 468, 273, 7, 36, "Output",
 CellID->252572008]
}, Open  ]],
Cell[15420, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->582996088],
Cell[15548, 483, 68, 1, 70, "ExampleText",
 CellID->1565418],
Cell[CellGroupData[{
Cell[15641, 488, 192, 6, 70, "Input",
 CellID->203516115],
Cell[15836, 496, 233, 7, 36, "Output",
 CellID->38420471]
}, Open  ]],
Cell[16084, 506, 125, 3, 70, "ExampleDelimiter",
 CellID->267616024],
Cell[16212, 511, 113, 3, 70, "ExampleText",
 CellID->334799518],
Cell[CellGroupData[{
Cell[16350, 518, 166, 4, 70, "Input",
 CellID->5991520],
Cell[16519, 524, 229, 6, 36, "Output",
 CellID->493074326]
}, Open  ]],
Cell[16763, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->133013977],
Cell[16891, 538, 82, 1, 70, "ExampleText",
 CellID->407918155],
Cell[CellGroupData[{
Cell[16998, 543, 136, 4, 70, "Input",
 CellID->66258578],
Cell[17137, 549, 346, 13, 65, "Output",
 CellID->55178805]
}, Open  ]],
Cell[17498, 565, 125, 3, 70, "ExampleDelimiter",
 CellID->112385281],
Cell[17626, 570, 238, 7, 70, "ExampleText",
 CellID->353875807],
Cell[CellGroupData[{
Cell[17889, 581, 197, 6, 70, "Input",
 CellID->79001476],
Cell[18089, 589, 273, 9, 36, "Output",
 CellID->312021952]
}, Open  ]],
Cell[18377, 601, 125, 3, 70, "ExampleDelimiter",
 CellID->279845572],
Cell[18505, 606, 203, 7, 70, "ExampleText",
 CellID->728284987],
Cell[CellGroupData[{
Cell[18733, 617, 176, 5, 70, "Input",
 CellID->267386826],
Cell[18912, 624, 292, 10, 50, "Output",
 CellID->264826921]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19253, 640, 239, 7, 70, "ExampleSection",
 CellID->10134],
Cell[19495, 649, 151, 6, 70, "ExampleText",
 CellID->228616014],
Cell[CellGroupData[{
Cell[19671, 659, 255, 8, 70, "Input",
 CellID->487814169],
Cell[19929, 669, 2284, 42, 70, "Output",
 Evaluatable->False,
 CellID->5443623]
}, Open  ]],
Cell[22228, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->413154318],
Cell[22356, 719, 72, 1, 70, "ExampleText",
 CellID->185285404],
Cell[CellGroupData[{
Cell[22453, 724, 261, 8, 70, "Input",
 CellID->90727225],
Cell[22717, 734, 3091, 55, 70, "Output",
 Evaluatable->False,
 CellID->169593587]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25857, 795, 223, 7, 70, "ExampleSection",
 CellID->19533],
Cell[26083, 804, 161, 4, 70, "ExampleText",
 CellID->194812099],
Cell[CellGroupData[{
Cell[26269, 812, 519, 17, 70, "Input",
 CellID->29301357],
Cell[26791, 831, 993, 32, 73, "Output",
 CellID->39163264]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27833, 869, 233, 7, 70, "ExampleSection",
 CellID->28878],
Cell[28069, 878, 375, 13, 70, "ExampleText",
 CellID->333200773],
Cell[CellGroupData[{
Cell[28469, 895, 177, 5, 70, "Input",
 CellID->8034759],
Cell[28649, 902, 438, 16, 55, "Output",
 CellID->528690957]
}, Open  ]],
Cell[CellGroupData[{
Cell[29124, 923, 236, 8, 70, "Input",
 CellID->122734016],
Cell[29363, 933, 415, 15, 59, "Output",
 CellID->123853334]
}, Open  ]],
Cell[29793, 951, 125, 3, 70, "ExampleDelimiter",
 CellID->420146355],
Cell[29921, 956, 235, 8, 70, "ExampleText",
 CellID->368350005],
Cell[CellGroupData[{
Cell[30181, 968, 438, 14, 70, "Input",
 CellID->625199043],
Cell[30622, 984, 551, 21, 43, "Output",
 CellID->187907280]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31234, 1012, 310, 9, 70, "SeeAlsoSection",
 CellID->5820],
Cell[31547, 1023, 977, 35, 70, "SeeAlso",
 CellID->14835]
}, Open  ]],
Cell[CellGroupData[{
Cell[32561, 1063, 313, 9, 70, "TutorialsSection",
 CellID->7640],
Cell[32877, 1074, 144, 3, 70, "Tutorials",
 CellID->12087]
}, Open  ]],
Cell[CellGroupData[{
Cell[33058, 1082, 318, 9, 70, "MoreAboutSection",
 CellID->53560354],
Cell[33379, 1093, 159, 3, 70, "MoreAbout",
 CellID->593350134],
Cell[33541, 1098, 174, 3, 70, "MoreAbout",
 CellID->108274145],
Cell[33718, 1103, 179, 3, 70, "MoreAbout",
 CellID->214771190]
}, Open  ]],
Cell[33912, 1109, 27, 0, 70, "History"],
Cell[33942, 1111, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

